/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.commons.spreadsheet.styles.xssf;

import java.util.ArrayList;
import java.util.List;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFFont;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.fenixedu.commons.spreadsheet.styles.xssf.XCellStyle;

public class XComposedCellStyle
extends XCellStyle {
    private final List<XCellStyle> parts = new ArrayList<XCellStyle>();

    @Override
    public XSSFCellStyle getStyle(XSSFWorkbook book) {
        XSSFCellStyle style = book.createCellStyle();
        XSSFFont font = book.createFont();
        for (XCellStyle part : this.parts) {
            part.appendToStyle(book, style, font);
        }
        style.setFont((Font)font);
        return style;
    }

    @Override
    protected void appendToStyle(XSSFWorkbook book, XSSFCellStyle style, XSSFFont font) {
    }

    public XCellStyle merge(XCellStyle style) {
        this.parts.add(style);
        return this;
    }

    public boolean equals(Object obj) {
        if (obj instanceof XComposedCellStyle) {
            XComposedCellStyle composedCellStyle = (XComposedCellStyle)obj;
            boolean equals = true;
            for (int i = 0; i < this.parts.size(); ++i) {
                if (this.parts.get(i).equals(composedCellStyle.parts.get(i))) continue;
                equals = false;
                break;
            }
            return equals;
        }
        return false;
    }

    public int hashCode() {
        int result = 0;
        for (XCellStyle part : this.parts) {
            result += part.hashCode();
        }
        return result;
    }
}

