/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.ulisboa.specifications.domain.legal.mapping;

import com.google.common.base.Strings;
import java.lang.annotation.Annotation;
import java.text.Collator;
import java.util.Comparator;
import java.util.Set;
import java.util.concurrent.Callable;
import org.fenixedu.bennu.core.domain.Bennu;
import org.fenixedu.commons.i18n.LocalizedString;
import org.fenixedu.legalpt.dto.mapping.LegalMappingBean;
import org.fenixedu.legalpt.dto.mapping.LegalMappingEntryBean;
import org.fenixedu.ulisboa.specifications.domain.exceptions.ULisboaSpecificationsDomainException;
import org.fenixedu.ulisboa.specifications.domain.legal.mapping.ILegalMappingType;
import org.fenixedu.ulisboa.specifications.domain.legal.mapping.LegalMapping$callable$create;
import org.fenixedu.ulisboa.specifications.domain.legal.mapping.LegalMapping$callable$create$1;
import org.fenixedu.ulisboa.specifications.domain.legal.mapping.LegalMapping$callable$delete;
import org.fenixedu.ulisboa.specifications.domain.legal.mapping.LegalMapping$callable$deleteEntry;
import org.fenixedu.ulisboa.specifications.domain.legal.mapping.LegalMappingEntry;
import org.fenixedu.ulisboa.specifications.domain.legal.mapping.LegalMapping_Base;
import org.fenixedu.ulisboa.specifications.domain.legal.report.LegalReport;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.DomainObject;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

public abstract class LegalMapping
extends LegalMapping_Base {
    public static Comparator<LegalMapping> COMPARATOR_BY_NAME;
    public static final Advice advice$deleteEntry;
    public static final Advice advice$delete;
    public static final Advice advice$create;
    public static final Advice advice$create$1;

    protected LegalMapping() {
        this.setBennu(Bennu.getInstance());
    }

    protected void init(LegalReport report, ILegalMappingType type) {
        this.setLegalReport(report);
        this.setType(type.getCode());
        this.checkRules();
    }

    public abstract void addEntry(LegalMappingEntryBean var1);

    public abstract String keyForObject(Object var1);

    public String translate(Enum<?> enumValue) {
        return this.translateObject(enumValue);
    }

    public String translate(Boolean booleanValue) {
        return booleanValue != null ? this.translateObject(booleanValue.toString()) : this.translateObject(Boolean.FALSE.toString());
    }

    public String translate(DomainObject domainObjectInstance) {
        return this.translateObject(domainObjectInstance);
    }

    public String translate(String key) {
        return this.translateObject(key);
    }

    protected String translateObject(Object key) {
        if (this.isKeyDefined(key)) {
            return this.findMappingEntryForKey(this.keyForObject(key)).getMappingValue();
        }
        return null;
    }

    public Set<?> getPossibleKeys() {
        return this.getLegalReport().getPossibleKeys(this.getType());
    }

    public LocalizedString getNameI18N() {
        return this.getLegalReport().getMappingTypeNameI18N(this.getType());
    }

    public boolean isKeyDefined(Object object) {
        String key = this.keyForObject(object);
        return this.findMappingEntryForKey(key) != null;
    }

    public void deleteEntry(LegalMappingEntry legalMappingEntry) {
        Object object = advice$deleteEntry.perform((Callable)new LegalMapping$callable$deleteEntry(this, legalMappingEntry));
    }

    static /* synthetic */ void advised$deleteEntry(LegalMapping this_, LegalMappingEntry entry) {
        entry.delete();
    }

    public LocalizedString getLocalizedNameEntryKeyI18N(String key) {
        return this.getLegalReport().getLocalizedNameMappingKey(this.getType(), key);
    }

    public LocalizedString getLocalizedNameEntryKeyI18NForObject(Object key) {
        return this.getLocalizedNameEntryKeyI18N(this.keyForObject(key));
    }

    public static LegalMapping find(LegalReport report, ILegalMappingType type) {
        return LegalMapping.find(report, type.getCode());
    }

    protected static LegalMapping find(LegalReport report, String type) {
        LegalMapping result = null;
        for (LegalMapping mapping : LegalMapping.readAll()) {
            if (!mapping.getType().equals(type) || mapping.getLegalReport() != report) continue;
            if (result != null) {
                throw new ULisboaSpecificationsDomainException("error.Mapping.found.more.than.one.in.report", new String[0]);
            }
            result = mapping;
        }
        return result;
    }

    public void delete() {
        Object object = advice$delete.perform((Callable)new LegalMapping$callable$delete(this));
    }

    static /* synthetic */ void advised$delete(LegalMapping this_) {
        if (this_.getLegalMappingEntriesSet().size() > 0) {
            throw new ULisboaSpecificationsDomainException("error.mapping.delete.not.empty.entries", new String[0]);
        }
        super.setLegalReport(null);
        super.setBennu(null);
        super.deleteDomainObject();
    }

    public static LegalMapping create(LegalMappingBean legalMappingBean) {
        return (LegalMapping)((Object)advice$create.perform((Callable)new LegalMapping$callable$create(legalMappingBean)));
    }

    static /* synthetic */ LegalMapping advised$create(LegalMappingBean bean) {
        return bean.getMappingType().createMapping(bean.getReport());
    }

    public static LegalMapping create(ILegalMappingType iLegalMappingType, LegalReport legalReport) {
        return (LegalMapping)((Object)advice$create$1.perform((Callable)new LegalMapping$callable$create$1(iLegalMappingType, legalReport)));
    }

    static /* synthetic */ LegalMapping advised$create(ILegalMappingType mappingType, LegalReport report) {
        return mappingType.createMapping(report);
    }

    public void addEntry(String key, String value) {
        new LegalMappingEntry(this, key, value);
    }

    protected static Set<LegalMapping> readAll() {
        return Bennu.getInstance().getLegalMappingsSet();
    }

    private void checkRules() {
        if (Strings.isNullOrEmpty((String)this.getType())) {
            throw new ULisboaSpecificationsDomainException("error.Mapping.type.required", new String[0]);
        }
        if (this.getLegalReport() == null) {
            throw new ULisboaSpecificationsDomainException("error.Mapping.report.required", new String[0]);
        }
        LegalMapping.find(this.getLegalReport(), this.getType());
    }

    protected LegalMappingEntry findMappingEntryForKey(String key) {
        for (LegalMappingEntry entry : this.getLegalMappingEntriesSet()) {
            if (!entry.getMappingKey().equals(key)) continue;
            return entry;
        }
        return null;
    }

    static {
        advice$deleteEntry = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        advice$delete = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        advice$create = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        advice$create$1 = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        COMPARATOR_BY_NAME = new Comparator<LegalMapping>(){

            @Override
            public int compare(LegalMapping o1, LegalMapping o2) {
                String leftName = o1.getNameI18N().getContent() == null ? "" : o1.getNameI18N().getContent();
                String rightName = o2.getNameI18N().getContent() == null ? "" : o2.getNameI18N().getContent();
                int result = Collator.getInstance().compare(leftName, rightName);
                return result == 0 ? o1.getExternalId().compareTo(o2.getExternalId()) : result;
            }
        };
    }
}

