/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.legalpt.ui.settings;

import org.fenixedu.bennu.core.domain.exceptions.DomainException;
import org.fenixedu.bennu.spring.portal.SpringFunctionality;
import org.fenixedu.legalpt.dto.LegalSettingsBean;
import org.fenixedu.legalpt.ui.FenixeduLegalPTBaseController;
import org.fenixedu.legalpt.ui.FenixeduLegalPTController;
import org.fenixedu.ulisboa.specifications.domain.legal.settings.LegalSettings;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import pt.ist.fenixframework.FenixFramework;

@SpringFunctionality(app=FenixeduLegalPTController.class, title="label.title.manageLegalSettings", accessGroup="#managers")
@RequestMapping(value={"/fenixedu-legal-pt/settings/managelegalsettings"})
public class LegalSettingsController
extends FenixeduLegalPTBaseController {
    public static final String CONTROLLER_URL = "/fenixedu-legal-pt/settings/managelegalsettings";
    public static final String JSP_PATH = "/fenixedu-legal-pt/settings/managelegalsettings".substring(1);
    private static final String _READ_URI = "/read";
    public static final String READ_URL = "/fenixedu-legal-pt/settings/managelegalsettings/read";
    private static final String _EDIT_URI = "/edit";
    public static final String EDIT_URL = "/fenixedu-legal-pt/settings/managelegalsettings/edit";

    @RequestMapping
    public String home() {
        return "forward:/fenixedu-legal-pt/settings/managelegalsettings/read";
    }

    @RequestMapping(value={"/read"}, method={RequestMethod.GET})
    public String read(Model model) {
        model.addAttribute("instance", (Object)LegalSettings.getInstance());
        return this.jspPage(_READ_URI);
    }

    private String jspPage(String page) {
        return JSP_PATH + "/" + page.substring(1, page.length());
    }

    @RequestMapping(value={"/edit"}, method={RequestMethod.GET})
    public String edit(Model model) {
        return this._edit(new LegalSettingsBean(LegalSettings.getInstance()), model);
    }

    private String _edit(LegalSettingsBean bean, Model model) {
        model.addAttribute("bean", (Object)bean);
        model.addAttribute("beanJson", (Object)this.getBeanJson(bean));
        return this.jspPage(_EDIT_URI);
    }

    @RequestMapping(value={"/edit"}, method={RequestMethod.POST})
    public String editpost(@RequestParam(value="bean") LegalSettingsBean bean, Model model) {
        try {
            FenixFramework.atomic(() -> {
                LegalSettings instance = LegalSettings.getInstance();
                instance.setNumberOfLessonWeeks(bean.getNumberOfLessonWeeks());
                instance.setA3esURL(bean.getA3esURL());
            });
            return "redirect:/fenixedu-legal-pt/settings/managelegalsettings/read";
        }
        catch (DomainException e) {
            this.addErrorMessage(e.getLocalizedMessage(), model);
            return this._edit(bean, model);
        }
    }
}

