/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.legalpt.services.a3es.process;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.ws.rs.NotAuthorizedException;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Response;
import org.apache.commons.httpclient.HttpStatus;
import org.apache.commons.lang.StringUtils;
import org.fenixedu.academic.domain.CompetenceCourse;
import org.fenixedu.academic.domain.DegreeCurricularPlan;
import org.fenixedu.academic.domain.ExecutionCourse;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.Professorship;
import org.fenixedu.academic.domain.Professorship_Base;
import org.fenixedu.academic.domain.ShiftProfessorship;
import org.fenixedu.academic.domain.ShiftType;
import org.fenixedu.academic.domain.executionPlanning.services.OccupationPeriodServices;
import org.fenixedu.commons.i18n.LocalizedString;
import org.fenixedu.commons.spreadsheet.SheetData;
import org.fenixedu.commons.spreadsheet.SpreadsheetBuilder;
import org.fenixedu.legalpt.domain.a3es.A3esInstance;
import org.fenixedu.legalpt.domain.a3es.A3esPeriod;
import org.fenixedu.legalpt.domain.a3es.A3esProcess;
import org.fenixedu.legalpt.domain.a3es.mapping.A3esMappingType;
import org.fenixedu.legalpt.domain.exceptions.LegalPTDomainException;
import org.fenixedu.legalpt.dto.a3es.A3esAbstractBean;
import org.fenixedu.legalpt.dto.a3es.A3esBeanField;
import org.fenixedu.legalpt.dto.a3es.A3esCourseBean;
import org.fenixedu.legalpt.dto.a3es.A3esProcessBean;
import org.fenixedu.legalpt.dto.a3es.A3esTeacherBean;
import org.fenixedu.legalpt.util.LegalPTUtil;
import org.fenixedu.ulisboa.specifications.domain.legal.mapping.LegalMapping;
import org.fenixedu.ulisboa.specifications.domain.legal.report.LegalReport;
import org.fenixedu.ulisboa.specifications.domain.legal.settings.LegalSettings;
import org.joda.time.DateTime;
import org.joda.time.Interval;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.JSONValue;

public abstract class A3esExportService {
    public static final Locale PT = new Locale("pt");
    public static final Locale EN = Locale.UK;
    public static int _UNSUPPORTED = -2;
    public static int _UNLIMITED = -1;
    protected static int _0 = 0;
    protected static int _3 = 3;
    protected static int _20 = 20;
    protected static int _30 = 30;
    protected static int _100 = 100;
    protected static int _200 = 200;
    protected static int _360 = 360;
    protected static int _500 = 200;
    protected static int _1000 = 1000;
    protected static int _3000 = 3000;
    protected static String SEMICOLON = "; ";
    protected static String BREAKLINE = "\n";
    protected static String SLASH = " / ";
    protected static String PLUS = " + ";
    private static final String API_PROCESS = "api_process";
    private static final String API_ID = "id";
    private static final String API_NAME = "name";
    private static final String API_ATTACH_NAME_SEPARATOR = " - ";
    private static final String REQUIRED_STATE = " em preenchimento";
    private static final String REQUIRED_ACTION = "Submeter ";
    private static final String API_FORM = "api_form";
    private static final String FORM_ID = "formId";
    private static final String FOLDER_ID = "folderId";
    protected static final String API_FOLDER = "api_folder";
    protected static final String API_CVFOLDER = "api_cvfolder";
    private static final String API_ATTACH = "api_annex";
    private String base64Hash;
    private String formId;

    private void initialize(A3esProcessBean bean) {
        this.initializeHash(bean);
        this.initializeFormId(bean);
    }

    private void initializeHash(A3esProcessBean bean) {
        this.base64Hash = new String(Base64.getEncoder().encode((bean.getUser() + ":" + bean.getPassword()).getBytes()));
    }

    private void initializeFormId(A3esProcessBean bean) {
        this.formId = bean.getFormId();
        if (StringUtils.isBlank((String)bean.getFormId())) {
            A3esPeriod period = bean.getPeriod();
            if (!period.isInFillingPeriod().booleanValue()) {
                throw new LegalPTDomainException("error.A3es.outside.period", OccupationPeriodServices.getIntervalsDescription((List)Lists.newArrayList((Object[])new Interval[]{period.getFillInDateInterval()})));
            }
            JSONArray processes = null;
            try {
                processes = this.invokeToArray(this.getClientTarget().path(API_PROCESS));
            }
            catch (NotAuthorizedException e) {
                throw new LegalPTDomainException("error.A3es.wrong.credentials", bean.getUser());
            }
            if (processes.size() != 1) {
                throw new LegalPTDomainException("error.A3es.process.not.unique", String.valueOf(processes.size()));
            }
            JSONObject process = (JSONObject)processes.iterator().next();
            String processName = (String)process.get((Object)API_NAME);
            if (!bean.getName().equals(processName)) {
                throw new LegalPTDomainException("error.A3es.process.unauthorized", processName);
            }
            String processPlan = (String)process.get((Object)"study_cycle");
            if (!A3esProcess.getPlanDescription(bean.getDegreeCurricularPlan()).contains(processPlan)) {
                throw new LegalPTDomainException("error.A3es.process.different.plan", processPlan);
            }
            String processState = (String)process.get((Object)"state");
            String processActions = (String)process.get((Object)"actions");
            if (!processState.contains(REQUIRED_STATE) || !processActions.contains(REQUIRED_ACTION)) {
                throw new LegalPTDomainException("error.A3es.process.unavailable", processState, processActions);
            }
            String processId = (String)process.get((Object)API_ID);
            for (Object formObj : this.invokeToArray(this.getClientTarget().path(API_FORM).queryParam("processId", new Object[]{processId}))) {
                JSONObject form = (JSONObject)formObj;
                if (!this.getFormName().equals(form.get((Object)API_NAME))) continue;
                this.formId = (String)form.get((Object)API_ID);
                bean.setFormId(this.formId);
                return;
            }
            throw new LegalPTDomainException("error.A3es.process.without.form", this.getFormName());
        }
    }

    protected WebTarget getClientTarget() {
        Client client = ClientBuilder.newClient();
        return client.target(LegalSettings.getInstance().getA3esURL());
    }

    private Invocation.Builder getClientBuilder(WebTarget target) {
        return target.request(new String[]{"application/json"}).header("Authorization", (Object)("Basic " + this.base64Hash));
    }

    protected JSONObject invoke(WebTarget target) {
        return (JSONObject)JSONValue.parse((String)((String)this.getClientBuilder(target).get(String.class)));
    }

    protected JSONArray invokeToArray(WebTarget target) {
        return (JSONArray)((JSONObject)JSONValue.parse((String)((String)this.getClientBuilder(target).get(String.class)))).get((Object)"list");
    }

    private String create(WebTarget target, JSONObject json, String name) {
        Response response = this.getClientBuilder(target).buildPost(Entity.text((Object)json.toJSONString())).invoke();
        return this.buildResponseText("create", response, name);
    }

    private String delete(WebTarget target, String name) {
        Response response = this.getClientBuilder(target).buildDelete().invoke();
        return this.buildResponseText("delete", response, name);
    }

    private String buildResponseText(String action, Response response, String name) {
        return "[" + new DateTime().toString("yyyy-dd-MM HH:mm:ss") + SLASH + A3esExportService.label(action) + SLASH + A3esExportService.label("response") + ": " + this.parseResponse(response) + "] " + name;
    }

    private String parseResponse(Response response) {
        if (response == null) {
            return "-";
        }
        int status = response.getStatus();
        if (status == 204) {
            return "-";
        }
        String result = A3esExportService.label(String.valueOf(status));
        return result.contains("!") ? HttpStatus.getStatusText((int)status) : result;
    }

    protected abstract String getFormName();

    protected abstract String getCoursesFolderIndex();

    protected abstract String getCoursesFolderName();

    private String getCoursesFieldKey(String keyIndex) {
        return "q-II." + this.getCoursesFolderIndex() + keyIndex;
    }

    private String getCourseId() {
        return API_ID;
    }

    private boolean isCourseFolder(JSONObject folder) {
        return this.getCoursesFolderName().equals(folder.get((Object)API_NAME));
    }

    private JSONArray getCourseFolders(WebTarget target) {
        return this.invokeToArray(target.path(API_FOLDER).queryParam(FORM_ID, new Object[]{this.formId}));
    }

    protected abstract String getTeachersFolderSectionName();

    protected abstract String getTeachersFolderIndex();

    protected abstract String getTeachersFolderName();

    protected abstract String getTeacherId();

    private boolean isTeacherFolder(JSONObject input) {
        return this.getTeachersFolderName().equals(input.get((Object)API_NAME)) && this.getTeachersFolderSectionName().equals(input.get((Object)"uo"));
    }

    private JSONArray getTeacherFolders(WebTarget target) {
        return (JSONArray)this.invoke(target.path(API_CVFOLDER)).get((Object)"folders");
    }

    private static String reportLabel(String label) {
        return A3esExportService.label("note") + ": " + label;
    }

    public List<String> coursesUpload(A3esProcessBean bean) {
        ArrayList<String> result = new ArrayList<String>();
        this.initialize(bean);
        WebTarget clientTarget = this.getClientTarget();
        for (Object folderObj : this.getCourseFolders(clientTarget)) {
            JSONObject folder = (JSONObject)folderObj;
            if (!this.isCourseFolder(folder)) continue;
            String folderId = (String)folder.get((Object)this.getCourseId());
            WebTarget attachPath = clientTarget.path(API_ATTACH);
            WebTarget attachTarget = attachPath.queryParam(FORM_ID, new Object[]{this.formId}).queryParam(FOLDER_ID, new Object[]{folderId});
            Map<String, String> attachExisting = this.existingAttachments(attachTarget);
            for (JSONObject json : this.buildCoursesJson(bean)) {
                String name = (String)json.get((Object)this.getCoursesFieldKey("1"));
                result.addAll(this.deleteAttachmentsWithSameName(attachPath, folderId, attachExisting, name));
                result.add(this.create(attachTarget, json, name));
            }
            result.add(this.deleteAttachmentsWithInvalidName(attachTarget, attachPath, folderId));
            break;
        }
        return result.stream().filter(i -> !StringUtils.isBlank((String)i)).sorted(A3esExportService.uploadResultsComparator()).collect(Collectors.toList());
    }

    public List<String> teachersUpload(A3esProcessBean bean) {
        ArrayList<String> result = new ArrayList<String>();
        this.initialize(bean);
        WebTarget clientTarget = this.getClientTarget();
        for (Object folderObj : this.getTeacherFolders(clientTarget)) {
            JSONObject folder = (JSONObject)folderObj;
            if (!this.isTeacherFolder(folder)) continue;
            String folderId = (String)folder.get((Object)this.getTeacherId());
            WebTarget attachPath = clientTarget.path(API_ATTACH);
            WebTarget attachTarget = attachPath.queryParam(FORM_ID, new Object[]{this.formId}).queryParam(FOLDER_ID, new Object[]{folderId});
            Map<String, String> attachExisting = this.existingAttachments(attachTarget);
            for (JSONObject json : this.buildTeachersJson(bean)) {
                String name = (String)json.get((Object)"q-cf-name");
                result.addAll(this.deleteAttachmentsWithSameName(attachPath, folderId, attachExisting, name));
                result.add(this.create(attachTarget, json, name));
            }
            result.add(this.deleteAttachmentsWithInvalidName(attachTarget, attachPath, folderId));
            break;
        }
        return result.stream().filter(i -> !StringUtils.isBlank((String)i)).sorted(A3esExportService.uploadResultsComparator()).collect(Collectors.toList());
    }

    private Map<String, String> existingAttachments(WebTarget attachTarget) {
        HashMap<String, String> result = new HashMap<String, String>();
        this.invokeToArray(attachTarget).stream().forEach(i -> {
            JSONObject attach = (JSONObject)i;
            result.put((String)attach.get((Object)API_ID), (String)attach.get((Object)API_NAME));
        });
        return result;
    }

    private List<String> deleteAttachmentsWithSameName(WebTarget attachPath, String folderId, Map<String, String> attachExisting, String attachName) {
        LinkedList<String> result = new LinkedList<String>();
        attachExisting.entrySet().stream().filter(i -> ((String)i.getValue()).contains(attachName)).forEach(i -> {
            String attachId = (String)i.getKey();
            result.add(this.delete(attachPath.path(attachId).queryParam(FORM_ID, new Object[]{this.formId}).queryParam(FOLDER_ID, new Object[]{folderId}), attachName));
        });
        return result;
    }

    private String deleteAttachmentsWithInvalidName(WebTarget attachTarget, WebTarget attachPath, String folderId) {
        int deleted = 0;
        for (Object i : this.invokeToArray(attachTarget)) {
            JSONObject attach = (JSONObject)i;
            String attachId = (String)attach.get((Object)API_ID);
            String attachName = (String)attach.get((Object)API_NAME);
            boolean attachNameInvalid = !attachName.contains(API_ATTACH_NAME_SEPARATOR) || attachName.endsWith(API_ATTACH_NAME_SEPARATOR);
            if (!attachNameInvalid) continue;
            this.delete(attachPath.path(attachId).queryParam(FORM_ID, new Object[]{this.formId}).queryParam(FOLDER_ID, new Object[]{folderId}), attachName);
            ++deleted;
        }
        return deleted == 0 ? "" : A3esExportService.i18n("info.A3es.process.deleted.invalid.attachment", String.valueOf(deleted));
    }

    private static Comparator<String> uploadResultsComparator() {
        return (x, y) -> {
            String marker = "] ";
            int xMark = x.indexOf("] ");
            int yMark = y.indexOf("] ");
            if (xMark > 0 && yMark > 0) {
                return x.substring(xMark).compareTo(y.substring(yMark));
            }
            if (xMark < 0) {
                return -1;
            }
            if (yMark < 0) {
                return 1;
            }
            return x.compareTo((String)y);
        };
    }

    private Set<JSONObject> buildCoursesJson(A3esProcessBean bean) {
        LinkedHashSet<JSONObject> result = new LinkedHashSet<JSONObject>();
        if (bean.getCoursesData().isEmpty()) {
            bean.updateCoursesData();
        }
        bean.getCoursesData().forEach(data -> {
            if (!bean.getSelectedIds().isEmpty() && !bean.getSelectedIds().contains(data.getFormattedId())) {
                return;
            }
            JSONObject root = new JSONObject();
            root.put((Object)this.getCoursesFieldKey("1"), (Object)data.getFieldUnique("1").getValue());
            root.put((Object)this.getCoursesFieldKey("2"), (Object)data.getFieldUnique("2").getValue());
            root.put((Object)this.getCoursesFieldKey("3"), (Object)data.getFieldUnique("3").getValue());
            JSONObject q4 = new JSONObject();
            data.getField("4").stream().forEach(i -> q4.put((Object)i.getLanguage(), (Object)i.getValue()));
            root.put((Object)this.getCoursesFieldKey("4"), (Object)q4);
            JSONObject q5 = new JSONObject();
            data.getField("5").stream().forEach(i -> q5.put((Object)i.getLanguage(), (Object)i.getValue()));
            root.put((Object)this.getCoursesFieldKey("5"), (Object)q5);
            JSONObject q6 = new JSONObject();
            data.getField("6").stream().forEach(i -> q6.put((Object)i.getLanguage(), (Object)i.getValue()));
            root.put((Object)this.getCoursesFieldKey("6"), (Object)q6);
            JSONObject q7 = new JSONObject();
            data.getField("7").stream().forEach(i -> q7.put((Object)i.getLanguage(), (Object)i.getValue()));
            root.put((Object)this.getCoursesFieldKey("7"), (Object)q7);
            JSONObject q8 = new JSONObject();
            data.getField("8").stream().forEach(i -> q8.put((Object)i.getLanguage(), (Object)i.getValue()));
            root.put((Object)this.getCoursesFieldKey("8"), (Object)q8);
            root.put((Object)this.getCoursesFieldKey("9"), (Object)data.getFieldUnique("9").getValue());
            result.add(root);
        });
        return result;
    }

    private Set<JSONObject> buildTeachersJson(A3esProcessBean bean) {
        LinkedHashSet<JSONObject> result = new LinkedHashSet<JSONObject>();
        if (bean.getTeachersData().isEmpty()) {
            bean.updateTeachersData();
        }
        bean.getTeachersData().forEach(data -> {
            if (!bean.getSelectedIds().isEmpty() && !bean.getSelectedIds().contains(data.getFormattedId())) {
                return;
            }
            JSONObject root = new JSONObject();
            root.put((Object)"q-cf-name", (Object)data.getFieldUnique(API_NAME).getValue());
            root.put((Object)"q-cf-ies", (Object)data.getFieldUnique("ies").getValue());
            root.put((Object)"q-cf-uo", (Object)data.getFieldUnique("uo").getValue());
            root.put((Object)"q-cf-cat", (Object)data.getFieldUnique("cat").getValue());
            root.put((Object)"q-cf-time", (Object)data.getFieldUnique("time").getValue());
            JSONObject file = new JSONObject();
            file.put((Object)API_NAME, (Object)data.getFieldUnique(API_NAME).getValue());
            file.put((Object)"ies", (Object)data.getFieldUnique("ies").getValue());
            file.put((Object)"uo", (Object)data.getFieldUnique("uo").getValue());
            file.put((Object)"research_center", (Object)data.getFieldUnique("research_center").getValue());
            file.put((Object)"cat", (Object)data.getFieldUnique("cat").getValue());
            file.put((Object)"spec", (Object)data.getFieldUnique("spec").getValue());
            file.put((Object)"spec_area", (Object)data.getFieldUnique("spec_area").getValue());
            A3esTeacherBean.AttainedDegree attainedDegree = data.getAttainedDegree();
            file.put((Object)"deg", (Object)attainedDegree.getFieldUnique("deg").getValue());
            file.put((Object)"degarea", (Object)attainedDegree.getFieldUnique("degarea").getValue());
            file.put((Object)"ano_grau", (Object)attainedDegree.getFieldUnique("ano_grau").getValue());
            file.put((Object)"instituicao_conferente", (Object)attainedDegree.getFieldUnique("instituicao_conferente").getValue());
            file.put((Object)"regime", (Object)data.getFieldUnique("time").getValue());
            JSONArray academicArray = new JSONArray();
            data.getOtherAttainedDegrees().forEach(x -> {
                JSONObject academic = new JSONObject();
                academic.put((Object)"year", (Object)x.getFieldUnique("year").getValue());
                academic.put((Object)"degree", (Object)x.getFieldUnique("degree").getValue());
                academic.put((Object)"area", (Object)x.getFieldUnique("area").getValue());
                academic.put((Object)"ies", (Object)x.getFieldUnique("ies").getValue());
                academic.put((Object)"rank", (Object)x.getFieldUnique("rank").getValue());
                academicArray.add((Object)academic);
            });
            file.put((Object)"form-academic", (Object)academicArray);
            file.put((Object)"form-investigation", (Object)A3esExportService.getJsonActivitiesArray(data.getPrimePublishedWork(), "investigation"));
            file.put((Object)"form-highlevelactivities", (Object)A3esExportService.getJsonActivitiesArray(data.getPrimeProfessionalActivities(), "highlevelactivities"));
            file.put((Object)"form-otherpublications", (Object)A3esExportService.getJsonActivitiesArray(data.getOtherPublishedWork(), "otherpublications"));
            file.put((Object)"form-professional", (Object)A3esExportService.getJsonActivitiesArray(data.getOtherProfessionalActivities(), "profession"));
            JSONArray insideLectures = new JSONArray();
            data.getTeachingServices().forEach(x -> {
                JSONObject lecture = new JSONObject();
                lecture.put((Object)"curricularUnit", (Object)x.getFieldUnique("curricularUnit").getValue());
                lecture.put((Object)"studyCycle", (Object)x.getFieldUnique("studyCycle").getValue());
                lecture.put((Object)"type", (Object)x.getFieldUnique("type").getValue());
                lecture.put((Object)"hoursPerWeek", (Object)x.getFieldUnique("hoursPerWeek").getValue());
                insideLectures.add((Object)lecture);
            });
            file.put((Object)"form-unit", (Object)insideLectures);
            root.put((Object)"q-cf-cfile", (Object)file);
            result.add(root);
        });
        return result;
    }

    private static JSONArray getJsonActivitiesArray(A3esTeacherBean.TeacherActivity teacherActivity, String jsonObject) {
        JSONArray result = new JSONArray();
        teacherActivity.getField(jsonObject).forEach(activity -> {
            JSONObject current = new JSONObject();
            current.put((Object)jsonObject, (Object)activity.getValue());
            result.add((Object)current);
        });
        return result;
    }

    public static void coursesDownload(SpreadsheetBuilder builder, final A3esProcessBean bean) throws IOException {
        Set<A3esCourseBean> datas = bean.getCoursesData();
        builder.addSheet(A3esExportService.label("courseFiles").replaceAll(" ", "_"), (SheetData)new SheetData<A3esCourseBean>(datas){

            protected void makeLine(A3esCourseBean data) {
                this.addCell(A3esExportService.label("degreeCode"), bean.getDegreeCode());
                this.addCell(A3esExportService.label("degree"), bean.getDegreeCurricularPlan().getPresentationName());
                data.getFields().forEach(i -> {
                    this.addCell(i.getLabel(), i.getValue());
                    String report = i.getReport();
                    if (!StringUtils.isBlank((String)report)) {
                        this.addCell(A3esExportService.reportLabel(i.getLabel()), report);
                    }
                });
            }
        });
    }

    public static void teachersDownload(SpreadsheetBuilder builder, A3esProcessBean bean) throws IOException {
        Set<A3esTeacherBean> datas = bean.getTeachersData();
        builder.addSheet(A3esExportService.label("teacherFiles").replaceAll(" ", "_"), (SheetData)new SheetData<A3esTeacherBean>(datas){

            protected void makeLine(A3esTeacherBean data) {
                data.getFields().forEach(i -> {
                    this.addCell(i.getLabel(), i.getValue());
                    String report = i.getReport();
                    if (!StringUtils.isBlank((String)report)) {
                        this.addCell(A3esExportService.reportLabel(i.getLabel()), report);
                    }
                });
                data.getAttainedDegree().getFields().forEach(i -> {
                    this.addCell(i.getLabel(), i.getValue());
                    this.addCell(A3esExportService.reportLabel(i.getLabel()), i.getReport());
                });
                String label = A3esExportService.label("otherAcademicDegreesOrTitle");
                String value = data.getOtherAttainedDegrees().stream().map(i -> this.concat((A3esAbstractBean)i, SLASH)).collect(Collectors.joining(BREAKLINE));
                this.addCell(label, value);
                this.addCell(A3esExportService.reportLabel(label), this.concatReport(value));
                label = A3esExportService.label("scientificActivity");
                value = this.concat(data.getPrimePublishedWork());
                this.addCell(label, value);
                this.addCell(A3esExportService.reportLabel(label), this.concatReport(value));
                label = A3esExportService.label("developmentActivity");
                value = this.concat(data.getPrimeProfessionalActivities());
                this.addCell(label, value);
                this.addCell(A3esExportService.reportLabel(label), this.concatReport(value));
                label = A3esExportService.label("otherPublicationActivity");
                value = this.concat(data.getOtherPublishedWork());
                this.addCell(label, value);
                this.addCell(A3esExportService.reportLabel(label), this.concatReport(value));
                label = A3esExportService.label("otherProfessionalActivity");
                value = this.concat(data.getOtherProfessionalActivities());
                this.addCell(label, value);
                this.addCell(A3esExportService.reportLabel(label), this.concatReport(value));
                label = A3esExportService.label("teachingServiceAllocation");
                value = data.getTeachingServices().stream().map(i -> this.concat((A3esAbstractBean)i, SLASH)).collect(Collectors.joining(BREAKLINE));
                this.addCell(label, value);
                this.addCell(A3esExportService.reportLabel(label), this.concatReport(value));
            }

            private String concat(A3esAbstractBean input) {
                return this.concat(input, BREAKLINE);
            }

            private String concat(A3esAbstractBean input, String separator) {
                return input.getFields().stream().map(i -> i.getValue()).filter(i -> !StringUtils.isBlank((String)i)).collect(Collectors.joining(separator));
            }

            private Object concatReport(String value) {
                return StringUtils.isBlank((String)value) ? A3esBeanField.labelFieldMissing() : (value.contains(" ...") ? A3esBeanField.labelFieldCutInfo() : null);
            }
        });
    }

    public static String label(String input) {
        return A3esExportService.i18n("label." + input, new String[0]);
    }

    public static String i18n(String code, String ... args) {
        return LegalPTUtil.bundleI18N(code, args).getContent(PT);
    }

    protected static LocalizedString createEmptyMLS() {
        return A3esExportService.createMLS(null, null);
    }

    public static LocalizedString createMLS(String pt, String en) {
        LocalizedString result = new LocalizedString();
        if (!StringUtils.isBlank((String)pt)) {
            result = result.with(PT, pt);
        }
        if (!StringUtils.isBlank((String)en)) {
            result = result.with(EN, en);
        }
        return result;
    }

    public static Map<Person, Map<CompetenceCourse, Set<Professorship>>> readPersonProfessorships(DegreeCurricularPlan plan, ExecutionYear year) {
        TreeMap<Person, Map<CompetenceCourse, Set<Professorship>>> result = new TreeMap<Person, Map<CompetenceCourse, Set<Professorship>>>((x, y) -> Collator.getInstance().compare(x.getName(), y.getName()));
        A3esExportService.readCourses(plan, year).stream().forEach(competence -> A3esExportService.readCourseProfessorships(plan, year, competence).entrySet().stream().forEach(entry -> {
            Person person = (Person)entry.getKey();
            Set courseProfessorships = (Set)entry.getValue();
            Map personProfessorships = (Map)result.get(person);
            personProfessorships = personProfessorships != null ? personProfessorships : new HashMap();
            Set tempSet = (Set)personProfessorships.get(competence);
            tempSet = tempSet != null ? tempSet : new HashSet();
            tempSet.addAll(courseProfessorships.stream().filter(p -> p.getPerson() == person).collect(Collectors.toSet()));
            personProfessorships.put(competence, tempSet);
            result.put(person, personProfessorships);
        }));
        result.entrySet().forEach(entry -> {
            Person person = (Person)entry.getKey();
            Map personProfessorships = (Map)entry.getValue();
            person.getProfessorshipsSet().stream().filter(i -> i.getExecutionCourse().getExecutionYear() == year).forEach(professorship -> {
                ExecutionCourse execution = professorship.getExecutionCourse();
                execution.getAssociatedCurricularCoursesSet().stream().filter(i -> i.getDegreeCurricularPlan() != plan).map(i -> i.getCompetenceCourse()).filter(i -> i != null).distinct().forEach(competence -> {
                    Set tempSet = (Set)personProfessorships.get(competence);
                    tempSet = tempSet != null ? tempSet : new HashSet();
                    tempSet.add(professorship);
                    personProfessorships.put(competence, tempSet);
                });
            });
            result.put(person, personProfessorships);
        });
        return result;
    }

    public static Set<CompetenceCourse> readCourses(DegreeCurricularPlan plan, ExecutionYear year) {
        TreeSet<CompetenceCourse> result = new TreeSet<CompetenceCourse>((x, y) -> Collator.getInstance().compare(x.getName(), y.getName()));
        year.getExecutionPeriodsSet().stream().forEach(semester -> plan.getRoot().getAllCurricularCourses(semester).stream().filter(c -> c.getCompetenceCourse() != null).map(c -> c.getCompetenceCourse()).distinct().collect(Collectors.toCollection(() -> result)));
        return result;
    }

    public static Map<Person, Set<Professorship>> readCourseProfessorships(DegreeCurricularPlan plan, ExecutionYear year, CompetenceCourse course) {
        TreeMap<Person, Set<Professorship>> result = new TreeMap<Person, Set<Professorship>>((x, y) -> Collator.getInstance().compare(x.getName(), y.getName()));
        result.putAll(A3esExportService.readExecutionCourses(plan, year, course).flatMap(ec -> ec.getProfessorshipsSet().stream()).collect(Collectors.groupingBy(Professorship_Base::getPerson, Collectors.toSet())));
        return result;
    }

    private static Stream<ExecutionCourse> readExecutionCourses(DegreeCurricularPlan plan, ExecutionYear year, CompetenceCourse competence) {
        return competence.getAssociatedCurricularCoursesSet().stream().filter(c -> c.getDegreeCurricularPlan() == plan).flatMap(c -> c.getAssociatedExecutionCoursesSet().stream()).filter(ec -> ec.getExecutionYear() == year);
    }

    public static String getShiftTypeAcronym(ShiftType t) {
        return LegalMapping.find((LegalReport)((Object)A3esInstance.getInstance()), A3esMappingType.SHIFT_TYPE).translate((Enum<?>)t);
    }

    public static BigDecimal calculateTeachingHours(ShiftProfessorship sp) {
        BigDecimal shiftTotalHours = sp.getShift().getUnitHours().multiply(new BigDecimal(LegalSettings.getInstance().getNumberOfLessonWeeks()));
        BigDecimal result = sp.getPercentage() != null ? shiftTotalHours.multiply(new BigDecimal(sp.getPercentage())).divide(BigDecimal.valueOf(100.0)).setScale(2, RoundingMode.DOWN) : shiftTotalHours;
        return result.stripTrailingZeros();
    }

    public static String getApaFormat(String authors, String date, String title, String aditionalInfo) {
        ArrayList<String> info = new ArrayList<String>();
        if (!StringUtils.isBlank((String)authors)) {
            info.add(authors.trim());
        }
        if (!StringUtils.isBlank((String)date)) {
            info.add("(" + date.trim() + ")");
        }
        if (!StringUtils.isBlank((String)title)) {
            info.add(title.trim());
        }
        if (!StringUtils.isBlank((String)aditionalInfo)) {
            info.add(aditionalInfo.trim());
        }
        return info.stream().collect(Collectors.joining(". ")).trim();
    }
}

