/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.legalpt.domain.rebides;

import com.google.common.collect.Sets;
import java.util.Set;
import org.fenixedu.commons.i18n.LocalizedString;
import org.fenixedu.legalpt.domain.LegalReportContext;
import org.fenixedu.legalpt.domain.rebides.RebidesInstance_Base;
import org.fenixedu.legalpt.domain.rebides.mapping.RebidesMappingType;
import org.fenixedu.legalpt.domain.rebides.report.RebidesRequestParameter;
import org.fenixedu.legalpt.dto.rebides.RebidesBean;
import org.fenixedu.legalpt.services.commons.export.XmlZipFileWriter;
import org.fenixedu.legalpt.services.rebides.export.RebidesXlsExporter;
import org.fenixedu.legalpt.services.rebides.export.RebidesXmlToBaseFileWriter;
import org.fenixedu.legalpt.services.rebides.process.RebidesService;
import org.fenixedu.legalpt.services.report.log.XlsExporterLog;
import org.fenixedu.legalpt.util.LegalPTUtil;
import org.fenixedu.ulisboa.specifications.domain.legal.mapping.ILegalMappingType;
import org.fenixedu.ulisboa.specifications.domain.legal.report.LegalReportRequest;
import org.fenixedu.ulisboa.specifications.domain.legal.report.LegalReportResultFile;

public class RebidesInstance
extends RebidesInstance_Base {
    public LocalizedString getNameI18N() {
        return LegalPTUtil.bundleI18N("title." + RebidesInstance.class.getName(), new String[0]);
    }

    public Set<ILegalMappingType> getMappingTypes() {
        return Sets.newHashSet((Object[])RebidesMappingType.values());
    }

    public Set<?> getPossibleKeys(String type) {
        return RebidesMappingType.valueOf(type).getValues();
    }

    public LocalizedString getMappingTypeNameI18N(String type) {
        return RebidesMappingType.valueOf(type).getName();
    }

    public LocalizedString getLocalizedNameMappingKey(String type, String key) {
        return RebidesMappingType.valueOf(type).getLocalizedNameKey(key);
    }

    public static RebidesInstance getInstance() {
        return (RebidesInstance)((Object)RebidesInstance.find(RebidesInstance.class));
    }

    public void executeProcessing(LegalReportRequest reportRequest) {
        RebidesService service = new RebidesService(reportRequest);
        RebidesRequestParameter parameter = reportRequest.getParametersAs(RebidesRequestParameter.class);
        RebidesBean rebidesBean = service.process(parameter.getExecutionYear());
        RebidesXlsExporter.write(reportRequest, rebidesBean);
        LegalReportResultFile xml = RebidesXmlToBaseFileWriter.write(reportRequest, rebidesBean);
        XlsExporterLog.write(reportRequest, LegalReportContext.getReport());
        XmlZipFileWriter.write(reportRequest, xml, this.getPasswordToZip());
        reportRequest.markAsProcessed();
    }
}

