/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.legalpt.services.rebides.export;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.commons.spreadsheet.SheetData;
import org.fenixedu.commons.spreadsheet.SpreadsheetBuilder;
import org.fenixedu.commons.spreadsheet.WorkbookExportFormat;
import org.fenixedu.legalpt.domain.report.LegalReportRequest;
import org.fenixedu.legalpt.domain.report.LegalReportResultFile;
import org.fenixedu.legalpt.domain.report.LegalReportResultFileType;
import org.fenixedu.legalpt.dto.rebides.CareerActivitiesBean;
import org.fenixedu.legalpt.dto.rebides.IdentificationBean;
import org.fenixedu.legalpt.dto.rebides.QualificationBean;
import org.fenixedu.legalpt.dto.rebides.RebidesBean;
import org.fenixedu.legalpt.dto.rebides.TeacherBean;

public class RebidesXlsExporter {
    public static LegalReportResultFile write(LegalReportRequest reportRequest, RebidesBean rebides) {
        ArrayList<QualificationTeacher> qualificationTeacherList = new ArrayList<QualificationTeacher>();
        for (TeacherBean teacherBean : rebides.getTeachers()) {
            for (QualificationBean qualificationBean : teacherBean.getQualifications()) {
                QualificationTeacher qualificationTeacher = new QualificationTeacher(teacherBean, qualificationBean);
                qualificationTeacherList.add(qualificationTeacher);
            }
        }
        SheetData<TeacherBean> identificationData = new SheetData<TeacherBean>(rebides.getTeachers()){

            protected void makeLine(TeacherBean teacherBean) {
                IdentificationBean bean = teacherBean.getIdentification();
                this.addCell("Nome", bean.getName());
                this.addCell("NumeroID", bean.getDocumentIdNumber());
                this.addCell("TipoID", bean.getDocumentIdType());
                this.addCell("OutroTipoID", bean.getOtherIdDocumentType());
                this.addCell("DataNascimento", bean.getDateOfBirth());
                this.addCell("Sexo", bean.getGender());
                this.addCell("PaisDeNacionalidade", bean.getNationalityCountry());
                this.addCell("OutroPaisDeNacionalidade", bean.getOtherNationalityCountry());
            }
        };
        SheetData<TeacherBean> careerActivitiesData = new SheetData<TeacherBean>(rebides.getTeachers()){

            protected void makeLine(TeacherBean teacherBean) {
                CareerActivitiesBean bean = teacherBean.getCareerActivities();
                this.addCell("Nome", teacherBean.getIdentification().getName());
                this.addCell("NumeroID", teacherBean.getIdentification().getDocumentIdNumber());
                this.addCell("Departamento", bean.getDepartment());
                this.addCell("OutroDepartamento", bean.getOtherDepartment());
                this.addCell("Categoria", bean.getCategory());
                this.addCell("Convidado", bean.getGuest());
                this.addCell("Equiparado", bean.getSchoolStaff());
                this.addCell("ProvasAptidao", bean.getAptitudeTests());
                this.addCell("ProvasAgregacao", bean.getAggregationTests());
                this.addCell("ProvasEspecialista", bean.getExpertTests());
                this.addCell("RegimePrestacaoServico", bean.getServiceRegime());
                this.addCell("RegimeParcial", bean.getPartialRegime());
                this.addCell("RegimeVinculacao", bean.getBindingRegime());
                this.addCell("Indice", bean.getContractWageLevel());
                this.addCell("PercentagemInvestigacao", bean.getResearchPercentage());
                this.addCell("Docencia", bean.getTeaching());
                this.addCell("HorasLetivas", bean.getTeachingHoursPercentage());
                this.addCell("UnidadeHL", bean.getTeachingHoursUnit());
                this.addCell("ActReitor", bean.getRootUnitPresident());
                this.addCell("ActViceReitor", bean.getRootUnitVicePresident());
                this.addCell("ActDiretor", bean.getUnitPresident());
                this.addCell("ActCoordena", bean.getUnitCoordinator());
                this.addCell("ActConsGeral", bean.getCoordenatorGeneralCouncil());
                this.addCell("ActConsGest", bean.getManagementCouncilActivities());
                this.addCell("ActConsCient", bean.getScientificCouncilActivities());
                this.addCell("ActConsPedag", bean.getPedagogicCouncilActivities());
                this.addCell("ActFormacao", bean.getCoachingOrResearchProjectActivities());
                this.addCell("ActOutra", bean.getOtherActivity());
                this.addCell("ActOutraDescr", bean.getOtherActivityDescription());
            }
        };
        SheetData<QualificationTeacher> qualificationsData = new SheetData<QualificationTeacher>(qualificationTeacherList){

            protected void makeLine(QualificationTeacher qualificationTeacher) {
                TeacherBean teacherBean = qualificationTeacher.teacherBean;
                this.addCell("Nome", teacherBean.getIdentification().getName());
                this.addCell("NumeroID", teacherBean.getIdentification().getDocumentIdNumber());
                QualificationBean bean = qualificationTeacher.qualificationBean;
                this.addCell("NivelFormacao", bean.getSchoolLevel());
                this.addCell("TipoNivelFormacao", bean.getSchoolLevelOrigin());
                this.addCell("Estabelecimento", bean.getInstituition());
                this.addCell("OutroEstabelecimento", bean.getOtherInstituition());
                this.addCell("Curso", bean.getDegree());
                this.addCell("OutroCurso", bean.getOtherDegree());
                this.addCell("Especialidade", bean.getExpertiseArea());
                this.addCell("OutraEspecialidade", bean.getOtherExpertiseArea());
                this.addCell("AreaCientifica", bean.getScientificArea());
            }
        };
        ByteArrayOutputStream outputStream = null;
        try {
            outputStream = new ByteArrayOutputStream();
            SpreadsheetBuilder spreadsheetBuilder = new SpreadsheetBuilder();
            spreadsheetBuilder.addSheet("Situa\u00e7\u00e3o Carreira Atividades", (SheetData)careerActivitiesData);
            spreadsheetBuilder.addSheet("Habilitacoes", (SheetData)qualificationsData);
            spreadsheetBuilder.addSheet("Docentes", (SheetData)identificationData);
            spreadsheetBuilder.build(WorkbookExportFormat.EXCEL, (OutputStream)outputStream);
            byte[] content = outputStream.toByteArray();
            LegalReportResultFile legalReportResultFile = new LegalReportResultFile(reportRequest, LegalReportResultFileType.XLSX, content);
            return legalReportResultFile;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new DomainException("error.XlsxExporter.spreadsheet.generation.failed", (Throwable)e, new String[0]);
        }
        finally {
            try {
                outputStream.close();
            }
            catch (IOException e) {
                e.printStackTrace();
                throw new DomainException("error.XlsxExporter.spreadsheet.generation.failed", (Throwable)e, new String[0]);
            }
        }
    }

    private static class QualificationTeacher {
        private TeacherBean teacherBean;
        private QualificationBean qualificationBean;

        public QualificationTeacher(TeacherBean teacherBean, QualificationBean qualificationBean) {
            this.teacherBean = teacherBean;
            this.qualificationBean = qualificationBean;
        }
    }
}

