/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.legalpt.services.raides.process;

import com.google.common.base.Strings;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.fenixedu.academic.domain.CompetenceCourseType;
import org.fenixedu.academic.domain.Country;
import org.fenixedu.academic.domain.CurricularCourse;
import org.fenixedu.academic.domain.Degree;
import org.fenixedu.academic.domain.DegreeCurricularPlan;
import org.fenixedu.academic.domain.DistrictSubdivision;
import org.fenixedu.academic.domain.Enrolment;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.SchoolLevelType;
import org.fenixedu.academic.domain.StudentCurricularPlan;
import org.fenixedu.academic.domain.candidacy.StudentCandidacy;
import org.fenixedu.academic.domain.degreeStructure.CourseGroup;
import org.fenixedu.academic.domain.degreeStructure.RootCourseGroup;
import org.fenixedu.academic.domain.organizationalStructure.AcademicalInstitutionType;
import org.fenixedu.academic.domain.organizationalStructure.UnitUtils;
import org.fenixedu.academic.domain.raides.DegreeClassification;
import org.fenixedu.academic.domain.raides.DegreeDesignation;
import org.fenixedu.academic.domain.student.PersonalIngressionData;
import org.fenixedu.academic.domain.student.PrecedentDegreeInformation;
import org.fenixedu.academic.domain.student.Registration;
import org.fenixedu.academic.domain.student.RegistrationServices;
import org.fenixedu.academic.domain.student.curriculum.conclusion.RegistrationConclusionInformation;
import org.fenixedu.academic.domain.student.curriculum.conclusion.RegistrationConclusionServices;
import org.fenixedu.academic.domain.studentCurriculum.CurriculumGroup;
import org.fenixedu.academic.domain.studentCurriculum.CycleCurriculumGroup;
import org.fenixedu.legalpt.domain.LegalReportContext;
import org.fenixedu.legalpt.domain.mapping.LegalMapping;
import org.fenixedu.legalpt.domain.raides.IGrauPrecedenteCompleto;
import org.fenixedu.legalpt.domain.raides.IMatricula;
import org.fenixedu.legalpt.domain.raides.Raides;
import org.fenixedu.legalpt.domain.raides.RaidesReportEntryTarget;
import org.fenixedu.legalpt.domain.raides.TblInscrito;
import org.fenixedu.legalpt.domain.raides.mapping.BranchMappingType;
import org.fenixedu.legalpt.domain.raides.mapping.LegalMappingType;
import org.fenixedu.legalpt.domain.raides.report.RaidesRequestPeriodParameter;
import org.fenixedu.legalpt.domain.report.LegalReport;
import org.fenixedu.legalpt.util.LegalPTUtil;
import org.joda.time.DateTime;
import pt.ist.fenixframework.DomainObject;

public class RaidesService {
    private static final int MAX_OTHER_SCHOOL_LEVEL_LENGTH = 80;
    protected LegalReport report;
    private static AttendanceRegimeProvider ATTENDANCE_REGIME_PROVIDER = (rpt, r, ey, mob) -> {
        boolean onlyEnrolledOnDissertation = RaidesService.isOnlyEnrolledOnCompetenceCourseType(r, ey, mob, CompetenceCourseType.DISSERTATION);
        boolean onlyEnrolledOnInternship = RaidesService.isOnlyEnrolledOnCompetenceCourseType(r, ey, mob, CompetenceCourseType.INTERNSHIP);
        boolean onlyEnrolledOnProjectWork = RaidesService.isOnlyEnrolledOnCompetenceCourseType(r, ey, mob, CompetenceCourseType.PROJECT_WORK);
        if (onlyEnrolledOnDissertation || onlyEnrolledOnInternship || onlyEnrolledOnProjectWork) {
            return LegalMapping.find(rpt, LegalMappingType.REGIME_FREQUENCIA).translate("ETD_CODE");
        }
        return LegalMapping.find(rpt, LegalMappingType.REGIME_FREQUENCIA).translate(r.getDegree().getExternalId());
    };

    public RaidesService(LegalReport report) {
        this.report = report;
    }

    protected String anoCurricular(Registration registration, ExecutionYear executionYear, boolean mobility) {
        if (Raides.isDoctoralDegree(registration)) {
            return LegalMapping.find(this.report, LegalMappingType.CURRICULAR_YEAR).translate("NAO_APLICAVEL_CODE");
        }
        if (RaidesService.isOnlyEnrolledOnCompetenceCourseType(registration, executionYear, mobility, CompetenceCourseType.DISSERTATION)) {
            return LegalMapping.find(this.report, LegalMappingType.CURRICULAR_YEAR).translate("DISSERTACAO_CODE");
        }
        if (RaidesService.isOnlyEnrolledOnCompetenceCourseType(registration, executionYear, mobility, CompetenceCourseType.INTERNSHIP)) {
            return LegalMapping.find(this.report, LegalMappingType.CURRICULAR_YEAR).translate("ESTAGIO_FINAL_CODE");
        }
        if (RaidesService.isOnlyEnrolledOnCompetenceCourseType(registration, executionYear, mobility, CompetenceCourseType.PROJECT_WORK)) {
            return LegalMapping.find(this.report, LegalMappingType.CURRICULAR_YEAR).translate("TRABALHO_PROJECTO_CODE");
        }
        return LegalMapping.find(this.report, LegalMappingType.CURRICULAR_YEAR).translate(String.valueOf(RegistrationServices.getCurricularYear((Registration)registration, (ExecutionYear)executionYear).getResult()));
    }

    public static boolean isOnlyEnrolledOnCompetenceCourseType(Registration registration, ExecutionYear executionYear, boolean mobility, CompetenceCourseType competenceCourseType) {
        Collection enrolments = registration.getEnrolments(executionYear);
        HashSet typesSet = Sets.newHashSet();
        for (Enrolment enrolment : enrolments) {
            if (!mobility && enrolment.getCurriculumGroup().isNoCourseGroupCurriculumGroup()) continue;
            CurricularCourse curricularCourse = enrolment.getCurricularCourse();
            CompetenceCourseType type = curricularCourse != null ? curricularCourse.getCompetenceCourse().getType() : CompetenceCourseType.REGULAR;
            typesSet.add(type);
        }
        if (typesSet.size() != 1) {
            return false;
        }
        return typesSet.iterator().next() == competenceCourseType;
    }

    protected boolean isFirstTimeOnDegree(Registration registration, ExecutionYear executionYear) {
        if (!RegistrationServices.getPrecedentDegreeRegistrations((Registration)registration).isEmpty() && RegistrationServices.getEnrolmentYearsIncludingPrecedentRegistrations((Registration)registration, (ExecutionYear)executionYear).size() > 1) {
            return false;
        }
        return executionYear == registration.getRegistrationYear();
    }

    protected void preencheInformacaoMatricula(LegalReport report, IMatricula bean, ExecutionYear executionYear, Registration registration) {
        bean.setIdAluno(registration.getStudent().getNumber().toString());
        bean.setAnoLectivo(executionYear.getQualifiedName());
        DegreeCurricularPlan degreeCurricularPlan = this.getStudentCurricularPlanForBranch(registration, executionYear).getDegreeCurricularPlan();
        LegalMapping oficialDegreeMapping = LegalMapping.find(report, LegalMappingType.DEGREE_CURRICULAR_PLAN_DEGREE_OFICIAL_CODE);
        if (oficialDegreeMapping != null && oficialDegreeMapping.isKeyDefined(degreeCurricularPlan)) {
            bean.setCurso(oficialDegreeMapping.translate((DomainObject)degreeCurricularPlan));
        } else {
            bean.setCurso(registration.getDegree().getMinistryCode());
        }
        this.preencheRamo(report, bean, executionYear, registration, false);
    }

    protected void preencheRamo(LegalReport report, IMatricula bean, ExecutionYear executionYear, Registration registration, boolean forScholarPart) {
        Set<CourseGroup> branches;
        Set<CourseGroup> set = branches = forScholarPart ? this.scholarPartBranches(registration, executionYear) : this.branches(registration, executionYear);
        if (!forScholarPart) {
            bean.setRamo(null);
        }
        if (!branches.isEmpty()) {
            if (branches.size() > 1) {
                LegalReportContext.addError(RaidesReportEntryTarget.of(registration, executionYear), this.i18n("error.Raides.validation.enrolled.more.than.one.branch", new String[0]), this.i18n("error.Raides.validation.enrolled.more.than.one.branch.action", new String[0]));
                bean.markAsInvalid();
            }
            bean.setRamo(BranchMappingType.readMapping(report).translate((DomainObject)branches.iterator().next()));
        } else {
            RootCourseGroup rootCourseGroup = this.getStudentCurricularPlanForBranch(registration, executionYear).getRoot().getDegreeModule();
            LegalMapping branchMapping = BranchMappingType.readMapping(report);
            bean.setRamo(branchMapping.isKeyDefined(rootCourseGroup) ? branchMapping.translate((DomainObject)rootCourseGroup) : "1000017");
        }
    }

    private Set<CourseGroup> branches(Registration registration, ExecutionYear executionYear) {
        HashSet result = Sets.newHashSet();
        StudentCurricularPlan scp = this.getStudentCurricularPlanForBranch(registration, executionYear);
        for (CurriculumGroup curriculumGroup : scp.getAllCurriculumGroups()) {
            if (curriculumGroup.getDegreeModule() == null || this.isAffinity(curriculumGroup)) continue;
            CourseGroup courseGroup = curriculumGroup.getDegreeModule();
            if (!BranchMappingType.readMapping(this.report).isKeyDefined(courseGroup)) continue;
            result.add(courseGroup);
        }
        return result;
    }

    private Set<CourseGroup> scholarPartBranches(Registration registration, ExecutionYear executionYear) {
        HashSet result = Sets.newHashSet();
        RegistrationConclusionInformation conclusionInfoToUse = null;
        for (RegistrationConclusionInformation conclusionInfo : RegistrationConclusionServices.inferConclusion((Registration)registration)) {
            if (!conclusionInfo.isScholarPart() || !conclusionInfo.isConcluded()) continue;
            conclusionInfoToUse = conclusionInfo;
            break;
        }
        for (CurriculumGroup curriculumGroup : conclusionInfoToUse.getCurriculumGroup().getAllCurriculumGroups()) {
            if (curriculumGroup.getDegreeModule() == null || this.isAffinity(curriculumGroup)) continue;
            CourseGroup courseGroup = curriculumGroup.getDegreeModule();
            if (!BranchMappingType.readMapping(this.report).isKeyDefined(courseGroup)) continue;
            result.add(courseGroup);
        }
        return result;
    }

    private boolean isAffinity(CurriculumGroup curriculumGroup) {
        CycleCurriculumGroup parentCycleCurriculumGroup = curriculumGroup.getParentCycleCurriculumGroup();
        return curriculumGroup.isExternal() || parentCycleCurriculumGroup != null && parentCycleCurriculumGroup.isExternal();
    }

    protected StudentCurricularPlan getStudentCurricularPlanForBranch(Registration registration, ExecutionYear executionYear) {
        return registration.getStudentCurricularPlansSet().size() == 1 ? registration.getLastStudentCurricularPlan() : registration.getStudentCurricularPlan(executionYear);
    }

    protected void preencheGrauPrecedentCompleto(IGrauPrecedenteCompleto bean, ExecutionYear executionYear, Registration registration) {
        String value;
        StudentCandidacy studentCandidacy = registration.getStudentCandidacy();
        PrecedentDegreeInformation lastCompletedQualification = studentCandidacy.getCompletedDegreeInformation();
        RaidesReportEntryTarget target = RaidesReportEntryTarget.of(registration, executionYear);
        if (lastCompletedQualification == null) {
            return;
        }
        if (lastCompletedQualification.getSchoolLevel() != null) {
            value = LegalMapping.find(this.report, LegalMappingType.PRECEDENT_SCHOOL_LEVEL).translate((Enum<?>)lastCompletedQualification.getSchoolLevel());
            if (StringUtils.isBlank((CharSequence)value)) {
                LegalReportContext.addError(target, this.i18n("error.Raides.validation.previous.complete.school.level.missing.translate", lastCompletedQualification.getSchoolLevel().getLocalizedName()), this.i18n("error.Raides.validation.previous.complete.school.level.missing.translate.action", lastCompletedQualification.getSchoolLevel().getLocalizedName()));
                bean.markAsInvalid();
            } else {
                bean.setEscolaridadeAnterior(value);
                if (bean.getEscolaridadeAnterior() != null && bean.getEscolaridadeAnterior().equals("19")) {
                    if (!Strings.isNullOrEmpty((String)lastCompletedQualification.getOtherSchoolLevel())) {
                        bean.setOutroEscolaridadeAnterior(lastCompletedQualification.getOtherSchoolLevel().substring(0, Math.min(80, lastCompletedQualification.getOtherSchoolLevel().length())));
                    } else {
                        bean.setOutroEscolaridadeAnterior(lastCompletedQualification.getSchoolLevel().getLocalizedName().substring(0, Math.min(80, lastCompletedQualification.getSchoolLevel().getLocalizedName().length())));
                    }
                }
            }
        }
        if (lastCompletedQualification.getCountry() != null) {
            bean.setPaisEscolaridadeAnt(lastCompletedQualification.getCountry().getCode());
        }
        if (lastCompletedQualification.getConclusionYear() != null) {
            bean.setAnoEscolaridadeAnt(lastCompletedQualification.getConclusionYear().toString());
        }
        if (this.isPortuguesePostHighSchool(lastCompletedQualification) && !Strings.isNullOrEmpty((String)lastCompletedQualification.getDegreeDesignation())) {
            if (lastCompletedQualification.getInstitution() != null && (lastCompletedQualification.getInstitution().isOfficial() || UnitUtils.readInstitutionUnit() == lastCompletedQualification.getInstitution())) {
                bean.setEstabEscolaridadeAnt(lastCompletedQualification.getInstitution().getCode());
            } else if (lastCompletedQualification.getInstitution() != null) {
                bean.setEstabEscolaridadeAnt("0000");
                bean.setOutroEstabEscolarAnt(lastCompletedQualification.getInstitution().getNameI18n().getContent());
            }
            DegreeDesignation degreeDesignation = DegreeDesignation.readByNameAndSchoolLevel((String)lastCompletedQualification.getDegreeDesignation(), (SchoolLevelType)lastCompletedQualification.getSchoolLevel());
            if (degreeDesignation != null) {
                bean.setCursoEscolarAnt(degreeDesignation.getCode());
            } else {
                bean.setCursoEscolarAnt("0000");
                bean.setOutroCursoEscolarAnt(lastCompletedQualification.getDegreeDesignation());
            }
        }
        if (bean.isTipoEstabSecSpecified() && lastCompletedQualification.getSchoolLevel() != null && lastCompletedQualification.getSchoolLevel().isHighSchoolOrEquivalent()) {
            if (this.highSchoolType(studentCandidacy) != null) {
                value = LegalMapping.find(this.report, LegalMappingType.HIGH_SCHOOL_TYPE).translate((Enum<?>)this.highSchoolType(studentCandidacy));
                if (StringUtils.isBlank((CharSequence)value)) {
                    LegalReportContext.addError(target, this.i18n("error.Raides.validation.highSchoolType.missing.translate", this.highSchoolType(studentCandidacy).getName()), this.i18n("error.Raides.validation.highSchoolType.missing.translate.action", this.highSchoolType(studentCandidacy).getName()));
                    bean.markAsInvalid();
                } else {
                    bean.setTipoEstabSec(value);
                }
            }
            if (Strings.isNullOrEmpty((String)bean.getTipoEstabSec())) {
                bean.setTipoEstabSec("1");
                LegalReportContext.addWarn(RaidesReportEntryTarget.of(registration, executionYear), this.i18n("warn.Raides.highSchoolType.not.specified", new String[0]));
            }
        }
        if (Strings.isNullOrEmpty((String)bean.getTipoEstabSec()) && registration.getStudent().getLatestPersonalIngressionData() != null && registration.getStudent().getLatestPersonalIngressionData().getHighSchoolType() != null) {
            PersonalIngressionData personalIngressionData = registration.getStudent().getLatestPersonalIngressionData();
            bean.setTipoEstabSec(LegalMapping.find(this.report, LegalMappingType.HIGH_SCHOOL_TYPE).translate((Enum<?>)personalIngressionData.getHighSchoolType()));
        }
        this.validaGrauPrecedenteCompleto(executionYear, registration, lastCompletedQualification, bean);
        this.validaCursoOficialInstituicaoOficial(executionYear, registration, lastCompletedQualification, bean);
    }

    private AcademicalInstitutionType highSchoolType(StudentCandidacy studentCandidacy) {
        if (studentCandidacy.getCompletedDegreeInformation() != null && studentCandidacy.getCompletedDegreeInformation().getInstitutionType() != null) {
            return studentCandidacy.getCompletedDegreeInformation().getInstitutionType();
        }
        if (studentCandidacy.getPerson().getStudent() != null) {
            for (PersonalIngressionData pid : studentCandidacy.getPerson().getStudent().getPersonalIngressionsDataSet()) {
                if (pid.getHighSchoolType() == null) continue;
                return pid.getHighSchoolType();
            }
        }
        return null;
    }

    protected boolean isPortuguesePostHighSchool(PrecedentDegreeInformation lastCompletedQualification) {
        return lastCompletedQualification.getCountry() != null && lastCompletedQualification.getCountry().isDefaultCountry() && this.isPostHighEducation(lastCompletedQualification);
    }

    protected boolean isPostHighEducation(PrecedentDegreeInformation precedentDegreeInformation) {
        return precedentDegreeInformation.getSchoolLevel() != null && (precedentDegreeInformation.getSchoolLevel().isHigherEducation() || this.isCetEducation(precedentDegreeInformation));
    }

    protected boolean isCetEducation(PrecedentDegreeInformation lastCompletedQualification) {
        return lastCompletedQualification.getSchoolLevel() != null && lastCompletedQualification.getSchoolLevel() == SchoolLevelType.TECHNICAL_SPECIALIZATION;
    }

    protected void validaGrauPrecedenteCompleto(ExecutionYear executionYear, Registration registration, PrecedentDegreeInformation lastCompletedQualification, IGrauPrecedenteCompleto bean) {
        Integer previousConclusionYear;
        RaidesReportEntryTarget target = RaidesReportEntryTarget.of(registration, executionYear);
        if (Strings.isNullOrEmpty((String)bean.getEscolaridadeAnterior())) {
            LegalReportContext.addError(target, this.i18n("error.Raides.validation.previous.complete.school.level.missing", new String[0]), this.i18n("error.Raides.validation.previous.complete.school.level.missing.action", new String[0]));
            bean.markAsInvalid();
        }
        if (Strings.isNullOrEmpty((String)bean.getPaisEscolaridadeAnt())) {
            LegalReportContext.addError(target, this.i18n("error.Raides.validation.previous.complete.country.missing", new String[0]), this.i18n("error.Raides.validation.previous.complete.country.missing.action", new String[0]));
            bean.markAsInvalid();
        }
        if (Strings.isNullOrEmpty((String)bean.getAnoEscolaridadeAnt())) {
            LegalReportContext.addError(target, this.i18n("error.Raides.validation.previous.complete.year.missing", new String[0]), this.i18n("error.Raides.validation.previous.complete.year.missing.action", new String[0]));
            bean.markAsInvalid();
        } else if (registration.getPerson().getDateOfBirthYearMonthDay() != null && (previousConclusionYear = Integer.valueOf(bean.getAnoEscolaridadeAnt())) < registration.getPerson().getDateOfBirthYearMonthDay().getYear() + Raides.Idade.MIN) {
            LegalReportContext.addError(target, this.i18n("error.Raides.validation.previous.complete.year.invalid", new String[0]), this.i18n("error.Raides.validation.previous.complete.year.invalid.action", new String[0]));
            bean.markAsInvalid();
        }
        this.validaEstabelecimentoAnteriorCompleto(executionYear, registration, lastCompletedQualification, bean);
        this.validaCursoAnteriorCompleto(executionYear, registration, lastCompletedQualification, bean);
        if (!bean.isTipoEstabSecSpecified()) {
            return;
        }
        if (lastCompletedQualification.getSchoolLevel() != null && lastCompletedQualification.getSchoolLevel().isHighSchoolOrEquivalent() && Strings.isNullOrEmpty((String)bean.getTipoEstabSec())) {
            LegalReportContext.addError(target, this.i18n("error.Raides.validation.previous.complete.highSchoolType.missing", new String[0]), this.i18n("error.Raides.validation.previous.complete.highSchoolType.missing.action", new String[0]));
            bean.markAsInvalid();
        }
    }

    protected void validaEstabelecimentoAnteriorCompleto(ExecutionYear executionYear, Registration registration, PrecedentDegreeInformation lastCompletedQualification, IGrauPrecedenteCompleto bean) {
        RaidesReportEntryTarget target = RaidesReportEntryTarget.of(registration, executionYear);
        if (lastCompletedQualification.getCountry() == null || !lastCompletedQualification.getCountry().isDefaultCountry()) {
            return;
        }
        if (lastCompletedQualification.getSchoolLevel() == null || !this.isPostHighEducation(lastCompletedQualification)) {
            return;
        }
        if (Strings.isNullOrEmpty((String)bean.getEstabEscolaridadeAnt())) {
            LegalReportContext.addError(target, this.i18n("error.Raides.validation.previous.complete.institution.missing", new String[0]), this.i18n("error.Raides.validation.previous.complete.institution.missing.action", new String[0]));
            bean.markAsInvalid();
        }
        if ("0000".equals(bean.getEstabEscolaridadeAnt()) && Strings.isNullOrEmpty((String)bean.getOutroEstabEscolarAnt())) {
            LegalReportContext.addError(target, this.i18n("error.Raides.validation.previous.complete.other.institution.missing", new String[0]), this.i18n("error.Raides.validation.previous.complete.other.institution.missing.action", new String[0]));
            bean.markAsInvalid();
        } else if ("0000".equals(bean.getEstabEscolaridadeAnt())) {
            LegalReportContext.addWarn(target, this.i18n("warn.Raides.validation.previous.complete.other.institution.given.instead.of.code", new String[0]));
            bean.markAsInvalid();
        }
    }

    protected void validaCursoOficialInstituicaoOficial(ExecutionYear executionYear, Registration registration, PrecedentDegreeInformation lastCompletedQualification, IGrauPrecedenteCompleto bean) {
        RaidesReportEntryTarget target = RaidesReportEntryTarget.of(registration, executionYear);
        if (!this.isPortuguesePostHighSchool(lastCompletedQualification)) {
            return;
        }
        if (Strings.isNullOrEmpty((String)lastCompletedQualification.getDegreeDesignation())) {
            return;
        }
        DegreeDesignation degreeDesignation = DegreeDesignation.readByNameAndSchoolLevel((String)lastCompletedQualification.getDegreeDesignation(), (SchoolLevelType)lastCompletedQualification.getSchoolLevel());
        if (degreeDesignation == null) {
            return;
        }
        boolean degreeDesignationContainsInstitution = false;
        for (DegreeDesignation it : this.readByNameAndSchoolLevel(lastCompletedQualification.getDegreeDesignation(), lastCompletedQualification.getSchoolLevel())) {
            degreeDesignationContainsInstitution |= it.getInstitutionUnitSet().contains(lastCompletedQualification.getInstitution());
        }
        if (!degreeDesignationContainsInstitution) {
            LegalReportContext.addError(target, this.i18n("error.Raides.validation.official.precedent.degree.is.not.offered.by.institution", new String[0]), this.i18n("error.Raides.validation.official.precedent.degree.is.not.offered.by.institution.action", new String[0]));
            bean.markAsInvalid();
        }
        if ((Raides.isMasterDegreeOrDoctoralDegree(registration) || Raides.isSpecializationDegree(registration)) && !this.isPostHighEducation(lastCompletedQualification)) {
            LegalReportContext.addError(target, this.i18n("error.Raides.validation.isMasterDoctoralOrSpecialization.but.completed.qualification.is.not.higher", new String[0]), this.i18n("error.Raides.validation.isMasterDoctoralOrSpecialization.but.completed.qualification.is.not.higher.action", new String[0]));
            bean.markAsInvalid();
        }
    }

    protected void validaCursoAnteriorCompleto(ExecutionYear executionYear, Registration registration, PrecedentDegreeInformation lastCompletedQualification, IGrauPrecedenteCompleto bean) {
        RaidesReportEntryTarget target = RaidesReportEntryTarget.of(registration, executionYear);
        if (lastCompletedQualification.getCountry() == null || !lastCompletedQualification.getCountry().isDefaultCountry()) {
            return;
        }
        if (lastCompletedQualification.getSchoolLevel() == null || !this.isPostHighEducation(lastCompletedQualification)) {
            return;
        }
        if (Strings.isNullOrEmpty((String)bean.getCursoEscolarAnt())) {
            LegalReportContext.addError(target, this.i18n("error.Raides.validation.previous.complete.degree.designation.missing", new String[0]), this.i18n("error.Raides.validation.previous.complete.degree.designation.missing.action", new String[0]));
            bean.markAsInvalid();
        }
        if ("4".equals(bean.getCursoEscolarAnt()) && Strings.isNullOrEmpty((String)bean.getOutroCursoEscolarAnt())) {
            LegalReportContext.addError(target, this.i18n("error.Raides.validation.previous.complete.other.degree.designation.missing", new String[0]), this.i18n("error.Raides.validation.previous.complete.other.degree.designation.missing.action", new String[0]));
            bean.markAsInvalid();
        }
        if (this.isPortuguesePostHighSchool(lastCompletedQualification) && "0000".equals(bean.getCursoEscolarAnt())) {
            LegalReportContext.addError(target, this.i18n("error.Raides.validation.previous.complete.other.degree.designation.set.even.if.level.is.portuguese.higher.education", new String[0]), this.i18n("error.Raides.validation.previous.complete.other.degree.designation.set.even.if.level.is.portuguese.higher.education.action", new String[0]));
            bean.markAsInvalid();
        }
    }

    protected Set<DegreeDesignation> readByNameAndSchoolLevel(String degreeDesignationName, SchoolLevelType schoolLevel) {
        if (schoolLevel == null || degreeDesignationName == null) {
            return null;
        }
        ArrayList<DegreeClassification> possibleClassifications = new ArrayList<DegreeClassification>();
        for (Object code : schoolLevel.getEquivalentDegreeClassifications()) {
            possibleClassifications.add(DegreeClassification.readByCode((String)code));
        }
        ArrayList possibleDesignations = new ArrayList();
        for (DegreeClassification classification : possibleClassifications) {
            if (classification.getDegreeDesignationsSet().isEmpty()) continue;
            possibleDesignations.addAll(classification.getDegreeDesignationsSet());
        }
        HashSet result = Sets.newHashSet();
        for (DegreeDesignation degreeDesignation : possibleDesignations) {
            if (!degreeDesignation.getDescription().equalsIgnoreCase(degreeDesignationName)) continue;
            result.add(degreeDesignation);
        }
        return result;
    }

    protected void preencheInformacaoPessoal(ExecutionYear executionYear, Registration registration, TblInscrito bean) {
        String value;
        PersonalIngressionData ingressionData;
        RaidesReportEntryTarget target = RaidesReportEntryTarget.of(registration, executionYear);
        if (registration.getPerson().getMaritalStatus() != null) {
            String value2 = LegalMapping.find(this.report, LegalMappingType.MARITAL_STATUS).translate((Enum<?>)registration.getPerson().getMaritalStatus());
            if (StringUtils.isBlank((CharSequence)value2)) {
                LegalReportContext.addError(target, this.i18n("error.Raides.validation.maritalStatus.missing.translate", registration.getPerson().getMaritalStatus().getLocalizedName()), this.i18n("error.Raides.validation.maritalStatus.missing.translate.action", registration.getPerson().getMaritalStatus().getLocalizedName()));
                bean.markAsInvalid();
            } else {
                bean.setEstadoCivil(value2);
            }
        }
        if ((ingressionData = Raides.personalIngressionData(registration, executionYear)) != null && ingressionData.getDislocatedFromPermanentResidence() != null) {
            bean.setAlunoDeslocado(LegalMapping.find(this.report, LegalMappingType.BOOLEAN).translate(ingressionData.getDislocatedFromPermanentResidence()));
        }
        Country countryOfResidence = Raides.countryOfResidence(registration, executionYear);
        DistrictSubdivision districtSubdivision = Raides.districtSubdivisionOfResidence(registration, executionYear);
        if (countryOfResidence != null && districtSubdivision != null) {
            bean.setResideConcelho(districtSubdivision.getDistrict().getCode() + districtSubdivision.getCode());
        } else if (Raides.countryOfResidence(registration, executionYear).isDefaultCountry()) {
            bean.setResideConcelho("9999");
        }
        if (ingressionData != null) {
            if (ingressionData.getFatherSchoolLevel() != null) {
                value = LegalMapping.find(this.report, LegalMappingType.SCHOOL_LEVEL).translate((Enum<?>)ingressionData.getFatherSchoolLevel());
                if (StringUtils.isBlank((CharSequence)value)) {
                    LegalReportContext.addError(target, this.i18n("error.Raides.validation.fatherSchoolLevel.missing.translate", ingressionData.getFatherSchoolLevel().getLocalizedName()), this.i18n("error.Raides.validation.fatherSchoolLevel.missing.translate.action", ingressionData.getFatherSchoolLevel().getLocalizedName()));
                    bean.markAsInvalid();
                } else {
                    bean.setNivelEscolarPai(value);
                }
            }
            if (ingressionData.getMotherSchoolLevel() != null) {
                value = LegalMapping.find(this.report, LegalMappingType.SCHOOL_LEVEL).translate((Enum<?>)ingressionData.getMotherSchoolLevel());
                if (StringUtils.isBlank((CharSequence)value)) {
                    LegalReportContext.addError(target, this.i18n("error.Raides.validation.motherSchoolLevel.missing.translate", ingressionData.getMotherSchoolLevel().getLocalizedName()), this.i18n("error.Raides.validation.motherSchoolLevel.missing.translate.action", ingressionData.getMotherSchoolLevel().getLocalizedName()));
                    bean.markAsInvalid();
                } else {
                    bean.setNivelEscolarMae(value);
                }
            }
            if (ingressionData.getFatherProfessionalCondition() != null) {
                value = LegalMapping.find(this.report, LegalMappingType.PROFESSIONAL_SITUATION_CONDITION).translate((Enum<?>)ingressionData.getFatherProfessionalCondition());
                if (StringUtils.isBlank((CharSequence)value)) {
                    LegalReportContext.addError(target, this.i18n("error.Raides.validation.fatherProfessionalSituationType.missing.translate", ingressionData.getFatherProfessionalCondition().getLocalizedName()), this.i18n("error.Raides.validation.fatherProfessionalSituationType.missing.translate.action", ingressionData.getFatherProfessionalCondition().getLocalizedName()));
                    bean.markAsInvalid();
                } else {
                    bean.setSituacaoProfPai(value);
                }
            }
        }
        if (ingressionData.getMotherProfessionalCondition() != null) {
            value = LegalMapping.find(this.report, LegalMappingType.PROFESSIONAL_SITUATION_CONDITION).translate((Enum<?>)ingressionData.getMotherProfessionalCondition());
            if (StringUtils.isBlank((CharSequence)value)) {
                LegalReportContext.addError(target, this.i18n("error.Raides.validation.motherProfessionalSituationType.missing.translate", ingressionData.getMotherProfessionalCondition().getLocalizedName()), this.i18n("error.Raides.validation.motherProfessionalSituationType.missing.translate.action", ingressionData.getMotherProfessionalCondition().getLocalizedName()));
                bean.markAsInvalid();
            } else {
                bean.setSituacaoProfMae(value);
            }
        }
        if (ingressionData.getProfessionalCondition() != null) {
            value = LegalMapping.find(this.report, LegalMappingType.PROFESSIONAL_SITUATION_CONDITION).translate((Enum<?>)ingressionData.getProfessionalCondition());
            if (StringUtils.isBlank((CharSequence)value)) {
                LegalReportContext.addError(target, this.i18n("error.Raides.validation.studentProfession.missing.translate", ingressionData.getProfessionalCondition().getLocalizedName()), this.i18n("error.Raides.validation.studentProfession.missing.translate.action", ingressionData.getProfessionalCondition().getLocalizedName()));
                bean.markAsInvalid();
            } else {
                bean.setSituacaoProfAluno(value);
            }
        }
        if (ingressionData.getFatherProfessionType() != null) {
            value = LegalMapping.find(this.report, LegalMappingType.PROFESSION_TYPE).translate((Enum<?>)ingressionData.getFatherProfessionType());
            if (StringUtils.isBlank((CharSequence)value)) {
                LegalReportContext.addError(target, this.i18n("error.Raides.validation.fatherProfession.missing.translate", ingressionData.getFatherProfessionType().getLocalizedName()), this.i18n("error.Raides.validation.fatherProfession.missing.translate.action", ingressionData.getFatherProfessionType().getLocalizedName()));
                bean.markAsInvalid();
            } else {
                bean.setProfissaoPai(this.transformProfessionTypeMappingValue(bean.getSituacaoProfPai(), value));
            }
        }
        if (ingressionData.getMotherProfessionType() != null) {
            value = LegalMapping.find(this.report, LegalMappingType.PROFESSION_TYPE).translate((Enum<?>)ingressionData.getMotherProfessionType());
            if (StringUtils.isBlank((CharSequence)value)) {
                LegalReportContext.addError(target, this.i18n("error.Raides.validation.motherProfession.missing.translate", ingressionData.getMotherProfessionType().getLocalizedName()), this.i18n("error.Raides.validation.motherProfession.missing.translate.action", ingressionData.getMotherProfessionType().getLocalizedName()));
                bean.markAsInvalid();
            } else {
                bean.setProfissaoMae(this.transformProfessionTypeMappingValue(bean.getSituacaoProfMae(), value));
            }
        }
        if (ingressionData.getProfessionType() != null) {
            value = LegalMapping.find(this.report, LegalMappingType.PROFESSION_TYPE).translate((Enum<?>)ingressionData.getProfessionType());
            if (StringUtils.isBlank((CharSequence)value)) {
                LegalReportContext.addError(target, this.i18n("error.Raides.validation.studentProfession.missing.translate", ingressionData.getProfessionType().getLocalizedName()), this.i18n("error.Raides.validation.studentProfession.missing.translate.action", ingressionData.getProfessionType().getLocalizedName()));
                bean.markAsInvalid();
            } else {
                bean.setProfissaoAluno(this.transformProfessionTypeMappingValue(bean.getSituacaoProfAluno(), value));
            }
        }
        this.validaInformacaoPessoal(executionYear, registration, bean);
    }

    private String transformProfessionTypeMappingValue(String professionalSituation, String professionType) {
        return Raides.SituacaoProfissional.requiresProfessionType(professionalSituation) ? professionType : null;
    }

    protected void validaInformacaoPessoal(ExecutionYear executionYear, Registration registration, TblInscrito bean) {
        RaidesReportEntryTarget target = RaidesReportEntryTarget.of(registration, executionYear);
        if (Strings.isNullOrEmpty((String)bean.getEstadoCivil())) {
            LegalReportContext.addError(target, this.i18n("error.Raides.validation.maritalStatus.missing", new String[0]), this.i18n("error.Raides.validation.maritalStatus.missing.action", new String[0]));
            bean.markAsInvalid();
        }
        if (Strings.isNullOrEmpty((String)bean.getAlunoDeslocado())) {
            LegalReportContext.addError(target, this.i18n("error.Raides.validation.dislocated.from.residence.missing", new String[0]), this.i18n("error.Raides.validation.dislocated.from.residence.missing.action", new String[0]));
            bean.markAsInvalid();
        }
        if (Raides.countryOfResidence(registration, executionYear) != null && Raides.countryOfResidence(registration, executionYear).isDefaultCountry() && Strings.isNullOrEmpty((String)bean.getResideConcelho())) {
            LegalReportContext.addError(target, this.i18n("error.Raides.validation.district.subdivision.missing", new String[0]), this.i18n("error.Raides.validation.district.subdivision.missing.action", new String[0]));
            bean.markAsInvalid();
        }
        if (Strings.isNullOrEmpty((String)bean.getSituacaoProfPai())) {
            LegalReportContext.addError(target, this.i18n("error.Raides.validation.fatherProfessionalSituationType.missing", new String[0]), this.i18n("error.Raides.validation.fatherProfessionalSituationType.missing.action", new String[0]));
            bean.markAsInvalid();
        }
        if (Strings.isNullOrEmpty((String)bean.getNivelEscolarPai())) {
            LegalReportContext.addError(target, this.i18n("error.Raides.validation.fatherSchoolLevel.missing", new String[0]), this.i18n("error.Raides.validation.fatherSchoolLevel.missing.action", new String[0]));
            bean.markAsInvalid();
        }
        if (Raides.SituacaoProfissional.requiresProfessionType(bean.getSituacaoProfPai()) && Strings.isNullOrEmpty((String)bean.getProfissaoPai())) {
            LegalReportContext.addError(target, this.i18n("error.Raides.validation.fatherProfession.missing", new String[0]), this.i18n("error.Raides.validation.fatherProfession.missing.action", new String[0]));
            bean.markAsInvalid();
        }
        if (Strings.isNullOrEmpty((String)bean.getSituacaoProfMae())) {
            LegalReportContext.addError(target, this.i18n("error.Raides.validation.motherProfessionalSituationType.missing", new String[0]), this.i18n("error.Raides.validation.motherProfessionalSituationType.missing.action", new String[0]));
            bean.markAsInvalid();
        }
        if (Strings.isNullOrEmpty((String)bean.getNivelEscolarMae())) {
            LegalReportContext.addError(target, this.i18n("error.Raides.validation.motherSchoolLevel.missing", new String[0]), this.i18n("error.Raides.validation.motherSchoolLevel.missing.action", new String[0]));
            bean.markAsInvalid();
        }
        if (Raides.SituacaoProfissional.requiresProfessionType(bean.getSituacaoProfMae()) && Strings.isNullOrEmpty((String)bean.getProfissaoMae())) {
            LegalReportContext.addError(target, this.i18n("error.Raides.validation.motherProfession.missing", new String[0]), this.i18n("error.Raides.validation.motherProfession.missing.action", new String[0]));
            bean.markAsInvalid();
        }
        if (Strings.isNullOrEmpty((String)bean.getSituacaoProfAluno())) {
            LegalReportContext.addError(target, this.i18n("error.Raides.validation.studentProfessionalSituationType.missing", new String[0]), this.i18n("error.Raides.validation.studentProfessionalSituationType.missing.action", new String[0]));
            bean.markAsInvalid();
        }
        if (Raides.SituacaoProfissional.requiresProfessionType(bean.getSituacaoProfAluno()) && Strings.isNullOrEmpty((String)bean.getProfissaoAluno())) {
            LegalReportContext.addError(target, this.i18n("error.Raides.validation.studentProfession.missing", new String[0]), this.i18n("error.Raides.validation.studentProfession.missing.action", new String[0]));
            bean.markAsInvalid();
        }
    }

    public static void setAttendanceRegimeProvider(AttendanceRegimeProvider provider) {
        ATTENDANCE_REGIME_PROVIDER = provider;
    }

    protected String regimeFrequencia(Registration registration, ExecutionYear executionYear, boolean mobility) {
        return ATTENDANCE_REGIME_PROVIDER.provide(this.report, registration, executionYear, mobility);
    }

    protected DateTime findMaximumAnnulmentDate(List<RaidesRequestPeriodParameter> periods, ExecutionYear executionYear) {
        return periods.stream().filter(p -> p.getAcademicPeriod() == executionYear).max(Comparator.comparing(RaidesRequestPeriodParameter::getEnd)).get().getEnd().plusDays(1).toDateTimeAtStartOfDay().minusSeconds(1);
    }

    protected BigDecimal enrolledEcts(ExecutionYear executionYear, Registration registration, DateTime maximumAnnulmentDate, boolean mobility) {
        StudentCurricularPlan studentCurricularPlan = registration.getStudentCurricularPlan(executionYear);
        double result = 0.0;
        for (Enrolment enrolment : studentCurricularPlan.getEnrolmentsSet()) {
            if (Raides.isEnrolmentAnnuled(enrolment, maximumAnnulmentDate) || !mobility && enrolment.getCurriculumGroup().isNoCourseGroupCurriculumGroup() || !enrolment.isValid(executionYear)) continue;
            result += enrolment.getEctsCredits().doubleValue();
        }
        return new BigDecimal(result);
    }

    protected Set<Enrolment> scholarPartEnrolments(ExecutionYear executionYear, Registration registration) {
        StudentCurricularPlan studentCurricularPlan = registration.getStudentCurricularPlan(executionYear);
        HashSet result = Sets.newHashSet();
        for (Enrolment enrolment : studentCurricularPlan.getEnrolmentsSet()) {
            if (enrolment.getCurricularCourse() != null && enrolment.getCurricularCourse().isDissertation() || !enrolment.isValid(executionYear)) continue;
            result.add(enrolment);
        }
        return result;
    }

    protected BigDecimal doctoralEnrolledEcts(ExecutionYear executionYear, Registration registration, DateTime maximumAnnulmentDate) {
        if (RaidesService.isOnlyEnrolledOnCompetenceCourseType(registration, executionYear, false, CompetenceCourseType.DISSERTATION)) {
            return null;
        }
        BigDecimal enrolledEcts = this.enrolledEcts(executionYear, registration, maximumAnnulmentDate, false);
        if (BigDecimal.ZERO.compareTo(enrolledEcts) != 0) {
            enrolledEcts = enrolledEcts.subtract(this.phdDissertationEnrolledEctsCredits(executionYear, registration, maximumAnnulmentDate));
            return enrolledEcts;
        }
        return null;
    }

    private BigDecimal phdDissertationEnrolledEctsCredits(ExecutionYear executionYear, Registration registration, DateTime maximumAnnulmentDate) {
        BigDecimal result = BigDecimal.ZERO;
        StudentCurricularPlan studentCurricularPlan = registration.getStudentCurricularPlan(executionYear);
        Collection allDissertationCurricularCourses = studentCurricularPlan.getDegreeCurricularPlan().getDcpDegreeModules(CurricularCourse.class, executionYear).stream().map(CurricularCourse.class::cast).filter(cc -> cc.isDissertation()).collect(Collectors.toSet());
        for (CurricularCourse dissertation : allDissertationCurricularCourses) {
            boolean isEnrollmentInDissertationCurricularCourse = studentCurricularPlan.getEnrolmentsByExecutionYear(executionYear).stream().filter(e -> e.getCurricularCourse() == dissertation).filter(e -> !Raides.isEnrolmentAnnuled(e, maximumAnnulmentDate)).count() > 0L;
            if (!isEnrollmentInDissertationCurricularCourse) continue;
            result = result.add(new BigDecimal(dissertation.getEctsCredits()));
        }
        return result;
    }

    public String i18n(String key, String ... arguments) {
        return LegalPTUtil.bundle(key, arguments);
    }

    public static interface AttendanceRegimeProvider {
        public String provide(LegalReport var1, Registration var2, ExecutionYear var3, boolean var4);
    }

    protected class DEGREE_VALUE_COMPARATOR
    implements Comparator<Degree> {
        protected Map<Degree, Integer> m;

        public DEGREE_VALUE_COMPARATOR(Map<Degree, Integer> m) {
            this.m = m;
        }

        @Override
        public int compare(Degree o1, Degree o2) {
            int result = this.m.get(o1).compareTo(this.m.get(o2));
            if (result != 0) {
                return -result;
            }
            return o1.getExternalId().compareTo(o2.getExternalId());
        }
    }
}

