/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.legalpt.domain.raides.report;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Set;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.degree.DegreeType;
import org.fenixedu.bennu.IBean;
import org.fenixedu.legalpt.domain.raides.report.RaidesPeriodInputType;
import org.joda.time.Interval;
import org.joda.time.LocalDate;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadablePartial;

public class RaidesRequestPeriodParameter
implements Serializable,
IBean {
    public static final Comparator<RaidesRequestPeriodParameter> COMPARATOR_BY_BEGIN_DATE = new Comparator<RaidesRequestPeriodParameter>(){

        @Override
        public int compare(RaidesRequestPeriodParameter o1, RaidesRequestPeriodParameter o2) {
            return o1.getBegin().compareTo((ReadablePartial)o2.getBegin());
        }
    };
    private static final long serialVersionUID = 1L;
    private ExecutionYear academicPeriod;
    private LocalDate begin;
    private LocalDate end;
    private boolean enrolledInAcademicPeriod;
    private RaidesPeriodInputType periodInputType;
    private boolean enrolmentEctsConstraint;
    private BigDecimal minEnrolmentEcts;
    private BigDecimal maxEnrolmentEcts;
    private boolean enrolmentYearsConstraint;
    private Integer minEnrolmentYears;
    private Integer maxEnrolmentYears;
    private Set<DegreeType> degreeTypes = new HashSet<DegreeType>();

    public RaidesRequestPeriodParameter(ExecutionYear academicPeriod, LocalDate begin, LocalDate end, boolean enrolledInAcademicPeriod, RaidesPeriodInputType periodInputType, boolean enrolmentEctsConstraint, BigDecimal minEnrolmentEcts, BigDecimal maxEnrolmentEcts, boolean enrolmentYearsConstraint, Integer minEnrolmentYears, Integer maxEnrolmentYears) {
        this.setAcademicPeriod(academicPeriod);
        this.setBegin(begin);
        this.setEnd(end);
        this.setEnrolledInAcademicPeriod(enrolledInAcademicPeriod);
        this.setPeriodInputType(periodInputType);
        this.setEnrolmentEctsConstraint(enrolmentEctsConstraint);
        this.setMinEnrolmentEcts(minEnrolmentEcts);
        this.setMaxEnrolmentEcts(maxEnrolmentEcts);
        this.setEnrolmentYearsConstraint(enrolmentYearsConstraint);
        this.setMinEnrolmentYears(minEnrolmentYears);
        this.setMaxEnrolmentYears(maxEnrolmentYears);
        this.checkRules();
    }

    public RaidesRequestPeriodParameter() {
    }

    private void checkRules() {
        if (this.getAcademicPeriod() == null) {
            throw new IllegalArgumentException("error.RaidesReportPeriodInput.academicPeriod.required");
        }
        if (this.getBegin() == null) {
            throw new IllegalArgumentException("error.RaidesReportPeriodInput.begin.required");
        }
        if (this.getEnd() == null) {
            throw new IllegalArgumentException("error.RaidesReportPeriodInput.end.required");
        }
        if (this.getPeriodInputType() == null) {
            throw new IllegalArgumentException("error.RaidesReportPeriodInput.periodInputType.required");
        }
    }

    public Interval getInterval() {
        return new Interval((ReadableInstant)this.getBegin().toDateTimeAtStartOfDay(), (ReadableInstant)this.getEnd().toDateTimeAtStartOfDay().plusDays(1).minusSeconds(1));
    }

    public ExecutionYear getAcademicPeriod() {
        return this.academicPeriod;
    }

    public void setAcademicPeriod(ExecutionYear academicPeriod) {
        this.academicPeriod = academicPeriod;
    }

    public LocalDate getBegin() {
        return this.begin;
    }

    public void setBegin(LocalDate begin) {
        this.begin = begin;
    }

    public LocalDate getEnd() {
        return this.end;
    }

    public void setEnd(LocalDate end) {
        this.end = end;
    }

    public boolean isEnrolledInAcademicPeriod() {
        return this.enrolledInAcademicPeriod;
    }

    public void setEnrolledInAcademicPeriod(boolean enrolledInAcademicPeriod) {
        this.enrolledInAcademicPeriod = enrolledInAcademicPeriod;
    }

    public RaidesPeriodInputType getPeriodInputType() {
        return this.periodInputType;
    }

    public void setPeriodInputType(RaidesPeriodInputType periodInputType) {
        this.periodInputType = periodInputType;
    }

    public boolean isEnrolmentEctsConstraint() {
        return this.enrolmentEctsConstraint;
    }

    public void setEnrolmentEctsConstraint(boolean enrolmentEctsConstraint) {
        this.enrolmentEctsConstraint = enrolmentEctsConstraint;
    }

    public BigDecimal getMinEnrolmentEcts() {
        return this.minEnrolmentEcts;
    }

    public void setMinEnrolmentEcts(BigDecimal minEnrolmentEcts) {
        this.minEnrolmentEcts = minEnrolmentEcts;
    }

    public BigDecimal getMaxEnrolmentEcts() {
        return this.maxEnrolmentEcts;
    }

    public void setMaxEnrolmentEcts(BigDecimal maxEnrolmentEcts) {
        this.maxEnrolmentEcts = maxEnrolmentEcts;
    }

    public boolean isEnrolmentYearsConstraint() {
        return this.enrolmentYearsConstraint;
    }

    public void setEnrolmentYearsConstraint(boolean enrolmentYearsConstraint) {
        this.enrolmentYearsConstraint = enrolmentYearsConstraint;
    }

    public Integer getMinEnrolmentYears() {
        return this.minEnrolmentYears;
    }

    public void setMinEnrolmentYears(Integer minEnrolmentYears) {
        this.minEnrolmentYears = minEnrolmentYears;
    }

    public Integer getMaxEnrolmentYears() {
        return this.maxEnrolmentYears;
    }

    public void setMaxEnrolmentYears(Integer maxEnrolmentYears) {
        this.maxEnrolmentYears = maxEnrolmentYears;
    }

    public void addDegreeTypes(Collection<DegreeType> degreeTypes) {
        this.degreeTypes.addAll(degreeTypes);
    }

    public Set<DegreeType> getDegreeTypes() {
        return this.degreeTypes;
    }

    public RaidesRequestPeriodParameter copy() {
        RaidesRequestPeriodParameter result = new RaidesRequestPeriodParameter();
        result.setAcademicPeriod(this.getAcademicPeriod());
        result.setBegin(this.getBegin());
        result.setEnd(this.getEnd());
        result.setEnrolledInAcademicPeriod(this.enrolledInAcademicPeriod);
        result.setEnrolmentEctsConstraint(this.enrolmentEctsConstraint);
        result.setEnrolmentYearsConstraint(this.enrolmentYearsConstraint);
        result.setMinEnrolmentEcts(this.getMinEnrolmentEcts());
        result.setMaxEnrolmentEcts(this.getMaxEnrolmentEcts());
        result.setMinEnrolmentYears(this.getMinEnrolmentYears());
        result.setMaxEnrolmentYears(this.getMaxEnrolmentYears());
        result.setPeriodInputType(this.getPeriodInputType());
        result.getDegreeTypes().addAll(this.getDegreeTypes());
        return result;
    }
}

