/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.ulisboa.integration.sas.ui.spring.controller;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

public class SasBaseController {
    private static final String ERROR_MESSAGES = "errorMessages";
    private static final String WARNING_MESSAGES = "warningMessages";
    private static final String INFO_MESSAGES = "infoMessages";
    @Autowired
    protected HttpServletRequest request;

    protected void addInfoMessage(String message, Model model) {
        ((List)model.asMap().get(INFO_MESSAGES)).add(message);
    }

    protected void addWarningMessage(String message, Model model) {
        ((List)model.asMap().get(WARNING_MESSAGES)).add(message);
    }

    protected void addErrorMessage(String message, Model model) {
        ((List)model.asMap().get(ERROR_MESSAGES)).add(message);
    }

    protected void clearMessages(Model model) {
        model.addAttribute(INFO_MESSAGES, new ArrayList());
        model.addAttribute(WARNING_MESSAGES, new ArrayList());
        model.addAttribute(ERROR_MESSAGES, new ArrayList());
    }

    protected String redirect(String destinationAction, Model model, RedirectAttributes redirectAttributes) {
        if (model.containsAttribute(INFO_MESSAGES)) {
            redirectAttributes.addFlashAttribute(INFO_MESSAGES, model.asMap().get(INFO_MESSAGES));
        }
        if (model.containsAttribute(WARNING_MESSAGES)) {
            redirectAttributes.addFlashAttribute(WARNING_MESSAGES, model.asMap().get(WARNING_MESSAGES));
        }
        if (model.containsAttribute(ERROR_MESSAGES)) {
            redirectAttributes.addFlashAttribute(ERROR_MESSAGES, model.asMap().get(ERROR_MESSAGES));
        }
        return "redirect:" + destinationAction;
    }

    @ModelAttribute
    protected void addModelProperties(Model model) {
        if (!model.containsAttribute(INFO_MESSAGES)) {
            model.addAttribute(INFO_MESSAGES, new ArrayList());
        }
        if (!model.containsAttribute(WARNING_MESSAGES)) {
            model.addAttribute(WARNING_MESSAGES, new ArrayList());
        }
        if (!model.containsAttribute(ERROR_MESSAGES)) {
            model.addAttribute(ERROR_MESSAGES, new ArrayList());
        }
    }

    protected void writeFile(HttpServletResponse response, String filename, String contentType, byte[] content) throws IOException {
        response.setContentLength(content.length);
        response.setContentType(contentType);
        response.addHeader("Content-Disposition", "attachment; filename=\"" + filename + "\"");
        try (ServletOutputStream outputStream = response.getOutputStream();){
            outputStream.write(content);
            outputStream.flush();
            response.flushBuffer();
        }
    }
}

