/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.ulisboa.integration.sas.ui.spring.controller.manageIngressionRegimeMapping;

import java.lang.annotation.Annotation;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.fenixedu.academic.domain.candidacy.IngressionType;
import org.fenixedu.bennu.core.domain.Bennu;
import org.fenixedu.bennu.core.i18n.BundleUtil;
import org.fenixedu.bennu.spring.portal.SpringFunctionality;
import org.fenixedu.ulisboa.integration.sas.domain.SasIngressionRegimeMapping;
import org.fenixedu.ulisboa.integration.sas.ui.spring.controller.SasBaseController;
import org.fenixedu.ulisboa.integration.sas.ui.spring.controller.SasController;
import org.fenixedu.ulisboa.integration.sas.ui.spring.controller.manageIngressionRegimeMapping.IngressionRegimeMappingController$callable$createIngressionRegimeMapping;
import org.fenixedu.ulisboa.integration.sas.ui.spring.controller.manageIngressionRegimeMapping.IngressionRegimeMappingController$callable$deleteIngressionRegimeMapping;
import org.fenixedu.ulisboa.integration.sas.ui.spring.controller.manageIngressionRegimeMapping.IngressionRegimeMappingController$callable$updateIngressionRegimeMapping;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

@SpringFunctionality(app=SasController.class, title="label.title.manageIngressionRegimeMapping", accessGroup="#managers")
@RequestMapping(value={"/integration/sas/manageIngressionRegimeMapping"})
public class IngressionRegimeMappingController
extends SasBaseController {
    public static final String CONTROLLER_URL = "/integration/sas/manageIngressionRegimeMapping";
    private static final String _SEARCH_URI = "/";
    public static final String SEARCH_URL = "/integration/sas/manageIngressionRegimeMapping/";
    private static final String _CREATE_URI = "/create";
    public static final String CREATE_URL = "/integration/sas/manageIngressionRegimeMapping/create";
    private static final String _SEARCH_TO_DELETE_ACTION_URI = "/search/delete/";
    public static final String SEARCH_TO_DELETE_ACTION_URL = "/integration/sas/manageIngressionRegimeMapping/search/delete/";
    private static final String _UPDATE_URI = "/update/";
    public static final String UPDATE_URL = "/integration/sas/manageIngressionRegimeMapping/update/";
    public static final Advice advice$deleteIngressionRegimeMapping = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
    public static final Advice advice$createIngressionRegimeMapping = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
    public static final Advice advice$updateIngressionRegimeMapping = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));

    @RequestMapping
    public String home(Model model) {
        return this.search(model);
    }

    private SasIngressionRegimeMapping getIngressionRegimeMapping(Model model) {
        return (SasIngressionRegimeMapping)((Object)model.asMap().get("ingressionRegimeMapping"));
    }

    private void setIngressionRegimeMapping(SasIngressionRegimeMapping ingressionRegimeMapping, Model model) {
        model.addAttribute("ingressionRegimeMapping", (Object)ingressionRegimeMapping);
    }

    public void deleteIngressionRegimeMapping(SasIngressionRegimeMapping sasIngressionRegimeMapping) {
        Object object = advice$deleteIngressionRegimeMapping.perform((Callable)new IngressionRegimeMappingController$callable$deleteIngressionRegimeMapping(this, sasIngressionRegimeMapping));
    }

    static /* synthetic */ void advised$deleteIngressionRegimeMapping(IngressionRegimeMappingController this_, SasIngressionRegimeMapping ingressionRegimeMapping) {
        ingressionRegimeMapping.delete();
    }

    @RequestMapping(value={"/"})
    public String search(Model model) {
        List<SasIngressionRegimeMapping> searchIngressionRegimeMappingResultsDataSet = this.filterSearchIngressionRegimeMapping();
        model.addAttribute("searchsIngressionRegimeMappingResultsDataSet", searchIngressionRegimeMappingResultsDataSet);
        return "integration/sas/manageIngressionRegimeMapping/search";
    }

    private Stream<SasIngressionRegimeMapping> getSearchUniverseSearchIngressionRegimeMappingDataSet() {
        return SasIngressionRegimeMapping.findAll();
    }

    private List<SasIngressionRegimeMapping> filterSearchIngressionRegimeMapping() {
        return this.getSearchUniverseSearchIngressionRegimeMappingDataSet().collect(Collectors.toList());
    }

    @RequestMapping(value={"/create"}, method={RequestMethod.GET})
    public String create(Model model) {
        model.addAttribute("ingressionValues", Bennu.getInstance().getIngressionTypesSet().stream().sorted((x, y) -> x.getDescription().compareTo(y.getDescription())).collect(Collectors.toList()));
        return "integration/sas/manageIngressionRegimeMapping/create";
    }

    @RequestMapping(value={"/create"}, method={RequestMethod.POST})
    public String create(@RequestParam(value="ingression", required=false) IngressionType ingressionType, @RequestParam(value="regimeCode", required=false) String regimeCode, @RequestParam(value="regimeCodeWithDescription", required=false) String regimeCodeWithDescription, Model model, RedirectAttributes redirectAttributes) {
        try {
            this.createIngressionRegimeMapping(ingressionType, regimeCode, regimeCodeWithDescription);
            return this.redirect(SEARCH_URL, model, redirectAttributes);
        }
        catch (Exception de) {
            this.addErrorMessage(BundleUtil.getString((String)"resources/SasResources", (String)"label.error.create", (String[])new String[]{de.getLocalizedMessage()}), model);
            return this.create(model);
        }
    }

    @RequestMapping(value={"/search/delete/{oid}"}, method={RequestMethod.POST})
    public String processSearchToDeleteAction(@PathVariable(value="oid") SasIngressionRegimeMapping ingressionRegimeMapping, Model model, RedirectAttributes redirectAttributes) {
        this.setIngressionRegimeMapping(ingressionRegimeMapping, model);
        try {
            this.deleteIngressionRegimeMapping(ingressionRegimeMapping);
            this.addInfoMessage(BundleUtil.getString((String)"resources/SasResources", (String)"label.manageIngressionRegimeMapping.success.delete", (String[])new String[0]), model);
            return this.redirect(SEARCH_URL, model, redirectAttributes);
        }
        catch (Exception ex) {
            this.addErrorMessage(BundleUtil.getString((String)"resources/SasResources", (String)"label.error.update", (String[])new String[]{ex.getLocalizedMessage()}), model);
            return "integration/sas/manageIngressionRegimeMapping/search";
        }
    }

    public SasIngressionRegimeMapping createIngressionRegimeMapping(IngressionType ingressionType, String string, String string2) {
        return (SasIngressionRegimeMapping)((Object)advice$createIngressionRegimeMapping.perform((Callable)new IngressionRegimeMappingController$callable$createIngressionRegimeMapping(this, ingressionType, string, string2)));
    }

    static /* synthetic */ SasIngressionRegimeMapping advised$createIngressionRegimeMapping(IngressionRegimeMappingController this_, IngressionType ingressionType, String regimeCode, String regimeCodeWithDescription) {
        return SasIngressionRegimeMapping.create(ingressionType, regimeCode, regimeCodeWithDescription);
    }

    @RequestMapping(value={"/update/{oid}"}, method={RequestMethod.GET})
    public String update(@PathVariable(value="oid") SasIngressionRegimeMapping ingressionRegimeMapping, Model model) {
        model.addAttribute("ingressionValues", (Object)Bennu.getInstance().getIngressionTypesSet());
        this.setIngressionRegimeMapping(ingressionRegimeMapping, model);
        return "integration/sas/manageIngressionRegimeMapping/update";
    }

    @RequestMapping(value={"/update/{oid}"}, method={RequestMethod.POST})
    public String update(@PathVariable(value="oid") SasIngressionRegimeMapping ingressionRegimeMapping, @RequestParam(value="ingression", required=false) IngressionType ingressionType, @RequestParam(value="regimeCode", required=false) String regimeCode, @RequestParam(value="regimeCodeWithDescription", required=false) String regimeCodeWithDescription, Model model, RedirectAttributes redirectAttributes) {
        this.setIngressionRegimeMapping(ingressionRegimeMapping, model);
        try {
            this.updateIngressionRegimeMapping(ingressionType, regimeCode, regimeCodeWithDescription, model);
            return this.redirect(SEARCH_URL, model, redirectAttributes);
        }
        catch (Exception de) {
            this.addErrorMessage(BundleUtil.getString((String)"resources/SasResources", (String)"label.error.update", (String[])new String[0]) + de.getLocalizedMessage(), model);
            return this.update(ingressionRegimeMapping, model);
        }
    }

    public void updateIngressionRegimeMapping(IngressionType ingressionType, String string, String string2, Model model) {
        Object object = advice$updateIngressionRegimeMapping.perform((Callable)new IngressionRegimeMappingController$callable$updateIngressionRegimeMapping(this, ingressionType, string, string2, model));
    }

    static /* synthetic */ void advised$updateIngressionRegimeMapping(IngressionRegimeMappingController this_, IngressionType ingression, String regimeCode, String regimeCodeWithDescription, Model model) {
        this_.getIngressionRegimeMapping(model).edit(ingression, regimeCode, regimeCodeWithDescription);
    }
}

