/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.ulisboa.integration.sas.domain;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import org.fenixedu.academic.domain.SchoolLevelType;
import org.fenixedu.academic.domain.degree.DegreeType;
import org.fenixedu.bennu.core.domain.Bennu;
import org.fenixedu.ulisboa.integration.sas.domain.SchoolLevelTypeMapping_Base;
import pt.ist.fenixframework.FenixFramework;
import pt.ist.fenixframework.dml.DeletionListener;

public class SchoolLevelTypeMapping
extends SchoolLevelTypeMapping_Base {
    private static final List<SchoolLevelType> CTSP_SCHOOL_LEVELS = new ArrayList<SchoolLevelType>();
    private static final List<SchoolLevelType> CET_SCHOOL_LEVELS = Arrays.asList(SchoolLevelType.TECHNICAL_SPECIALIZATION);
    private static final List<SchoolLevelType> DEGREE_SCHOOL_LEVELS = Arrays.asList(SchoolLevelType.DEGREE, SchoolLevelType.DEGREE_PRE_BOLOGNA, SchoolLevelType.BACHELOR_DEGREE_PRE_BOLOGNA, SchoolLevelType.FIRST_CYCLE_INTEGRATED_MASTER_DEGREE);
    private static final List<SchoolLevelType> MASTER_DEGREE_SCHOOL_LEVELS = Arrays.asList(SchoolLevelType.MASTER_DEGREE, SchoolLevelType.MASTER_DEGREE_PRE_BOLOGNA, SchoolLevelType.MASTER_DEGREE_INTEGRATED);
    private static final List<SchoolLevelType> PHD_SCHOOL_LEVELS = Arrays.asList(SchoolLevelType.DOCTORATE_DEGREE, SchoolLevelType.DOCTORATE_DEGREE_PRE_BOLOGNA);

    protected SchoolLevelTypeMapping() {
    }

    public void delete() {
        this.setDegreeType(null);
        this.setBennu(null);
        super.deleteDomainObject();
    }

    public static Stream<SchoolLevelTypeMapping> findAll() {
        return Bennu.getInstance().getSchoolLevelTypeMappingSet().stream();
    }

    public static void registerEvents() {
        FenixFramework.getDomainModel().registerDeletionListener(DegreeType.class, (DeletionListener)new DeletionListener<DegreeType>(){

            public void deleting(DegreeType object) {
                Optional.ofNullable(object.getSchoolLevelTypeMapping()).ifPresent(sltm -> sltm.delete());
            }
        });
    }

    public void edit(SchoolLevelType schoolLevelType, DegreeType degreeType) {
        SchoolLevelTypeMapping.checkPreConditions(this, schoolLevelType, degreeType);
        this.setSchoolLevel(schoolLevelType);
        this.setDegreeType(degreeType);
    }

    public static SchoolLevelTypeMapping create(SchoolLevelType schoolLevelType, DegreeType degreeType) {
        SchoolLevelTypeMapping.checkPreConditions(null, schoolLevelType, degreeType);
        SchoolLevelTypeMapping schoolLevelTypeMapping = new SchoolLevelTypeMapping();
        schoolLevelTypeMapping.setSchoolLevel(schoolLevelType);
        schoolLevelTypeMapping.setDegreeType(degreeType);
        schoolLevelTypeMapping.setBennu(Bennu.getInstance());
        return schoolLevelTypeMapping;
    }

    public static void checkPreConditions(SchoolLevelTypeMapping schoolLevelTypeMapping, SchoolLevelType schoolLevelType, DegreeType degreeType) {
        if (degreeType == null) {
            throw new RuntimeException("Degree Type cannot be null");
        }
        if (schoolLevelType == null) {
            throw new RuntimeException("School Level cannot be null");
        }
        SchoolLevelTypeMapping degreeTypeCurrentSchoolLevelTypeMapping = degreeType.getSchoolLevelTypeMapping();
        if (degreeTypeCurrentSchoolLevelTypeMapping != null && degreeTypeCurrentSchoolLevelTypeMapping != schoolLevelTypeMapping) {
            throw new RuntimeException("Degree type already has associated school level");
        }
    }

    public DegreeType getDegreeType() {
        return super.getDegreeType();
    }

    public SchoolLevelType getSchoolLevel() {
        return super.getSchoolLevel();
    }

    public static boolean isCTSP(SchoolLevelType schoolLevelType) {
        return CTSP_SCHOOL_LEVELS.contains(schoolLevelType);
    }

    public static boolean isCET(SchoolLevelType schoolLevelType) {
        return CET_SCHOOL_LEVELS.contains(schoolLevelType);
    }

    public static boolean isDegree(SchoolLevelType schoolLevelType) {
        return DEGREE_SCHOOL_LEVELS.contains(schoolLevelType);
    }

    public static boolean isMasterDegree(SchoolLevelType schoolLevelType) {
        return MASTER_DEGREE_SCHOOL_LEVELS.contains(schoolLevelType);
    }

    public static boolean isPhd(SchoolLevelType schoolLevelType) {
        return PHD_SCHOOL_LEVELS.contains(schoolLevelType);
    }
}

