/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.legalpt.services.raides.process;

import com.google.common.base.Strings;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.student.Registration;
import org.fenixedu.academic.domain.student.RegistrationServices;
import org.fenixedu.academic.domain.student.curriculum.conclusion.RegistrationConclusionInformation;
import org.fenixedu.academic.domain.student.curriculum.conclusion.RegistrationConclusionServices;
import org.fenixedu.academic.domain.student.mobility.MobilityRegistrationInformation;
import org.fenixedu.academic.dto.student.RegistrationConclusionBean;
import org.fenixedu.legalpt.domain.LegalReportContext;
import org.fenixedu.legalpt.domain.mapping.LegalMapping;
import org.fenixedu.legalpt.domain.raides.Raides;
import org.fenixedu.legalpt.domain.raides.RaidesInstance;
import org.fenixedu.legalpt.domain.raides.RaidesReportEntryTarget;
import org.fenixedu.legalpt.domain.raides.TblDiplomado;
import org.fenixedu.legalpt.domain.raides.mapping.LegalMappingType;
import org.fenixedu.legalpt.domain.raides.report.RaidesRequestParameter;
import org.fenixedu.legalpt.domain.raides.report.RaidesRequestPeriodParameter;
import org.fenixedu.legalpt.domain.report.LegalReport;
import org.fenixedu.legalpt.services.raides.process.RaidesService;
import org.joda.time.ReadableInstant;
import pt.ist.fenixframework.DomainObject;

public class DiplomadoService
extends RaidesService {
    private final Integer MAX_SIZE_PROG_MOBILITY = 80;
    protected boolean valid = true;

    public DiplomadoService(LegalReport report) {
        super(report);
    }

    public TblDiplomado createNormal(RaidesRequestParameter raidesRequestParameter, RaidesRequestPeriodParameter graduatedPeriod, ExecutionYear executionYear, Registration registration) {
        RaidesReportEntryTarget target = RaidesReportEntryTarget.of(registration, executionYear);
        TblDiplomado bean = new TblDiplomado();
        bean.setRegistration(registration);
        this.preencheInformacaoMatricula(this.report, bean, executionYear, registration);
        RegistrationConclusionInformation terminalConclusionInfo = DiplomadoService.terminalConclusionInformation(registration, graduatedPeriod, executionYear);
        if (terminalConclusionInfo != null && (RaidesInstance.getInstance().isReportGraduatedWithoutConclusionProcess() || terminalConclusionInfo.getRegistrationConclusionBean().isConclusionProcessed())) {
            String value;
            RegistrationConclusionBean registrationConclusionBean = terminalConclusionInfo.getRegistrationConclusionBean();
            bean.setConcluiGrau(LegalMapping.find(this.report, LegalMappingType.BOOLEAN).translate(true));
            bean.setAnoLectivo(raidesRequestParameter.getGraduatedExecutionYear() != null ? raidesRequestParameter.getGraduatedExecutionYear().getQualifiedName() : terminalConclusionInfo.getConclusionYear().getQualifiedName());
            bean.setNumInscConclusao(String.valueOf(RegistrationServices.getEnrolmentYearsIncludingPrecedentRegistrations((Registration)registration).size()));
            if (Raides.isDoctoralDegree(registration) && !registrationConclusionBean.isConclusionProcessed()) {
                LegalReportContext.addError(target, this.i18n("error.Raides.validation.doctoral.degree.without.conclusion.process", new String[0]), this.i18n("error.Raides.validation.doctoral.degree.without.conclusion.process.action", new String[0]));
                bean.markAsInvalid();
            }
            if (registrationConclusionBean.getDescriptiveGrade() != null && !registrationConclusionBean.getDescriptiveGrade().isEmpty() && this.isToReportDescriptiveGrade(registrationConclusionBean)) {
                value = LegalMapping.find(this.report, LegalMappingType.GRADE).translate(this.finalGrade(registrationConclusionBean.getDescriptiveGrade().getValue()));
                if (StringUtils.isBlank((CharSequence)value)) {
                    LegalReportContext.addError(target, this.i18n("error.Raides.validation.conclution.descriptiveGrade.missing.translate", registrationConclusionBean.getDescriptiveGrade().getValue()), this.i18n("error.Raides.validation.grade.conclution.descriptiveGrade.translate.action", registrationConclusionBean.getDescriptiveGrade().getValue()));
                    bean.markAsInvalid();
                } else {
                    bean.setClassificacaoFinal(value);
                }
            } else if (registrationConclusionBean.getFinalGrade().isEmpty()) {
                LegalReportContext.addError(target, this.i18n("error.Raides.validation.finalGrade.set.but.empty", new String[0]), this.i18n("error.Raides.validation.finalGrade.set.but.empty.action", new String[0]));
                bean.markAsInvalid();
            } else {
                value = LegalMapping.find(this.report, LegalMappingType.GRADE).translate(this.finalGrade(registrationConclusionBean.getFinalGrade().getValue()));
                if (StringUtils.isBlank((CharSequence)value)) {
                    LegalReportContext.addError(target, this.i18n("error.Raides.validation.conclution.finalGrade.missing.translate", registrationConclusionBean.getFinalGrade().getValue()), this.i18n("error.Raides.validation.grade.finalGrade.finalGrade.translate.action", registrationConclusionBean.getFinalGrade().getValue()));
                    bean.markAsInvalid();
                } else {
                    bean.setClassificacaoFinal(value);
                }
            }
            bean.setDataDiploma(registrationConclusionBean.getConclusionDate().toLocalDate());
            if (Raides.isDoctoralDegree(registration)) {
                bean.setAreaInvestigacao(registration.getResearchArea() != null ? registration.getResearchArea().getCode() : "");
            }
        } else {
            bean.setConcluiGrau(LegalMapping.find(this.report, LegalMappingType.BOOLEAN).translate(false));
        }
        if (Raides.isMasterDegreeOrDoctoralDegree(registration)) {
            RegistrationConclusionInformation scholarPartConclusionInfo = this.scholarPartConclusionInformation(registration, graduatedPeriod, executionYear);
            if (scholarPartConclusionInfo != null && (RaidesInstance.getInstance().isReportGraduatedWithoutConclusionProcess() || scholarPartConclusionInfo.getRegistrationConclusionBean().isConclusionProcessed())) {
                RegistrationConclusionBean conclusionBean = scholarPartConclusionInfo.getRegistrationConclusionBean();
                bean.setAnoLectivo(raidesRequestParameter.getGraduatedExecutionYear() != null ? raidesRequestParameter.getGraduatedExecutionYear().getQualifiedName() : conclusionBean.getConclusionYear().getQualifiedName());
                bean.setConclusaoMd(LegalMapping.find(this.report, LegalMappingType.BOOLEAN).translate(true));
                bean.setClassificacaoFinalMd(LegalMapping.find(this.report, LegalMappingType.GRADE).translate(this.finalGrade(conclusionBean.getFinalGrade().getValue())));
                if ((Strings.isNullOrEmpty((String)bean.getClassificacaoFinalMd()) || "0".equals(bean.getClassificacaoFinalMd())) && Raides.isDoctoralDegree(registration) && conclusionBean.getDescriptiveGrade() != null) {
                    bean.setClassificacaoFinalMd(LegalMapping.find(this.report, LegalMappingType.GRADE).translate(this.finalGrade(conclusionBean.getDescriptiveGrade().getValue())));
                }
            } else {
                bean.setConclusaoMd(LegalMapping.find(this.report, LegalMappingType.BOOLEAN).translate(false));
            }
        }
        this.preencheMobilidadeCredito(registration, bean, executionYear);
        this.preencheGrauPrecedentCompleto(bean, executionYear, registration);
        this.validaClassificacao(executionYear, graduatedPeriod, registration, bean);
        this.validaMobilidadeCredito(executionYear, registration, bean);
        this.validaAreaInvestigacao(executionYear, registration, bean);
        return bean;
    }

    private boolean isToReportDescriptiveGrade(RegistrationConclusionBean conclusionBean) {
        if (Raides.isDoctoralDegree(conclusionBean.getRegistration())) {
            return true;
        }
        if (conclusionBean.getFinalGrade().isEmpty()) {
            return true;
        }
        return conclusionBean.getFinalGrade().isNumeric() && conclusionBean.getFinalGrade().getNumericValue().compareTo(BigDecimal.ZERO) == 0;
    }

    public TblDiplomado createIntegratedCycleFirstCyle(RaidesRequestParameter raidesRequestParameter, RaidesRequestPeriodParameter graduatedPeriod, ExecutionYear executionYear, Registration registration) {
        TblDiplomado bean = new TblDiplomado();
        bean.setRegistration(registration);
        this.preencheInformacaoMatricula(this.report, bean, executionYear, registration);
        RegistrationConclusionInformation scholarPartConclusionInfo = this.scholarPartConclusionInformation(registration, graduatedPeriod, executionYear);
        RegistrationConclusionBean scholarPartConclusionBean = scholarPartConclusionInfo.getRegistrationConclusionBean();
        bean.setCurso(LegalMapping.find(this.report, LegalMappingType.INTEGRATED_MASTER_FIRST_CYCLE_CODES).translate((DomainObject)registration.getDegree()));
        bean.setConcluiGrau(LegalMapping.find(this.report, LegalMappingType.BOOLEAN).translate(true));
        bean.setAnoLectivo(raidesRequestParameter.getGraduatedExecutionYear() != null ? raidesRequestParameter.getGraduatedExecutionYear().getQualifiedName() : scholarPartConclusionBean.getConclusionYear().getQualifiedName());
        bean.setNumInscConclusao(String.valueOf(RegistrationServices.getEnrolmentYearsIncludingPrecedentRegistrations((Registration)registration, (ExecutionYear)scholarPartConclusionBean.getConclusionYear()).size()));
        bean.setClassificacaoFinal(LegalMapping.find(this.report, LegalMappingType.GRADE).translate(this.finalGrade(scholarPartConclusionBean.getFinalGrade().getValue())));
        bean.setDataDiploma(scholarPartConclusionBean.getConclusionDate().toLocalDate());
        this.preencheRamo(this.report, bean, executionYear, registration, true);
        this.preencheMobilidadeCredito(registration, bean, executionYear);
        this.preencheGrauPrecedentCompleto(bean, executionYear, registration);
        this.validaClassificacao(executionYear, graduatedPeriod, registration, bean);
        this.validaMobilidadeCredito(executionYear, registration, bean);
        return bean;
    }

    protected void preencheMobilidadeCredito(Registration registration, TblDiplomado bean, ExecutionYear executionYear) {
        bean.setMobilidadeCredito(LegalMapping.find(this.report, LegalMappingType.BOOLEAN).translate(false));
        if (MobilityRegistrationInformation.hasAnyInternationalOutgoingMobilityUntil((Registration)registration, (ExecutionYear)executionYear)) {
            MobilityRegistrationInformation mobility = this.findOutgoingMobility(registration, executionYear);
            bean.setMobilidadeCredito(LegalMapping.find(this.report, LegalMappingType.BOOLEAN).translate(true));
            bean.setTipoMobilidadeCredito(LegalMapping.find(this.report, LegalMappingType.INTERNATIONAL_MOBILITY_ACTIVITY).translate((DomainObject)mobility.getMobilityActivityType()));
            bean.setProgMobilidadeCredito(LegalMapping.find(this.report, LegalMappingType.INTERNATIONAL_MOBILITY_PROGRAM).translate((DomainObject)mobility.getMobilityProgramType()));
            if ("2".equals(bean.getProgMobilidadeCredito())) {
                bean.setOutroProgMobCredito(mobility.getMobilityProgramType().getName().getContent());
            }
            if (mobility.hasCountry()) {
                bean.setPaisMobilidadeCredito(mobility.getCountry().getCode());
            }
        }
    }

    private MobilityRegistrationInformation findOutgoingMobility(Registration registration, ExecutionYear executionYear) {
        MobilityRegistrationInformation mainInformation = MobilityRegistrationInformation.findMainInternationalOutgoingInformationUntil((Registration)registration, (ExecutionYear)executionYear);
        if (mainInformation != null) {
            return mainInformation;
        }
        return MobilityRegistrationInformation.findInternationalOutgoingInformationsUntil((Registration)registration, (ExecutionYear)executionYear).stream().sorted((x, y) -> x.getExternalId().compareTo(y.getExternalId())).findFirst().orElse(null);
    }

    private String finalGrade(String value) {
        if (!Strings.isNullOrEmpty((String)value) && value.matches("\\d+\\.\\d+")) {
            return new BigDecimal(value).setScale(0, RoundingMode.HALF_UP).toString();
        }
        return value;
    }

    private boolean isScholarPartConcluded(Registration registration, RaidesRequestPeriodParameter graduatedPeriod, ExecutionYear executionYear) {
        RegistrationConclusionInformation conclusionInfo = this.scholarPartConclusionInformation(registration, graduatedPeriod, executionYear);
        return conclusionInfo != null && (RaidesInstance.getInstance().getReportGraduatedWithoutConclusionProcess() || conclusionInfo.getRegistrationConclusionBean().isConclusionProcessed());
    }

    private RegistrationConclusionInformation scholarPartConclusionInformation(Registration registration, RaidesRequestPeriodParameter graduatedPeriod, ExecutionYear executionYear) {
        Set conclusionInfoSet = RegistrationConclusionServices.inferConclusion((Registration)registration);
        for (RegistrationConclusionInformation rci : conclusionInfoSet) {
            if (!rci.isConcluded() || !rci.isScholarPart() || rci.getConclusionYear() != executionYear || !graduatedPeriod.getInterval().contains((ReadableInstant)rci.getConclusionDate().toDateTimeAtStartOfDay())) continue;
            return rci;
        }
        return null;
    }

    public static boolean isTerminalConcluded(Registration registration, RaidesRequestPeriodParameter graduatedPeriod, ExecutionYear executionYear) {
        RegistrationConclusionInformation conclusionInfo = DiplomadoService.terminalConclusionInformation(registration, graduatedPeriod, executionYear);
        return conclusionInfo != null && (RaidesInstance.getInstance().getReportGraduatedWithoutConclusionProcess() || conclusionInfo.getRegistrationConclusionBean().isConclusionProcessed());
    }

    private static RegistrationConclusionInformation terminalConclusionInformation(Registration registration, RaidesRequestPeriodParameter graduatedPeriod, ExecutionYear executionYear) {
        for (RegistrationConclusionInformation rci : RegistrationConclusionServices.inferConclusion((Registration)registration)) {
            if (!rci.isConcluded() || rci.isScholarPart() || rci.getConclusionYear() != executionYear || !graduatedPeriod.getInterval().contains((ReadableInstant)rci.getConclusionDate().toDateTimeAtStartOfDay())) continue;
            return rci;
        }
        return null;
    }

    protected void validaMobilidadeCredito(ExecutionYear executionYear, Registration registration, TblDiplomado bean) {
        if (!MobilityRegistrationInformation.hasAnyInternationalOutgoingMobilityUntil((Registration)registration, (ExecutionYear)executionYear)) {
            return;
        }
        RaidesReportEntryTarget target = RaidesReportEntryTarget.of(registration, executionYear);
        if (MobilityRegistrationInformation.findInternationalOutgoingInformationsUntil((Registration)registration, (ExecutionYear)executionYear).size() > 1 && MobilityRegistrationInformation.findMainInternationalOutgoingInformationUntil((Registration)registration, (ExecutionYear)executionYear) == null) {
            LegalReportContext.addError(target, this.i18n("error.Raides.validation.graduated.mobility.mainInformation.missing", new String[0]), this.i18n("error.Raides.validation.graduated.mobility.mainInformation.missing.action", new String[0]));
            bean.markAsInvalid();
        }
        if (Strings.isNullOrEmpty((String)bean.getTipoMobilidadeCredito())) {
            LegalReportContext.addError(target, this.i18n("error.Raides.validation.graduated.mobility.credit.type.missing", new String[0]), this.i18n("error.Raides.validation.graduated.mobility.credit.type.missing.action", new String[0]));
            bean.markAsInvalid();
        }
        if (Strings.isNullOrEmpty((String)bean.getProgMobilidadeCredito())) {
            LegalReportContext.addError(target, this.i18n("error.Raides.validation.graduated.mobility.program.type.missing", new String[0]), this.i18n("error.Raides.validation.graduated.mobility.program.type.missing.action", new String[0]));
            bean.markAsInvalid();
        }
        if ("2".equals(bean.getProgMobilidadeCredito()) && Strings.isNullOrEmpty((String)bean.getOutroProgMobCredito())) {
            LegalReportContext.addError(target, this.i18n("error.Raides.validation.graduated.mobility.other.program.type.missing", new String[0]), this.i18n("error.Raides.validation.graduated.mobility.other.program.type.missing.action", new String[0]));
            bean.markAsInvalid();
        }
        if ("2".equals(bean.getProgMobilidadeCredito()) && Strings.isNullOrEmpty((String)bean.getOutroProgMobCredito()) && bean.getOutroProgMobCredito().length() > this.MAX_SIZE_PROG_MOBILITY) {
            LegalReportContext.addError(target, this.i18n("error.Raides.validation.graduated.mobility.other.program.type.max.size", new String[0]), this.i18n("error.Raides.validation.graduated.mobility.other.program.type.max.size.action", new String[0]));
            bean.markAsInvalid();
        }
        if (Strings.isNullOrEmpty((String)bean.getPaisMobilidadeCredito())) {
            LegalReportContext.addError(target, this.i18n("error.Raides.validation.graduated.mobility.country.missing", new String[0]), this.i18n("error.Raides.validation.graduated.mobility.country.missing.action", new String[0]));
            bean.markAsInvalid();
        }
    }

    protected void validaClassificacao(ExecutionYear executionYear, RaidesRequestPeriodParameter graduatedPeriod, Registration registration, TblDiplomado bean) {
        RaidesReportEntryTarget target = RaidesReportEntryTarget.of(registration, executionYear);
        if (bean.getConclusaoMd() != null && bean.getConclusaoMd().equals(LegalMapping.find(this.report, LegalMappingType.BOOLEAN).translate(true)) && (Strings.isNullOrEmpty((String)bean.getClassificacaoFinalMd()) || "0".equals(bean.getClassificacaoFinalMd()))) {
            LegalReportContext.addError(target, this.i18n("error.Raides.validation.masterOrDoctoral.scholarpart.classification.empty.or.zero", new String[0]), this.i18n("error.Raides.validation.masterOrDoctoral.scholarpart.classification.empty.or.zero.action", new String[0]));
            bean.markAsInvalid();
        }
        if (bean.getConcluiGrau().equals(LegalMapping.find(this.report, LegalMappingType.BOOLEAN).translate(true)) && Strings.isNullOrEmpty((String)bean.getClassificacaoFinal()) || "0".equals(bean.getClassificacaoFinal())) {
            LegalReportContext.addError(target, this.i18n("error.Raides.validation.masterOrDoctoral.terminalpart.classification.empty.or.zero", new String[0]), this.i18n("error.Raides.validation.masterOrDoctoral.terminalpart.classification.empty.or.zero.action", new String[0]));
            bean.markAsInvalid();
        }
    }

    private void validaAreaInvestigacao(ExecutionYear executionYear, Registration registration, TblDiplomado bean) {
        if (Raides.isDoctoralDegree(registration) && bean.getConcluiGrau().equals(LegalMapping.find(this.report, LegalMappingType.BOOLEAN).translate(true)) && Strings.isNullOrEmpty((String)bean.getAreaInvestigacao())) {
            LegalReportContext.addError(RaidesReportEntryTarget.of(registration, executionYear), this.i18n("error.Raides.validation.doctoral.requires.research.area", new String[0]), this.i18n("error.Raides.validation.doctoral.requires.research.area.action", new String[0]));
            bean.markAsInvalid();
        }
    }

    public boolean isToReportNormal(RaidesRequestPeriodParameter graduatedPeriod, ExecutionYear executionYear, Registration registration) {
        return DiplomadoService.isTerminalConcluded(registration, graduatedPeriod, executionYear) || Raides.isMasterDegreeOrDoctoralDegree(registration) && this.isScholarPartConcluded(registration, graduatedPeriod, executionYear);
    }

    public boolean isToReportIntegratedCycleFirstCycle(RaidesRequestPeriodParameter graduatedPeriod, ExecutionYear executionYear, Registration registration) {
        if (Raides.isIntegratedMasterDegree(registration) && this.isScholarPartConcluded(registration, graduatedPeriod, executionYear)) {
            RaidesInstance instance = (RaidesInstance)((Object)this.report);
            if (instance.isReportGraduatedWithoutConclusionProcess() && instance.isToReportAllIntegratedMasterFirstCycleGraduatedStudents()) {
                return true;
            }
            if (instance.isToReportIntegratedMasterFirstCycleGraduatedStudentsOnlyWithConclusionProcess() && this.scholarPartConclusionInformation(registration, graduatedPeriod, executionYear).getRegistrationConclusionBean().isConclusionProcessed()) {
                return true;
            }
        }
        return false;
    }
}

