/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.legalpt.domain.report;

import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.concurrent.Callable;
import org.fenixedu.bennu.core.domain.Bennu;
import org.fenixedu.bennu.core.security.Authenticate;
import org.fenixedu.legalpt.domain.report.LegalReport;
import org.fenixedu.legalpt.domain.report.LegalReportRequest$callable$cancelRequest;
import org.fenixedu.legalpt.domain.report.LegalReportRequest$callable$createRequest;
import org.fenixedu.legalpt.domain.report.LegalReportRequest$callable$delete;
import org.fenixedu.legalpt.domain.report.LegalReportRequest$callable$markAsProcessed;
import org.fenixedu.legalpt.domain.report.LegalReportRequestParameters;
import org.fenixedu.legalpt.domain.report.LegalReportRequest_Base;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

public class LegalReportRequest
extends LegalReportRequest_Base {
    protected static final Comparator<LegalReportRequest> COMPARE_BY_REQUEST_DATE;
    public static final Advice advice$cancelRequest;
    public static final Advice advice$createRequest;
    public static final Advice advice$markAsProcessed;
    public static final Advice advice$delete;

    protected LegalReportRequest() {
        this.setBennu(Bennu.getInstance());
        this.setBennuPending(Bennu.getInstance());
    }

    protected void init(LegalReport report) {
        this.setWhenRequested(new DateTime());
        this.setRequestor(Authenticate.getUser().getPerson());
        this.setLegalReport(report);
        this.checkRules();
    }

    private void checkRules() {
        if (this.getRequestor() == null) {
            throw new IllegalArgumentException("error.ReportRequest.requestor.required");
        }
        if (this.getWhenRequested() == null) {
            throw new IllegalArgumentException("error.ReportRequest.whenRequested.required");
        }
        if (this.getLegalReport() == null) {
            throw new IllegalArgumentException("error.ReportRequest.report.required");
        }
    }

    public boolean isPending() {
        return this.getBennuPending() != null;
    }

    public Boolean getPending() {
        return this.getBennuPending() != null;
    }

    public boolean isCancelable() {
        return this.isPending();
    }

    public Boolean getCancelable() {
        return this.getBennuPending() != null;
    }

    public void process() {
        this.getLegalReport().process(this);
    }

    public void cancelRequest() {
        Object object = advice$cancelRequest.perform((Callable)new LegalReportRequest$callable$cancelRequest(this));
    }

    static /* synthetic */ void advised$cancelRequest(LegalReportRequest this_) {
        this_.setBennuPending(null);
    }

    public static final LegalReportRequest findFirstAsynchronousPendingRequest() {
        Collection requests = Collections2.filter((Collection)Bennu.getInstance().getPendingLegalReportRequestsSet(), (Predicate)new Predicate<LegalReportRequest>(){

            public boolean apply(LegalReportRequest request) {
                return request.getLegalReport().getSynchronous() == false;
            }
        });
        if (requests.isEmpty()) {
            return null;
        }
        return Collections.min(requests, COMPARE_BY_REQUEST_DATE);
    }

    public String getParameters() {
        throw new IllegalArgumentException("error.ReportRequest.report.use.method.getParametersAs");
    }

    public <T extends LegalReportRequestParameters> T getParametersAs(Class<T> type) {
        return LegalReportRequestParameters.fromJson(type, super.getParameters());
    }

    public void setParameters(LegalReportRequestParameters reportRequestParameter) {
        super.setParameters(reportRequestParameter != null ? reportRequestParameter.toJson() : null);
    }

    public static LegalReportRequest createRequest(LegalReport legalReport, LegalReportRequestParameters legalReportRequestParameters) {
        return (LegalReportRequest)((Object)advice$createRequest.perform((Callable)new LegalReportRequest$callable$createRequest(legalReport, legalReportRequestParameters)));
    }

    static /* synthetic */ LegalReportRequest advised$createRequest(LegalReport report, LegalReportRequestParameters parameters) {
        LegalReportRequest result = new LegalReportRequest();
        result.init(report);
        result.setParameters(parameters);
        if (report.getSynchronous().booleanValue()) {
            result.process();
        }
        return result;
    }

    public void markAsProcessed() {
        Object object = advice$markAsProcessed.perform((Callable)new LegalReportRequest$callable$markAsProcessed(this));
    }

    static /* synthetic */ void advised$markAsProcessed(LegalReportRequest this_) {
        this_.setWhenProcessed(new DateTime());
        this_.setBennuPending(null);
    }

    public void delete() {
        Object object = advice$delete.perform((Callable)new LegalReportRequest$callable$delete(this));
    }

    static /* synthetic */ void advised$delete(LegalReportRequest this_) {
        this_.setBennu(null);
        this_.setBennuPending(null);
        this_.getLegalResultDataFileSet().forEach(dataFile -> dataFile.delete());
        this_.getLegalReportParametersFilesSet().forEach(parameterFile -> parameterFile.delete());
        this_.setRequestor(null);
        this_.setLegalReport(null);
        this_.deleteDomainObject();
    }

    static {
        advice$cancelRequest = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        advice$createRequest = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        advice$markAsProcessed = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.WRITE, true));
        advice$delete = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        COMPARE_BY_REQUEST_DATE = new Comparator<LegalReportRequest>(){

            @Override
            public int compare(LegalReportRequest o1, LegalReportRequest o2) {
                int c = o1.getWhenRequested().compareTo((ReadableInstant)o2.getWhenRequested());
                return c != 0 ? c : o1.getExternalId().compareTo(o2.getExternalId());
            }
        };
    }
}

