/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.ulisboa.integration.sas.tasks.sicabe;

import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.fenixedu.academic.domain.ExecutionInterval;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.GrantOwnerType;
import org.fenixedu.academic.domain.student.PersonalIngressionData;
import org.fenixedu.academic.domain.student.Registration;
import org.fenixedu.academic.domain.student.StatuteType;
import org.fenixedu.academic.domain.student.StudentStatute;
import org.fenixedu.academic.domain.student.services.StatuteServices;
import org.fenixedu.academic.domain.util.email.Message;
import org.fenixedu.academic.domain.util.email.Sender;
import org.fenixedu.bennu.core.domain.Bennu;
import org.fenixedu.bennu.core.i18n.BundleUtil;
import org.fenixedu.bennu.scheduler.CronTask;
import org.fenixedu.bennu.scheduler.annotation.Task;
import org.fenixedu.ulisboa.integration.sas.domain.CandidacyState;
import org.fenixedu.ulisboa.integration.sas.domain.SasScholarshipCandidacy;
import org.fenixedu.ulisboa.integration.sas.domain.SocialServicesConfiguration;
import org.fenixedu.ulisboa.integration.sas.service.sicabe.SicabeExternalService;
import org.fenixedu.ulisboa.integration.sas.tasks.sicabe.IngestSasScholarshipSicabe$callable$updatePersonalIngressionDataAndUpdateStatuteType;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.FenixFramework;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

@Task(englishTitle="Ingest SAS Scholarships from SICABE", readOnly=true)
public class IngestSasScholarshipSicabe
extends CronTask {
    public static final Advice advice$updatePersonalIngressionDataAndUpdateStatuteType = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));

    public void runTask() throws Exception {
        try {
            boolean newCandidaciesProcesses;
            int beforeSasCandidacies = Bennu.getInstance().getSasScholarshipCandidaciesSet().size();
            long beforeWithStateModified = this.getNumberOfCandidaciesWithModifiedState();
            SicabeExternalService sicabe = new SicabeExternalService();
            ExecutionYear currentExecutionYear = ExecutionYear.readCurrentExecutionYear();
            sicabe.removeAllCandidaciesWithoutRegistrationAndLoadAllSasCandidacies(currentExecutionYear);
            sicabe.processAllSasScholarshipCandidacies(currentExecutionYear);
            int afterSasCandidacies = Bennu.getInstance().getSasScholarshipCandidaciesSet().size();
            long afterWithStateModified = this.getNumberOfCandidaciesWithModifiedState();
            HashSet<Registration> listOfWarningToReport = new HashSet<Registration>();
            this.updatePersonalIngressionDataAndUpdateStatuteType(currentExecutionYear, listOfWarningToReport);
            boolean bl = newCandidaciesProcesses = beforeSasCandidacies != afterSasCandidacies || beforeWithStateModified != afterWithStateModified;
            if (newCandidaciesProcesses || listOfWarningToReport.size() > 0) {
                this.sendEmailForUser(BundleUtil.getString((String)"resources/SasResources", (String)"sasScholarship.ingestion.task.message.notification.subject", (String[])new String[0]), (newCandidaciesProcesses ? BundleUtil.getString((String)"resources/SasResources", (String)"sasScholarship.ingestion.task.message.notification.body", (String[])new String[]{String.valueOf(afterSasCandidacies - beforeSasCandidacies), String.valueOf(afterWithStateModified - beforeWithStateModified)}) : "") + (String)(listOfWarningToReport.size() > 0 ? "\n" + BundleUtil.getString((String)"resources/SasResources", (String)"sasScholarship.ingestion.task.message.notification.body.warnings", (String[])new String[0]) + "\n" + this.printRegistrationList(listOfWarningToReport) : ""));
            }
        }
        catch (Throwable e) {
            this.sendEmailForUser(BundleUtil.getString((String)"resources/SasResources", (String)"sasScholarship.ingestion.task.message.notification.subject.error", (String[])new String[0]), BundleUtil.getString((String)"resources/SasResources", (String)"sasScholarship.ingestion.task.message.notification.body.error", (String[])new String[]{ExceptionUtils.getStackTrace((Throwable)e)}));
            throw e;
        }
    }

    private String printRegistrationList(HashSet<Registration> listOfWarningToReport) {
        return listOfWarningToReport.stream().map(r -> r.getNumber() + " - " + r.getStudent().getName() + " -  [" + r.getDegree().getCode() + " - " + r.getDegree().getPresentationName() + "]").collect(Collectors.joining("\n"));
    }

    private void updatePersonalIngressionDataAndUpdateStatuteType(ExecutionYear executionYear, HashSet<Registration> hashSet) {
        Object object = advice$updatePersonalIngressionDataAndUpdateStatuteType.perform((Callable)new IngestSasScholarshipSicabe$callable$updatePersonalIngressionDataAndUpdateStatuteType(this, executionYear, hashSet));
    }

    /*
     * Ignored method signature, as it can't be verified against descriptor
     */
    static /* synthetic */ void advised$updatePersonalIngressionDataAndUpdateStatuteType(IngestSasScholarshipSicabe this_, ExecutionYear currentExecutionYear, HashSet listOfWarningToReport) {
        currentExecutionYear.getSasScholarshipCandidaciesSet().stream().filter(c -> c.getRegistration() != null && c.getRegistration().getStudent() != null).forEach(c -> {
            this.updatePersonalIngressionData((SasScholarshipCandidacy)((Object)c), listOfWarningToReport);
            this.updateStatuteType((SasScholarshipCandidacy)((Object)c), listOfWarningToReport);
        });
    }

    private void updatePersonalIngressionData(SasScholarshipCandidacy c, HashSet<Registration> listOfWarningToReport) {
        PersonalIngressionData pid = c.getRegistration().getStudent().getPersonalIngressionDataByExecutionYear(c.getExecutionYear());
        if (pid != null && c.getCandidacyState() == CandidacyState.DEFERRED && pid.getGrantOwnerType() != GrantOwnerType.HIGHER_EDUCATION_SAS_GRANT_OWNER) {
            pid.setGrantOwnerType(GrantOwnerType.HIGHER_EDUCATION_SAS_GRANT_OWNER);
            return;
        }
        if (pid != null && (c.getCandidacyState() == CandidacyState.UNDEFINED || c.getCandidacyState() == CandidacyState.DISMISSED) && pid.getGrantOwnerType() == GrantOwnerType.HIGHER_EDUCATION_SAS_GRANT_OWNER) {
            listOfWarningToReport.add(c.getRegistration());
            return;
        }
    }

    private void updateStatuteType(SasScholarshipCandidacy c, HashSet<Registration> listOfWarningToReport) {
        StatuteType sasStatuteType = SocialServicesConfiguration.getInstance().getStatuteTypeSas();
        if (c.getCandidacyState() == CandidacyState.DEFERRED && sasStatuteType != null && !this.studentHasStatuteType(c, sasStatuteType)) {
            new StudentStatute(c.getRegistration().getStudent(), sasStatuteType, c.getExecutionYear().getExecutionSemesterFor(Integer.valueOf(1)), c.getExecutionYear().getExecutionSemesterFor(Integer.valueOf(2)), null, null, "", c.getRegistration());
        }
        if ((c.getCandidacyState() == CandidacyState.UNDEFINED || c.getCandidacyState() == CandidacyState.DISMISSED) && sasStatuteType != null && this.studentHasStatuteType(c, sasStatuteType)) {
            listOfWarningToReport.add(c.getRegistration());
        }
    }

    private boolean studentHasStatuteType(SasScholarshipCandidacy candidacy, StatuteType statuteType) {
        return StatuteServices.findStatuteTypes((Registration)candidacy.getRegistration(), (ExecutionInterval)candidacy.getExecutionYear()).stream().anyMatch(st -> st == statuteType);
    }

    private long getNumberOfCandidaciesWithModifiedState() {
        return Bennu.getInstance().getSasScholarshipCandidaciesSet().stream().filter(c -> c.isModified()).count();
    }

    public void sendEmailForUser(String subject, String body) {
        Runnable runnable = () -> FenixFramework.atomic(() -> {
            String emailAddress = Bennu.getInstance().getSocialServicesConfiguration().getEmail();
            new Message((Sender)Bennu.getInstance().getSystemSender(), Collections.emptyList(), Collections.emptyList(), subject, body, new HashSet<String>(Arrays.asList(emailAddress.split(","))));
        });
        Thread t = new Thread(runnable);
        t.start();
        try {
            t.join();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }
}

