/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.ulisboa.integration.sas.tasks;

import org.fenixedu.bennu.core.domain.Bennu;
import org.fenixedu.bennu.scheduler.CronTask;
import org.fenixedu.bennu.scheduler.annotation.Task;
import org.fenixedu.ulisboa.integration.sas.domain.ScholarshipReportRequest;
import org.fenixedu.ulisboa.integration.sas.service.process.ScholarshipService;
import org.fenixedu.ulisboa.integration.sas.util.SASDomainException;

@Task(englishTitle="Process Scholarship Report Requests", readOnly=true)
public class ProcessScholarshipReportRequests
extends CronTask {
    public void runTask() throws Exception {
        for (ScholarshipReportRequest request : Bennu.getInstance().getPendingScholarshipReportRequestsSet()) {
            try {
                ScholarshipService.processScholarshipFile(request);
            }
            catch (SASDomainException e) {
                this.taskLog("Error processing scholarship request with oid " + request.getExternalId(), new Object[0]);
                this.getLogger().error(e.getMessage() + " - Error processing scholarship request with oid " + request.getExternalId(), (Throwable)((Object)e));
                request.removeReport(e.getLocalizedString());
            }
            catch (Throwable t) {
                this.taskLog("Error processing scholarship request with oid " + request.getExternalId(), new Object[0]);
                this.getLogger().error(t.getMessage() + " - Error processing scholarship request with oid " + request.getExternalId(), t);
                request.removeReport(null);
            }
        }
    }
}

