/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.ulisboa.integration.sas.service.transform;

import java.io.IOException;
import java.util.ArrayList;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.fenixedu.ulisboa.integration.sas.dto.ScholarshipStudentFirstYearBean;
import org.fenixedu.ulisboa.integration.sas.dto.ScholarshipStudentOtherYearBean;
import org.fenixedu.ulisboa.integration.sas.service.transform.AbstractScholarshipXlsTransformService;
import org.fenixedu.ulisboa.integration.sas.util.SASDomainException;

public class OtherYearScholarshipXlsTransformService
extends AbstractScholarshipXlsTransformService {
    static Integer FIRST_VALUE_ROW = 2;
    static Integer TEST_VALUE_ROW = null;

    @Override
    public boolean checkExcelFormat(HSSFSheet sheet) throws IOException {
        int columnsRead = Integer.valueOf(String.valueOf(sheet.getRow(0).getLastCellNum()));
        int columnsExpected = ScholarshipStudentOtherYearBean.INGRESSION_REGIME + 1;
        int columnsAlternative = ScholarshipStudentFirstYearBean.INGRESSION_REGIME + 1;
        if (columnsRead == columnsExpected) {
            return true;
        }
        if (columnsRead == columnsAlternative) {
            throw new SASDomainException("error.fileTypeDoesNotMatchRequest.expected" + this.getClass().getSimpleName());
        }
        throw new SASDomainException("error.fileFormatDoesNotMatchRequest.expected", new String[]{String.valueOf(columnsExpected), String.valueOf(columnsRead)});
    }

    @Override
    public void readStudentLines(HSSFSheet sheet) {
        HSSFRow row;
        int i = FIRST_VALUE_ROW;
        while ((row = sheet.getRow(i)) != null && row.getCell(0) != null) {
            if (TEST_VALUE_ROW != null && i != TEST_VALUE_ROW) {
                ++i;
                continue;
            }
            ScholarshipStudentOtherYearBean bean = new ScholarshipStudentOtherYearBean();
            this.readSpreadsheetRow(row, bean);
            this.studentLines.add(bean);
            ++i;
        }
    }

    protected void readSpreadsheetRow(HSSFRow row, ScholarshipStudentOtherYearBean bean) {
        bean.setInstitutionCode(this.getValueFromColumnMayBeNull(row, ScholarshipStudentOtherYearBean.INSTITUTION_CODE));
        bean.setInstitutionName(this.getValueFromColumnMayBeNull(row, ScholarshipStudentOtherYearBean.INSTITUTION_NAME));
        bean.setCandidacyNumber(this.getValueFromColumnMayBeNull(row, ScholarshipStudentOtherYearBean.CANDIDACY_NUMBER));
        try {
            bean.setStudentNumber(Integer.parseInt(this.getValueFromColumnMayBeNull(row, ScholarshipStudentOtherYearBean.STUDENT_NUMBER)));
        }
        catch (NumberFormatException e) {
            bean.setStudentNumber(null);
        }
        bean.setStudentName(this.getValueFromColumnMayBeNull(row, ScholarshipStudentOtherYearBean.STUDENT_NAME));
        bean.setDocumentTypeName(this.getValueFromColumnMayBeNull(row, ScholarshipStudentOtherYearBean.DOCUMENT_TYPE_NAME));
        bean.setDocumentNumber(this.getValueFromColumnMayBeNull(row, ScholarshipStudentOtherYearBean.DOCUMENT_NUMBER));
        bean.setDegreeCode(this.getValueFromColumnMayBeNull(row, ScholarshipStudentOtherYearBean.DEGREE_CODE));
        bean.setDegreeName(this.getValueFromColumnMayBeNull(row, ScholarshipStudentOtherYearBean.DEGREE_NAME));
        bean.setDegreeTypeName(this.getValueFromColumnMayBeNull(row, ScholarshipStudentOtherYearBean.DEGREE_TYPE_NAME));
        bean.setCode(this.getValueFromColumnMayBeNull(row, ScholarshipStudentOtherYearBean.CODE));
        try {
            bean.setCycleIngressionYear(Integer.parseInt(this.getValueFromColumnMayBeNull(row, ScholarshipStudentOtherYearBean.CYCLE_INGRESSION_YEAR)));
        }
        catch (NumberFormatException e) {
            bean.setCycleIngressionYear(null);
        }
        bean.setDocumentBINumber(this.getValueFromColumnMayBeNull(row, ScholarshipStudentOtherYearBean.DOCUMENT_BI));
    }

    @Override
    public void writeExcelLines(HSSFSheet sheet) throws IOException {
        for (int i = 0; i < this.studentLines.size(); ++i) {
            ScholarshipStudentOtherYearBean scholarshipStudentBean = (ScholarshipStudentOtherYearBean)this.studentLines.get(i);
            HSSFRow row = sheet.getRow(FIRST_VALUE_ROW + i);
            this.writeSpreadsheetRow(row, scholarshipStudentBean);
        }
    }

    protected void writeSpreadsheetRow(HSSFRow row, ScholarshipStudentOtherYearBean bean) {
        this.writeCellString(row, ScholarshipStudentOtherYearBean.INSTITUTION_CODE, bean.getInstitutionCode());
        this.writeCellInteger(row, ScholarshipStudentOtherYearBean.STUDENT_NUMBER, bean.getStudentNumber());
        this.writeCellString(row, ScholarshipStudentOtherYearBean.DEGREE_CODE, bean.getDegreeCode());
        this.writeCellInteger(row, ScholarshipStudentOtherYearBean.COUNT_NUMBER_OF_DEGREE_CHANGES, bean.getNumberOfDegreeChanges());
        this.writeCellString(row, ScholarshipStudentOtherYearBean.CURRENT_YEAR_HAS_MADE_DEGREE_CHANGE, this.booleanToString(bean.getHasMadeDegreeChangeOnCurrentYear()));
        this.writeCellString(row, ScholarshipStudentOtherYearBean.REGISTERED, this.booleanToString(bean.getEnroled()));
        this.writeCellLocalDate(row, ScholarshipStudentOtherYearBean.REGISTRATION_DATE, bean.getEnroled() != false ? bean.getEnrolmentDate() : null);
        this.writeCellString(row, ScholarshipStudentOtherYearBean.REGIME, bean.getEnroled() != false ? bean.getRegime() : null);
        this.writeCellInteger(row, ScholarshipStudentOtherYearBean.CYCLE_INGRESSION_YEAR, bean.getEnroled() != false ? bean.getCycleIngressionYear() : null);
        this.writeCellInteger(row, ScholarshipStudentOtherYearBean.CYCLE_NUMBER_OF_ENROLMENT_YEARS, bean.getEnroled() != false ? bean.getCycleNumberOfEnrolmentsYearsInIntegralRegime() : null);
        this.writeCellInteger(row, ScholarshipStudentOtherYearBean.CYCLE_COUNT_NUMBER_OF_ENROLMENTS_YEARS_IN_INTEGRAL_REGIME, bean.getEnroled() != false ? bean.getCycleNumberOfEnrolmentsYearsInIntegralRegime() : null);
        this.writeCellBigDecimal(row, ScholarshipStudentOtherYearBean.NUMBER_OF_APPROVED_ECTS, bean.getEnroled() != false ? bean.getNumberOfApprovedEcts() : null);
        this.writeCellInteger(row, ScholarshipStudentOtherYearBean.NUMBER_OF_YEARS_DEGREE, bean.getEnroled() != false ? bean.getNumberOfDegreeCurricularYears() : null);
        this.writeCellInteger(row, ScholarshipStudentOtherYearBean.LAST_ENROLMENT_CURRICULAR_YEAR, bean.getEnroled() != false ? bean.getLastEnrolmentCurricularYear() : null);
        this.writeCellBigDecimal(row, ScholarshipStudentOtherYearBean.NUMBER_OF_ENROLLED_ECTS_LAST_YEAR, bean.getEnroled() != false ? bean.getNumberOfEnrolledEctsLastYear() : null);
        this.writeCellBigDecimal(row, ScholarshipStudentOtherYearBean.NUMBER_OF_APPROVED_ECTS_LAST_YEAR, bean.getEnroled() != false ? bean.getNumberOfApprovedEctsLastYear() : null);
        this.writeCellInteger(row, ScholarshipStudentOtherYearBean.CURRICULAR_YEAR, bean.getEnroled() != false ? bean.getCurricularYear() : null);
        this.writeCellBigDecimal(row, ScholarshipStudentOtherYearBean.NUMBER_OF_ECTS, bean.getEnroled() != false ? bean.getNumberOfEnrolledECTS() : null);
        this.writeCellBigDecimal(row, ScholarshipStudentOtherYearBean.GRATUITY, bean.getEnroled() != false ? bean.getGratuityAmount() : null);
        this.writeCellInteger(row, ScholarshipStudentOtherYearBean.NUMBER_OF_MONTHS_EXECUTION_YEAR, bean.getEnroled() != false ? bean.getNumberOfMonthsExecutionYear() : null);
        this.writeCellString(row, ScholarshipStudentOtherYearBean.FIRST_MONTH_EXECUTION_YEAR, bean.getEnroled() != false ? this.toMonthString(bean.getFirstMonthExecutionYear()) : null);
        this.writeCellString(row, ScholarshipStudentOtherYearBean.OWNER_CET, bean.getEnroled() != false ? this.booleanToString(bean.getCetQualificationOwner()) : null);
        this.writeCellString(row, ScholarshipStudentOtherYearBean.OWNER_CSTP, bean.getEnroled() != false ? this.booleanToString(bean.getCtspQualificationOwner()) : null);
        this.writeCellString(row, ScholarshipStudentOtherYearBean.OWNER_BACHELOR, bean.getEnroled() != false ? this.booleanToString(bean.getDegreeQualificationOwner()) : null);
        this.writeCellString(row, ScholarshipStudentOtherYearBean.OWNER_MASTER, bean.getEnroled() != false ? this.booleanToString(bean.getMasterQualificationOwner()) : null);
        this.writeCellString(row, ScholarshipStudentOtherYearBean.OWNER_PHD, bean.getEnroled() != false ? this.booleanToString(bean.getPhdQualificationOwner()) : null);
        this.writeCellString(row, ScholarshipStudentOtherYearBean.OBSERVATIONS, bean.getObservations());
        this.writeCellInteger(row, ScholarshipStudentOtherYearBean.LAST_ENROLMENT_EXECUTION_YEAR, bean.getEnroled() != false ? bean.getLastEnrolmentYear() : null);
        this.writeCellLocalDate(row, ScholarshipStudentOtherYearBean.LAST_ACADEMIC_ACT_DATE_LAST_YEAR, bean.getEnroled() != false ? bean.getLastAcademicActDateLastYear() : null);
        this.writeCellString(row, ScholarshipStudentOtherYearBean.INGRESSION_REGIME, bean.getIngressionRegimeCodeWithDescription());
    }

    public OtherYearScholarshipXlsTransformService(POIFSFileSystem poifsFileSystem) {
        this.scholarshipStudentBean = new ScholarshipStudentOtherYearBean();
        this.studentLines = new ArrayList();
        this.poifsFileSystem = poifsFileSystem;
    }
}

