/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.legalpt.ui.raides;

import com.google.gson.Gson;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.degree.DegreeType;
import org.fenixedu.bennu.TupleDataSourceBean;
import org.fenixedu.bennu.core.domain.Bennu;
import org.fenixedu.bennu.core.domain.exceptions.DomainException;
import org.fenixedu.bennu.scheduler.CronTask;
import org.fenixedu.bennu.scheduler.TaskRunner;
import org.fenixedu.bennu.scheduler.domain.SchedulerSystem;
import org.fenixedu.bennu.spring.portal.SpringFunctionality;
import org.fenixedu.legalpt.domain.raides.Raides;
import org.fenixedu.legalpt.domain.raides.RaidesInstance;
import org.fenixedu.legalpt.domain.raides.report.RaidesRequestParameter;
import org.fenixedu.legalpt.domain.report.LegalReport;
import org.fenixedu.legalpt.domain.report.LegalReportRequest;
import org.fenixedu.legalpt.domain.report.LegalReportResultFile;
import org.fenixedu.legalpt.dto.DegreeTypeBean;
import org.fenixedu.legalpt.task.ProcessPendingLegalReportRequest;
import org.fenixedu.legalpt.ui.FenixeduLegalPTBaseController;
import org.fenixedu.legalpt.ui.FenixeduLegalPTController;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

@SpringFunctionality(app=FenixeduLegalPTController.class, title="label.title.manageRaidesRequests", accessGroup="logged")
@RequestMapping(value={"/fenixedu-legal-pt/raides/manageraidesrequests"})
public class RaidesRequestsController
extends FenixeduLegalPTBaseController {
    public static final String CONTROLLER_URL = "/fenixedu-legal-pt/raides/manageraidesrequests";
    public static final String JSP_PATH = "/fenixedu-legal-pt/raides/manageraidesrequests".substring(1);
    private static final String _SEARCH_URI = "/search";
    public static final String SEARCH_URL = "/fenixedu-legal-pt/raides/manageraidesrequests/search";
    private static final String _READ_URI = "/read";
    public static final String READ_URL = "/fenixedu-legal-pt/raides/manageraidesrequests/read";
    private static final String _DOWNLOAD_RESULT_FILE_URI = "/downloadresultfile";
    public static final String DOWNLOAD_RESULT_FILE_URL = "/fenixedu-legal-pt/raides/manageraidesrequests/downloadresultfile";
    private static final String _CREATE_URI = "/create";
    public static final String CREATE_URL = "/fenixedu-legal-pt/raides/manageraidesrequests/create";
    private static final String _CREATE_BY_COPY_URI = "/createByCopy";
    public static final String CREATE_BY_COPY_URL = "/fenixedu-legal-pt/raides/manageraidesrequests/createByCopy";
    private static final String _CREATE_POSTBACK_URI = "/createpostback";
    public static final String CREATE_POSTBACK_URL = "/fenixedu-legal-pt/raides/manageraidesrequests/read";

    @RequestMapping
    public String home() {
        return "forward:/fenixedu-legal-pt/raides/manageraidesrequests/search";
    }

    @RequestMapping(value={"/search"})
    public String search(Model model) {
        model.addAttribute("reportRequests", (Object)RaidesInstance.getInstance().getLegalRequestsSet());
        return this.jspPage(_SEARCH_URI);
    }

    @RequestMapping(value={"/read/{requestId}"})
    public String read(@PathVariable(value="requestId") LegalReportRequest request, Model model) {
        model.addAttribute("reportRequest", (Object)request);
        return this.jspPage(_READ_URI);
    }

    @RequestMapping(value={"/downloadresultfile/{resultFileId}"})
    public void downloadresultfile(@PathVariable(value="resultFileId") LegalReportResultFile resultFile, Model model, HttpServletResponse response) {
        try {
            response.setContentType(resultFile.getContentType());
            response.setHeader("Content-Disposition", "attachment;filename=" + resultFile.getFilename());
            response.getOutputStream().write(resultFile.getContent());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @RequestMapping(value={"/create"}, method={RequestMethod.GET})
    public String create(Model model) {
        RaidesRequestParameter raidesRequestParameter = new RaidesRequestParameter();
        Raides.fillRaidesRequestDefaultData(raidesRequestParameter);
        return this._create(raidesRequestParameter, model);
    }

    @RequestMapping(value={"/createByCopy/{legalReportRequestId}"}, method={RequestMethod.GET})
    public String createByCopy(@PathVariable(value="legalReportRequestId") LegalReportRequest legalReportRequest, Model model) {
        RaidesRequestParameter previousRequestParameters = legalReportRequest.getParametersAs(RaidesRequestParameter.class);
        return this._create(previousRequestParameters.copy(), model);
    }

    private String _create(RaidesRequestParameter raidesRequestParameter, Model model) {
        model.addAttribute("bean", (Object)raidesRequestParameter);
        model.addAttribute("beanJson", (Object)this.getBeanJson(raidesRequestParameter));
        model.addAttribute("executionYearDataSource", (Object)this.getNotClosedExecutionYearsJson());
        model.addAttribute("degreeTypeDataSource", (Object)this.getDegreeTypesJson());
        return this.jspPage(_CREATE_URI);
    }

    private String getNotClosedExecutionYearsJson() {
        List list = ExecutionYear.readNotClosedExecutionYears().stream().sorted(ExecutionYear.REVERSE_COMPARATOR_BY_YEAR).map(x -> {
            TupleDataSourceBean tuple = new TupleDataSourceBean();
            tuple.setId(x.getExternalId());
            tuple.setText(x.getName());
            return tuple;
        }).collect(Collectors.toList());
        return new Gson().toJson(list);
    }

    private String getDegreeTypesJson() {
        List list = Bennu.getInstance().getDegreeTypeSet().stream().map(type -> new DegreeTypeBean((DegreeType)type)).sorted(DegreeTypeBean.COMPARE_BY_TEXT).collect(Collectors.toList());
        return new Gson().toJson(list);
    }

    @RequestMapping(value={"/createpostback"}, method={RequestMethod.GET})
    public String createpostback(Model model) {
        return this._create(null, model);
    }

    @RequestMapping(value={"/create"}, method={RequestMethod.POST})
    public String createpost(@RequestParam(value="bean") RaidesRequestParameter raidesRequestParameter, Model model) {
        try {
            LegalReportRequest request = LegalReportRequest.createRequest((LegalReport)((Object)RaidesInstance.getInstance()), raidesRequestParameter);
            if (request.isPending()) {
                SchedulerSystem.queue((TaskRunner)new TaskRunner((CronTask)new ProcessPendingLegalReportRequest(request.getExternalId())));
            }
            return "redirect:/fenixedu-legal-pt/raides/manageraidesrequests/search";
        }
        catch (DomainException e) {
            this.addErrorMessage(e.getLocalizedMessage(), model);
            return this._create(raidesRequestParameter, model);
        }
    }

    private String jspPage(String page) {
        return JSP_PATH + "/" + page.substring(1, page.length());
    }
}

