/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.legalpt.ui.academicinstitutions;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import org.fenixedu.academic.domain.organizationalStructure.Unit;
import org.fenixedu.academic.domain.raides.DegreeDesignation;
import org.fenixedu.bennu.core.domain.Bennu;
import org.fenixedu.bennu.spring.portal.SpringFunctionality;
import org.fenixedu.legalpt.ui.FenixeduLegalPTBaseController;
import org.fenixedu.legalpt.ui.FenixeduLegalPTController;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@SpringFunctionality(app=FenixeduLegalPTController.class, title="label.title.AcademicInstitutions", accessGroup="logged")
@RequestMapping(value={"/fenixedu-legal-pt/academicinstitutions"})
public class AcademicInstitutionsController
extends FenixeduLegalPTBaseController {
    public static final String CONTROLLER_URL = "/fenixedu-legal-pt/academicinstitutions";
    private static final String JSP_PATH = "/fenixedu-legal-pt/academicinstitutions".substring(1);
    public static final String _VIEW_ACADEMIC_UNITS_URI = "/viewacademicunits";
    public static final String VIEW_ACADEMIC_UNITS_URL = "/fenixedu-legal-pt/academicinstitutions/viewacademicunits";
    public static final String _VIEW_ACADEMIC_UNIT_DETAIL_URI = "/viewacademicunitdetail";
    public static final String VIEW_ACADEMIC_UNIT_DETAIL_URL = "/fenixedu-legal-pt/academicinstitutions/viewacademicunitdetail";
    public static final String _VIEW_DEGREE_DESIGNATIONS_URI = "/viewdegreedesignations";
    public static final String VIEW_DEGREE_DESIGNATIONS_URL = "/fenixedu-legal-pt/academicinstitutions/viewdegreedesignations";
    public static final String _VIEW_DEGREE_DESIGNATION_DETAIL_URI = "/viewdegreedesignationdetail";
    public static final String VIEW_DEGREE_DESIGNATION_DETAIL_URL = "/fenixedu-legal-pt/academicinstitutions/viewdegreedesignationdetail";

    @RequestMapping
    public String home(Model model) {
        return "forward:/fenixedu-legal-pt/academicinstitutions/viewacademicunits";
    }

    @RequestMapping(value={"/viewacademicunits"}, method={RequestMethod.GET})
    public String viewacademicunits(Model model, RedirectAttributes redirectAttributes) {
        model.addAttribute("officialAcademicUnits", this.readAllOfficialAcademicUnits());
        model.addAttribute("unofficialAcademicUnits", this.readAllUnofficialAcademicUnits());
        return this.jspPage(_VIEW_ACADEMIC_UNITS_URI);
    }

    private List<Unit> readAllUnofficialAcademicUnits() {
        return Unit.readAllUnits().stream().filter(u -> u.isAcademicalUnit() && Strings.isNullOrEmpty((String)u.getCode())).sorted(Unit.COMPARATOR_BY_NAME_AND_ID).collect(Collectors.toList());
    }

    private List<Unit> readAllOfficialAcademicUnits() {
        return Unit.readAllUnits().stream().filter(u -> u.isAcademicalUnit() && !Strings.isNullOrEmpty((String)u.getCode())).sorted(Unit.COMPARATOR_BY_NAME_AND_ID).collect(Collectors.toList());
    }

    @RequestMapping(value={"/viewacademicunitdetail/{unitId}"}, method={RequestMethod.GET})
    public String viewacademicunitdetail(@PathVariable(value="unitId") Unit unit, Model model, RedirectAttributes redirectAttributes) {
        model.addAttribute("academicUnit", (Object)unit);
        return this.jspPage(_VIEW_ACADEMIC_UNIT_DETAIL_URI);
    }

    @RequestMapping(value={"/viewdegreedesignations"}, method={RequestMethod.GET})
    public String viewdegreedesignations(Model model, RedirectAttributes redirectAttributes) {
        model.addAttribute("degreeDesignations", this.readDegreeDesignations());
        return this.jspPage(_VIEW_DEGREE_DESIGNATIONS_URI);
    }

    private List<DegreeDesignation> readDegreeDesignations() {
        ArrayList result = Lists.newArrayList((Iterable)Bennu.getInstance().getDegreeDesignationsSet());
        Collections.sort(result, new Comparator<DegreeDesignation>(){

            @Override
            public int compare(DegreeDesignation o1, DegreeDesignation o2) {
                int c = o1.getDescription().compareTo(o2.getDescription());
                return c != 0 ? c : o1.getExternalId().compareTo(o2.getExternalId());
            }
        });
        return result;
    }

    @RequestMapping(value={"/viewdegreedesignationdetail/{degreeDesignationId}"}, method={RequestMethod.GET})
    public String viewdegreedesignationdetail(@PathVariable(value="degreeDesignationId") DegreeDesignation degreeDesignation, Model model, RedirectAttributes redirectAttributes) {
        model.addAttribute("degreeDesignation", (Object)degreeDesignation);
        return this.jspPage(_VIEW_DEGREE_DESIGNATION_DETAIL_URI);
    }

    private String jspPage(String page) {
        return JSP_PATH + "/" + page.substring(1, page.length());
    }
}

