/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.legalpt.services.report.log;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.util.List;
import java.util.concurrent.Callable;
import org.fenixedu.academic.domain.ProfessionType;
import org.fenixedu.academic.domain.ProfessionalSituationConditionType;
import org.fenixedu.academic.domain.SchoolLevelType;
import org.fenixedu.academic.domain.SchoolPeriodDuration;
import org.fenixedu.commons.spreadsheet.SheetData;
import org.fenixedu.commons.spreadsheet.SpreadsheetBuilderForXLSX;
import org.fenixedu.legalpt.domain.LegalReportContext;
import org.fenixedu.legalpt.domain.ReportEntry;
import org.fenixedu.legalpt.domain.report.LegalReportRequest;
import org.fenixedu.legalpt.domain.report.LegalReportResultFile;
import org.fenixedu.legalpt.domain.report.LegalReportResultFileType;
import org.fenixedu.legalpt.services.report.log.XlsExporterLog$callable$writeToFile;
import org.fenixedu.legalpt.util.LegalPTUtil;
import org.joda.time.DateTime;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

public class XlsExporterLog {
    public static final Advice advice$writeToFile = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.WRITE, true));

    public static LegalReportResultFile write(LegalReportRequest reportRequest, LegalReportContext.LegalReportEntryData legalReportEntryData) {
        List<ReportEntry> compiledData = legalReportEntryData.getErrorEntries();
        compiledData.addAll(legalReportEntryData.getWarnEntries());
        compiledData.addAll(legalReportEntryData.getInfoEntries());
        SheetData<ReportEntry> compiledSheet = new SheetData<ReportEntry>(compiledData){

            protected void makeLine(ReportEntry reportEntry) {
                this.addCell(LegalPTUtil.bundle("label.RaidesRequests.header.excel.type", new String[0]), reportEntry.getType() != null ? LegalPTUtil.bundle("label.ReportEntryType." + reportEntry.getType().name(), new String[0]) : "");
                reportEntry.getTarget().asMap().entrySet().forEach(e -> this.addCell(e.getKey(), e.getValue()));
                this.addCell(LegalPTUtil.bundle("label.RaidesRequests.header.excel.message", new String[0]), reportEntry.getMessage());
                this.addCell(LegalPTUtil.bundle("label.RaidesRequests.header.excel.action", new String[0]), reportEntry.getAction());
            }
        };
        ByteArrayOutputStream outputStream = null;
        try {
            outputStream = new ByteArrayOutputStream();
            SpreadsheetBuilderForXLSX spreadsheetBuilder = new SpreadsheetBuilderForXLSX();
            spreadsheetBuilder.addSheet(LegalPTUtil.bundle("label.RaidesRequests.sheet.name.excel", new String[0]), compiledSheet);
            spreadsheetBuilder.build(outputStream);
            byte[] content = outputStream.toByteArray();
            String fileName = "Logs_" + reportRequest.getLegalReport().getName().getContent() + "_" + new DateTime().toString("dd-MM-yyyy-HH-mm") + "." + LegalReportResultFileType.XLSX.toString().toLowerCase();
            LegalReportResultFile legalReportResultFile = XlsExporterLog.writeToFile(reportRequest, content, fileName);
            return legalReportResultFile;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("error.XlsxExporter.spreadsheet.generation.failed", e);
        }
        finally {
            try {
                outputStream.close();
            }
            catch (IOException e) {
                e.printStackTrace();
                throw new RuntimeException("error.XlsxExporter.spreadsheet.generation.failed", e);
            }
        }
    }

    private static LegalReportResultFile writeToFile(LegalReportRequest legalReportRequest, byte[] byArray, String string) {
        return (LegalReportResultFile)((Object)advice$writeToFile.perform((Callable)new XlsExporterLog$callable$writeToFile(legalReportRequest, byArray, string)));
    }

    static /* synthetic */ LegalReportResultFile advised$writeToFile(LegalReportRequest reportRequest, byte[] content, String fileName) {
        return new LegalReportResultFile(reportRequest, LegalReportResultFileType.XLSX, fileName, content);
    }

    protected static String pdiLabel(String key) {
        return LegalPTUtil.bundle("org.fenixedu.academic.domain.student.PrecedentDegreeInformation." + key, new String[0]);
    }

    protected static String pidLabel(String key) {
        return LegalPTUtil.bundle("label.org.fenixedu.academic.domain.student.PersonalIngressionData." + key, new String[0]);
    }

    protected static String schoolLevelLocalizedName(SchoolLevelType schoolLevel) {
        return schoolLevel.getLocalizedName();
    }

    protected static String professionTypeLocalizedName(ProfessionType profession) {
        return profession.getLocalizedName();
    }

    protected static String professionalSituationConditionTypeLocalizedName(ProfessionalSituationConditionType conditionType) {
        return conditionType.getLocalizedName();
    }

    protected static String schoolPeriodDurationLocalizedName(SchoolPeriodDuration duration) {
        return LegalPTUtil.bundle("label.SchoolPeriodDuration." + duration.name(), new String[0]);
    }
}

