/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.legalpt.services.raides.process;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.apache.commons.lang3.StringUtils;
import org.fenixedu.academic.domain.Enrolment;
import org.fenixedu.academic.domain.ExecutionInterval;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.GrantOwnerType;
import org.fenixedu.academic.domain.StudentCurricularPlan;
import org.fenixedu.academic.domain.student.PersonalIngressionData;
import org.fenixedu.academic.domain.student.PrecedentDegreeInformation;
import org.fenixedu.academic.domain.student.Registration;
import org.fenixedu.academic.domain.student.RegistrationServices;
import org.fenixedu.academic.domain.student.Student;
import org.fenixedu.academic.domain.student.services.StatuteServices;
import org.fenixedu.legalpt.domain.LegalReportContext;
import org.fenixedu.legalpt.domain.mapping.LegalMapping;
import org.fenixedu.legalpt.domain.raides.Raides;
import org.fenixedu.legalpt.domain.raides.RaidesInstance;
import org.fenixedu.legalpt.domain.raides.RaidesReportEntryTarget;
import org.fenixedu.legalpt.domain.raides.TblInscrito;
import org.fenixedu.legalpt.domain.raides.mapping.LegalMappingType;
import org.fenixedu.legalpt.domain.raides.report.RaidesRequestParameter;
import org.fenixedu.legalpt.domain.report.LegalReport;
import org.fenixedu.legalpt.services.raides.process.RaidesService;
import org.joda.time.DateTime;
import pt.ist.fenixframework.DomainObject;

public class InscritoService
extends RaidesService {
    private static final BigDecimal MIN_NOTA_INGRESSO = new BigDecimal(95);
    private static final BigDecimal MAX_NOTA_INGRESSO = new BigDecimal(200);

    public InscritoService(LegalReport report) {
        super(report);
    }

    public TblInscrito create(RaidesRequestParameter raidesRequestParameter, ExecutionYear executionYear, Registration registration) {
        RaidesReportEntryTarget target = RaidesReportEntryTarget.of(registration, executionYear);
        TblInscrito bean = new TblInscrito();
        bean.setRegistration(registration);
        this.preencheInformacaoMatricula(this.report, bean, executionYear, registration);
        bean.setAnoCurricular(this.anoCurricular(registration, executionYear, false));
        bean.setPrimeiraVez(LegalMapping.find(this.report, LegalMappingType.BOOLEAN).translate(this.isFirstTimeOnDegree(registration, executionYear)));
        bean.setRegimeFrequencia(this.regimeFrequencia(registration, executionYear, false));
        DateTime maximumAnnulmentDate = this.findMaximumAnnulmentDate(raidesRequestParameter.getPeriodsForEnrolled(), executionYear);
        if (Raides.isDoctoralDegree(registration)) {
            bean.setEctsInscricao(this.doctoralEnrolledEcts(executionYear, registration, maximumAnnulmentDate));
        } else {
            bean.setEctsInscricao(this.enrolledEcts(executionYear, registration, maximumAnnulmentDate, false));
        }
        if (!this.isFirstTimeOnDegree(registration, executionYear)) {
            bean.setEctsAcumulados(this.ectsAcumulados(registration, executionYear));
        }
        bean.setTempoParcial(LegalMapping.find(this.report, LegalMappingType.BOOLEAN).translate(this.isInPartialRegime(executionYear, registration)));
        bean.setBolseiro(this.bolseiro(registration, executionYear));
        if (this.isFirstCycle(registration) && this.isFirstTimeOnDegree(registration, executionYear)) {
            if (registration.getIngressionType() != null) {
                String value = LegalMapping.find(this.report, LegalMappingType.REGISTRATION_INGRESSION_TYPE).translate((DomainObject)registration.getIngressionType());
                if (StringUtils.isBlank((CharSequence)value)) {
                    LegalReportContext.addError(target, this.i18n("error.Raides.validation.ingression.missing.translate", registration.getIngressionType().getLocalizedName()), this.i18n("error.Raides.validation.ingression.missing.translate.action", registration.getIngressionType().getLocalizedName()));
                    bean.markAsInvalid();
                } else {
                    bean.setFormaIngresso(value);
                }
            }
            if (this.isDegreeChangeOrTransfer(raidesRequestParameter, registration)) {
                PrecedentDegreeInformation precedentQualification = registration.getStudentCandidacy().getPreviousDegreeInformation();
                if (precedentQualification != null && precedentQualification.getInstitution() != null) {
                    if (!Strings.isNullOrEmpty((String)precedentQualification.getInstitution().getCode())) {
                        bean.setEstabInscricaoAnt(precedentQualification.getInstitution().getCode());
                    } else {
                        bean.setEstabInscricaoAnt("0000");
                        bean.setOutroEstabInscAnt(precedentQualification.getInstitution().getNameI18n().getContent());
                    }
                }
                bean.setNumInscCursosAnt(precedentQualification.getNumberOfEnrolmentsInPreviousDegrees());
            } else if (this.isGeneralAccessRegime(raidesRequestParameter, registration)) {
                if (registration.getStudentCandidacy().getEntryGrade() != null) {
                    bean.setNotaIngresso(registration.getStudentCandidacy().getEntryGrade().toString());
                }
                if (registration.getStudentCandidacy().getPlacingOption() != null) {
                    bean.setOpcaoIngresso(registration.getStudentCandidacy().getPlacingOption().toString());
                }
            }
        }
        if (!this.isFirstTimeOnDegree(registration, executionYear)) {
            ArrayList enrolmentsExecutionYears = Lists.newArrayList((Iterable)RegistrationServices.getEnrolmentYearsIncludingPrecedentRegistrations((Registration)registration, (ExecutionYear)executionYear.getPreviousExecutionYear()));
            if (enrolmentsExecutionYears.size() >= 1) {
                bean.setAnoUltimaInscricao(((ExecutionYear)Collections.max(enrolmentsExecutionYears, ExecutionYear.COMPARATOR_BY_YEAR)).getQualifiedName());
            }
            bean.setNumInscNesteCurso(this.numberOfYearsEnrolled(executionYear, registration));
        }
        bean.setEstudanteTrabalhador(LegalMapping.find(this.report, LegalMappingType.BOOLEAN).translate(this.isWorkingStudent(registration, executionYear)));
        this.preencheInformacaoPessoal(executionYear, registration, bean);
        this.preencheGrauPrecedentCompleto(bean, executionYear, registration);
        this.validaFormaIngresso(bean, registration, executionYear);
        this.validaRegimeFrequencia(bean, registration, executionYear);
        this.validaInformacaoMudancaCursoTransferencia(raidesRequestParameter, bean, executionYear, registration);
        this.validaInformacaoRegimeGeralAcesso(raidesRequestParameter, bean, executionYear, registration);
        this.validaNumInscricoesNoCurso(raidesRequestParameter, bean, executionYear, registration);
        this.validaEctsInscricao(bean, executionYear, registration);
        return bean;
    }

    private BigDecimal ectsAcumulados(Registration registration, ExecutionYear executionYear) {
        if (((RaidesInstance)((Object)this.report)).isSumEctsCreditsBetweenPlans() && RegistrationServices.canCollectAllPlansForCurriculum((Registration)registration)) {
            LegalReportContext.addWarn(RaidesReportEntryTarget.of(registration, executionYear), this.i18n("warn.Raides.ects.acumulados.sum.of.student.curricular.plans", new String[0]));
            return this.sumEctsAcumulados(registration, executionYear);
        }
        return registration.getStudentCurricularPlan(executionYear).getRoot().getCurriculum(executionYear).getSumEctsCredits().setScale(1);
    }

    private BigDecimal sumEctsAcumulados(Registration registration, ExecutionYear executionYear) {
        return RegistrationServices.getAllPlansCurriculum((Registration)registration, (ExecutionYear)executionYear).getSumEctsCredits().setScale(1);
    }

    private void validaNumInscricoesNoCurso(RaidesRequestParameter raidesRequestParameter, TblInscrito bean, ExecutionYear executionYear, Registration registration) {
        if (!this.isFirstTimeOnDegree(registration, executionYear) && new Integer(0).equals(bean.getNumInscNesteCurso())) {
            LegalReportContext.addError(RaidesReportEntryTarget.of(registration, executionYear), this.i18n("error.Raides.validation.is.not.first.time.student.but.number.previous.enrolments.in.registration.is.zero", new String[0]), this.i18n("error.Raides.validation.is.not.first.time.student.but.number.previous.enrolments.in.registration.is.zero.action", new String[0]));
            bean.markAsInvalid();
        }
    }

    protected void validaInformacaoRegimeGeralAcesso(RaidesRequestParameter raidesRequestParameter, TblInscrito bean, ExecutionYear executionYear, Registration registration) {
        if (!this.isFirstCycle(registration) || !this.isFirstTimeOnDegree(registration, executionYear)) {
            return;
        }
        if (!this.isGeneralAccessRegime(raidesRequestParameter, registration)) {
            return;
        }
        if (Strings.isNullOrEmpty((String)bean.getNotaIngresso()) || Strings.isNullOrEmpty((String)bean.getOpcaoIngresso())) {
            LegalReportContext.addError(RaidesReportEntryTarget.of(registration, executionYear), this.i18n("error.Raides.validation.general.access.regime.incomplete", new String[0]), this.i18n("error.Raides.validation.general.access.regime.incomplete.action", new String[0]));
            bean.markAsInvalid();
            return;
        }
        if (!Strings.isNullOrEmpty((String)bean.getNotaIngresso())) {
            try {
                BigDecimal value = new BigDecimal(bean.getNotaIngresso());
                if (value.compareTo(MIN_NOTA_INGRESSO) < 0 || value.compareTo(MAX_NOTA_INGRESSO) > 0) {
                    LegalReportContext.addError(RaidesReportEntryTarget.of(registration, executionYear), this.i18n("error.Raides.validation.general.access.regime.notaIngresso.in.wrong.interval", new String[0]), this.i18n("error.Raides.validation.general.access.regime.notaIngresso.in.wrong.interval.action", new String[0]));
                    bean.markAsInvalid();
                    return;
                }
            }
            catch (NumberFormatException e) {
                LegalReportContext.addError(RaidesReportEntryTarget.of(registration, executionYear), this.i18n("error.Raides.validation.general.access.regime.notaIngresso.wrong.format", new String[0]), this.i18n("error.Raides.validation.general.access.regime.notaIngresso.wrong.format.action", new String[0]));
                bean.markAsInvalid();
                return;
            }
        }
    }

    protected void validaFormaIngresso(TblInscrito bean, Registration registration, ExecutionYear executionYear) {
        if (this.isFirstCycle(registration) && this.isFirstTimeOnDegree(registration, executionYear) && Strings.isNullOrEmpty((String)bean.getFormaIngresso())) {
            LegalReportContext.addError(RaidesReportEntryTarget.of(registration, executionYear), this.i18n("error.Raides.validation.missing.ingressionType", new String[0]), this.i18n("error.Raides.validation.missing.ingressionType.action", new String[0]));
            bean.markAsInvalid();
        }
    }

    protected void validaRegimeFrequencia(TblInscrito bean, Registration registration, ExecutionYear executionYear) {
        if (Strings.isNullOrEmpty((String)bean.getRegimeFrequencia())) {
            LegalReportContext.addError(RaidesReportEntryTarget.of(registration, executionYear), this.i18n("error.Raides.validation.missing.mapping.for.regime.frequence", new String[0]), this.i18n("error.Raides.validation.missing.mapping.for.regime.frequence.action", new String[0]));
            bean.markAsInvalid();
        }
    }

    protected void validaInformacaoMudancaCursoTransferencia(RaidesRequestParameter raidesRequestParameter, TblInscrito bean, ExecutionYear executionYear, Registration registration) {
        if (!this.isFirstCycle(registration) || !this.isFirstTimeOnDegree(registration, executionYear)) {
            return;
        }
        if (!this.isDegreeChangeOrTransfer(raidesRequestParameter, registration)) {
            return;
        }
        if (Strings.isNullOrEmpty((String)bean.getEstabInscricaoAnt())) {
            LegalReportContext.addError(RaidesReportEntryTarget.of(registration, executionYear), this.i18n("error.Raides.validation.degree.change.or.transfer.requires.information", new String[0]), this.i18n("error.Raides.validation.degree.change.or.transfer.requires.information.action", new String[0]));
            bean.markAsInvalid();
        } else if ("0000".equals(bean.getEstabInscricaoAnt()) && Strings.isNullOrEmpty((String)bean.getOutroEstabInscAnt())) {
            LegalReportContext.addError(RaidesReportEntryTarget.of(registration, executionYear), this.i18n("error.Raides.validation.degree.change.or.transfer.requires.other.information", new String[0]), this.i18n("error.Raides.validation.degree.change.or.transfer.requires.other.information.action", new String[0]));
            bean.markAsInvalid();
        }
        if (bean.getNumInscCursosAnt() == null) {
            LegalReportContext.addError(RaidesReportEntryTarget.of(registration, executionYear), this.i18n("error.Raides.validation.degree.change.or.transfer.requires.information", new String[0]), this.i18n("error.Raides.validation.degree.change.or.transfer.requires.information.action", new String[0]));
            bean.markAsInvalid();
        }
    }

    private void validaEctsInscricao(TblInscrito bean, ExecutionYear executionYear, Registration registration) {
        if (bean.getEctsInscricao().compareTo(BigDecimal.ZERO) == 0) {
            LegalReportContext.addError(RaidesReportEntryTarget.of(registration, executionYear), this.i18n("error.Raides.validation.enroled.ects.cannot.be.zero", new String[0]), this.i18n("error.Raides.validation.enroled.ects.cannot.be.zero.action", new String[0]));
            bean.markAsInvalid();
        }
    }

    protected boolean isFirstCycle(Registration registration) {
        return registration.getDegreeType().isFirstCycle();
    }

    protected String bolseiro(Registration registration, ExecutionYear executionYear) {
        PersonalIngressionData pid = registration.getStudent().getPersonalIngressionDataByExecutionYear(executionYear);
        if (pid == null || pid.getGrantOwnerType() == null || pid.getGrantOwnerType() == GrantOwnerType.STUDENT_WITHOUT_SCHOLARSHIP) {
            return LegalMapping.find(this.report, LegalMappingType.GRANT_OWNER_TYPE).translate((Enum<?>)Raides.Bolseiro.NAO_BOLSEIRO);
        }
        if (!this.hasOtherActiveRegistrationWhichRequiresStatuteToReportGrantOwner(registration, executionYear)) {
            return LegalMapping.find(this.report, LegalMappingType.GRANT_OWNER_TYPE).translate((Enum<?>)pid.getGrantOwnerType());
        }
        if (!this.hasGrantOwnerStatuteInAnyRegistration(registration.getStudent(), executionYear)) {
            LegalReportContext.addError(RaidesReportEntryTarget.of(registration, executionYear), this.i18n("error.Raides.grantOwner.requires.statute", new String[0]), this.i18n("error.Raides.grantOwner.requires.statute.action", new String[0]));
            return LegalMapping.find(this.report, LegalMappingType.GRANT_OWNER_TYPE).translate((Enum<?>)Raides.Bolseiro.NAO_BOLSEIRO);
        }
        if (this.hasGrantOwnerStatute(registration, executionYear)) {
            return LegalMapping.find(this.report, LegalMappingType.GRANT_OWNER_TYPE).translate((Enum<?>)pid.getGrantOwnerType());
        }
        return LegalMapping.find(this.report, LegalMappingType.GRANT_OWNER_TYPE).translate((Enum<?>)Raides.Bolseiro.NAO_BOLSEIRO);
    }

    private boolean hasOtherActiveRegistrationWhichRequiresStatuteToReportGrantOwner(Registration registration, ExecutionYear executionYear) {
        return registration.getStudent().getRegistrationsSet().stream().anyMatch(r -> r != registration && RegistrationServices.getEnrolmentYears((Registration)r).contains(executionYear));
    }

    private boolean hasGrantOwnerStatute(Registration registration, ExecutionYear executionYear) {
        return registration.getStudentStatutesSet().stream().anyMatch(s -> s.isValidOn(executionYear) && RaidesInstance.getInstance().getGrantOwnerStatuteTypesSet().contains(s.getType()));
    }

    private boolean hasGrantOwnerStatuteInAnyRegistration(Student student, ExecutionYear executionYear) {
        return student.getRegistrationsSet().stream().anyMatch(r -> this.hasGrantOwnerStatute((Registration)r, executionYear));
    }

    protected boolean isWorkingStudent(Registration registration, ExecutionYear executionYear) {
        return StatuteServices.findStatuteTypes((Registration)registration, (ExecutionInterval)executionYear).stream().anyMatch(s -> s.isWorkingStudentStatute());
    }

    protected boolean isInPartialRegime(ExecutionYear executionYear, Registration registration) {
        return registration.isPartialRegime(executionYear);
    }

    private boolean isGeneralAccessRegime(RaidesRequestParameter raidesRequestParameter, Registration registration) {
        return Raides.isGeneralAccessRegime(raidesRequestParameter, registration.getIngressionType());
    }

    protected boolean isDegreeChangeOrTransfer(RaidesRequestParameter raidesRequestParameter, Registration registration) {
        return Raides.isDegreeChange(raidesRequestParameter, registration.getIngressionType()) || Raides.isDegreeTransfer(raidesRequestParameter, registration.getIngressionType());
    }

    protected Integer numberOfYearsEnrolled(ExecutionYear executionYear, Registration registration) {
        return RegistrationServices.getEnrolmentYearsIncludingPrecedentRegistrations((Registration)registration, (ExecutionYear)executionYear.getPreviousExecutionYear()).size();
    }

    protected boolean deliveredDissertation(ExecutionYear executionYear, Registration registration) {
        StudentCurricularPlan studentCurricularPlan = registration.getStudentCurricularPlan(executionYear);
        Collection dissertationEnrolments = studentCurricularPlan.getDissertationEnrolments();
        for (Enrolment enrolment : dissertationEnrolments) {
            if (!enrolment.isValid(executionYear) || !enrolment.isApproved()) continue;
            return true;
        }
        return false;
    }
}

