/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.ulisboa.integration.sas.service.transform;

import java.io.IOException;
import java.util.ArrayList;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.fenixedu.ulisboa.integration.sas.dto.ScholarshipStudentFirstYearBean;
import org.fenixedu.ulisboa.integration.sas.service.transform.AbstractScholarshipXlsTransformService;
import org.fenixedu.ulisboa.integration.sas.util.SASDomainException;

public class FirstYearScholarshipXlsTransformService
extends AbstractScholarshipXlsTransformService {
    static Integer FIRST_VALUE_ROW = 1;

    @Override
    public boolean checkExcelFormat(HSSFSheet sheet) throws IOException {
        int columnsExpected;
        int columnsRead = Integer.valueOf(String.valueOf(sheet.getRow(0).getLastCellNum()));
        if (columnsRead == (columnsExpected = ScholarshipStudentFirstYearBean.INGRESSION_REGIME + 1)) {
            return true;
        }
        throw new SASDomainException("error.fileFormatDoesNotMatchRequest.expected", new String[]{String.valueOf(columnsExpected), String.valueOf(columnsRead)});
    }

    @Override
    public void readStudentLines(HSSFSheet sheet) {
        HSSFRow row;
        int i = FIRST_VALUE_ROW;
        while ((row = sheet.getRow(i)) != null && row.getCell(0) != null) {
            ScholarshipStudentFirstYearBean scholarshipStudentBean = new ScholarshipStudentFirstYearBean();
            this.readSpreadsheetRow(row, scholarshipStudentBean);
            this.studentLines.add(scholarshipStudentBean);
            ++i;
        }
    }

    private void readSpreadsheetRow(HSSFRow row, ScholarshipStudentFirstYearBean bean) {
        bean.setInstitutionCode(this.getValueFromColumnMayBeNull(row, ScholarshipStudentFirstYearBean.INSTITUTION_CODE));
        bean.setInstitutionName(this.getValueFromColumnMayBeNull(row, ScholarshipStudentFirstYearBean.INSTITUTION_NAME));
        bean.setCandidacyNumber(this.getValueFromColumnMayBeNull(row, ScholarshipStudentFirstYearBean.CANDIDACY_NUMBER));
        try {
            bean.setStudentNumber(Integer.parseInt(this.getValueFromColumnMayBeNull(row, ScholarshipStudentFirstYearBean.STUDENT_NUMBER)));
        }
        catch (NumberFormatException e) {
            bean.setStudentNumber(null);
        }
        bean.setStudentName(this.getValueFromColumnMayBeNull(row, ScholarshipStudentFirstYearBean.STUDENT_NAME));
        bean.setDocumentTypeName(this.getValueFromColumnMayBeNull(row, ScholarshipStudentFirstYearBean.DOCUMENT_TYPE_NAME));
        bean.setDocumentNumber(this.getValueFromColumnMayBeNull(row, ScholarshipStudentFirstYearBean.DOCUMENT_NUMBER));
        bean.setDegreeCode(this.getValueFromColumnMayBeNull(row, ScholarshipStudentFirstYearBean.DEGREE_CODE));
        bean.setDegreeName(this.getValueFromColumnMayBeNull(row, ScholarshipStudentFirstYearBean.DEGREE_NAME));
        bean.setDegreeTypeName(this.getValueFromColumnMayBeNull(row, ScholarshipStudentFirstYearBean.DEGREE_TYPE_NAME));
        bean.setCode(this.getValueFromColumnMayBeNull(row, ScholarshipStudentFirstYearBean.CODE));
        bean.setFiscalCode(this.getValueFromColumnMayBeNull(row, ScholarshipStudentFirstYearBean.FISCAL_CODE));
        bean.setDocumentBINumber(this.getValueFromColumnMayBeNull(row, ScholarshipStudentFirstYearBean.DOCUMENT_BI));
    }

    @Override
    public void writeExcelLines(HSSFSheet sheet) throws IOException {
        for (int i = 0; i < this.studentLines.size(); ++i) {
            ScholarshipStudentFirstYearBean scholarshipStudentBean = (ScholarshipStudentFirstYearBean)this.studentLines.get(i);
            HSSFRow row = sheet.getRow(FIRST_VALUE_ROW + i);
            this.writeSpreadsheetRow(row, scholarshipStudentBean);
        }
    }

    private void writeSpreadsheetRow(HSSFRow row, ScholarshipStudentFirstYearBean bean) {
        this.writeCellString(row, ScholarshipStudentFirstYearBean.INSTITUTION_CODE, bean.getInstitutionCode());
        this.writeCellInteger(row, ScholarshipStudentFirstYearBean.STUDENT_NUMBER, bean.getStudentNumber());
        this.writeCellString(row, ScholarshipStudentFirstYearBean.DEGREE_CODE, bean.getDegreeCode());
        this.writeCellString(row, ScholarshipStudentFirstYearBean.REGISTERED, this.booleanToString(bean.getEnroled()));
        this.writeCellLocalDate(row, ScholarshipStudentFirstYearBean.REGISTRATION_DATE, bean.getEnroled() != false ? bean.getEnrolmentDate() : null);
        this.writeCellBigDecimal(row, ScholarshipStudentFirstYearBean.GRATUITY, bean.getEnroled() != false ? bean.getGratuityAmount() : null);
        this.writeCellInteger(row, ScholarshipStudentFirstYearBean.NUMBER_OF_MONTHS_EXECUTION_YEAR, bean.getEnroled() != false ? bean.getNumberOfMonthsExecutionYear() : null);
        this.writeCellString(row, ScholarshipStudentFirstYearBean.FIRST_MONTH_EXECUTION_YEAR, bean.getEnroled() != false ? this.toMonthString(bean.getFirstMonthExecutionYear()) : null);
        this.writeCellString(row, ScholarshipStudentFirstYearBean.OWNER_CET, bean.getEnroled() != false ? this.booleanToString(bean.getCetQualificationOwner()) : null);
        this.writeCellString(row, ScholarshipStudentFirstYearBean.OWNER_CTSP, bean.getEnroled() != false ? this.booleanToString(bean.getCtspQualificationOwner()) : null);
        this.writeCellString(row, ScholarshipStudentFirstYearBean.OWNER_BACHELOR, bean.getEnroled() != false ? this.booleanToString(bean.getDegreeQualificationOwner()) : null);
        this.writeCellString(row, ScholarshipStudentFirstYearBean.OWNER_MASTER, bean.getEnroled() != false ? this.booleanToString(bean.getMasterQualificationOwner()) : null);
        this.writeCellString(row, ScholarshipStudentFirstYearBean.OWNER_PHD, bean.getEnroled() != false ? this.booleanToString(bean.getPhdQualificationOwner()) : null);
        this.writeCellString(row, ScholarshipStudentFirstYearBean.OBSERVATIONS, bean.getObservations() != null ? bean.getObservations() : null);
        this.writeCellString(row, ScholarshipStudentFirstYearBean.REGIME, bean.getEnroled() != false ? bean.getRegime() : null);
        this.writeCellInteger(row, ScholarshipStudentFirstYearBean.NUMBER_OF_YEARS_DEGREE, bean.getEnroled() != false ? bean.getNumberOfDegreeCurricularYears() : null);
        this.writeCellInteger(row, ScholarshipStudentFirstYearBean.NUMBER_OF_REGISTRATIONS_SINCE_REGISTRATION_START, bean.getEnroled() != false ? bean.getCycleNumberOfEnrolmentsYears() : null);
        this.writeCellBigDecimal(row, ScholarshipStudentFirstYearBean.NUMBER_OF_ECTS, bean.getEnroled() != false ? bean.getNumberOfEnrolledECTS() : null);
        this.writeCellString(row, ScholarshipStudentFirstYearBean.INGRESSION_REGIME, bean.getIngressionRegimeCodeWithDescription());
    }

    public FirstYearScholarshipXlsTransformService(POIFSFileSystem poifsFileSystem) {
        this.studentLines = new ArrayList();
        this.poifsFileSystem = poifsFileSystem;
    }
}

