/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.legalpt.domain.raides;

import com.google.common.base.Function;
import com.google.common.base.Strings;
import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.commons.lang.math.NumberUtils;
import org.fenixedu.academic.domain.Country;
import org.fenixedu.academic.domain.Degree;
import org.fenixedu.academic.domain.District;
import org.fenixedu.academic.domain.DistrictSubdivision;
import org.fenixedu.academic.domain.Enrolment;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.GrantOwnerType;
import org.fenixedu.academic.domain.StudentCurricularPlan;
import org.fenixedu.academic.domain.candidacy.IngressionType;
import org.fenixedu.academic.domain.student.PersonalIngressionData;
import org.fenixedu.academic.domain.student.Registration;
import org.fenixedu.academic.domain.student.RegistrationDataByExecutionYear;
import org.fenixedu.academic.domain.student.RegistrationProtocol;
import org.fenixedu.academic.domain.student.Student;
import org.fenixedu.academic.domain.student.curriculum.conclusion.RegistrationConclusionInformation;
import org.fenixedu.academic.domain.student.curriculum.conclusion.RegistrationConclusionServices;
import org.fenixedu.academic.domain.student.registrationStates.RegistrationState;
import org.fenixedu.academic.domain.studentCurriculum.CurriculumLine;
import org.fenixedu.bennu.core.domain.Bennu;
import org.fenixedu.bennu.core.domain.exceptions.DomainException;
import org.fenixedu.bennu.core.i18n.BundleUtil;
import org.fenixedu.commons.i18n.I18N;
import org.fenixedu.commons.i18n.LocalizedString;
import org.fenixedu.legalpt.domain.LegalReportContext;
import org.fenixedu.legalpt.domain.mapping.LegalMapping;
import org.fenixedu.legalpt.domain.raides.IRaidesReportRequestDefaultData;
import org.fenixedu.legalpt.domain.raides.RaidesData;
import org.fenixedu.legalpt.domain.raides.RaidesInstance;
import org.fenixedu.legalpt.domain.raides.RaidesReportEntryTarget;
import org.fenixedu.legalpt.domain.raides.RaidesReportRequestDefaultData;
import org.fenixedu.legalpt.domain.raides.TblDiplomado;
import org.fenixedu.legalpt.domain.raides.TblIdentificacao;
import org.fenixedu.legalpt.domain.raides.TblInscrito;
import org.fenixedu.legalpt.domain.raides.TblMobilidadeInternacional;
import org.fenixedu.legalpt.domain.raides.mapping.LegalMappingType;
import org.fenixedu.legalpt.domain.raides.report.RaidesRequestParameter;
import org.fenixedu.legalpt.domain.raides.report.RaidesRequestPeriodParameter;
import org.fenixedu.legalpt.domain.report.LegalReport;
import org.fenixedu.legalpt.domain.report.LegalReportRequest;
import org.fenixedu.legalpt.domain.report.LegalReportResultFile;
import org.fenixedu.legalpt.services.commons.export.XmlZipFileWriter;
import org.fenixedu.legalpt.services.raides.export.XlsxExporter;
import org.fenixedu.legalpt.services.raides.export.XmlToBaseFileWriter;
import org.fenixedu.legalpt.services.raides.process.DiplomadoService;
import org.fenixedu.legalpt.services.raides.process.IdentificacaoService;
import org.fenixedu.legalpt.services.raides.process.InscritoService;
import org.fenixedu.legalpt.services.raides.process.MobilidadeInternacionalService;
import org.fenixedu.legalpt.services.report.log.XlsExporterLog;
import org.fenixedu.legalpt.util.LegalPTUtil;
import org.joda.time.DateTime;
import org.joda.time.Interval;
import org.joda.time.LocalDate;
import org.joda.time.ReadableInstant;
import pt.ist.fenixframework.FenixFramework;

public class Raides {
    public static final String DATE_FORMAT = "dd-MM-yyyy";
    protected Map<Student, TblIdentificacao> alunos = new LinkedHashMap<Student, TblIdentificacao>();
    protected Multimap<Student, TblInscrito> inscritos = LinkedListMultimap.create();
    protected Multimap<Student, TblDiplomado> diplomados = LinkedListMultimap.create();
    protected Multimap<Student, TblMobilidadeInternacional> mobilidadeInternacional = LinkedListMultimap.create();
    public Set<Registration> registrationList = new HashSet<Registration>();
    protected static IRaidesReportRequestDefaultData requestDefaultData;

    public void process(RaidesInstance raidesInstance, LegalReportRequest reportRequest) {
        RaidesRequestParameter raidesRequestParameter = reportRequest.getParametersAs(RaidesRequestParameter.class);
        this.processEnrolled(reportRequest.getLegalReport(), raidesRequestParameter);
        this.processGraduated(reportRequest.getLegalReport(), raidesRequestParameter);
        this.processMobilidadeInternacional(reportRequest.getLegalReport(), raidesRequestParameter);
        XlsxExporter.write(reportRequest, this);
        LegalReportResultFile xml = XmlToBaseFileWriter.write(reportRequest, raidesRequestParameter, this);
        XlsExporterLog.write(reportRequest, LegalReportContext.getReport());
        XmlZipFileWriter.write(reportRequest, xml, ((RaidesInstance)((Object)reportRequest.getLegalReport())).getPasswordToZip());
        reportRequest.markAsProcessed();
    }

    public void processMobilidadeInternacional(LegalReport report, RaidesRequestParameter raidesRequestParameter) {
        for (RaidesRequestPeriodParameter enroledPeriod : raidesRequestParameter.getPeriodsForInternationalMobility()) {
            ExecutionYear academicPeriod = enroledPeriod.getAcademicPeriod();
            for (Degree degree : raidesRequestParameter.getDegrees()) {
                for (Registration registration : degree.getRegistrationsSet()) {
                    if (!this.matchesStudent(raidesRequestParameter, registration)) continue;
                    try {
                        if (!this.isAcceptedDegreeType(enroledPeriod, registration) || !Raides.isAgreementPartOfMobilityReport(raidesRequestParameter, registration) || enroledPeriod.isEnrolledInAcademicPeriod() && !this.isEnrolledInExecutionYear(enroledPeriod, registration, false) || !this.hadEnrolmentsInPeriod(enroledPeriod.getInterval(), enroledPeriod.getAcademicPeriod(), registration, raidesRequestParameter) || !this.isInEnrolledEctsLimit(enroledPeriod, registration, academicPeriod) || !this.isInEnrolledYearsLimit(enroledPeriod, registration, academicPeriod) || !this.isActiveAtPeriod(enroledPeriod, registration, academicPeriod)) continue;
                        if (!this.containsStudentIdentification(registration.getStudent())) {
                            this.addStudent(report, registration.getStudent(), registration, academicPeriod);
                        }
                        this.addMobilidadeInternacional(report, raidesRequestParameter, academicPeriod, registration);
                    }
                    catch (DomainException e) {
                        LegalReportContext.addError(RaidesReportEntryTarget.empty(), Raides.i18n("error.Raides.unexpected.error.occured", e.getLocalizedMessage()));
                    }
                    catch (Throwable e) {
                        LegalReportContext.addError(RaidesReportEntryTarget.empty(), Raides.i18n("error.Raides.unexpected.error.occured", ExceptionUtils.getFullStackTrace((Throwable)e)));
                    }
                }
            }
        }
    }

    public void processGraduated(LegalReport report, RaidesRequestParameter raidesRequestParameter) {
        for (RaidesRequestPeriodParameter graduatedPeriod : raidesRequestParameter.getPeriodsForGraduated()) {
            ExecutionYear executionYear = graduatedPeriod.getAcademicPeriod();
            for (Degree degree : raidesRequestParameter.getDegrees()) {
                for (Registration registration : degree.getRegistrationsSet()) {
                    if (!this.matchesStudent(raidesRequestParameter, registration)) continue;
                    try {
                        if (!this.isAcceptedDegreeType(graduatedPeriod, registration) || !this.isAgreementPartOfEnrolledReport(raidesRequestParameter, registration) || graduatedPeriod.isEnrolledInAcademicPeriod() && !this.isEnrolledInExecutionYear(graduatedPeriod, registration, true) || !graduatedPeriod.isEnrolledInAcademicPeriod() && this.isEnrolledInExecutionYear(graduatedPeriod, registration, true) || !this.hasConcludedInPeriodAndAcademicPeriod(graduatedPeriod, registration) || !this.isInEnrolledEctsLimit(graduatedPeriod, registration, executionYear) || !this.isInEnrolledYearsLimit(graduatedPeriod, registration, executionYear)) continue;
                        if (!this.containsStudentIdentification(registration.getStudent())) {
                            this.addStudent(report, registration.getStudent(), registration, executionYear);
                        }
                        this.addGraduated(report, raidesRequestParameter, graduatedPeriod, executionYear, registration);
                    }
                    catch (Throwable e) {
                        LegalReportContext.addError(RaidesReportEntryTarget.of(registration, executionYear), Raides.i18n("error.Raides.unexpected.error.occured", ExceptionUtils.getFullStackTrace((Throwable)e)));
                    }
                }
            }
        }
        this.mergeSchoolPartWithGraduationLines(report, raidesRequestParameter);
    }

    private void mergeSchoolPartWithGraduationLines(LegalReport report, RaidesRequestParameter raidesRequestParameter) {
        if (raidesRequestParameter.getGraduatedExecutionYear() == null) {
            return;
        }
        HashMap<Student, TblDiplomado> toRemove = new HashMap<Student, TblDiplomado>();
        for (Map.Entry entry : this.diplomados.entries()) {
            TblDiplomado otherLine;
            TblDiplomado diplomado = (TblDiplomado)entry.getValue();
            if (diplomado.getConclusaoMd() == null || diplomado.getConclusaoMd().equals(LegalMapping.find(report, LegalMappingType.BOOLEAN).translate(false)) || (otherLine = (TblDiplomado)this.diplomados.values().stream().filter(d -> d != diplomado && d.getIdAluno().equals(diplomado.getIdAluno()) && d.getCurso().equals(diplomado.getCurso()) && d.getAnoLectivo().equals(diplomado.getAnoLectivo()) && d.getConcluiGrau().equals(LegalMapping.find(report, LegalMappingType.BOOLEAN).translate(true))).findFirst().orElse(null)) == null) continue;
            otherLine.setConclusaoMd(diplomado.getConclusaoMd());
            otherLine.setClassificacaoFinalMd(diplomado.getClassificacaoFinalMd());
            toRemove.put((Student)entry.getKey(), diplomado);
        }
        toRemove.entrySet().forEach(line -> this.diplomados.remove(line.getKey(), line.getValue()));
    }

    protected boolean isInEnrolledEctsLimit(RaidesRequestPeriodParameter enroledPeriod, Registration registration, ExecutionYear executionYear) {
        if (!enroledPeriod.isEnrolmentEctsConstraint()) {
            return true;
        }
        BigDecimal ectsEnrolled = registration.getEnrolments(executionYear).stream().filter(e -> !Raides.isEnrolmentAnnuled(e, enroledPeriod.getInterval().getEnd())).map(e -> e.getEctsCreditsForCurriculum()).collect(Collectors.reducing(BigDecimal.ZERO, BigDecimal::add));
        if (enroledPeriod.getMinEnrolmentEcts() != null && ectsEnrolled.compareTo(enroledPeriod.getMinEnrolmentEcts()) < 0) {
            return false;
        }
        return enroledPeriod.getMaxEnrolmentEcts() == null || ectsEnrolled.compareTo(enroledPeriod.getMaxEnrolmentEcts()) <= 0;
    }

    protected boolean isInEnrolledYearsLimit(RaidesRequestPeriodParameter enroledPeriod, Registration registration, ExecutionYear academicPeriod) {
        if (!enroledPeriod.isEnrolmentYearsConstraint()) {
            return true;
        }
        int enrolledYears = registration.getEnrolmentsExecutionYears().size();
        if (enroledPeriod.getMinEnrolmentYears() != null && enroledPeriod.getMinEnrolmentYears().compareTo(enrolledYears) > 0) {
            return false;
        }
        return enroledPeriod.getMaxEnrolmentYears() == null || enroledPeriod.getMaxEnrolmentYears().compareTo(enrolledYears) >= 0;
    }

    protected boolean hasConcludedInPeriodAndAcademicPeriod(RaidesRequestPeriodParameter period, Registration registration) {
        Interval interval = period.getInterval();
        ExecutionYear executionYear = period.getAcademicPeriod();
        Set informationConclusionSet = RegistrationConclusionServices.inferConclusion((Registration)registration);
        for (RegistrationConclusionInformation rci : informationConclusionSet) {
            if (!RaidesInstance.getInstance().isReportGraduatedWithoutConclusionProcess() && !rci.getRegistrationConclusionBean().isConclusionProcessed() || rci.getConclusionYear() != executionYear || !interval.contains((ReadableInstant)rci.getConclusionDate().toDateTimeAtStartOfDay())) continue;
            return true;
        }
        return false;
    }

    public void processEnrolled(LegalReport report, RaidesRequestParameter raidesRequestParameter) {
        for (RaidesRequestPeriodParameter enroledPeriod : raidesRequestParameter.getPeriodsForEnrolled()) {
            ExecutionYear executionYear = enroledPeriod.getAcademicPeriod();
            for (Degree degree : raidesRequestParameter.getDegrees()) {
                for (Registration registration : degree.getRegistrationsSet()) {
                    if (!this.matchesStudent(raidesRequestParameter, registration)) continue;
                    try {
                        if (!this.isAcceptedDegreeType(enroledPeriod, registration) || !this.isAgreementPartOfEnrolledReport(raidesRequestParameter, registration) || enroledPeriod.isEnrolledInAcademicPeriod() && !this.isEnrolledInExecutionYear(enroledPeriod, registration, false) || !this.hadEnrolmentsInPeriod(enroledPeriod.getInterval(), enroledPeriod.getAcademicPeriod(), registration, raidesRequestParameter) || !this.isInEnrolledEctsLimit(enroledPeriod, registration, executionYear) || !this.isInEnrolledYearsLimit(enroledPeriod, registration, executionYear) || !this.isActiveAtPeriod(enroledPeriod, registration, executionYear)) continue;
                        if (this.isTerminalConcluded(registration, raidesRequestParameter)) {
                            LegalReportContext.addWarn(RaidesReportEntryTarget.of(registration, executionYear), Raides.i18n("warn.Raides.skiping.enroled.because.is.already.declared.as.terminal.concluded", new String[0]));
                            continue;
                        }
                        if (!this.containsStudentIdentification(registration.getStudent())) {
                            this.addStudent(report, registration.getStudent(), registration, executionYear);
                        }
                        this.addEnrolledStudent(report, raidesRequestParameter, executionYear, registration);
                    }
                    catch (DomainException e) {
                        LegalReportContext.addError(RaidesReportEntryTarget.of(registration, executionYear), Raides.i18n("error.Raides.unexpected.error.occured", e.getLocalizedMessage()));
                    }
                    catch (Throwable e) {
                        LegalReportContext.addError(RaidesReportEntryTarget.of(registration, executionYear), Raides.i18n("error.Raides.unexpected.error.occured", ExceptionUtils.getFullStackTrace((Throwable)e)));
                    }
                }
            }
        }
    }

    private boolean isAcceptedDegreeType(RaidesRequestPeriodParameter parameter, Registration registration) {
        return parameter.getDegreeTypes().isEmpty() || parameter.getDegreeTypes().contains(registration.getDegreeType());
    }

    private boolean isTerminalConcluded(Registration registration, RaidesRequestParameter raidesRequestParameter) {
        return raidesRequestParameter.getPeriodsForGraduated().stream().anyMatch(p -> DiplomadoService.isTerminalConcluded(registration, p, p.getAcademicPeriod()));
    }

    protected boolean matchesStudent(RaidesRequestParameter raidesRequestParameter, Registration registration) {
        return !NumberUtils.isNumber((String)raidesRequestParameter.getStudentNumber()) || registration.getStudent().getNumber().intValue() == Integer.valueOf(raidesRequestParameter.getStudentNumber()).intValue();
    }

    protected boolean isActiveAtPeriod(RaidesRequestPeriodParameter enroledPeriod, Registration registration, ExecutionYear academicPeriod) {
        RegistrationState stateInDate = registration.getStateInDate(enroledPeriod.getEnd());
        return stateInDate != null && (stateInDate.isActive() || stateInDate.getType().isConcluded());
    }

    protected boolean isEnrolled(Registration registration, RaidesRequestPeriodParameter enroledPeriod) {
        ExecutionYear academicPeriod = enroledPeriod.getAcademicPeriod();
        Interval interval = enroledPeriod.getInterval();
        Collection enrolments = registration.getEnrolments(academicPeriod);
        for (Enrolment enrolment : enrolments) {
            if (Raides.isEnrolmentAnnuled(enrolment, interval.getEnd())) continue;
            return true;
        }
        return false;
    }

    public static boolean isEnrolmentAnnuled(Enrolment enrolment, DateTime annulmentEndDate) {
        if (enrolment.isAnnulled() && enrolment.getAnnulmentDate() != null) {
            return !enrolment.getAnnulmentDate().isAfter((ReadableInstant)annulmentEndDate);
        }
        return enrolment.isAnnulled();
    }

    protected boolean hadEnrolmentsInPeriod(Interval interval, ExecutionYear executionYear, Registration registration, RaidesRequestParameter raidesRequestParameter) {
        LocalDate enrolmentDate = Raides.getEnrolmentDate(registration, executionYear);
        if (enrolmentDate == null || !interval.contains((ReadableInstant)enrolmentDate.toDateTimeAtStartOfDay())) {
            return false;
        }
        Collection<CurriculumLine> allCurriculumLines = Raides.getAllCurriculumLines(registration);
        for (CurriculumLine curriculumLine : allCurriculumLines) {
            Enrolment enrolment;
            if (curriculumLine.getExecutionYear() != executionYear || !curriculumLine.isEnrolment() || (enrolment = (Enrolment)curriculumLine).isExtraCurricular() || Raides.isEnrolmentAnnuled(enrolment, interval.getEnd())) continue;
            return true;
        }
        return false;
    }

    protected void addEnrolledStudent(LegalReport report, RaidesRequestParameter raidesRequestParameter, ExecutionYear executionYear, Registration registration) {
        TblInscrito tblInscrito = new InscritoService(report).create(raidesRequestParameter, executionYear, registration);
        this.inscritos.put((Object)registration.getStudent(), (Object)tblInscrito);
        this.registrationList.add(registration);
    }

    protected void addGraduated(LegalReport report, RaidesRequestParameter raidesRequestParameter, RaidesRequestPeriodParameter graduatedPeriod, ExecutionYear executionYear, Registration registration) {
        DiplomadoService diplomadoService = new DiplomadoService(report);
        if (diplomadoService.isToReportNormal(graduatedPeriod, executionYear, registration)) {
            this.diplomados.put((Object)registration.getStudent(), (Object)diplomadoService.createNormal(raidesRequestParameter, graduatedPeriod, executionYear, registration));
            this.registrationList.add(registration);
        }
        if (diplomadoService.isToReportIntegratedCycleFirstCycle(graduatedPeriod, executionYear, registration)) {
            this.diplomados.put((Object)registration.getStudent(), (Object)diplomadoService.createIntegratedCycleFirstCyle(raidesRequestParameter, graduatedPeriod, executionYear, registration));
            this.registrationList.add(registration);
        }
    }

    protected void addMobilidadeInternacional(LegalReport report, RaidesRequestParameter raidesRequestParameter, ExecutionYear executionYear, Registration registration) {
        TblMobilidadeInternacional mobilidadeInternacional = new MobilidadeInternacionalService(report).create(raidesRequestParameter, executionYear, registration);
        this.mobilidadeInternacional.put((Object)registration.getStudent(), (Object)mobilidadeInternacional);
        this.registrationList.add(registration);
    }

    protected TblIdentificacao addStudent(LegalReport report, Student student, Registration registration, ExecutionYear executionYear) {
        TblIdentificacao aluno = new IdentificacaoService(report).create(student, registration, executionYear);
        this.alunos.put(student, aluno);
        return aluno;
    }

    protected boolean containsStudentIdentification(Student student) {
        return this.alunos.containsKey(student);
    }

    public static boolean isAgreementPartOfMobilityReport(RaidesRequestParameter raidesRequestParameter, Registration registration) {
        return raidesRequestParameter.getAgreementsForMobility().contains(registration.getRegistrationProtocol());
    }

    protected boolean isAgreementPartOfEnrolledReport(RaidesRequestParameter raidesRequestParameter, Registration registration) {
        return raidesRequestParameter.getAgreementsForEnrolled().contains(registration.getRegistrationProtocol());
    }

    protected boolean isEnrolledInExecutionYear(RaidesRequestPeriodParameter period, Registration registration, boolean lookupAtRegistrationDataByExecutionYear) {
        ExecutionYear executionYear = period.getAcademicPeriod();
        Set executionYearsSet = this.filterAnnulledEnrolments(this.filterExtraCurricularCourses(registration.getEnrolments(executionYear)), period.getInterval()).stream().map(r -> r.getExecutionYear()).collect(Collectors.toSet());
        if (!lookupAtRegistrationDataByExecutionYear) {
            return !executionYearsSet.isEmpty();
        }
        if (!executionYearsSet.isEmpty()) {
            return true;
        }
        RegistrationDataByExecutionYear registrationData = Raides.getRegistrationDataByExecutionYear(registration, executionYear);
        return registrationData != null && registrationData.getEnrolmentDate() != null;
    }

    protected Collection<Enrolment> filterExtraCurricularCourses(Collection<Enrolment> enrolments) {
        HashSet result = Sets.newHashSet();
        for (Enrolment enrolment : enrolments) {
            if (enrolment.isExtraCurricular()) continue;
            result.add(enrolment);
        }
        return result;
    }

    protected Collection<Enrolment> filterAnnulledEnrolments(Collection<Enrolment> enrolments, Interval periodInterval) {
        HashSet result = Sets.newHashSet();
        for (Enrolment enrolment : enrolments) {
            if (Raides.isEnrolmentAnnuled(enrolment, periodInterval.getEnd())) continue;
            result.add(enrolment);
        }
        return result;
    }

    protected boolean hadEnrolmentsInPeriod(LocalDate begin, LocalDate end, Registration registration) {
        return false;
    }

    public static boolean isDegreeChange(RaidesRequestParameter raidesRequestParameter, IngressionType registrationIngression) {
        return raidesRequestParameter.getIngressionsForDegreeChange().contains(registrationIngression);
    }

    public static boolean isDegreeTransfer(RaidesRequestParameter raidesRequestParameter, IngressionType registrationIngression) {
        return raidesRequestParameter.getIngressionsForDegreeTransfer().contains(registrationIngression);
    }

    public static boolean isGeneralAccessRegime(RaidesRequestParameter raidesRequestParameter, IngressionType registrationIngression) {
        return raidesRequestParameter.getIngressionsForGeneralAccessRegime().contains(registrationIngression);
    }

    public Set<Student> studentsToReport() {
        return this.alunos.keySet();
    }

    public TblIdentificacao identificacaoForStudent(Student student) {
        return this.alunos.get(student);
    }

    public List<TblIdentificacao> getAllIdentifications() {
        return Lists.newArrayList(this.alunos.values());
    }

    public Collection<TblInscrito> inscricoesForStudent(Student student, RaidesRequestParameter raidesRequestParameter) {
        if (!raidesRequestParameter.isFilterEntriesWithErrors()) {
            return this.inscritos.get((Object)student);
        }
        ArrayList filteredResult = Lists.newArrayList();
        for (TblInscrito tblInscrito : this.inscritos.get((Object)student)) {
            if (!tblInscrito.isValid()) continue;
            filteredResult.add(tblInscrito);
        }
        return filteredResult;
    }

    public Collection<TblInscrito> getAllInscritos() {
        return this.inscritos.values();
    }

    public Collection<TblDiplomado> diplomadosForStudent(Student student, RaidesRequestParameter raidesRequestParameter) {
        if (!raidesRequestParameter.isFilterEntriesWithErrors()) {
            return this.diplomados.get((Object)student);
        }
        ArrayList filteredResult = Lists.newArrayList();
        for (TblDiplomado tblDiplomado : this.diplomados.get((Object)student)) {
            if (!tblDiplomado.isValid()) continue;
            filteredResult.add(tblDiplomado);
        }
        return filteredResult;
    }

    public Collection<TblDiplomado> getAllDiplomados() {
        return this.diplomados.values();
    }

    public TblMobilidadeInternacional mobilidadeInternacionalForStudent(Student student, RaidesRequestParameter raidesRequestParameter) {
        if (this.mobilidadeInternacional.get((Object)student).isEmpty()) {
            return null;
        }
        if (this.mobilidadeInternacional.get((Object)student).size() > 1) {
            throw new RuntimeException("error.Raides.student.with.more.than.one.mobility");
        }
        TblMobilidadeInternacional tblMobilidadeInternacional = (TblMobilidadeInternacional)this.mobilidadeInternacional.get((Object)student).iterator().next();
        if (raidesRequestParameter.isFilterEntriesWithErrors() && !tblMobilidadeInternacional.isValid()) {
            return null;
        }
        return tblMobilidadeInternacional;
    }

    public Collection<TblMobilidadeInternacional> getAllMobilidadeInternacional() {
        return this.mobilidadeInternacional.values();
    }

    public static void defineRaidesReportRequestDefaultData(IRaidesReportRequestDefaultData requestDefaultData) {
        Raides.requestDefaultData = requestDefaultData;
    }

    public static void fillRaidesRequestDefaultData(RaidesRequestParameter raidesRequestParameter) {
        requestDefaultData = new RaidesReportRequestDefaultData();
        requestDefaultData.fill(raidesRequestParameter);
    }

    public List<Registration> getAllRegistrations() {
        return this.registrationList.stream().collect(Collectors.toUnmodifiableList());
    }

    public boolean isInEnrolledData(Registration registration) {
        for (RaidesData data : this.inscritos.values()) {
            if (data.getRegistration() != registration) continue;
            return true;
        }
        return false;
    }

    public boolean isInGraduated(Registration registration) {
        for (RaidesData data : this.diplomados.values()) {
            if (data.getRegistration() != registration) continue;
            return true;
        }
        return false;
    }

    public boolean isInInternacionalMobility(Registration registration) {
        for (RaidesData data : this.mobilidadeInternacional.values()) {
            if (data.getRegistration() != registration) continue;
            return true;
        }
        return false;
    }

    public static Country countryOfResidence(Registration registration, ExecutionYear executionYear) {
        if (registration.getPerson().getDefaultPhysicalAddress() != null && registration.getPerson().getDefaultPhysicalAddress().getCountryOfResidence() != null) {
            return registration.getPerson().getDefaultPhysicalAddress().getCountryOfResidence();
        }
        return null;
    }

    public static DistrictSubdivision districtSubdivisionOfResidence(Registration registration, ExecutionYear executionYear) {
        if (registration.getPerson().getDefaultPhysicalAddress() != null && registration.getPerson().getDefaultPhysicalAddress().getCountryOfResidence() != null && registration.getPerson().getDefaultPhysicalAddress().getCountryOfResidence().isDefaultCountry() && !Strings.isNullOrEmpty((String)registration.getPerson().getDefaultPhysicalAddress().getDistrictOfResidence()) && !Strings.isNullOrEmpty((String)registration.getPerson().getDefaultPhysicalAddress().getDistrictSubdivisionOfResidence())) {
            District district = Raides.findDistrictByName(registration.getPerson().getDefaultPhysicalAddress().getDistrictOfResidence());
            DistrictSubdivision districtSubdivision = Raides.findDistrictSubdivisionByName(district, registration.getPerson().getDefaultPhysicalAddress().getDistrictSubdivisionOfResidence());
            return districtSubdivision;
        }
        PersonalIngressionData pid = registration.getStudent().getPersonalIngressionDataByExecutionYear(executionYear);
        if (pid != null && pid.getCountryOfResidence() != null && pid.getCountryOfResidence().isDefaultCountry() && pid.getDistrictSubdivisionOfResidence() != null) {
            LegalReportContext.addWarn(RaidesReportEntryTarget.of(registration, executionYear), Raides.i18n("warn.Raides.techWarning", new String[0]));
            return pid.getDistrictSubdivisionOfResidence();
        }
        return null;
    }

    public static District districtOfResidence(Registration registration, ExecutionYear executionYear) {
        if (registration.getPerson().getDefaultPhysicalAddress() != null && registration.getPerson().getDefaultPhysicalAddress().getCountryOfResidence() != null && registration.getPerson().getDefaultPhysicalAddress().getCountryOfResidence().isDefaultCountry() && !Strings.isNullOrEmpty((String)registration.getPerson().getDefaultPhysicalAddress().getDistrictOfResidence()) && !Strings.isNullOrEmpty((String)registration.getPerson().getDefaultPhysicalAddress().getDistrictSubdivisionOfResidence())) {
            District district = Raides.findDistrictByName(registration.getPerson().getDefaultPhysicalAddress().getDistrictOfResidence());
            return district;
        }
        PersonalIngressionData pid = registration.getStudent().getPersonalIngressionDataByExecutionYear(executionYear);
        if (pid != null && pid.getCountryOfResidence() != null && pid.getCountryOfResidence().isDefaultCountry() && pid.getDistrictSubdivisionOfResidence() != null) {
            LegalReportContext.addWarn(RaidesReportEntryTarget.of(registration, executionYear), Raides.i18n("warn.Raides.techWarning", new String[0]));
            return pid.getDistrictSubdivisionOfResidence().getDistrict();
        }
        return null;
    }

    public static boolean isMasterDegreeOrDoctoralDegree(Registration registration) {
        return registration.getDegreeType().isSecondCycle() && !Raides.isIntegratedMasterDegree(registration) || registration.getDegreeType().isThirdCycle();
    }

    public static boolean isIntegratedMasterDegree(Registration registration) {
        return registration.getDegreeType().isIntegratedMasterDegree();
    }

    public static boolean isDoctoralDegree(Registration registration) {
        return registration.getDegreeType().isThirdCycle();
    }

    public static boolean isSpecializationDegree(Registration registration) {
        return registration.getDegreeType().isSpecializationDegree();
    }

    public static PersonalIngressionData personalIngressionData(Registration registration, ExecutionYear executionYear) {
        PersonalIngressionData personalIngressionDataByExecutionYear = registration.getStudent().getPersonalIngressionDataByExecutionYear(executionYear);
        if (personalIngressionDataByExecutionYear != null) {
            return personalIngressionDataByExecutionYear;
        }
        ExecutionYear ex = executionYear;
        while (ex.getPreviousExecutionYear() != null) {
            if (registration.getStudent().getPersonalIngressionDataByExecutionYear(ex) != null) {
                LegalReportContext.addWarn(RaidesReportEntryTarget.of(registration, executionYear), Raides.i18n("warn.Raides.validation.using.personal.ingression.data.from.previous.year", new String[0]));
                return registration.getStudent().getPersonalIngressionDataByExecutionYear(ex);
            }
            ex = ex.getPreviousExecutionYear();
        }
        return null;
    }

    private static String i18n(String key, String ... arguments) {
        return LegalPTUtil.bundle(key, arguments);
    }

    public static Collection<CurriculumLine> getAllCurriculumLines(Registration registration) {
        HashSet<CurriculumLine> curriculumLines = new HashSet<CurriculumLine>();
        Set studentCurricularPlans = registration.getStudentCurricularPlansSet();
        for (StudentCurricularPlan studentCurricularPlan : studentCurricularPlans) {
            curriculumLines.addAll(studentCurricularPlan.getAllCurriculumLines());
        }
        return curriculumLines;
    }

    public static LocalDate getEnrolmentDate(Registration registration, ExecutionYear executionYear) {
        if (Raides.getRegistrationDataByExecutionYear(registration, executionYear) == null) {
            return null;
        }
        return Raides.getRegistrationDataByExecutionYear(registration, executionYear).getEnrolmentDate();
    }

    public static RegistrationDataByExecutionYear getRegistrationDataByExecutionYear(Registration registration, ExecutionYear year) {
        for (RegistrationDataByExecutionYear registrationData : registration.getRegistrationDataByExecutionYearSet()) {
            if (!registrationData.getExecutionYear().equals((Object)year)) continue;
            return registrationData;
        }
        return null;
    }

    public static District findDistrictByName(String name) {
        String n = name;
        for (District district : Bennu.getInstance().getDistrictsSet()) {
            if (!district.getName().equalsIgnoreCase(n.trim())) continue;
            return district;
        }
        return null;
    }

    public static DistrictSubdivision findDistrictSubdivisionByName(District district, String name) {
        DistrictSubdivision result = null;
        String n = name.trim();
        if (district != null && !Strings.isNullOrEmpty((String)n)) {
            for (DistrictSubdivision iter : Bennu.getInstance().getDistrictSubdivisionsSet()) {
                if (!iter.getDistrict().equals((Object)district) || !n.toLowerCase().equals(iter.getName().toLowerCase())) continue;
                if (result != null) {
                    throw new IllegalStateException(BundleUtil.getString((String)"resources.ApplicationResources", (String)"error.DistrictSubdivision.found.duplicate", (String[])new String[]{district.getCode(), name, result.toString(), iter.toString()}));
                }
                result = iter;
            }
        }
        return result;
    }

    public static RegistrationProtocol findRegistrationProtocolByCode(String code) {
        return Bennu.getInstance().getRegistrationProtocolsSet().stream().filter(r -> r.getCode().equals(code)).findAny().get();
    }

    private static String[] concatArgs(String[] left, String ... right) {
        ArrayList<String> result = new ArrayList<String>();
        result.addAll(Arrays.asList(left));
        result.addAll(Arrays.asList(right));
        return result.toArray(new String[0]);
    }

    public static class TipoEstabSec {
        public static final String PUBLICO = "1";
    }

    public static class Idade {
        public static final Integer MIN = 16;
        public static final Integer MAX = 95;
    }

    public static class DocumentoIdentificacao {
        public static final String OUTRO = "7";
    }

    public static class SituacaoProfissional {
        public static final String DOMESTICO = "16";
        public static final String ALUNO = "17";
        public static final String OUTRA = "18";
        public static final String NAO_DISPONIVEL = "19";
        private static final List<String> WITHOUT_PROFESSION_TYPE = List.of("16", "17", "18", "19");

        public static final boolean requiresProfessionType(String value) {
            return value != null && !WITHOUT_PROFESSION_TYPE.contains(value);
        }
    }

    public static class NivelEscolaridadeAluno {
        public static final String OUTRO = "19";
    }

    public static class NivelEscolaridade {
        public static final String NAO_DISPONIVEL = "22";
    }

    public static class Ramo {
        public static final String TRONCO_COMUM = "1000017";
        public static final String OUTRO = "0000000";
    }

    public static class NivelCursoOrigem {
        public static final String OUTRO = "4";
    }

    public static class ActividadeMobilidade {
        public static final String MOBILIDADE_ESTUDO = "1";
    }

    public static class ProgramaMobilidade {
        public static final String OUTRO_DOIS = "2";
        public static final String OUTRO_TRES = "3";
    }

    public static class Estabelecimentos {
        public static final String OUTRO = "0000";
    }

    public static class Cursos {
        public static final String OUTRO = "0000";
    }

    public static class Concelho {
        public static final String OUTRO = "9999";
    }

    public static class Bolseiro {
        public static final GrantOwnerType NAO_BOLSEIRO = GrantOwnerType.STUDENT_WITHOUT_SCHOLARSHIP;
        public static final GrantOwnerType CANDIDATO_BOLSEIRO_ACCAO_SOCIAL = GrantOwnerType.HIGHER_EDUCATION_SAS_GRANT_OWNER_CANDIDATE;

        public static LocalizedString LOCALIZED_NAME(String key) {
            if (Sets.newHashSet((Object[])new GrantOwnerType[]{NAO_BOLSEIRO, CANDIDATO_BOLSEIRO_ACCAO_SOCIAL}).contains(key)) {
                return LegalPTUtil.bundleI18N(Bolseiro.class.getSimpleName() + "." + key, new String[0]);
            }
            return LegalPTUtil.bundleI18N("label.GrantOwnerType." + key, new String[0]);
        }
    }

    public static class RegimeFrequencia {
        public static final String ETD_CODE = "ETD_CODE";

        public static Set<String> VALUES() {
            HashSet degreeCodes = Sets.newHashSet((Iterable)Lists.transform((List)Lists.newArrayList((Iterable)Bennu.getInstance().getDegreesSet()), (Function)new Function<Degree, String>(){

                public String apply(Degree degree) {
                    return degree.getExternalId();
                }
            }));
            degreeCodes.add(ETD_CODE);
            return degreeCodes;
        }

        public static LocalizedString LOCALIZED_NAME(String key) {
            if (ETD_CODE.equals(key)) {
                return LegalPTUtil.bundleI18N(RegimeFrequencia.class.getSimpleName() + "." + key, new String[0]);
            }
            Degree degree = (Degree)FenixFramework.getDomainObject((String)key);
            return new LocalizedString(I18N.getLocale(), "[" + degree.getCode() + "] " + degree.getPresentationName());
        }
    }

    public static class AnoCurricular {
        public static final String ESTAGIO_FINAL_CODE = "ESTAGIO_FINAL_CODE";
        public static final String TRABALHO_PROJECTO_CODE = "TRABALHO_PROJECTO_CODE";
        public static final String DISSERTACAO_CODE = "DISSERTACAO_CODE";
        public static final String NAO_APLICAVEL_CODE = "NAO_APLICAVEL_CODE";

        public static Set<String> VALUES() {
            return Sets.newHashSet((Object[])new String[]{"1", "2", "3", "4", "5", "6", "7", ESTAGIO_FINAL_CODE, TRABALHO_PROJECTO_CODE, DISSERTACAO_CODE, NAO_APLICAVEL_CODE});
        }

        public static LocalizedString LOCALIZED_NAME(String key) {
            return LegalPTUtil.bundleI18N(AnoCurricular.class.getSimpleName() + "." + key, new String[0]);
        }
    }
}

