/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.legalpt.domain.a3es;

import com.google.common.collect.Lists;
import java.util.stream.Stream;
import org.fenixedu.commons.i18n.LocalizedString;
import org.fenixedu.legalpt.services.a3es.process.A3esExportService;
import org.fenixedu.legalpt.services.a3es.process.A3esExportServiceForEvaluationOfActiveProgram;
import org.fenixedu.legalpt.services.a3es.process.A3esExportServiceForNewProgram;
import org.fenixedu.legalpt.services.a3es.process.A3esExportServiceForRenewalOfUnalignedProgram;
import org.fenixedu.legalpt.util.LegalPTUtil;

public enum A3esProcessType {
    EVALUATION_OF_NEW_PROGRAM("PAPNCE"){

        @Override
        public A3esExportService getExportService() {
            return new A3esExportServiceForNewProgram();
        }
    }
    ,
    EVALUATION_OF_ACTIVE_PROGRAM("ACEF"){

        @Override
        public A3esExportService getExportService() {
            return new A3esExportServiceForEvaluationOfActiveProgram();
        }
    }
    ,
    RENEWAL_OF_UNALIGNED_PROGRAM("PERA"){

        @Override
        public A3esExportService getExportService() {
            return new A3esExportServiceForRenewalOfUnalignedProgram();
        }
    };

    private String code;

    private A3esProcessType(String code) {
        this.code = code;
    }

    public LocalizedString getLocalizedName() {
        return LegalPTUtil.bundleI18N(A3esProcessType.class.getName() + "." + this.name(), new String[0]);
    }

    public String getCode() {
        return this.code;
    }

    public abstract A3esExportService getExportService();

    public static Stream<A3esProcessType> getSupportedTypes() {
        return Lists.newArrayList((Object[])A3esProcessType.values()).stream().filter(x -> x.getExportService() != null);
    }
}

