/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.ulisboa.integration.sas.ui.spring.controller.manageScholarshipCandidacies;

import com.sun.xml.ws.fault.ServerSOAPFaultException;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.bennu.core.domain.Bennu;
import org.fenixedu.bennu.spring.portal.SpringFunctionality;
import org.fenixedu.ulisboa.integration.sas.domain.SasScholarshipCandidacy;
import org.fenixedu.ulisboa.integration.sas.service.process.FillScholarshipException;
import org.fenixedu.ulisboa.integration.sas.service.sicabe.SicabeExternalService;
import org.fenixedu.ulisboa.integration.sas.ui.spring.controller.SasBaseController;
import org.fenixedu.ulisboa.integration.sas.ui.spring.controller.SasController;
import org.fenixedu.ulisboa.integration.sas.util.SasPTUtil;
import org.joda.time.ReadableInstant;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;
import pt.dges.schemas.services.sicabe.v1.DadosAcademicosObterCandidaturasSubmetidasSicabeBusinessMessageFaultFaultMessage;
import pt.dges.schemas.services.sicabe.v1.DadosAcademicosObterCandidaturasSubmetidasSicabeErrorMessageFaultFaultMessage;
import pt.dges.schemas.services.sicabe.v1.DadosAcademicosObterCandidaturasSubmetidasSicabeValidationMessageFaultFaultMessage;
import pt.ist.fenixframework.FenixFramework;

@SpringFunctionality(app=SasController.class, title="label.title.manageScholarships", accessGroup="#academicAdmOffice")
@RequestMapping(value={"/integration/sas/manageScholarshipCandidacies"})
public class ScholarshipCandidaciesController
extends SasBaseController {
    public static final String CONTROLLER_URL = "/integration/sas/manageScholarshipCandidacies";
    public static final String JSP_PATH = "/integration/sas/manageScholarshipCandidacies".substring(1);
    private static final String _CHANGE_EXECUTION_YEAR_URI = "/changeExecutionYear";
    public static final String CHANGE_EXECUTION_YEAR_URL = "/integration/sas/manageScholarshipCandidacies/changeExecutionYear";
    private static final String _READ_SAS_SCHOLARSHIP_CANDIDACY_URI = "/readSasScholarshipCandidacy";
    public static final String READ_SAS_SCHOLARSHIP_CANDIDACY_URL = "/integration/sas/manageScholarshipCandidacies/readSasScholarshipCandidacy";
    private static final String _SYNC_ALL_ENTRIES_URI = "/syncAll";
    public static final String SYNC_ALL_ENTRIES_URL = "/integration/sas/manageScholarshipCandidacies/syncAll";
    private static final String _PROCESS_ENTRY_URI = "/process";
    public static final String PROCESS_ENTRY_URL = "/integration/sas/manageScholarshipCandidacies/process";
    private static final String _PROCESS_ALL_ENTRIES_URI = "/processAll";
    public static final String PROCESS_ALL_ENTRIES_URL = "/integration/sas/manageScholarshipCandidacies/processAll";
    private static final String _SEND_ENTRY_URI = "/send";
    public static final String SEND_ENTRY_URL = "/integration/sas/manageScholarshipCandidacies/send";
    private static final String _SEND_ALL_ENTRIES_URI = "/sendAll";
    public static final String SEND_ALL_ENTRIES_URL = "/integration/sas/manageScholarshipCandidacies/sendAll";
    private static final String _SEND_SELECTED_ENTRIES_URI = "/sendSelected";
    public static final String SEND_SELECTED_ENTRIES_URL = "/integration/sas/manageScholarshipCandidacies/sendSelected";
    private static final String _DELETE_ENTRY_URI = "/delete";
    public static final String DELETE_ENTRY_URL = "/integration/sas/manageScholarshipCandidacies/delete";
    private static final String _DELETE_ALL_ENTRIES_URI = "/deleteAll";
    public static final String DELETE_ALL_ENTRIES_URL = "/integration/sas/manageScholarshipCandidacies/deleteAll";
    private static final String _VIEW_LOGS_URI = "/logs";
    public static final String VIEW_LOGS_ENTRIES_URL = "/integration/sas/manageScholarshipCandidacies/logs";
    private static final String _VIEW_LOG_URI = "/log";
    public static final String VIEW_LOG_URL = "/integration/sas/manageScholarshipCandidacies/log";
    private static final String _EXPORT_TO_XLS_URI = "/exportToXls";
    public static final String EXPORT_TO_XLS_URL = "/integration/sas/manageScholarshipCandidacies/exportToXls";

    @RequestMapping
    public String home(Model model) {
        ExecutionYear executionYear = ExecutionYear.readCurrentExecutionYear();
        return "forward:/integration/sas/manageScholarshipCandidacies/" + executionYear.getExternalId();
    }

    @RequestMapping(value={"/{executionYearId}"}, method={RequestMethod.GET})
    public String search(Model model, @PathVariable(value="executionYearId") ExecutionYear executionYearParam) {
        List scholarshipCandidacies = SasScholarshipCandidacy.findAll().stream().filter(c -> c.getExecutionYear() == executionYearParam).sorted((x, y) -> -x.getSubmissionDate().compareTo((ReadableInstant)y.getSubmissionDate())).collect(Collectors.toList());
        model.addAttribute("scholarshipCandidacies", scholarshipCandidacies);
        model.addAttribute("executionYears", ExecutionYear.readNotClosedExecutionYears().stream().sorted(ExecutionYear.COMPARATOR_BY_BEGIN_DATE.reversed()).collect(Collectors.toList()));
        model.addAttribute("executionYear", (Object)executionYearParam);
        return this.jspPath("search");
    }

    @RequestMapping(value={"/changeExecutionYear"}, method={RequestMethod.POST})
    public String changeExecutionYear(Model model, @RequestParam(value="executionYearId") ExecutionYear executionYearParam) {
        return this.search(model, executionYearParam);
    }

    private String jspPath(String page) {
        return JSP_PATH + "/" + page;
    }

    @RequestMapping(value={"/readSasScholarshipCandidacy/{oid}"}, method={RequestMethod.GET})
    public String readResumeSasScholarshipCandidacy(@PathVariable(value="oid") SasScholarshipCandidacy sasScholarshipCandidacy, Model model) {
        model.addAttribute("sasScholarshipCandidacy", (Object)sasScholarshipCandidacy);
        return this.jspPath("resume");
    }

    @RequestMapping(value={"/syncAll/{executionYearId}"}, method={RequestMethod.GET})
    public String syncAllEntries(@PathVariable(value="executionYearId") ExecutionYear executionYear, Model model, RedirectAttributes redirectAttributes) {
        SicabeExternalService sicabe = new SicabeExternalService();
        try {
            sicabe.removeAllCandidaciesWithoutRegistrationAndLoadAllSasCandidacies(executionYear);
            this.addInfoMessage(SasPTUtil.bundle("label.info.syncAll", new String[0]), model);
        }
        catch (DadosAcademicosObterCandidaturasSubmetidasSicabeBusinessMessageFaultFaultMessage | DadosAcademicosObterCandidaturasSubmetidasSicabeErrorMessageFaultFaultMessage | DadosAcademicosObterCandidaturasSubmetidasSicabeValidationMessageFaultFaultMessage e) {
            this.addErrorMessage(SasPTUtil.bundle("label.error.syncAll", new String[0]), model);
        }
        catch (ServerSOAPFaultException e) {
            this.addErrorMessage(SasPTUtil.bundle("label.error.connection", new String[0]), model);
        }
        return this.redirect("/integration/sas/manageScholarshipCandidacies/" + executionYear.getExternalId(), model, redirectAttributes);
    }

    @RequestMapping(value={"/process/{sasScholarshipCandidacyId}"}, method={RequestMethod.GET})
    public String processSearchEntries(@PathVariable(value="sasScholarshipCandidacyId") SasScholarshipCandidacy sasScholarshipCandidacy, Model model, RedirectAttributes redirectAttributes) {
        SicabeExternalService sicabe = new SicabeExternalService();
        sicabe.processSasScholarshipCandidacies(Collections.singletonList(sasScholarshipCandidacy));
        this.addInfoMessage(SasPTUtil.bundle("label.info.process", new String[0]), model);
        return this.readResumeSasScholarshipCandidacy(sasScholarshipCandidacy, model);
    }

    @RequestMapping(value={"/processAll/{executionYearId}"}, method={RequestMethod.GET})
    public String processAll(@PathVariable(value="executionYearId") ExecutionYear executionYear, Model model, RedirectAttributes redirectAttributes) {
        SicabeExternalService sicabe = new SicabeExternalService();
        sicabe.processAllSasScholarshipCandidacies(executionYear);
        this.addInfoMessage(SasPTUtil.bundle("label.info.processAll", new String[0]), model);
        return this.redirect("/integration/sas/manageScholarshipCandidacies/" + executionYear.getExternalId(), model, redirectAttributes);
    }

    @RequestMapping(value={"/send/{sasScholarshipCandidacyId}"}, method={RequestMethod.GET})
    public String sendSearchEntries(@PathVariable(value="sasScholarshipCandidacyId") SasScholarshipCandidacy sasScholarshipCandidacy, Model model, RedirectAttributes redirectAttributes) {
        try {
            SicabeExternalService sicabe = new SicabeExternalService();
            sicabe.sendSasScholarshipsCandidaciesToSicabe(Collections.singletonList(sasScholarshipCandidacy));
            this.addInfoMessage(SasPTUtil.bundle("label.info.send", new String[0]), model);
        }
        catch (RuntimeException e) {
            this.addErrorMessage(SasPTUtil.bundle("label.error.send", new String[0]), model);
        }
        model.addAttribute("sasScholarshipCandidacy", (Object)sasScholarshipCandidacy);
        return this.jspPath("resume");
    }

    @RequestMapping(value={"/sendAll/{executionYearId}"}, method={RequestMethod.GET})
    public String sendSearchEntries(@PathVariable(value="executionYearId") ExecutionYear executionYear, Model model, RedirectAttributes redirectAttributes) {
        try {
            SicabeExternalService sicabe = new SicabeExternalService();
            sicabe.sendAllSasScholarshipCandidaciesToSicabe(executionYear);
            this.addInfoMessage(SasPTUtil.bundle("label.info.sendAll", new String[0]), model);
        }
        catch (RuntimeException e) {
            this.addErrorMessage(SasPTUtil.bundle("label.error.sendAll", new String[0]), model);
        }
        return this.redirect("/integration/sas/manageScholarshipCandidacies/" + executionYear.getExternalId(), model, redirectAttributes);
    }

    @RequestMapping(value={"/sendSelected/{executionYearId}"}, method={RequestMethod.POST})
    public String sendSelectedEntries(@RequestParam(value="selectedCandidacyIds", required=false) String selectedCandidacyIds, @PathVariable(value="executionYearId") ExecutionYear executionYear, Model model, RedirectAttributes redirectAttributes) {
        try {
            Set<SasScholarshipCandidacy> candidacies;
            SicabeExternalService sicabe = new SicabeExternalService();
            Collection<SasScholarshipCandidacy> collection = candidacies = selectedCandidacyIds == null ? Collections.emptySet() : (Collection)Arrays.stream(selectedCandidacyIds.split(",")).map(s -> s.trim()).filter(s -> !s.isEmpty()).map(s -> (SasScholarshipCandidacy)FenixFramework.getDomainObject((String)s)).collect(Collectors.toSet());
            if (!candidacies.isEmpty()) {
                sicabe.sendSasScholarshipsCandidaciesToSicabe(candidacies);
                this.addInfoMessage(SasPTUtil.bundle("label.info.sendSelected", new String[0]), model);
            } else {
                this.addErrorMessage(SasPTUtil.bundle("label.error.sendSelected.empty.list", new String[0]), model);
            }
        }
        catch (RuntimeException e) {
            this.addErrorMessage(SasPTUtil.bundle("label.error.sendSelected", new String[0]), model);
        }
        return this.redirect("/integration/sas/manageScholarshipCandidacies/" + executionYear.getExternalId(), model, redirectAttributes);
    }

    @RequestMapping(value={"/delete/{sasScholarshipCandidacyId}"}, method={RequestMethod.GET})
    public String delete(@PathVariable(value="sasScholarshipCandidacyId") SasScholarshipCandidacy sasScholarshipCandidacy, Model model, RedirectAttributes redirectAttributes) {
        String studentName = sasScholarshipCandidacy.getCandidacyName();
        ExecutionYear executionYear = sasScholarshipCandidacy.getExecutionYear();
        try {
            SicabeExternalService sicabe = new SicabeExternalService();
            sicabe.removeSasScholarshipsCandidacy(sasScholarshipCandidacy);
            this.addInfoMessage(SasPTUtil.bundle("label.info.delete", studentName), model);
            return this.redirect("/integration/sas/manageScholarshipCandidacies/" + executionYear.getExternalId(), model, redirectAttributes);
        }
        catch (FillScholarshipException e) {
            this.addErrorMessage(e.getMessage(), model);
            model.addAttribute("sasScholarshipCandidacy", (Object)sasScholarshipCandidacy);
            return this.jspPath("resume");
        }
    }

    @RequestMapping(value={"/deleteAll/{executionYearId}"}, method={RequestMethod.GET})
    public String deleteAll(@PathVariable(value="executionYearId") ExecutionYear executionYear, Model model, RedirectAttributes redirectAttributes) {
        SicabeExternalService sicabe = new SicabeExternalService();
        boolean showWarningMessage = sicabe.removeAllSasScholarshipsCandidacies(executionYear);
        if (showWarningMessage) {
            this.addWarningMessage(SasPTUtil.bundle("label.error.delete.already.sent", new String[0]), model);
        } else {
            this.addInfoMessage(SasPTUtil.bundle("label.info.deleteAll", new String[0]), model);
        }
        return this.redirect("/integration/sas/manageScholarshipCandidacies/" + executionYear.getExternalId(), model, redirectAttributes);
    }

    @RequestMapping(value={"/logs/{executionYearId}"}, method={RequestMethod.GET})
    public String viewLogs(@PathVariable(value="executionYearId") ExecutionYear executionYear, Model model, RedirectAttributes redirectAttributes) {
        List logs = Bennu.getInstance().getSasScholarshipDataChangeLogsSet().stream().filter(l -> l.getSasScholarshipCandidacy().getExecutionYear() == executionYear).sorted((x, y) -> -x.getDate().compareTo((ReadableInstant)y.getDate())).collect(Collectors.toList());
        model.addAttribute("sasScholarshipDataChangeLogs", logs);
        return this.jspPath("viewLogs");
    }

    @RequestMapping(value={"/log/{sasScholarshipCandidacyId}"}, method={RequestMethod.GET})
    public String viewLogs(@PathVariable(value="sasScholarshipCandidacyId") SasScholarshipCandidacy sasScholarshipCandidacy, Model model, RedirectAttributes redirectAttributes) {
        List logs = Bennu.getInstance().getSasScholarshipDataChangeLogsSet().stream().filter(l -> l.getSasScholarshipCandidacy() == sasScholarshipCandidacy).sorted((x, y) -> -x.getDate().compareTo((ReadableInstant)y.getDate())).collect(Collectors.toList());
        model.addAttribute("sasScholarshipDataChangeLogs", logs);
        model.addAttribute("sasScholarshipCandidacy", (Object)sasScholarshipCandidacy);
        return this.jspPath("viewLogs");
    }

    @RequestMapping(value={"/exportToXls/{executionYearId}"}, method={RequestMethod.GET})
    public void exportToXls(@PathVariable(value="executionYearId") ExecutionYear executionYear, Model model, RedirectAttributes redirectAttributes, HttpServletResponse response) throws IOException {
        this.writeFile(response, "SAS_Report.xlsx", "application/vnd.ms-excel", SicabeExternalService.export(executionYear));
    }
}

