/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.legalpt.services.rebides.process;

import org.apache.commons.lang.StringUtils;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.Teacher;
import org.fenixedu.legalpt.domain.LegalReportContext;
import org.fenixedu.legalpt.domain.mapping.LegalMapping;
import org.fenixedu.legalpt.domain.rebides.mapping.RebidesMappingType;
import org.fenixedu.legalpt.domain.report.LegalReport;
import org.fenixedu.legalpt.dto.rebides.IdentificationBean;
import org.fenixedu.legalpt.services.rebides.process.RebidesService;
import org.joda.time.LocalDate;
import org.joda.time.Period;
import org.joda.time.PeriodType;
import org.joda.time.ReadablePartial;

public class IdentificationService {
    private final Teacher teacher;
    private final ExecutionYear executionYear;
    private LegalReport report;

    public IdentificationService(LegalReport report, Teacher teacher, ExecutionYear executionYear) {
        this.report = report;
        this.teacher = teacher;
        this.executionYear = executionYear;
    }

    public IdentificationBean getIdentificationData() {
        IdentificationBean bean = new IdentificationBean();
        this.fillTeacherName(bean);
        this.fillTeacherDocumentIdNumber(bean);
        this.fillTeacherDocumentIdType(bean);
        this.fillTeacherOtherIdDocumentType(bean);
        this.fillTeacherDateOfBirth(bean);
        this.fillTeacherGender(bean);
        this.fillTeacherNationalityCountry(bean);
        this.fillTeacherOtherNationalityCountry(bean);
        return bean;
    }

    private void fillTeacherName(IdentificationBean bean) {
        String name = this.teacher.getPerson().getName();
        if (StringUtils.isNotEmpty((String)name)) {
            if (RebidesService.validateMaxFieldSize(this.teacher, "Person.name", name, RebidesService.LIMIT_80CHARS).booleanValue()) {
                bean.setName(name);
            }
        } else {
            LegalReportContext.addError(RebidesService.createSubjectForReport(this.teacher), RebidesService.createMissingFieldMessage("Person.name"), new String[0]);
        }
    }

    private void fillTeacherDocumentIdNumber(IdentificationBean bean) {
        String documentIdNumber = this.teacher.getPerson().getDocumentIdNumber();
        if (StringUtils.isNotEmpty((String)documentIdNumber)) {
            if (RebidesService.validateMaxFieldSize(this.teacher, "Person.documentIdNumber", documentIdNumber, RebidesService.LIMIT_20CHARS).booleanValue()) {
                bean.setDocumentIdNumber(documentIdNumber);
            }
        } else {
            LegalReportContext.addError(RebidesService.createSubjectForReport(this.teacher), RebidesService.createMissingFieldMessage("Person.documentIdNumber"), new String[0]);
        }
    }

    private void fillTeacherDocumentIdType(IdentificationBean bean) {
        if (this.teacher.getPerson().getIdDocumentType() != null) {
            if (LegalMapping.find(this.report, RebidesMappingType.ID_DOCUMENT_TYPE).translate((Enum<?>)this.teacher.getPerson().getIdDocumentType()) != null) {
                bean.setDocumentIdType(LegalMapping.find(this.report, RebidesMappingType.ID_DOCUMENT_TYPE).translate((Enum<?>)this.teacher.getPerson().getIdDocumentType()));
            } else {
                LegalReportContext.addError(RebidesService.createSubjectForReport(this.teacher), RebidesService.createMissingMappingMessage("Person.idDocumentType", this.teacher.getPerson().getIdDocumentType().getLocalizedName()), new String[0]);
            }
        } else {
            LegalReportContext.addError(RebidesService.createSubjectForReport(this.teacher), RebidesService.createMissingFieldMessage("Person.idDocumentType"), new String[0]);
        }
    }

    private void fillTeacherOtherIdDocumentType(IdentificationBean bean) {
        String otherIdDocumentType;
        if ("7".equals(this.teacher.getPerson().getIdDocumentType().name()) && RebidesService.validateMaxFieldSize(this.teacher, "Person.otherIdDocumentType", otherIdDocumentType = this.teacher.getPerson().getIdDocumentType().getLocalizedName(), RebidesService.LIMIT_60CHARS).booleanValue()) {
            bean.setOtherIdDocumentType(otherIdDocumentType);
        }
    }

    private void fillTeacherDateOfBirth(IdentificationBean bean) {
        if (this.teacher.getPerson().getDateOfBirthYearMonthDay() != null) {
            LocalDate dateOfBirth = this.teacher.getPerson().getDateOfBirthYearMonthDay().toLocalDate();
            if (this.validateDateOfBirth("label.age", dateOfBirth).booleanValue()) {
                bean.setDateOfBirth(dateOfBirth);
            }
        } else {
            LegalReportContext.addError(RebidesService.createSubjectForReport(this.teacher), RebidesService.createMissingFieldMessage("Person.dateOfBirthYearMonthDay"), new String[0]);
        }
    }

    private void fillTeacherGender(IdentificationBean bean) {
        if (this.teacher.getPerson().getGender() != null) {
            if (LegalMapping.find(this.report, RebidesMappingType.GENDER).translate((Enum<?>)this.teacher.getPerson().getGender()) != null) {
                String gender = LegalMapping.find(this.report, RebidesMappingType.GENDER).translate((Enum<?>)this.teacher.getPerson().getGender());
                bean.setGender(gender);
            } else {
                LegalReportContext.addError(RebidesService.createSubjectForReport(this.teacher), RebidesService.createMissingMappingMessage("Person.gender", this.teacher.getPerson().getGender().getLocalizedName()), new String[0]);
            }
        } else {
            LegalReportContext.addError(RebidesService.createSubjectForReport(this.teacher), RebidesService.createMissingFieldMessage("Person.gender"), new String[0]);
        }
    }

    private void fillTeacherNationalityCountry(IdentificationBean bean) {
        if (this.teacher.getPerson().getCountry() != null) {
            bean.setNationalityCountry(this.teacher.getPerson().getCountry().getCode());
        } else {
            LegalReportContext.addError(RebidesService.createSubjectForReport(this.teacher), RebidesService.createMissingFieldMessage("Person.nationality"), new String[0]);
        }
    }

    private void fillTeacherOtherNationalityCountry(IdentificationBean bean) {
        bean.setOtherNationalityCountry(null);
    }

    private Boolean validateDateOfBirth(String field, LocalDate dateOfBirth) {
        LocalDate now = new LocalDate(this.executionYear.getAcademicInterval().getStart().getYear(), 12, 31);
        Period period = new Period((ReadablePartial)dateOfBirth, (ReadablePartial)now, PeriodType.yearMonthDay());
        if (period.getYears() < RebidesService.MIN_AGE || period.getYears() > RebidesService.MAX_AGE) {
            String message = RebidesService.i18n("rebides.invalidIntervalValue", RebidesService.i18n(field, new String[0]), String.valueOf(period.getYears()), String.valueOf(RebidesService.MIN_AGE), String.valueOf(RebidesService.MAX_AGE));
            LegalReportContext.addError(RebidesService.createSubjectForReport(this.teacher), message, new String[0]);
            return false;
        }
        return true;
    }

    public static class IdDocument {
        public static final String OTHER = "7";
    }
}

