/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.legalpt.services.rebides.process;

import org.apache.commons.lang.StringUtils;
import org.fenixedu.legalpt.domain.LegalReportContext;
import org.fenixedu.legalpt.domain.rebides.report.RebidesRequestParameter;
import org.fenixedu.legalpt.domain.report.LegalReportRequest;
import org.fenixedu.legalpt.dto.rebides.ExtractionInfoBean;
import org.fenixedu.legalpt.services.rebides.process.RebidesService;
import org.joda.time.LocalDate;

public class ExtractionInfoService {
    public ExtractionInfoBean getExtractionInfoData(LegalReportRequest reportRequest) {
        ExtractionInfoBean bean = new ExtractionInfoBean();
        RebidesRequestParameter parameters = reportRequest.getParametersAs(RebidesRequestParameter.class);
        this.fillInstitutionCode(bean, parameters.getInstitutionCode());
        this.fillMoment(bean, parameters.getMoment());
        this.fillExtractionDate(bean, new LocalDate());
        this.fillInterlocutorName(bean, parameters.getInterlocutorName());
        this.fillInterlocutorEmail(bean, parameters.getInterlocutorEmail());
        this.fillInterlocutorPhone(bean, parameters.getInterlocutorPhone());
        return bean;
    }

    private void fillInstitutionCode(ExtractionInfoBean bean, String institutionCode) {
        if (StringUtils.isNotEmpty((String)institutionCode)) {
            if (ExtractionInfoService.validateMaxFieldSize("label.RebidesReportUI.institutionCode", institutionCode, RebidesService.SIZE_4CHARS).booleanValue()) {
                bean.setInterlocutorName(institutionCode);
            }
        } else {
            LegalReportContext.addError(RebidesService.i18n("label.extractionInfo", new String[0]), RebidesService.createMissingFieldMessage("label.RebidesReportUI.institutionCode"), new String[0]);
        }
    }

    private void fillMoment(ExtractionInfoBean bean, String moment) {
        if (StringUtils.isNotEmpty((String)moment)) {
            bean.setMoment(moment);
        } else {
            LegalReportContext.addError(RebidesService.i18n("label.extractionInfo", new String[0]), RebidesService.createMissingFieldMessage("label.RebidesReportUI.moment"), new String[0]);
        }
    }

    private void fillExtractionDate(ExtractionInfoBean bean, LocalDate localDate) {
        bean.setExtractionDate(localDate);
    }

    private void fillInterlocutorName(ExtractionInfoBean bean, String interlocutorName) {
        if (StringUtils.isNotEmpty((String)interlocutorName)) {
            if (ExtractionInfoService.validateMaxFieldSize("label.RebidesReportUI.interlocutorName", interlocutorName, RebidesService.LIMIT_80CHARS).booleanValue()) {
                bean.setInterlocutorName(interlocutorName);
            }
        } else {
            LegalReportContext.addError(RebidesService.i18n("label.extractionInfo", new String[0]), RebidesService.createMissingFieldMessage("label.RebidesReportUI.interlocutorName"), new String[0]);
        }
    }

    private void fillInterlocutorEmail(ExtractionInfoBean bean, String interlocutorEmail) {
        if (StringUtils.isNotEmpty((String)interlocutorEmail)) {
            if (ExtractionInfoService.validateMaxFieldSize("label.RebidesReportUI.interlocutorEmail", interlocutorEmail, RebidesService.LIMIT_50CHARS).booleanValue()) {
                bean.setInterlocutorEmail(interlocutorEmail);
            }
        } else {
            LegalReportContext.addError(RebidesService.i18n("label.extractionInfo", new String[0]), RebidesService.createMissingFieldMessage("label.RebidesReportUI.interlocutorEmail"), new String[0]);
        }
    }

    private void fillInterlocutorPhone(ExtractionInfoBean bean, String interlocutorPhone) {
        if (StringUtils.isNotEmpty((String)interlocutorPhone)) {
            if (ExtractionInfoService.validateMaxFieldSize("label.RebidesReportUI.interlocutorPhone", interlocutorPhone, RebidesService.SIZE_9CHARS).booleanValue()) {
                bean.setInterlocutorPhone(interlocutorPhone);
            }
        } else {
            LegalReportContext.addError(RebidesService.i18n("label.extractionInfo", new String[0]), RebidesService.createMissingFieldMessage("label.RebidesReportUI.interlocutorPhone"), new String[0]);
        }
    }

    public static Boolean validateMaxFieldSize(String field, String fieldContent, int maxFieldSize) {
        if (fieldContent.length() > maxFieldSize) {
            String message = RebidesService.i18n("rebides.fieldSizeOverflow", RebidesService.i18n(field, new String[0]), String.valueOf(fieldContent.length()), String.valueOf(maxFieldSize));
            LegalReportContext.addError(RebidesService.i18n("label.extractionInfo", new String[0]), message, new String[0]);
            return false;
        }
        return true;
    }
}

