/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.legalpt.services.commons.export;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.util.concurrent.Callable;
import net.lingala.zip4j.exception.ZipException;
import net.lingala.zip4j.io.ZipOutputStream;
import net.lingala.zip4j.model.ZipModel;
import net.lingala.zip4j.model.ZipParameters;
import org.fenixedu.legalpt.domain.report.LegalReportRequest;
import org.fenixedu.legalpt.domain.report.LegalReportResultFile;
import org.fenixedu.legalpt.domain.report.LegalReportResultFileType;
import org.fenixedu.legalpt.services.commons.export.XmlZipFileWriter$callable$writeToFile;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

public class XmlZipFileWriter {
    public static final Advice advice$writeToFile = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.WRITE, true));

    public static LegalReportResultFile write(LegalReportRequest reportRequest, LegalReportResultFile xmlResultFile, String password) {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ZipParameters parameters = new ZipParameters();
            parameters.setCompressionMethod(8);
            parameters.setCompressionLevel(5);
            parameters.setEncryptFiles(true);
            parameters.setEncryptionMethod(0);
            parameters.setPassword(password);
            parameters.setFileNameInZip(xmlResultFile.getFilename());
            parameters.setSourceExternalStream(true);
            ZipOutputStream zOut = new ZipOutputStream((OutputStream)baos, new ZipModel());
            zOut.putNextEntry(null, parameters);
            zOut.write(xmlResultFile.getContent());
            zOut.closeEntry();
            zOut.finish();
            zOut.close();
            return XmlZipFileWriter.writeToFile(reportRequest, xmlResultFile, baos);
        }
        catch (IOException | ZipException e) {
            e.printStackTrace();
            return null;
        }
    }

    private static LegalReportResultFile writeToFile(LegalReportRequest legalReportRequest, LegalReportResultFile legalReportResultFile, ByteArrayOutputStream byteArrayOutputStream) {
        return (LegalReportResultFile)((Object)advice$writeToFile.perform((Callable)new XmlZipFileWriter$callable$writeToFile(legalReportRequest, legalReportResultFile, byteArrayOutputStream)));
    }

    static /* synthetic */ LegalReportResultFile advised$writeToFile(LegalReportRequest reportRequest, LegalReportResultFile xmlResultFile, ByteArrayOutputStream baos) {
        return new LegalReportResultFile(reportRequest, LegalReportResultFileType.ZIP, xmlResultFile.getFilename().replace(".xml", ".zip"), baos.toByteArray());
    }
}

