/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.legalpt.services.a3es.process;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Collection;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.fenixedu.academic.domain.DegreeCurricularPlan;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.degreeStructure.CycleType;
import org.fenixedu.academic.domain.person.Gender;
import org.fenixedu.academic.domain.student.Registration;
import org.fenixedu.academic.domain.student.RegistrationDataServices;
import org.fenixedu.academic.domain.student.RegistrationServices;
import org.fenixedu.legalpt.domain.a3es.A3esInstance;
import org.fenixedu.legalpt.dto.a3es.A3esProcessBean;
import org.fenixedu.legalpt.dto.a3es.A3esStudentsBean;
import org.fenixedu.legalpt.services.a3es.process.A3esExportService;
import org.fenixedu.legalpt.util.LegalPTUtil;

public class A3esHarvestStudentsDataService {
    private final ExecutionYear year;
    private final DegreeCurricularPlan degreeCurricularPlan;

    public A3esHarvestStudentsDataService(A3esProcessBean bean) {
        this.year = bean.getExecutionYear();
        this.degreeCurricularPlan = bean.getDegreeCurricularPlan();
        Collection<Registration> registrations = this.getAllRegistrations();
        A3esStudentsBean data = bean.getStudentsData();
        A3esHarvestStudentsDataService.fillStudentsEnroled(data, registrations);
        A3esHarvestStudentsDataService.fillStudentsByGender(data, registrations);
        this.fillStudentsByCurricularYear(data, registrations);
        A3esHarvestStudentsDataService.fillStudentsByForeignNationality(data, registrations);
        this.fillStudentsByBranch(data, registrations);
    }

    private Collection<Registration> getAllRegistrations() {
        return this.year.getExecutionPeriodsSet().stream().flatMap(semester -> semester.getEnrolmentsSet().stream().filter(enrolment -> !enrolment.isAnnulled()).map(enrolment -> enrolment.getRegistration()).filter(registration -> registration.getDegree() == this.degreeCurricularPlan.getDegree()).filter(registration -> !A3esHarvestStudentsDataService.isAgreementPartOfMobilityReport(registration)).filter(registration -> RegistrationDataServices.getRegistrationData((Registration)registration, (ExecutionYear)this.year) != null)).collect(Collectors.toSet());
    }

    private static boolean isAgreementPartOfMobilityReport(Registration registration) {
        return A3esInstance.getInstance().getMobilityAgreementsSet().contains(registration.getRegistrationProtocol());
    }

    private static void fillStudentsEnroled(A3esStudentsBean data, Collection<Registration> registrations) {
        data.addField("q-II.5.1.1", "studentsEnroled", String.valueOf(registrations.size()), A3esExportService._UNLIMITED);
    }

    private static void fillStudentsByGender(A3esStudentsBean data, Collection<Registration> registrations) {
        data.addField("q-II.5.1.2.a", "studentsMale", A3esHarvestStudentsDataService.getPercentOfStudentsByGender(registrations, Gender.MALE), A3esExportService._UNLIMITED);
        data.addField("q-II.5.1.2.b", "studentsFemale", A3esHarvestStudentsDataService.getPercentOfStudentsByGender(registrations, Gender.FEMALE), A3esExportService._UNLIMITED);
    }

    private static String getPercentOfStudentsByGender(Collection<Registration> registrations, Gender gender) {
        int total = registrations.size();
        if (total == 0) {
            return "0 %";
        }
        long filtered = registrations.stream().filter(r -> r.getPerson().getGender() == gender).count();
        return new BigDecimal(filtered).divide(new BigDecimal(total), 2, RoundingMode.HALF_EVEN).multiply(new BigDecimal(100)).stripTrailingZeros().toPlainString() + " %";
    }

    private void fillStudentsByCurricularYear(A3esStudentsBean data, Collection<Registration> registrations) {
        for (Map.Entry<Integer, Collection<Registration>> entry : this.groupStudentsByCurricularYear(registrations).entrySet()) {
            Integer curricularYear = entry.getKey();
            int number = entry.getValue().size();
            CycleType cycleType = this.degreeCurricularPlan.getDegreeType().getFirstOrderedCycleType();
            int cycle = cycleType == null ? 1 : cycleType.getWeight();
            data.addField("q-II.5.1.3." + curricularYear, "studentsCurricularYear" + curricularYear + cycle, String.valueOf(number), A3esExportService._UNLIMITED);
        }
    }

    private Map<Integer, Collection<Registration>> groupStudentsByCurricularYear(Collection<Registration> registrations) {
        ArrayListMultimap registrationsByYear = ArrayListMultimap.create();
        for (Registration registration : registrations) {
            int curricularYear = RegistrationServices.getCurricularYear((Registration)registration, (ExecutionYear)this.year).getResult();
            registrationsByYear.put((Object)curricularYear, (Object)registration);
        }
        return registrationsByYear.asMap();
    }

    private static void fillStudentsByForeignNationality(A3esStudentsBean data, Collection<Registration> registrations) {
        data.addField("studentsByForeignNationality", "studentsByForeignNationality", A3esHarvestStudentsDataService.getPercentOfStudentsByForeignNationality(registrations), A3esExportService._UNLIMITED);
    }

    private static String getPercentOfStudentsByForeignNationality(Collection<Registration> registrations) {
        int total = registrations.size();
        if (total == 0) {
            return "0 %";
        }
        long filtered = registrations.stream().filter(r -> r.getPerson().getCountry() != null && !r.getPerson().getCountry().isDefaultCountry()).count();
        return new BigDecimal(filtered).divide(new BigDecimal(total), 2, RoundingMode.HALF_EVEN).multiply(new BigDecimal(100)).stripTrailingZeros().toPlainString() + " %";
    }

    private void fillStudentsByBranch(A3esStudentsBean data, Collection<Registration> registrations) {
        HashMultimap registrationsByBranch = HashMultimap.create();
        registrations.forEach(arg_0 -> A3esHarvestStudentsDataService.lambda$fillStudentsByBranch$8((Multimap)registrationsByBranch, arg_0));
        data.addField("studentsByBranch", "studentsByBranch", registrationsByBranch.asMap().entrySet().stream().sorted((x, y) -> ((String)x.getKey()).compareTo((String)y.getKey())).map(e -> (String)e.getKey() + "=" + ((Collection)e.getValue()).size()).collect(Collectors.joining(";")), A3esExportService._3000);
    }

    private static /* synthetic */ void lambda$fillStudentsByBranch$8(Multimap registrationsByBranch, Registration r) {
        String branch = r.getLastStudentCurricularPlan().getMajorBranchNames();
        if (StringUtils.isEmpty((String)branch)) {
            registrationsByBranch.put((Object)LegalPTUtil.bundle("label.noBranch", new String[0]), (Object)r);
        } else {
            registrationsByBranch.put((Object)branch, (Object)r);
        }
    }
}

