/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.legalpt.dto.a3es;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.fenixedu.academic.domain.Degree;
import org.fenixedu.academic.domain.DegreeCurricularPlan;
import org.fenixedu.academic.domain.Teacher;
import org.fenixedu.bennu.IBean;
import org.fenixedu.bennu.TupleDataSourceBean;
import org.fenixedu.legalpt.domain.a3es.A3esProcess;
import org.fenixedu.legalpt.dto.a3es.A3esCourseBean;
import org.fenixedu.legalpt.dto.a3es.A3esDegreeBean;
import org.fenixedu.legalpt.dto.a3es.A3esPeriodBean;
import org.fenixedu.legalpt.dto.a3es.A3esStudentsBean;
import org.fenixedu.legalpt.dto.a3es.A3esTeacherBean;
import org.fenixedu.legalpt.services.a3es.process.A3esHarvestCoursesDataService;
import org.fenixedu.legalpt.services.a3es.process.A3esHarvestDegreeDataService;
import org.fenixedu.legalpt.services.a3es.process.A3esHarvestStudentsDataService;
import org.fenixedu.legalpt.services.a3es.process.A3esHarvestTeachersDataService;
import org.fenixedu.treasury.services.integration.FenixEDUTreasuryPlatformDependentServices;
import org.joda.time.DateTime;

public class A3esProcessBean
extends A3esPeriodBean
implements IBean {
    private A3esProcess process;
    private Teacher teacher;
    private String identifier;
    private String name;
    private String description;
    private DegreeCurricularPlan degreeCurricularPlan;
    private List<TupleDataSourceBean> degreeCurricularPlanDataSource;
    private A3esDegreeBean degreeData;
    private A3esStudentsBean studentsData;
    private Set<A3esCourseBean> coursesData;
    private Set<A3esTeacherBean> teachersData;
    private String user;
    private String password;
    private String formId;
    private List<String> selectedIds = new ArrayList<String>();

    public A3esProcessBean() {
        this.updateDataSources();
    }

    public A3esProcessBean(A3esProcess process) {
        this(process, null);
    }

    public A3esProcessBean(A3esProcess process, Teacher teacher) {
        this.setProcess(process);
        this.setTeacher(teacher);
        this.setPeriod(process.getPeriod());
        this.setExecutionYear(process.getPeriod().getExecutionYear());
        this.setType(process.getPeriod().getType());
        this.setIdentifier(process.getIdentifier());
        this.setName(process.getName());
        this.setDescription(process.getDescription());
        this.setDegreeCurricularPlan(process.getDegreeCurricularPlan());
        this.updateDataSources();
    }

    public A3esProcess getProcess() {
        return this.process;
    }

    public void setProcess(A3esProcess input) {
        this.process = input;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public void setIdentifier(String input) {
        this.identifier = input;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String input) {
        this.name = input;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String input) {
        this.description = input;
    }

    public String getDegreeCode() {
        String code;
        String result = null;
        DegreeCurricularPlan plan = this.getDegreeCurricularPlan();
        Degree degree = plan == null ? null : plan.getDegree();
        String ministryCode = degree == null ? null : degree.getMinistryCode();
        String string = code = degree == null ? null : degree.getCode();
        if (ministryCode != null) {
            result = ministryCode;
        }
        if (code != null && !code.equals(ministryCode)) {
            result = result.isEmpty() ? code : result + " [" + code + "]";
        }
        return result;
    }

    public String getExternalId() {
        return this.getProcess().getExternalId();
    }

    public DateTime getVersioningCreationDate() {
        return FenixEDUTreasuryPlatformDependentServices.readVersioningCreationDate((Object)((Object)this.getProcess()));
    }

    public String getPlanDescription() {
        return A3esProcess.getPlanDescription(this.getDegreeCurricularPlan());
    }

    public DegreeCurricularPlan getDegreeCurricularPlan() {
        return this.degreeCurricularPlan;
    }

    public void setDegreeCurricularPlan(DegreeCurricularPlan input) {
        this.degreeCurricularPlan = input;
    }

    public List<TupleDataSourceBean> getDegreeCurricularPlanDataSource() {
        if (this.degreeCurricularPlanDataSource == null) {
            this.degreeCurricularPlanDataSource = new ArrayList<TupleDataSourceBean>();
        }
        return this.degreeCurricularPlanDataSource;
    }

    public A3esDegreeBean getDegreeData() {
        if (this.degreeData == null) {
            this.degreeData = new A3esDegreeBean();
        }
        return this.degreeData;
    }

    public A3esStudentsBean getStudentsData() {
        if (this.studentsData == null) {
            this.studentsData = new A3esStudentsBean();
        }
        return this.studentsData;
    }

    public Set<A3esCourseBean> getCoursesData() {
        if (this.coursesData == null) {
            this.coursesData = new HashSet<A3esCourseBean>();
        }
        return this.coursesData;
    }

    public Set<A3esTeacherBean> getTeachersData() {
        if (this.teachersData == null) {
            this.teachersData = new HashSet<A3esTeacherBean>();
        }
        return this.teachersData;
    }

    public Teacher getTeacher() {
        return this.teacher;
    }

    public void setTeacher(Teacher input) {
        this.teacher = input;
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getFormId() {
        return this.formId;
    }

    public void setFormId(String formId) {
        this.formId = formId;
    }

    public List<String> getSelectedIds() {
        return this.selectedIds;
    }

    public void setSelectedIds(List<String> input) {
        this.selectedIds = input;
    }

    @Override
    public void updateDataSources() {
        super.updateDataSources();
        this.updateDegreeCurricularPlanDataSource();
    }

    private void updateDegreeCurricularPlanDataSource() {
        if (this.getDegreeCurricularPlanDataSource().isEmpty() && this.getExecutionYear() != null) {
            Degree.readBolonhaDegrees().stream().flatMap(d -> d.getDegreeCurricularPlansForYear(this.getExecutionYear()).stream()).sorted(DegreeCurricularPlan.COMPARATOR_BY_PRESENTATION_NAME).map(x -> {
                TupleDataSourceBean tuple = new TupleDataSourceBean();
                tuple.setId(x.getExternalId());
                tuple.setText(A3esProcess.getPlanDescription(x));
                return tuple;
            }).collect(Collectors.toCollection(() -> this.getDegreeCurricularPlanDataSource()));
        }
    }

    public void updateInfoData() {
        if (this.getDegreeData().getFields().isEmpty() && this.getExecutionYear() != null && this.getDegreeCurricularPlan() != null) {
            new A3esHarvestDegreeDataService(this);
        }
        if (this.getStudentsData().getFields().isEmpty() && this.getExecutionYear() != null && this.getDegreeCurricularPlan() != null) {
            new A3esHarvestStudentsDataService(this);
        }
    }

    public void updateCoursesData() {
        if (this.getCoursesData().isEmpty() && this.getExecutionYear() != null && this.getDegreeCurricularPlan() != null) {
            new A3esHarvestCoursesDataService(this);
        }
    }

    public void updateTeachersData() {
        if (this.getTeachersData().isEmpty() && this.getExecutionYear() != null && this.getDegreeCurricularPlan() != null) {
            new A3esHarvestTeachersDataService(this);
        }
    }
}

