/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.commons.spreadsheet.styles.xssf;

import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFFont;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.fenixedu.commons.spreadsheet.styles.xssf.XCellStyle;

public class XFontColor
extends XCellStyle {
    private final IndexedColors color;

    public XFontColor(IndexedColors color) {
        this.color = color;
    }

    @Override
    protected void appendToStyle(XSSFWorkbook book, XSSFCellStyle style, XSSFFont font) {
        font.setColor(this.color.getIndex());
    }

    @Override
    public XSSFCellStyle getStyle(XSSFWorkbook book) {
        XSSFCellStyle style = book.createCellStyle();
        XSSFFont font = book.createFont();
        this.appendToStyle(book, style, font);
        style.setFont((Font)font);
        return style;
    }

    public boolean equals(Object obj) {
        if (obj instanceof XFontColor) {
            XFontColor fontColor = (XFontColor)obj;
            return this.color.equals((Object)fontColor.color);
        }
        return false;
    }

    public int hashCode() {
        return this.color.hashCode();
    }
}

