/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.commons.spreadsheet;

import java.io.IOException;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.poi.ss.formula.Formula;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.fenixedu.commons.i18n.LocalizedString;
import org.fenixedu.commons.spreadsheet.AbstractSheetBuilder;
import org.fenixedu.commons.spreadsheet.SheetData;
import org.fenixedu.commons.spreadsheet.converters.CellConverter;
import org.fenixedu.commons.spreadsheet.converters.LocalizedStringCellConverter;
import org.fenixedu.commons.spreadsheet.converters.excel.BigDecimalCellConverter;
import org.fenixedu.commons.spreadsheet.converters.excel.IntegerCellConverter;
import org.fenixedu.commons.spreadsheet.converters.xssf.DateTimeCellConverter;
import org.fenixedu.commons.spreadsheet.converters.xssf.LocalDateCellConverter;
import org.fenixedu.commons.spreadsheet.converters.xssf.MultiLanguageStringCellConverter;
import org.fenixedu.commons.spreadsheet.converters.xssf.YearMonthDayCellConverter;
import org.fenixedu.commons.spreadsheet.styles.xssf.XCellAlignment;
import org.fenixedu.commons.spreadsheet.styles.xssf.XCellBorder;
import org.fenixedu.commons.spreadsheet.styles.xssf.XCellFillForegroundColor;
import org.fenixedu.commons.spreadsheet.styles.xssf.XCellFillPattern;
import org.fenixedu.commons.spreadsheet.styles.xssf.XCellStyle;
import org.fenixedu.commons.spreadsheet.styles.xssf.XCellVerticalAlignment;
import org.fenixedu.commons.spreadsheet.styles.xssf.XCellWrapText;
import org.fenixedu.commons.spreadsheet.styles.xssf.XComposedCellStyle;
import org.fenixedu.commons.spreadsheet.styles.xssf.XFontColor;
import org.fenixedu.commons.spreadsheet.styles.xssf.XFontHeight;
import org.fenixedu.commons.spreadsheet.styles.xssf.XFontWeight;
import org.joda.time.DateTime;
import org.joda.time.LocalDate;
import org.joda.time.YearMonthDay;

@Deprecated
class DocxBuilder
extends AbstractSheetBuilder {
    static Map<Class<?>, CellConverter> BASE_CONVERTERS = new HashMap();
    private static XCellStyle HEADER_STYLE;
    private XCellStyle headerStyle;
    int usefulAreaStart;
    int usefulAreaEnd;

    DocxBuilder() {
        this.converters.putAll(BASE_CONVERTERS);
        this.headerStyle = HEADER_STYLE;
    }

    protected void setValue(XSSFWorkbook book, XSSFCell cell, Object value, short span) {
        this.setValue(book, cell, value, span, null);
    }

    private void setValue(XSSFWorkbook book, XSSFCell cell, Object value, short span, XSSFCellStyle style) {
        if (value != null) {
            Object content = this.convert(value);
            if (content instanceof Boolean) {
                cell.setCellValue(((Boolean)content).booleanValue());
            } else if (content instanceof Double) {
                cell.setCellValue(((Double)content).doubleValue());
            } else if (content instanceof String) {
                cell.setCellValue((String)content);
            } else if (content instanceof GregorianCalendar) {
                cell.setCellValue((Calendar)((GregorianCalendar)content));
            } else if (content instanceof Date) {
                cell.setCellValue((Date)content);
            } else if (content instanceof RichTextString) {
                cell.setCellValue((RichTextString)content);
            } else if (!(content instanceof Formula)) {
                cell.setCellValue(content.toString());
            }
        } else {
            cell.setCellValue((String)null);
        }
        if (span > 1) {
            CellRangeAddress region = new CellRangeAddress(cell.getRowIndex(), cell.getRowIndex(), cell.getColumnIndex(), cell.getColumnIndex() + span - 1);
            cell.getSheet().addMergedRegion(region);
        }
        cell.setCellStyle((CellStyle)style);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void build(Map<String, SheetData<?>> sheets, Set<String> sheetNames, OutputStream output) throws IOException {
        try {
            XSSFWorkbook book = new XSSFWorkbook();
            XSSFCellStyle xssfHeaderStyle = this.headerStyle.getStyle(book);
            for (String sheetName : sheetNames) {
                XSSFRow row;
                XSSFSheet sheet = book.createSheet(sheetName);
                int rownum = 0;
                int colnum = 0;
                SheetData<?> data = sheets.get(sheetName);
                if (!((List)data.headers.get(0)).isEmpty()) {
                    for (List headerRow : data.headers) {
                        colnum = 0;
                        row = sheet.createRow(rownum++);
                        for (SheetData.Cell cell : headerRow) {
                            this.setValue(book, row.createCell(colnum++), cell.value, cell.span, xssfHeaderStyle);
                            colnum = colnum + cell.span - 1;
                        }
                    }
                }
                this.usefulAreaStart = rownum;
                for (List line : data.matrix) {
                    colnum = 0;
                    row = sheet.createRow(rownum++);
                    for (SheetData.Cell cell : line) {
                        this.setValue(book, row.createCell(colnum++), cell.value, cell.span);
                        colnum = colnum + cell.span - 1;
                    }
                }
                this.usefulAreaEnd = rownum - 1;
                if (!data.hasFooter()) continue;
                colnum = 0;
                XSSFRow row2 = sheet.createRow(rownum++);
                for (SheetData.Cell cell : data.footer) {
                    this.setValue(book, row2.createCell(colnum++), cell.value, cell.span);
                    colnum = colnum + cell.span - 1;
                }
            }
            book.write(output);
        }
        finally {
            output.flush();
            output.close();
        }
    }

    static {
        BASE_CONVERTERS.put(Integer.class, (CellConverter)new IntegerCellConverter());
        BASE_CONVERTERS.put(DateTime.class, new DateTimeCellConverter());
        BASE_CONVERTERS.put(YearMonthDay.class, new YearMonthDayCellConverter());
        BASE_CONVERTERS.put(LocalDate.class, new LocalDateCellConverter());
        BASE_CONVERTERS.put(BigDecimal.class, (CellConverter)new BigDecimalCellConverter());
        BASE_CONVERTERS.put(MultiLanguageStringCellConverter.class, new MultiLanguageStringCellConverter());
        BASE_CONVERTERS.put(LocalizedString.class, (CellConverter)new LocalizedStringCellConverter());
        HEADER_STYLE = new XComposedCellStyle(){
            {
                IndexedColors black = IndexedColors.BLACK;
                IndexedColors gray = IndexedColors.GREY_25_PERCENT;
                this.merge(new XFontColor(black));
                this.merge(new XFontWeight(700));
                this.merge(new XFontHeight(8));
                this.merge(new XCellAlignment(2));
                this.merge(new XCellFillForegroundColor(gray));
                this.merge(new XCellFillPattern(1));
                this.merge(new XCellBorder(1));
                this.merge(new XCellVerticalAlignment(1));
                this.merge(new XCellWrapText(true));
            }
        };
    }
}

