/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.ulisboa.integration.sas.service.transform;

import java.io.IOException;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.fenixedu.ulisboa.integration.sas.dto.ScholarshipStudentOtherYearBean;
import org.fenixedu.ulisboa.integration.sas.service.transform.OtherYearScholarshipXlsTransformService;
import org.fenixedu.ulisboa.integration.sas.util.SASDomainException;

public class ContractualisationScholarshipXlsTransformService
extends OtherYearScholarshipXlsTransformService {
    public ContractualisationScholarshipXlsTransformService(POIFSFileSystem poifsFileSystem) {
        super(poifsFileSystem);
    }

    @Override
    public boolean checkExcelFormat(HSSFSheet sheet) throws IOException {
        int columnsExpected;
        int columnsRead = Integer.valueOf(String.valueOf(sheet.getRow(0).getLastCellNum()));
        if (columnsRead == (columnsExpected = ScholarshipStudentOtherYearBean.CONTRACTUALISATION_DOCUMENT_BI + 1)) {
            return true;
        }
        throw new SASDomainException("error.fileFormatDoesNotMatchRequest.expected", new String[]{String.valueOf(columnsExpected), String.valueOf(columnsRead)});
    }

    @Override
    protected void readSpreadsheetRow(HSSFRow row, ScholarshipStudentOtherYearBean bean) {
        bean.setInstitutionCode(this.getValueFromColumnMayBeNull(row, ScholarshipStudentOtherYearBean.INSTITUTION_CODE));
        bean.setInstitutionName(this.getValueFromColumnMayBeNull(row, ScholarshipStudentOtherYearBean.INSTITUTION_NAME));
        bean.setCandidacyNumber(this.getValueFromColumnMayBeNull(row, ScholarshipStudentOtherYearBean.CANDIDACY_NUMBER));
        try {
            bean.setStudentNumber(Integer.parseInt(this.getValueFromColumnMayBeNull(row, ScholarshipStudentOtherYearBean.STUDENT_NUMBER)));
        }
        catch (NumberFormatException e) {
            bean.setStudentNumber(null);
        }
        bean.setStudentName(this.getValueFromColumnMayBeNull(row, ScholarshipStudentOtherYearBean.STUDENT_NAME));
        bean.setDocumentTypeName(this.getValueFromColumnMayBeNull(row, ScholarshipStudentOtherYearBean.DOCUMENT_TYPE_NAME));
        bean.setDocumentNumber(this.getValueFromColumnMayBeNull(row, ScholarshipStudentOtherYearBean.DOCUMENT_NUMBER));
        bean.setDegreeCode(this.getValueFromColumnMayBeNull(row, ScholarshipStudentOtherYearBean.DEGREE_CODE));
        bean.setDegreeName(this.getValueFromColumnMayBeNull(row, ScholarshipStudentOtherYearBean.DEGREE_NAME));
        bean.setDegreeTypeName(this.getValueFromColumnMayBeNull(row, ScholarshipStudentOtherYearBean.DEGREE_TYPE_NAME));
        bean.setCode(this.getValueFromColumnMayBeNull(row, ScholarshipStudentOtherYearBean.CODE));
        bean.setDocumentBINumber(this.getValueFromColumnMayBeNull(row, ScholarshipStudentOtherYearBean.CONTRACTUALISATION_DOCUMENT_BI));
    }

    @Override
    protected void writeSpreadsheetRow(HSSFRow row, ScholarshipStudentOtherYearBean bean) {
        this.writeCellString(row, ScholarshipStudentOtherYearBean.INSTITUTION_CODE, bean.getInstitutionCode());
        this.writeCellInteger(row, ScholarshipStudentOtherYearBean.STUDENT_NUMBER, bean.getStudentNumber());
        this.writeCellString(row, ScholarshipStudentOtherYearBean.DEGREE_CODE, bean.getDegreeCode());
        this.writeCellInteger(row, ScholarshipStudentOtherYearBean.COUNT_NUMBER_OF_DEGREE_CHANGES, bean.getNumberOfDegreeChanges());
        this.writeCellString(row, ScholarshipStudentOtherYearBean.CURRENT_YEAR_HAS_MADE_DEGREE_CHANGE, this.booleanToString(bean.getHasMadeDegreeChangeOnCurrentYear()));
        this.writeCellString(row, ScholarshipStudentOtherYearBean.REGISTERED, this.booleanToString(bean.getEnroled()));
        this.writeCellLocalDate(row, ScholarshipStudentOtherYearBean.REGISTRATION_DATE, bean.getEnroled() != false ? bean.getEnrolmentDate() : null);
        this.writeCellString(row, ScholarshipStudentOtherYearBean.CONTRACTUALISATION_REGIME, bean.getEnroled() != false ? bean.getRegime() : null);
        this.writeCellBigDecimal(row, ScholarshipStudentOtherYearBean.CONTRACTUALISATION_NUMBER_OF_ECTS, bean.getEnroled() != false ? bean.getNumberOfEnrolledECTS() : null);
        this.writeCellBigDecimal(row, ScholarshipStudentOtherYearBean.CONTRACTUALISATION_GRATUITY, bean.getEnroled() != false ? bean.getGratuityAmount() : null);
        this.writeCellInteger(row, ScholarshipStudentOtherYearBean.CONTRACTUALISATION_NUMBER_OF_MONTHS_EXECUTION_YEAR, bean.getEnroled() != false ? bean.getNumberOfMonthsExecutionYear() : null);
        this.writeCellString(row, ScholarshipStudentOtherYearBean.CONTRACTUALISATION_FIRST_MONTH_EXECUTION_YEAR, bean.getEnroled() != false ? this.toMonthString(bean.getFirstMonthExecutionYear()) : null);
    }
}

