/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.ulisboa.integration.sas.service.process;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.organizationalStructure.Unit;
import org.fenixedu.bennu.core.domain.Bennu;
import org.fenixedu.bennu.io.domain.GenericFile;
import org.fenixedu.ulisboa.integration.sas.domain.ScholarshipReportFile;
import org.fenixedu.ulisboa.integration.sas.domain.ScholarshipReportRequest;
import org.fenixedu.ulisboa.integration.sas.service.process.AbstractFillScholarshipService;
import org.fenixedu.ulisboa.integration.sas.service.process.FillScholarshipFirstYearService;
import org.fenixedu.ulisboa.integration.sas.service.process.FillScholarshipServiceOtherYearService;
import org.fenixedu.ulisboa.integration.sas.service.transform.AbstractScholarshipXlsTransformService;
import org.fenixedu.ulisboa.integration.sas.service.transform.ContractualisationScholarshipXlsTransformService;
import org.fenixedu.ulisboa.integration.sas.service.transform.FirstYearScholarshipXlsTransformService;
import org.fenixedu.ulisboa.integration.sas.service.transform.OtherYearScholarshipXlsTransformService;
import org.fenixedu.ulisboa.integration.sas.util.SASDomainException;
import org.joda.time.DateTime;

public class ScholarshipService {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static GenericFile processScholarshipFile(ScholarshipReportRequest request) {
        ScholarshipReportFile file = request.getParameterFile();
        try {
            POIFSFileSystem poifs = new POIFSFileSystem(file.getStream());
            AbstractScholarshipXlsTransformService xlsService = request.getContractualisation() ? new ContractualisationScholarshipXlsTransformService(poifs) : (request.getFirstYearOfCycle() ? new FirstYearScholarshipXlsTransformService(poifs) : new OtherYearScholarshipXlsTransformService(poifs));
            xlsService.readExcelFile();
            AbstractFillScholarshipService service = request.getContractualisation() || !request.getFirstYearOfCycle() ? new FillScholarshipServiceOtherYearService() : new FillScholarshipFirstYearService();
            service.fillAcademicInfos(xlsService.getStudentLines(), request.getExecutionYear(), request.getFirstYearOfCycle());
            HSSFWorkbook hssfWorkbook = xlsService.writeExcelFile(poifs);
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            try {
                hssfWorkbook.write((OutputStream)outputStream);
                byte[] content = outputStream.toByteArray();
                ScholarshipReportFile scholarshipReportFile = request.createResultFile(ScholarshipService.getFilename(request), content);
                return scholarshipReportFile;
            }
            catch (Exception e) {
                throw new DomainException("error.ScholarshipService.spreadsheet.generation.failed", (Throwable)e, new String[0]);
            }
            finally {
                try {
                    outputStream.close();
                }
                catch (IOException e) {
                    throw new DomainException("error.ScholarshipService.spreadsheet.generation.failed", (Throwable)e, new String[0]);
                }
            }
        }
        catch (SASDomainException e1) {
            throw e1;
        }
        catch (IOException e1) {
            throw new DomainException(e1.getMessage(), new String[0]);
        }
    }

    private static String getFilename(ScholarshipReportRequest request) {
        Unit institutionUnit = Bennu.getInstance().getInstitutionUnit();
        String acronym = institutionUnit.getAcronym();
        String title = acronym + "_Bolsas_";
        ExecutionYear executionInterval = request.getExecutionYear();
        String period = executionInterval == null ? "" : executionInterval.getQualifiedName().replace("/", "-").replace(" ", "-") + "_";
        return title + period + new DateTime().toString("yyyy-MM-dd_HH-mm-ss") + "_" + request.getParameterFile().getFilename();
    }
}

