/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.ulisboa.integration.sas.service.process;

import com.google.common.base.Objects;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang.StringUtils;
import org.fenixedu.academic.FenixEduAcademicConfiguration;
import org.fenixedu.academic.domain.Degree;
import org.fenixedu.academic.domain.ExecutionInterval;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.SchoolLevelType;
import org.fenixedu.academic.domain.StudentCurricularPlan;
import org.fenixedu.academic.domain.degree.DegreeType;
import org.fenixedu.academic.domain.degreeStructure.CycleType;
import org.fenixedu.academic.domain.organizationalStructure.Party;
import org.fenixedu.academic.domain.person.IDDocumentType;
import org.fenixedu.academic.domain.student.Registration;
import org.fenixedu.academic.domain.student.RegistrationRegimeType;
import org.fenixedu.academic.domain.student.RegistrationServices;
import org.fenixedu.academic.domain.student.Student;
import org.fenixedu.academic.domain.student.curriculum.CreditsReasonType;
import org.fenixedu.academic.domain.student.registrationStates.RegistrationState;
import org.fenixedu.academic.domain.student.services.StatuteServices;
import org.fenixedu.academic.domain.studentCurriculum.CurriculumLine;
import org.fenixedu.academic.domain.treasury.IAcademicTreasuryEvent;
import org.fenixedu.academic.domain.treasury.TreasuryBridgeAPIFactory;
import org.fenixedu.bennu.core.domain.Bennu;
import org.fenixedu.bennu.core.i18n.BundleUtil;
import org.fenixedu.ulisboa.integration.sas.domain.SasIngressionRegimeMapping_Base;
import org.fenixedu.ulisboa.integration.sas.domain.SasScholarshipCandidacy;
import org.fenixedu.ulisboa.integration.sas.domain.SchoolLevelTypeMapping;
import org.fenixedu.ulisboa.integration.sas.domain.SocialServicesConfiguration;
import org.fenixedu.ulisboa.integration.sas.dto.AbstractScholarshipStudentBean;
import org.fenixedu.ulisboa.integration.sas.service.SasDataShareAuthorizationServices;
import org.fenixedu.ulisboa.integration.sas.service.process.FillScholarshipException;
import org.joda.time.DateTime;
import org.joda.time.LocalDate;
import org.joda.time.ReadablePartial;

public class AbstractFillScholarshipService {
    private static final String REGISTRATION_TYPE_CANCELED = "CANCELED";
    private final Multimap<AbstractScholarshipStudentBean, MessageEntry> messages = ArrayListMultimap.create();
    protected static final Map<String, IDDocumentType> ID_DOCUMENT_TYPE_MAPPING = Maps.newHashMap();
    public static final String REGIME_FULL_TIME = "Tempo integral";
    public static final String REGIME_FULL_TIME_WORKING_STUDENT = "Trabalhador estudante tempo integral";
    public static final String REGIME_PARTIAL_TIME = "Tempo parcial";
    public static final String REGIME_PARTIAL_TIME_WORKING_STUDENT = "Trabalhador estudante tempo parcial";
    public static final String REGIME_PROFESSIONAL_INTERNSHIP = "Est\u00e1gio Profissional";
    public static final String ERROR_OBSERVATION = "ERRO";
    public static final String WARNING_OBSERVATION = "AVISO";

    public void fillAcademicInfos(Collection<AbstractScholarshipStudentBean> scholarshipStudentBeans, ExecutionYear requestYear, boolean firstYearOfCycle) {
        this.messages.clear();
        for (AbstractScholarshipStudentBean bean : scholarshipStudentBeans) {
            try {
                this.fillBeanWithAcademicInfos(bean, this.getRegistrationByAbstractScholarshipStudentBean(bean, requestYear), requestYear, firstYearOfCycle);
            }
            catch (FillScholarshipException e) {
                this.addError(bean, false, e.getMessage(), new String[0]);
                bean.setObservations(this.formatObservations(bean));
            }
        }
    }

    public Registration getRegistrationByAbstractScholarshipStudentBean(AbstractScholarshipStudentBean bean, ExecutionYear requestYear) {
        return this.findRegistration(this.findStudent(bean, requestYear), bean, requestYear);
    }

    private Registration findRegistration(Student student, AbstractScholarshipStudentBean bean, ExecutionYear requestYear) {
        Collection<Degree> degrees = this.findDegree(bean);
        Predicate<Registration> isEnroled = r -> !this.getEnroledCurriculumLines((Registration)r, requestYear).isEmpty();
        HashSet registrations = Sets.newHashSet();
        for (Degree degree : degrees) {
            registrations.addAll(student.getRegistrationsFor(degree).stream().filter(isEnroled).collect(Collectors.toSet()));
        }
        if (registrations.size() == 1) {
            return (Registration)registrations.iterator().next();
        }
        if (registrations.size() > 1) {
            this.addError(bean, false, "message.error.multiple.registrations", new String[0]);
            bean.setObservations(this.formatObservations(bean));
            throw new FillScholarshipException("message.error.multiple.registrations", new String[0]);
        }
        Collection possibleDegreeTypes = degrees.stream().map(d -> d.getDegreeType()).collect(Collectors.toSet());
        Predicate<Registration> degreeTypePredicate = r -> possibleDegreeTypes.contains(r.getDegreeType());
        Predicate<Registration> precedentDegreePredicate = r -> r.getDegree().getPrecedentDegreesSet().stream().anyMatch(pd -> Objects.equal((Object)pd.getMinistryCode(), (Object)bean.getDegreeCode()));
        Collection registrationsWithActiveEnrolments = student.getRegistrationsSet().stream().filter(isEnroled.and(degreeTypePredicate).and(precedentDegreePredicate)).collect(Collectors.toSet());
        if (registrationsWithActiveEnrolments.size() == 1) {
            Registration registration = (Registration)registrationsWithActiveEnrolments.iterator().next();
            this.addWarning(bean, true, "message.warning.input.degree.code.not.equals.to.active.degree.code", registration.getDegree().getCode());
            bean.setObservations(this.formatObservations(bean));
            return registration;
        }
        if (registrationsWithActiveEnrolments.size() > 1) {
            this.addError(bean, false, "message.error.input.registration.not.found.and.multiple.active.registrations", new String[0]);
            bean.setObservations(this.formatObservations(bean));
            throw new FillScholarshipException("message.error.input.registration.not.found.and.multiple.active.registrations", new String[0]);
        }
        this.addError(bean, false, "message.error.input.registration.not.found.and.no.active.registrations", new String[0]);
        bean.setObservations(this.formatObservations(bean));
        throw new FillScholarshipException("message.error.input.registration.not.found.and.no.active.registrations", new String[0]);
    }

    private Collection<Degree> findDegree(AbstractScholarshipStudentBean bean) {
        Collection degrees = Bennu.getInstance().getDegreesSet().stream().filter(d -> Objects.equal((Object)d.getMinistryCode(), (Object)bean.getDegreeCode()) || Objects.equal((Object)d.getCode(), (Object)bean.getDegreeCode())).collect(Collectors.toSet());
        if (degrees.isEmpty()) {
            this.addError(bean, false, "message.error.degree.not.found", new String[0]);
            bean.setObservations(this.formatObservations(bean));
            throw new FillScholarshipException("message.error.degree.not.found", new String[0]);
        }
        return degrees;
    }

    private Student findStudent(AbstractScholarshipStudentBean bean, ExecutionYear requestYear) {
        Person person = this.findPerson(bean, requestYear);
        if (person == null) {
            this.addError(bean, false, "message.error.person.not.found", new String[0]);
            throw new FillScholarshipException("message.error.person.not.found", new String[0]);
        }
        if (person.getStudent() == null) {
            this.addError(bean, false, "message.error.degree.not.found", new String[0]);
            throw new FillScholarshipException("message.error.person.is.not.a.student", new String[0]);
        }
        if (bean.getStudentNumber() == null) {
            this.addWarning(bean, false, "message.warning.input.student.number.is.empty", new String[0]);
        }
        return person.getStudent();
    }

    protected Person findPerson(AbstractScholarshipStudentBean bean, ExecutionYear requestYear) {
        Person person;
        Party party;
        Collection withDocumentId = Person.readByDocumentIdNumber((String)bean.getDocumentNumber());
        if (withDocumentId.size() == 1) {
            return this.ensureDocumentIdType((Person)withDocumentId.iterator().next(), bean);
        }
        if (withDocumentId.size() > 1) {
            this.addWarning(bean, false, "message.warning.multiple.people.found.with.same.document.id", new String[0]);
            return this.findPersonByName(withDocumentId, bean);
        }
        if (bean.getDocumentNumber().length() != 0) {
            String documentIdWithoutCheckDigit = bean.getDocumentNumber().substring(0, bean.getDocumentNumber().length() - 1);
            Collection withPartialDocumentId = Person.readByDocumentIdNumber((String)documentIdWithoutCheckDigit);
            if (withPartialDocumentId.size() == 1) {
                if (!(bean.getDocumentBINumber() != null && bean.getDocumentBINumber().equals(documentIdWithoutCheckDigit) || this.hasSameCheckDigitValue(bean.getDocumentNumber(), (Person)withPartialDocumentId.iterator().next()))) {
                    this.addWarning(bean, false, "message.warning.input.document.id.not.equals.without.control.digit", new String[0]);
                }
                return this.ensureDocumentIdType((Person)withPartialDocumentId.iterator().next(), bean);
            }
            if (withPartialDocumentId.size() > 1) {
                if (bean.getDocumentBINumber() == null || !bean.getDocumentBINumber().equals(documentIdWithoutCheckDigit)) {
                    this.addWarning(bean, false, "message.warning.input.document.id.not.equals.without.control.digit", new String[0]);
                }
                this.addWarning(bean, false, "message.warning.multiple.people.found.with.same.document.id.without.control.digit", new String[0]);
                return this.findPersonByName(withPartialDocumentId, bean);
            }
            String documentIdWithoutCitizenCardSerial = bean.getDocumentNumber().substring(0, bean.getDocumentNumber().length() - 4);
            Collection withPartialDocumentIdWithoutCCSerial = Person.readByDocumentIdNumber((String)documentIdWithoutCitizenCardSerial);
            if (withPartialDocumentIdWithoutCCSerial.size() == 1) {
                if (bean.getDocumentBINumber() == null || !bean.getDocumentBINumber().equals(documentIdWithoutCitizenCardSerial)) {
                    this.addWarning(bean, false, "message.warning.input.document.id.not.equals.without.control.digit.and.serial", new String[0]);
                }
                return this.ensureDocumentIdType((Person)withPartialDocumentIdWithoutCCSerial.iterator().next(), bean);
            }
            if (withPartialDocumentIdWithoutCCSerial.size() > 1) {
                if (bean.getDocumentBINumber() == null || !bean.getDocumentBINumber().equals(documentIdWithoutCitizenCardSerial)) {
                    this.addWarning(bean, false, "message.warning.input.document.id.not.equals.without.control.digit.and.serial", new String[0]);
                }
                this.addWarning(bean, false, "message.warning.multiple.people.found.with.same.document.id.without.control.digit.and.serial", new String[0]);
                return this.findPersonByName(withPartialDocumentIdWithoutCCSerial, bean);
            }
            Collection studentsWithSameName = Person.findPerson((String)bean.getStudentName()).stream().filter(p -> p.getStudent() != null).collect(Collectors.toSet());
            for (Person person2 : studentsWithSameName) {
                Registration findRegistration = this.findRegistration(person2.getStudent(), bean, requestYear);
                if (!findRegistration.getNumber().equals(bean.getStudentNumber()) && (bean.getStudentNumber() == null || findRegistration.getStudent().getNumber().intValue() != bean.getStudentNumber().intValue())) continue;
                this.addWarning(bean, false, "message.warning.student.not.found.with.id.but.name.and.number.match", new String[0]);
                return person2;
            }
        }
        if (StringUtils.isNotBlank((String)bean.getFiscalCode()) && !StringUtils.equals((String)bean.getFiscalCode(), (String)FenixEduAcademicConfiguration.getConfiguration().getDefaultSocialSecurityNumber()) && (party = Person.readByContributorNumber((String)bean.getFiscalCode())) != null && (person = (Person)party).getName().equalsIgnoreCase(bean.getStudentName())) {
            this.addWarning(bean, false, "message.warning.student.not.found.with.id.but.name.and.social.number.match", new String[0]);
            return person;
        }
        return null;
    }

    private boolean hasSameCheckDigitValue(String candidacyIdDocumentNumber, Person person) {
        String inputDocumentIdCheckDigit = candidacyIdDocumentNumber.substring(candidacyIdDocumentNumber.length() - 1);
        String personDocumentIdCheckDigit = person.getIdentificationDocumentSeriesNumber() != null && person.getIdentificationDocumentSeriesNumber().length() > 0 ? person.getIdentificationDocumentSeriesNumber().substring(0, 1) : "";
        return inputDocumentIdCheckDigit.equals(personDocumentIdCheckDigit);
    }

    private Person findPersonByName(Collection<Person> toCheck, AbstractScholarshipStudentBean bean) {
        for (Person person : toCheck) {
            if (!person.getName().equalsIgnoreCase(bean.getStudentName())) continue;
            return this.ensureDocumentIdType(person, bean);
        }
        return null;
    }

    private Person ensureDocumentIdType(Person person, AbstractScholarshipStudentBean bean) {
        if (person.getIdDocumentType() != ID_DOCUMENT_TYPE_MAPPING.get(bean.getDocumentTypeName()) && !person.getIdDocumentType().name().equalsIgnoreCase(bean.getDocumentTypeName())) {
            this.addError(bean, false, "message.error.identity.document.type", new String[0]);
            throw new FillScholarshipException("message.error.identity.document.type", new String[0]);
        }
        return person;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fillBeanWithAcademicInfos(AbstractScholarshipStudentBean bean, Registration registration, ExecutionYear requestYear, boolean firstYearOfCycle) {
        try {
            this.validateStudentNumber(bean, registration);
            this.checkPreconditions(bean, registration, requestYear, firstYearOfCycle);
            this.fillSpecificInfo(bean, registration, requestYear);
            this.fillCommonInfo(bean, registration, requestYear);
        }
        catch (FillScholarshipException fillScholarshipException) {
        }
        finally {
            bean.setObservations(this.formatObservations(bean));
        }
    }

    private void validateStudentNumber(AbstractScholarshipStudentBean bean, Registration registration) {
        if (bean.getStudentNumber() != null && registration.getNumber().intValue() != bean.getStudentNumber().intValue()) {
            this.addWarning(bean, false, "message.warning.input.student.number.does.not.match.with.fenix", new String[0]);
        }
    }

    private void checkPreconditions(AbstractScholarshipStudentBean bean, Registration registration, ExecutionYear requestYear, boolean firstYearOfCycle) {
        RegistrationState lastRegistrationState = registration.getLastRegistrationState(requestYear);
        if (lastRegistrationState != null && !lastRegistrationState.isActive()) {
            if (lastRegistrationState.getType().getCode().equals(REGISTRATION_TYPE_CANCELED)) {
                this.addWarning(bean, false, "message.warning.registration.is.canceled", lastRegistrationState.getStateDate().toLocalDate().toString("yyyy-MM-dd"));
            } else {
                this.addWarning(bean, false, "message.warning.registration.is.not.active", requestYear.getQualifiedName());
            }
        }
        if (firstYearOfCycle && !AbstractFillScholarshipService.isFirstTimeInCycle(registration, requestYear)) {
            this.addWarning(bean, false, "message.warning.student.is.not.first.time", new String[0]);
        }
        if (AbstractFillScholarshipService.getCycleEnrolmentYears(registration, requestYear).isEmpty()) {
            this.addWarning(bean, false, "message.warning.registration.without.enrolments", new String[0]);
        }
        if (registration.hasReingression(requestYear)) {
            this.addWarning(bean, true, "message.warning.found.reingression.for.year", new String[0]);
        }
        if (!SasDataShareAuthorizationServices.isAuthorizationTypeActive()) {
            return;
        }
        if (!SasDataShareAuthorizationServices.isAnswered(registration.getPerson())) {
            this.addError(bean, false, "message.error.student.has.not.answer.data.sharing.survey", new String[0]);
            throw new FillScholarshipException("message.error.student.has.not.answer.data.sharing.survey", new String[0]);
        }
        if (!SasDataShareAuthorizationServices.isDataShareAllowed(registration.getPerson())) {
            this.addError(bean, false, "message.error.student.does.not.allow.data.sharing", new String[0]);
            throw new FillScholarshipException("message.error.student.does.not.allow.data.sharing", new String[0]);
        }
    }

    public static boolean isFirstTimeInCycle(Registration registration, ExecutionYear requestYear) {
        List<ExecutionYear> cycleEnrolmentYears = AbstractFillScholarshipService.getCycleEnrolmentYears(registration, requestYear);
        return cycleEnrolmentYears.size() > 1 ? false : cycleEnrolmentYears.isEmpty() || cycleEnrolmentYears.size() == 1 && cycleEnrolmentYears.iterator().next() == requestYear;
    }

    private void fillCommonInfo(AbstractScholarshipStudentBean bean, Registration registration, ExecutionYear requestYear) {
        bean.setCurricularYear(registration.getCurriculum(requestYear).getCurricularYear());
        bean.setGratuityAmount(this.getTuitionAmount(registration, requestYear));
        bean.setNumberOfMonthsExecutionYear(SocialServicesConfiguration.getInstance().getNumberOfMonthsOfAcademicYear());
        bean.setFirstMonthExecutionYear(this.getFirstMonthOfExecutionYear(registration, requestYear));
        bean.setStudentNumber(registration.getNumber());
        bean.setRegime(this.getRegime(bean, registration, requestYear));
        bean.setEnroled(this.isEnroled(registration, requestYear));
        LocalDate enrolmentDate = RegistrationServices.getEnrolmentDate((Registration)registration, (ExecutionYear)requestYear);
        bean.setEnrolmentDate(enrolmentDate != null ? enrolmentDate : requestYear.getBeginLocalDate());
        bean.setNumberOfEnrolledECTS(this.getEnroledCredits(registration, requestYear));
        bean.setCetQualificationOwner(this.isCETQualificationOwner(registration));
        bean.setCtspQualificationOwner(this.isCTSPQualificationOwner(registration));
        bean.setDegreeQualificationOwner(this.isDegreeQualificationOwner(registration));
        bean.setMasterQualificationOwner(this.isMasterQualificationOwner(registration));
        bean.setPhdQualificationOwner(this.isPhdQualificationOwner(registration));
        this.checkIfRegistrationDegreeIsCompleted(bean, registration);
        bean.setCycleIngressionYear(this.getCycleIngressionYear(bean, registration));
        bean.setCycleNumberOfEnrolmentsYears(AbstractFillScholarshipService.getCycleEnrolmentYears(registration, requestYear).size());
        bean.setNumberOfDegreeCurricularYears(this.getNumberOfDegreeCurricularYears(registration, requestYear));
        bean.setIngressionRegimeCodeWithDescription(Bennu.getInstance().getSasIngressionRegimeMappingsSet().stream().filter(ir -> ir.getIngressionType() == registration.getIngressionType()).map(SasIngressionRegimeMapping_Base::getRegimeCodeWithDescription).findFirst().orElse(null));
        bean.setIngressionRegimeCode(Bennu.getInstance().getSasIngressionRegimeMappingsSet().stream().filter(ir -> ir.getIngressionType() == registration.getIngressionType()).map(SasIngressionRegimeMapping_Base::getRegimeCode).findFirst().orElse(null));
        if (bean.getIngressionRegimeCode() == null || bean.getIngressionRegimeCodeWithDescription() == null) {
            this.addError(bean, false, "message.error.ingression.regime.mapping.is.missing", registration.getIngressionType() != null ? registration.getIngressionType().getLocalizedName() : "empty.ingression.regime");
        }
        if (SocialServicesConfiguration.getInstance().ingressionTypeRequiresExternalData(registration)) {
            this.addWarning(bean, true, "message.warning.ingression.type.requires.external.data", registration.getIngressionType().getLocalizedName(), RegistrationServices.getCurriculum((Registration)registration, (ExecutionYear)requestYear).getSumEctsCredits().toString());
        }
    }

    private Boolean isEnroled(Registration registration, ExecutionYear requestYear) {
        RegistrationState stateInDate = registration.getStateInDate(new DateTime());
        return stateInDate != null && stateInDate.isActive() && !this.getEnroledCurriculumLines(registration, requestYear).isEmpty();
    }

    private Integer getNumberOfDegreeCurricularYears(Registration registration, ExecutionYear requestYear) {
        return this.getStudentCurricularPlan(registration, requestYear).getDegreeCurricularPlan().getDurationInYears();
    }

    private Collection<SchoolLevelType> getPersonSchoolLevelTypes(Person person) {
        HashSet result = Sets.newHashSet();
        result.addAll(this.getCompletedQualificationsSchoolLevelTypes(person));
        result.addAll(this.getCompletedRegistrationSchoolLevelTypes(person.getStudent()));
        return result;
    }

    private Collection<SchoolLevelType> getCompletedRegistrationSchoolLevelTypes(Student student) {
        HashSet result = Sets.newHashSet();
        for (Registration registration : student.getRegistrationsSet()) {
            SchoolLevelTypeMapping schoolLevelTypeMapping;
            if (registration.getDegreeType().isIntegratedMasterDegree() && registration.hasConcludedCycle(CycleType.FIRST_CYCLE)) {
                result.add(SchoolLevelType.DEGREE);
            }
            if (!registration.isConcluded() && !registration.hasConcluded() || (schoolLevelTypeMapping = registration.getDegreeType().getSchoolLevelTypeMapping()) == null) continue;
            result.add(schoolLevelTypeMapping.getSchoolLevel());
        }
        return result;
    }

    private Collection<SchoolLevelType> getCompletedQualificationsSchoolLevelTypes(Person person) {
        return person.getStudent().getRegistrationsSet().stream().map(r -> r.getStudentCandidacy()).filter(o -> o != null).map(sc -> sc.getCompletedDegreeInformation().getSchoolLevel()).filter(o -> o != null).collect(Collectors.toSet());
    }

    private BigDecimal getTuitionAmount(Registration registration, ExecutionYear requestYear) {
        IAcademicTreasuryEvent treasuryEvent = TreasuryBridgeAPIFactory.implementation().getTuitionForRegistrationTreasuryEvent(registration, requestYear);
        if (treasuryEvent == null) {
            return BigDecimal.ZERO;
        }
        return treasuryEvent.getAmountWithVatToPay().subtract(treasuryEvent.getInterestsAmountToPay());
    }

    private Integer getFirstMonthOfExecutionYear(Registration registration, ExecutionYear requestYear) {
        LocalDate enrolmentDate = RegistrationServices.getEnrolmentDate((Registration)registration, (ExecutionYear)requestYear);
        if (enrolmentDate == null || requestYear.getBeginLocalDate().compareTo((ReadablePartial)enrolmentDate) > 0) {
            return requestYear.getBeginLocalDate().getMonthOfYear();
        }
        return enrolmentDate.getMonthOfYear();
    }

    private String getRegime(AbstractScholarshipStudentBean bean, Registration registration, ExecutionYear requestYear) {
        boolean partialRegime = registration.getRegimeType(requestYear) == RegistrationRegimeType.PARTIAL_TIME;
        boolean workingStudent = StatuteServices.findStatuteTypes((Registration)registration, (ExecutionInterval)requestYear).stream().anyMatch(s -> s.isWorkingStudentStatute());
        boolean professionalInternship = false;
        if (partialRegime) {
            if (workingStudent) {
                return REGIME_PARTIAL_TIME_WORKING_STUDENT;
            }
            return REGIME_PARTIAL_TIME;
        }
        if (workingStudent) {
            return REGIME_FULL_TIME_WORKING_STUDENT;
        }
        return REGIME_FULL_TIME;
    }

    public Integer getCycleIngressionYear(AbstractScholarshipStudentBean bean, Registration registration) {
        Registration cycleFirstRegistration = AbstractFillScholarshipService.getCycleRegistrations(registration).iterator().next();
        Integer cycleIngressionYear = cycleFirstRegistration.getStartExecutionYear().getBeginDateYearMonthDay().getYear();
        if (bean.getCycleIngressionYear() != null && !bean.getCycleIngressionYear().equals(cycleIngressionYear)) {
            this.addWarning(bean, false, "message.warning.input.ingression.date.does.not.match.with.fenix", String.valueOf(bean.getCycleIngressionYear()), String.valueOf(cycleIngressionYear));
        }
        return cycleIngressionYear;
    }

    protected static List<ExecutionYear> getCycleEnrolmentYears(Registration registration, ExecutionYear requestYear) {
        return AbstractFillScholarshipService.getCycleRegistrations(registration).stream().flatMap(r -> RegistrationServices.getEnrolmentYears((Registration)r).stream()).distinct().filter(ey -> ey.isBeforeOrEquals(requestYear)).sorted(ExecutionYear.COMPARATOR_BY_BEGIN_DATE).collect(Collectors.toList());
    }

    protected static List<Registration> getCycleRegistrations(Registration registration) {
        Collection degreeTypesToCheck = DegreeType.all().filter(dt -> dt.getFirstOrderedCycleType() == registration.getDegreeType().getFirstOrderedCycleType()).collect(Collectors.toSet());
        Collection degreesToProcess = registration.getStudent().getRegistrationsSet().stream().filter(r -> degreeTypesToCheck.contains(r.getDegreeType())).collect(Collectors.toSet());
        return degreesToProcess.stream().filter(r -> r.getStartExecutionYear().isBeforeOrEquals(registration.getStartExecutionYear())).flatMap(r -> Stream.concat(Stream.of(r), Stream.of(RegistrationServices.getRootRegistration((Registration)r)))).distinct().sorted(Registration.COMPARATOR_BY_START_DATE).collect(Collectors.toList());
    }

    public String getMessages(AbstractScholarshipStudentBean bean, boolean publicMessage) {
        return this.messages.containsKey((Object)bean) ? this.messages.get((Object)bean).stream().filter(m -> m.isPublicMessage() == publicMessage).map(m -> m.getMessage()).collect(Collectors.joining("\n")) : null;
    }

    public String formatObservations(AbstractScholarshipStudentBean bean) {
        if (!this.messages.containsKey((Object)bean)) {
            return "";
        }
        return this.messages.get((Object)bean).stream().map(m -> m.getMessage()).collect(Collectors.joining("\n"));
    }

    protected void addError(AbstractScholarshipStudentBean bean, boolean publicMessage, String message, String ... args) {
        this.messages.put((Object)bean, (Object)new MessageEntry(publicMessage, "ERRO: " + BundleUtil.getString((String)"resources/SasResources", (String)message, (String[])args)));
    }

    protected void addWarning(AbstractScholarshipStudentBean bean, boolean publicMessage, String message, String ... args) {
        this.messages.put((Object)bean, (Object)new MessageEntry(publicMessage, "AVISO: " + BundleUtil.getString((String)"resources/SasResources", (String)message, (String[])args)));
    }

    private StudentCurricularPlan getStudentCurricularPlan(Registration registration, ExecutionYear executionYear) {
        StudentCurricularPlan studentCurricularPlan = RegistrationServices.getStudentCurricularPlan((Registration)registration, (ExecutionYear)executionYear);
        if (studentCurricularPlan == null) {
            throw new FillScholarshipException("message.error.curricular.plan.not.found", new String[0]);
        }
        return studentCurricularPlan;
    }

    protected BigDecimal getEnroledCredits(Registration registration, ExecutionYear executionYear) {
        return this.sumCredits(this.getEnroledCurriculumLines(registration, executionYear).stream());
    }

    protected BigDecimal getApprovedCredits(Registration registration, ExecutionYear executionYear) {
        return this.sumCredits(this.getEnroledCurriculumLines(registration, executionYear).stream().filter(l -> l.isApproved()));
    }

    private Set<CurriculumLine> getEnroledCurriculumLines(Registration registration, ExecutionYear executionYear) {
        return RegistrationServices.getNormalEnroledCurriculumLines((Registration)registration, (ExecutionYear)executionYear, (boolean)true, this.getDismissalTypesToConsider());
    }

    private Set<CreditsReasonType> getDismissalTypesToConsider() {
        return Bennu.getInstance().getSocialServicesConfiguration().getCreditsReasonTypesSet();
    }

    private BigDecimal sumCredits(Stream<CurriculumLine> linesStream) {
        return linesStream.map(line -> line.getEctsCreditsForCurriculum()).reduce((x, y) -> x.add((BigDecimal)y)).orElse(BigDecimal.ZERO);
    }

    private Boolean isCETQualificationOwner(Registration registration) {
        return this.getPersonSchoolLevelTypes(registration.getPerson()).stream().filter(SchoolLevelTypeMapping::isCET).findAny().isPresent();
    }

    private Boolean isCTSPQualificationOwner(Registration registration) {
        return this.getPersonSchoolLevelTypes(registration.getPerson()).stream().filter(SchoolLevelTypeMapping::isCTSP).findAny().isPresent();
    }

    private Boolean isDegreeQualificationOwner(Registration registration) {
        return this.getPersonSchoolLevelTypes(registration.getPerson()).stream().filter(SchoolLevelTypeMapping::isDegree).findAny().isPresent();
    }

    private Boolean isMasterQualificationOwner(Registration registration) {
        return this.getPersonSchoolLevelTypes(registration.getPerson()).stream().filter(SchoolLevelTypeMapping::isMasterDegree).findAny().isPresent();
    }

    private Boolean isPhdQualificationOwner(Registration registration) {
        return this.getPersonSchoolLevelTypes(registration.getPerson()).stream().filter(SchoolLevelTypeMapping::isPhd).findAny().isPresent();
    }

    private void checkIfRegistrationDegreeIsCompleted(AbstractScholarshipStudentBean bean, Registration registration) {
        SchoolLevelType schoolLevelType;
        SchoolLevelTypeMapping schoolLevelTypeMapping = registration.getDegreeType().getSchoolLevelTypeMapping();
        SchoolLevelType schoolLevelType2 = schoolLevelType = schoolLevelTypeMapping == null ? null : schoolLevelTypeMapping.getSchoolLevel();
        if (bean.getCetQualificationOwner().booleanValue() && SchoolLevelTypeMapping.isCET(schoolLevelType)) {
            this.addWarning(bean, false, "message.warning.cet.level", new String[0]);
        }
        if (bean.getCtspQualificationOwner().booleanValue() && SchoolLevelTypeMapping.isCTSP(schoolLevelType)) {
            this.addWarning(bean, false, "message.warning.ctsp.level", new String[0]);
        }
        if (bean.getDegreeQualificationOwner().booleanValue() && SchoolLevelTypeMapping.isDegree(schoolLevelType)) {
            this.addWarning(bean, false, "message.warning.degree.level", new String[0]);
        }
        if (bean.getMasterQualificationOwner().booleanValue() && SchoolLevelTypeMapping.isMasterDegree(schoolLevelType)) {
            this.addWarning(bean, false, "message.warning.master.level", new String[0]);
        }
        if (bean.getPhdQualificationOwner().booleanValue() && SchoolLevelTypeMapping.isPhd(schoolLevelType)) {
            this.addWarning(bean, false, "message.warning.phd.level", new String[0]);
        }
    }

    protected void fillSpecificInfo(AbstractScholarshipStudentBean bean, Registration registration, ExecutionYear requestYear) {
    }

    public void addWarningIfRegistrationChangedToInactive(AbstractScholarshipStudentBean bean, SasScholarshipCandidacy candidacy) {
        BigDecimal beforeNumberOfEnrolledECTS = candidacy.getSasScholarshipData().getNumberOfEnrolledECTS();
        Registration registration = candidacy.getRegistration();
        if (bean.getNumberOfEnrolledECTS().compareTo(beforeNumberOfEnrolledECTS) != 0 && bean.getNumberOfEnrolledECTS().compareTo(BigDecimal.ZERO) == 0 && !registration.getActiveStateType().getActive()) {
            this.addWarning(bean, true, "message.warning.student.registration.state.inactive", registration.getActiveState().getStateDate().toLocalDate().toString("yyyy-MM-dd"));
        }
    }

    public boolean equal(AbstractScholarshipStudentBean bean, Object left, Object right, String fieldName) {
        if (Objects.equal((Object)left, (Object)right)) {
            return true;
        }
        this.addWarning(bean, false, "message.warning.data.has.changed", BundleUtil.getString((String)"resources/SasResources", (String)("label.SasScholarshipData." + fieldName), (String[])new String[0]));
        return false;
    }

    static {
        ID_DOCUMENT_TYPE_MAPPING.put("BI / N.\u00ba ID CIVIL", IDDocumentType.IDENTITY_CARD);
        ID_DOCUMENT_TYPE_MAPPING.put("Autoriza\u00e7\u00e3o de resid\u00eancia", IDDocumentType.RESIDENCE_AUTHORIZATION);
        ID_DOCUMENT_TYPE_MAPPING.put("Passaporte", IDDocumentType.PASSPORT);
        ID_DOCUMENT_TYPE_MAPPING.put("NIF", IDDocumentType.OTHER);
        ID_DOCUMENT_TYPE_MAPPING.put("Outros", IDDocumentType.OTHER);
    }

    public static class MessageEntry {
        private boolean publicMessage;
        private String message;

        public MessageEntry(boolean publicMessage, String message) {
            this.publicMessage = publicMessage;
            this.message = message;
        }

        public boolean isPublicMessage() {
            return this.publicMessage;
        }

        public String getMessage() {
            return this.message;
        }

        public void setPublicMessage(boolean publicMessage) {
            this.publicMessage = publicMessage;
        }

        public void setMessage(String message) {
            this.message = message;
        }
    }
}

