/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.legalpt.ui.raides;

import java.lang.annotation.Annotation;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import org.fenixedu.bennu.TupleDataSourceBean;
import org.fenixedu.bennu.core.domain.exceptions.DomainException;
import org.fenixedu.bennu.spring.portal.SpringFunctionality;
import org.fenixedu.legalpt.domain.mapping.LegalMapping;
import org.fenixedu.legalpt.domain.mapping.LegalMappingEntry;
import org.fenixedu.legalpt.domain.raides.RaidesInstance;
import org.fenixedu.legalpt.domain.raides.mapping.BranchMappingType;
import org.fenixedu.legalpt.domain.raides.mapping.LegalMappingType;
import org.fenixedu.legalpt.domain.report.LegalReport;
import org.fenixedu.legalpt.ui.FenixeduLegalPTBaseController;
import org.fenixedu.legalpt.ui.FenixeduLegalPTController;
import org.fenixedu.legalpt.ui.raides.ManageLegalMappingController$callable$createLegalMapping;
import org.fenixedu.legalpt.ui.raides.ManageLegalMappingController$callable$createLegalMappingEntry;
import org.fenixedu.legalpt.ui.raides.ManageLegalMappingController$callable$deleteLegalMapping;
import org.fenixedu.legalpt.ui.raides.ManageLegalMappingController$callable$deleteLegalMappingEntry;
import org.fenixedu.legalpt.util.LegalPTUtil;
import org.springframework.stereotype.Component;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

@SpringFunctionality(app=FenixeduLegalPTController.class, title="label.title.manageRaidesLegalMapping", accessGroup="logged")
@RequestMapping(value={"/fenixedu-legal-pt/raides/managelegalmappings"})
@Component(value="org.fenixedu.legalpt.ui.raides.ManageLegalMappingController")
public class ManageLegalMappingController
extends FenixeduLegalPTBaseController {
    public static final String CONTROLLER_URL = "/fenixedu-legal-pt/raides/managelegalmappings";
    public static final String JSP_PATH;
    private static final String _SEARCH_URI = "/search";
    public static final String SEARCH_URL = "/fenixedu-legal-pt/raides/managelegalmappings/search";
    private static final String SEARCH_VIEW_URI = "/search/view";
    public static final String SEARCH_VIEW_URL = "/fenixedu-legal-pt/raides/managelegalmappings/search/view";
    private static final String _DELETE_URI = "/delete";
    public static final String DELETE_URL = "/fenixedu-legal-pt/raides/managelegalmappings/delete";
    private static final String _CREATE_URI = "/create";
    public static final String CREATE_URL = "/fenixedu-legal-pt/raides/managelegalmappings/create";
    private static final String _READ_URI = "/read";
    public static final String READ_URL = "/fenixedu-legal-pt/raides/managelegalmappings/read";
    private static final String _CREATE_ENTRY_URI = "/create/entry";
    public static final String CREATE_ENTRY_URL = "/fenixedu-legal-pt/raides/managelegalmappings/create/entry";
    private static final String _DELETE_ENTRY_URI = "/delete/entry";
    public static final String DELETE_ENTRY_URL = "/fenixedu-legal-pt/raides/managelegalmappings/delete/entry";
    public static final Advice advice$deleteLegalMapping;
    public static final Advice advice$createLegalMapping;
    public static final Advice advice$createLegalMappingEntry;
    public static final Advice advice$deleteLegalMappingEntry;

    @RequestMapping
    public String home(Model model, RedirectAttributes redirectAttributes) {
        return this.redirect(SEARCH_URL, model, redirectAttributes);
    }

    private String jspPage(String page) {
        return JSP_PATH + page;
    }

    @RequestMapping(value={"/search"}, method={RequestMethod.GET})
    public String search(Model model) {
        List mappingsToBeManage = RaidesInstance.getInstance().getLegalMappingsSet().stream().filter(m -> !BranchMappingType.isTypeForMapping(m.getType())).collect(Collectors.toList());
        model.addAttribute("legalMappings", mappingsToBeManage);
        List possibleTypes = RaidesInstance.getInstance().getMappingTypes().stream().filter(type -> type instanceof LegalMappingType).filter(type -> LegalMapping.find((LegalReport)((Object)((Object)((Object)RaidesInstance.getInstance()))), type) == null).sorted((t1, t2) -> t1.getName().getContent().compareTo(t2.getName().getContent())).collect(Collectors.toList());
        model.addAttribute("possibleLegalMappingTypes", possibleTypes);
        return this.jspPage(_SEARCH_URI);
    }

    @RequestMapping(value={"/search/view/{legalMappingId}"})
    public String processSearchToViewAction(@PathVariable(value="legalMappingId") LegalMapping legalMapping, Model model, RedirectAttributes redirectAttributes) {
        return this.redirect("/fenixedu-legal-pt/raides/managelegalmappings/read/" + legalMapping.getExternalId(), model, redirectAttributes);
    }

    @RequestMapping(value={"/delete/{legalMappingId}"}, method={RequestMethod.POST})
    public String processSearchToDeleteAction(@PathVariable(value="legalMappingId") LegalMapping legalMapping, Model model, RedirectAttributes redirectAttributes) {
        try {
            this.deleteLegalMapping(legalMapping);
            this.addInfoMessage(LegalPTUtil.bundle("message.LegalMapping.removed.with.success", new String[0]), model);
            return this.redirect(SEARCH_URL, model, redirectAttributes);
        }
        catch (DomainException ex) {
            this.addErrorMessage(LegalPTUtil.bundle(ex.getKey(), new String[0]), model);
            return this.read(legalMapping, model);
        }
    }

    public void deleteLegalMapping(LegalMapping legalMapping) {
        Object object = advice$deleteLegalMapping.perform((Callable)new ManageLegalMappingController$callable$deleteLegalMapping(this, legalMapping));
    }

    static /* synthetic */ void advised$deleteLegalMapping(ManageLegalMappingController this_, LegalMapping legalMapping) {
        for (LegalMappingEntry entry : legalMapping.getLegalMappingEntriesSet()) {
            legalMapping.deleteEntry(entry);
        }
        legalMapping.delete();
    }

    @RequestMapping(value={"/create"}, method={RequestMethod.POST})
    public String create(@RequestParam(value="selectedType", required=true) LegalMappingType selectedType, Model model, RedirectAttributes redirectAttributes) {
        try {
            LegalMapping legalMapping = this.createLegalMapping(selectedType);
            return this.redirect("/fenixedu-legal-pt/raides/managelegalmappings/read/" + legalMapping.getExternalId(), model, redirectAttributes);
        }
        catch (DomainException de) {
            this.addErrorMessage(LegalPTUtil.bundle(de.getKey(), new String[0]), model);
            return this.search(model);
        }
    }

    public LegalMapping createLegalMapping(LegalMappingType legalMappingType) {
        return (LegalMapping)((Object)advice$createLegalMapping.perform((Callable)new ManageLegalMappingController$callable$createLegalMapping(this, legalMappingType)));
    }

    static /* synthetic */ LegalMapping advised$createLegalMapping(ManageLegalMappingController this_, LegalMappingType type) {
        return type.createMapping((LegalReport)((Object)RaidesInstance.getInstance()));
    }

    @RequestMapping(value={"/read/{legalMappingId}"}, method={RequestMethod.GET})
    public String read(@PathVariable(value="legalMappingId") LegalMapping legalMapping, Model model) {
        model.addAttribute("legalMapping", (Object)legalMapping);
        model.addAttribute("legalMappingEntries", legalMapping.getLegalMappingEntriesSet().stream().sorted((e1, e2) -> e1.getMappingKey().compareTo(e2.getMappingKey())).collect(Collectors.toList()));
        List possibleLegalMappingEntryKeys = legalMapping.getPossibleKeys().stream().map(o -> {
            TupleDataSourceBean tuple = new TupleDataSourceBean();
            tuple.setId(legalMapping.keyForObject(o));
            tuple.setText(legalMapping.getLocalizedNameEntryKeyI18NForObject(o).getContent());
            return tuple;
        }).sorted(TupleDataSourceBean.COMPARE_BY_TEXT).collect(Collectors.toList());
        model.addAttribute("possibleLegalMappingEntryKeys", possibleLegalMappingEntryKeys);
        return this.jspPage(_READ_URI);
    }

    @RequestMapping(value={"/create/entry/{legalMappingId}"}, method={RequestMethod.POST})
    public String createEntry(@PathVariable(value="legalMappingId") LegalMapping legalMapping, @RequestParam(value="key", required=true) String key, @RequestParam(value="value", required=true) String value, Model model) {
        try {
            this.createLegalMappingEntry(legalMapping, key, value);
            this.addInfoMessage(LegalPTUtil.bundle("message.LegalMappingEntry.created.with.success", new String[0]), model);
        }
        catch (DomainException de) {
            this.addErrorMessage(LegalPTUtil.bundle(de.getKey(), new String[0]), model);
        }
        return this.read(legalMapping, model);
    }

    public void createLegalMappingEntry(LegalMapping legalMapping, String string, String string2) {
        Object object = advice$createLegalMappingEntry.perform((Callable)new ManageLegalMappingController$callable$createLegalMappingEntry(this, legalMapping, string, string2));
    }

    static /* synthetic */ void advised$createLegalMappingEntry(ManageLegalMappingController this_, LegalMapping legalMapping, String key, String value) {
        legalMapping.addEntry(key, value);
    }

    @RequestMapping(value={"/delete/entry/{legalMappingId}/{legalMappingEntryId}"}, method={RequestMethod.POST})
    public String deleteEntry(@PathVariable(value="legalMappingId") LegalMapping legalMapping, @PathVariable(value="legalMappingEntryId") LegalMappingEntry legalMappingEntry, Model model) {
        try {
            this.deleteLegalMappingEntry(legalMapping, legalMappingEntry);
            this.addInfoMessage(LegalPTUtil.bundle("message.LegalMappingEntry.removed.with.success", new String[0]), model);
        }
        catch (DomainException de) {
            this.addErrorMessage(LegalPTUtil.bundle(de.getKey(), new String[0]), model);
        }
        return this.read(legalMapping, model);
    }

    public void deleteLegalMappingEntry(LegalMapping legalMapping, LegalMappingEntry legalMappingEntry) {
        Object object = advice$deleteLegalMappingEntry.perform((Callable)new ManageLegalMappingController$callable$deleteLegalMappingEntry(this, legalMapping, legalMappingEntry));
    }

    static /* synthetic */ void advised$deleteLegalMappingEntry(ManageLegalMappingController this_, LegalMapping legalMapping, LegalMappingEntry legalMappingEntry) {
        legalMapping.deleteEntry(legalMappingEntry);
    }

    static {
        advice$deleteLegalMapping = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        advice$createLegalMapping = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        advice$createLegalMappingEntry = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        advice$deleteLegalMappingEntry = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        JSP_PATH = CONTROLLER_URL.substring(1);
    }
}

