/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.legalpt.dto.a3es;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.bennu.IBean;
import org.fenixedu.bennu.TupleDataSourceBean;
import org.fenixedu.legalpt.domain.a3es.A3esPeriod;
import org.fenixedu.legalpt.domain.a3es.A3esProcessType;
import org.joda.time.DateTime;

public class A3esPeriodBean
implements IBean {
    private A3esPeriod period;
    private ExecutionYear executionYear;
    private List<TupleDataSourceBean> executionYearDataSource;
    private A3esProcessType type;
    private List<TupleDataSourceBean> typeDataSource;
    private DateTime fillInDateBegin;
    private DateTime fillInDateEnd;

    public A3esPeriodBean() {
        this.updateDataSources();
    }

    public A3esPeriodBean(A3esPeriod input) {
        this.setPeriod(input);
        this.setExecutionYear(input.getExecutionYear());
        this.setType(input.getType());
        this.setFillInDateBegin(input.getFillInDateBegin());
        this.setFillInDateEnd(input.getFillInDateEnd());
        this.updateDataSources();
    }

    public ExecutionYear getExecutionYear() {
        return this.executionYear;
    }

    public void setExecutionYear(ExecutionYear input) {
        this.executionYear = input;
    }

    public List<TupleDataSourceBean> getExecutionYearDataSource() {
        if (this.executionYearDataSource == null) {
            this.executionYearDataSource = new ArrayList<TupleDataSourceBean>();
        }
        return this.executionYearDataSource;
    }

    public A3esProcessType getType() {
        return this.type;
    }

    public void setType(A3esProcessType input) {
        this.type = input;
    }

    public List<TupleDataSourceBean> getTypeDataSource() {
        if (this.typeDataSource == null) {
            this.typeDataSource = new ArrayList<TupleDataSourceBean>();
        }
        return this.typeDataSource;
    }

    public DateTime getFillInDateBegin() {
        return this.fillInDateBegin;
    }

    public void setFillInDateBegin(DateTime input) {
        this.fillInDateBegin = input;
    }

    public DateTime getFillInDateEnd() {
        return this.fillInDateEnd;
    }

    public void setFillInDateEnd(DateTime input) {
        this.fillInDateEnd = input;
    }

    public A3esPeriod getPeriod() {
        return this.period;
    }

    public void setPeriod(A3esPeriod input) {
        this.period = input;
    }

    public void updateDataSources() {
        this.updateExecutionYearDataSource();
        this.updateTypeDataSource();
    }

    private void updateExecutionYearDataSource() {
        if (this.getExecutionYearDataSource().isEmpty()) {
            ExecutionYear.readNotClosedExecutionYears().stream().sorted(ExecutionYear.COMPARATOR_BY_BEGIN_DATE.reversed()).map(x -> {
                TupleDataSourceBean tuple = new TupleDataSourceBean();
                tuple.setId(x.getExternalId());
                tuple.setText(x.getQualifiedName());
                return tuple;
            }).collect(Collectors.toCollection(() -> this.getExecutionYearDataSource()));
        }
    }

    private void updateTypeDataSource() {
        if (this.getTypeDataSource().isEmpty()) {
            Lists.newArrayList((Object[])A3esProcessType.values()).stream().map(x -> {
                TupleDataSourceBean tuple = new TupleDataSourceBean();
                tuple.setId(x.name());
                tuple.setText(x.getCode() + " - " + x.getLocalizedName().getContent());
                return tuple;
            }).collect(Collectors.toCollection(() -> this.getTypeDataSource()));
        }
    }
}

