/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.legalpt.services.rebides.process;

import java.math.BigDecimal;
import org.apache.commons.lang.StringUtils;
import org.fenixedu.academic.domain.Coordinator;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.Teacher;
import org.fenixedu.academic.domain.TeacherAuthorization;
import org.fenixedu.legalpt.domain.LegalReportContext;
import org.fenixedu.legalpt.domain.mapping.LegalMapping;
import org.fenixedu.legalpt.domain.rebides.mapping.RebidesMappingType;
import org.fenixedu.legalpt.domain.report.LegalReport;
import org.fenixedu.legalpt.dto.rebides.CareerActivitiesBean;
import org.fenixedu.legalpt.services.rebides.process.RebidesService;
import org.joda.time.YearMonthDay;
import pt.ist.fenixframework.DomainObject;

public class CareerActivitiesService {
    private final TeacherAuthorization contract;
    private final Teacher teacher;
    private final YearMonthDay lastDayOfTheYear;
    private final ExecutionYear executionYear;
    private LegalReport report;

    public CareerActivitiesService(LegalReport report, Teacher teacher, YearMonthDay lastDayOfTheYear, ExecutionYear executionYear) {
        this.report = report;
        this.teacher = teacher;
        this.lastDayOfTheYear = lastDayOfTheYear;
        this.executionYear = executionYear;
        this.contract = teacher.getLatestTeacherAuthorizationInInterval(lastDayOfTheYear.toInterval()).orElse(null);
    }

    public CareerActivitiesBean getCareerActivitiesData() {
        CareerActivitiesBean bean = new CareerActivitiesBean();
        this.fillDepartment(bean);
        this.fillOtherDepartment(bean);
        this.fillCategory(bean);
        this.fillGuest(bean);
        this.fillEquated(bean);
        this.fillAptitudeTests(bean);
        this.fillAggregationTests(bean);
        this.fillExpertTests(bean);
        this.fillServiceRegime(bean);
        this.fillPartialRegime(bean);
        this.fillBindingRegime(bean);
        this.fillContractWageLevel(bean);
        this.fillResearchPercentage(bean);
        this.fillTeaching(bean);
        this.fillTeachingHours(bean);
        this.fillTeachingHoursUnit(bean);
        this.fillRootUnitPresident(bean);
        this.fillRootUnitVicePrincipal(bean);
        this.fillRootUnitPresident(bean);
        this.fillUnitCoordinator(bean);
        this.fillCoordenatorGeneralCouncil(bean);
        this.fillManagementCouncilActivities(bean);
        this.fillScientificCouncilActivities(bean);
        this.fillPedagogicCouncilActivitiesl(bean);
        this.fillCoachingOrResearchProjectActivities(bean);
        this.fillOtherActivity(bean);
        this.fillOtherActivityDescription(bean);
        return bean;
    }

    private void fillDepartment(CareerActivitiesBean bean) {
        if (this.contract.getDepartment() != null && StringUtils.isNotEmpty((String)this.contract.getDepartment().getName())) {
            if (LegalMapping.find(this.report, RebidesMappingType.DEPARTMENT).translate((DomainObject)this.contract.getDepartment()) != null) {
                String department = LegalMapping.find(this.report, RebidesMappingType.DEPARTMENT).translate((DomainObject)this.contract.getDepartment());
                if (RebidesService.validateMaxFieldSize(this.teacher, "label.department", department, RebidesService.LIMIT_2CHARS).booleanValue()) {
                    bean.setDepartment(department);
                }
            } else {
                bean.setDepartment("00");
            }
        } else {
            bean.setDepartment("99");
        }
    }

    private void fillOtherDepartment(CareerActivitiesBean bean) {
        String otherDepartmentName;
        if (bean.getDepartment().equals("00") && RebidesService.validateMaxFieldSize(this.teacher, "label.otherDepartment", otherDepartmentName = this.contract.getDepartment().getName(), RebidesService.LIMIT_160CHARS).booleanValue()) {
            bean.setOtherDepartment(otherDepartmentName);
        }
    }

    private void fillCategory(CareerActivitiesBean bean) {
        if (this.contract.getTeacherCategory() != null) {
            if (LegalMapping.find(this.report, RebidesMappingType.CONTRACT_CATEGORY).translate((DomainObject)this.contract.getTeacherCategory()) != null) {
                String contractCategory = LegalMapping.find(this.report, RebidesMappingType.CONTRACT_CATEGORY).translate((DomainObject)this.contract.getTeacherCategory());
                if (RebidesService.validateMaxFieldSize(this.teacher, "Contract.contractCategory", contractCategory, RebidesService.LIMIT_2CHARS).booleanValue()) {
                    bean.setCategory(contractCategory);
                }
            } else {
                LegalReportContext.addError(RebidesService.createSubjectForReport(this.teacher), RebidesService.createMissingMappingMessage("Contract.contractCategory", this.contract.getTeacherCategory().getName().getContent()), new String[0]);
            }
        } else {
            LegalReportContext.addError(RebidesService.createSubjectForReport(this.teacher), RebidesService.createMissingFieldMessage("Contract.contractCategory"), new String[0]);
        }
    }

    private void fillGuest(CareerActivitiesBean bean) {
        bean.setGuest(!this.contract.isContracted());
    }

    private void fillEquated(CareerActivitiesBean bean) {
        bean.setSchoolStaff(this.contract.isContracted());
    }

    private void fillAptitudeTests(CareerActivitiesBean bean) {
        String aptitudeTests = this.getAptitudeTests();
        if (StringUtils.isNotEmpty((String)this.getAptitudeTests()) && RebidesService.validateMaxFieldSize(this.teacher, "CareerSituation.aptitude", aptitudeTests, RebidesService.LIMIT_160CHARS).booleanValue()) {
            bean.setAptitudeTests(aptitudeTests);
        }
    }

    private String getAptitudeTests() {
        return null;
    }

    private void fillAggregationTests(CareerActivitiesBean bean) {
        String aggregationTests = this.getAggregationTests();
        if (StringUtils.isNotEmpty((String)aggregationTests) && RebidesService.validateMaxFieldSize(this.teacher, "CareerSituation.aggregation", aggregationTests, RebidesService.LIMIT_160CHARS).booleanValue()) {
            bean.setAggregationTests(aggregationTests);
        }
    }

    private String getAggregationTests() {
        return null;
    }

    private void fillExpertTests(CareerActivitiesBean bean) {
        String expertTests = this.getExpertTests();
        if (StringUtils.isNotEmpty((String)expertTests) && RebidesService.validateMaxFieldSize(this.teacher, "CareerSituation.expert", expertTests, RebidesService.LIMIT_160CHARS).booleanValue()) {
            bean.setExpertTests(expertTests);
        }
    }

    private String getExpertTests() {
        return null;
    }

    private void fillServiceRegime(CareerActivitiesBean bean) {
    }

    private void fillPartialRegime(CareerActivitiesBean bean) {
    }

    private void fillBindingRegime(CareerActivitiesBean bean) {
    }

    private void fillContractWageLevel(CareerActivitiesBean bean) {
    }

    private void fillResearchPercentage(CareerActivitiesBean bean) {
    }

    private void fillTeaching(CareerActivitiesBean bean) {
    }

    private void fillTeachingHours(CareerActivitiesBean bean) {
    }

    private BigDecimal professorshipTeachingHours(CareerActivitiesBean bean) {
        Double teachingHours = 0.0;
        return new BigDecimal(teachingHours);
    }

    private void fillTeachingHoursUnit(CareerActivitiesBean bean) {
        if (bean.getTeaching() != null && bean.getTeaching().booleanValue()) {
            bean.setTeachingHoursUnit(UnitHL.ANUAL);
        }
    }

    private void fillRootUnitPrincipal(CareerActivitiesBean bean) {
        bean.setRootUnitPresident(this.isRootUnitPresident());
    }

    private Boolean isRootUnitPresident() {
        return false;
    }

    private void fillRootUnitVicePrincipal(CareerActivitiesBean bean) {
        bean.setRootUnitVicePresident(this.isRootUnitVicePresident());
    }

    private Boolean isRootUnitVicePresident() {
        return false;
    }

    private void fillRootUnitPresident(CareerActivitiesBean bean) {
        bean.setUnitPresident(this.isUnitPresident());
    }

    private Boolean isUnitPresident() {
        return false;
    }

    private void fillUnitCoordinator(CareerActivitiesBean bean) {
        bean.setUnitCoordinator(this.isUnitCoordinator());
    }

    private Boolean isUnitCoordinator() {
        return false;
    }

    private boolean isDegreeCoordinator() {
        for (Coordinator coordinator : this.teacher.getPerson().getCoordinatorsSet()) {
            if (coordinator.getExecutionDegree().getExecutionYear() != this.executionYear) continue;
            return true;
        }
        return false;
    }

    private void fillCoordenatorGeneralCouncil(CareerActivitiesBean bean) {
        bean.setCoordenatorGeneralCouncil(this.isGeneralCouncilCoordinator());
    }

    private Boolean isGeneralCouncilCoordinator() {
        return false;
    }

    private void fillManagementCouncilActivities(CareerActivitiesBean bean) {
        bean.setManagementCouncilActivities(this.hasManagementCouncilActivities());
    }

    private Boolean hasManagementCouncilActivities() {
        return false;
    }

    private void fillScientificCouncilActivities(CareerActivitiesBean bean) {
        bean.setScientificCouncilActivities(this.hasScientificCouncilActivities());
    }

    private Boolean hasScientificCouncilActivities() {
        return false;
    }

    private void fillPedagogicCouncilActivitiesl(CareerActivitiesBean bean) {
        bean.setPedagogicCouncilActivities(this.hasPedagogicCouncilActivities());
    }

    private Boolean hasPedagogicCouncilActivities() {
        return false;
    }

    private void fillCoachingOrResearchProjectActivities(CareerActivitiesBean bean) {
        bean.setCoachingOrResearchProjectActivities(this.hasCoachingOrResearchProjectActivities());
    }

    private Boolean hasCoachingOrResearchProjectActivities() {
        return false;
    }

    private void fillOtherActivity(CareerActivitiesBean bean) {
        bean.setOtherActivity(this.hasOtherActivity());
    }

    private Boolean hasOtherActivity() {
        return false;
    }

    private void fillOtherActivityDescription(CareerActivitiesBean bean) {
        if (bean.getOtherActivity() != null && bean.getOtherActivity().booleanValue()) {
            if (StringUtils.isNotEmpty((String)this.getOtherActivityDescription())) {
                if (RebidesService.validateMaxFieldSize(this.teacher, "CareerSituation.otherActivityDescription", this.getOtherActivityDescription(), RebidesService.LIMIT_255CHARS).booleanValue()) {
                    bean.setOtherActivityDescription(this.getOtherActivityDescription());
                }
            } else {
                LegalReportContext.addError(RebidesService.createSubjectForReport(this.teacher), RebidesService.createMissingFieldMessage("CareerSituation.otherActivityDescription"), new String[0]);
            }
        }
    }

    private String getOtherActivityDescription() {
        return null;
    }

    public static class UnitHL {
        public static final Integer ANUAL = 1;
        public static final Integer SEMESTER = 2;
    }

    public static class Department {
        public static final String OTHER_DEPARTMENT = "00";
        public static final String NO_DEPARTMENT = "99";
    }
}

