/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.legalpt.ui.rebides;

import org.fenixedu.bennu.core.domain.exceptions.DomainException;
import org.fenixedu.bennu.spring.portal.SpringFunctionality;
import org.fenixedu.legalpt.domain.rebides.RebidesInstance;
import org.fenixedu.legalpt.dto.rebides.RebidesInstanceBean;
import org.fenixedu.legalpt.ui.FenixeduLegalPTBaseController;
import org.fenixedu.legalpt.ui.FenixeduLegalPTController;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import pt.ist.fenixframework.FenixFramework;

@SpringFunctionality(app=FenixeduLegalPTController.class, title="label.title.manageRebidesConfiguration", accessGroup="logged")
@RequestMapping(value={"/fenixedu-legal-pt/rebides/managerebidesconfiguration"})
public class RebidesConfigurationController
extends FenixeduLegalPTBaseController {
    public static final String CONTROLLER_URL = "/fenixedu-legal-pt/rebides/managerebidesconfiguration";
    public static final String JSP_PATH = "/fenixedu-legal-pt/rebides/managerebidesconfiguration".substring(1);
    private static final String _READ_URI = "/read";
    public static final String READ_URL = "/fenixedu-legal-pt/rebides/managerebidesconfiguration/read";
    private static final String _EDIT_URI = "/edit";
    public static final String EDIT_URL = "/fenixedu-legal-pt/rebides/managerebidesconfiguration/edit";

    @RequestMapping
    public String home() {
        return "forward:/fenixedu-legal-pt/rebides/managerebidesconfiguration/read";
    }

    @RequestMapping(value={"/read"}, method={RequestMethod.GET})
    public String read(Model model) {
        model.addAttribute("rebidesInstance", (Object)RebidesInstance.getInstance());
        return this.jspPage(_READ_URI);
    }

    private String jspPage(String page) {
        return JSP_PATH + "/" + page.substring(1, page.length());
    }

    @RequestMapping(value={"/edit"}, method={RequestMethod.GET})
    public String edit(Model model) {
        return this._edit(new RebidesInstanceBean(RebidesInstance.getInstance()), model);
    }

    private String _edit(RebidesInstanceBean bean, Model model) {
        model.addAttribute("bean", (Object)bean);
        model.addAttribute("beanJson", (Object)this.getBeanJson(bean));
        return this.jspPage(_EDIT_URI);
    }

    @RequestMapping(value={"/edit"}, method={RequestMethod.POST})
    public String editpost(@RequestParam(value="bean") RebidesInstanceBean bean, Model model) {
        try {
            FenixFramework.atomic(() -> {
                RebidesInstance instance = RebidesInstance.getInstance();
                instance.setInstitutionCode(bean.getInstitutionCode());
                instance.setInterlocutorName(bean.getInterlocutorName());
                instance.setInterlocutorEmail(bean.getInterlocutorEmail());
                instance.setInterlocutorPhone(bean.getInterlocutorPhone());
                instance.setPasswordToZip(bean.getPasswordToZip());
            });
            return "redirect:/fenixedu-legal-pt/rebides/managerebidesconfiguration/read";
        }
        catch (DomainException e) {
            this.addErrorMessage(e.getLocalizedMessage(), model);
            return this._edit(bean, model);
        }
    }
}

