/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.legalpt.ui.raides;

import com.google.common.collect.Lists;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.concurrent.Callable;
import org.fenixedu.academic.domain.DegreeCurricularPlan;
import org.fenixedu.bennu.core.domain.Bennu;
import org.fenixedu.bennu.core.domain.exceptions.DomainException;
import org.fenixedu.bennu.spring.portal.SpringFunctionality;
import org.fenixedu.legalpt.dto.raides.BranchMappingEntryBean;
import org.fenixedu.legalpt.ui.FenixeduLegalPTBaseController;
import org.fenixedu.legalpt.ui.FenixeduLegalPTController;
import org.fenixedu.legalpt.ui.raides.ManageBranchMappingsController$callable$addMapping;
import org.fenixedu.legalpt.ui.raides.ManageBranchMappingsController$callable$removeMapping;
import org.fenixedu.ulisboa.specifications.domain.legal.mapping.LegalMappingEntry;
import org.fenixedu.ulisboa.specifications.domain.legal.raides.RaidesInstance;
import org.fenixedu.ulisboa.specifications.domain.legal.raides.mapping.BranchMappingType;
import org.fenixedu.ulisboa.specifications.domain.legal.report.LegalReport;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

@SpringFunctionality(app=FenixeduLegalPTController.class, title="label.title.manageBranchMappings", accessGroup="logged")
@RequestMapping(value={"/fenixedu-legal-pt/raides/managebranchmappings"})
public class ManageBranchMappingsController
extends FenixeduLegalPTBaseController {
    public static final String CONTROLLER_URL = "/fenixedu-legal-pt/raides/managebranchmappings";
    public static final String JSP_PATH;
    private static final String SEARCH_URI = "/search";
    public static final String SEARCH_URL = "/fenixedu-legal-pt/raides/managebranchmappings/search";
    private static final String VIEW_URI = "/view";
    public static final String VIEW_URL = "/fenixedu-legal-pt/raides/managebranchmappings/view";
    private static final String ADD_MAPPING_URI = "/addmapping";
    public static final String ADD_MAPPING_URL = "/fenixedu-legal-pt/raides/managebranchmappings/addmapping";
    private static final String ADD_MAPPING_POST_URI = "/addmappingpost";
    public static final String ADD_MAPPING_POST_URL = "/fenixedu-legal-pt/raides/managebranchmappings/addmappingpost";
    private static final String DELETE_MAPPING_URI = "/deletemapping";
    public static final String DELETE_MAPPING_URL = "/fenixedu-legal-pt/raides/managebranchmappings/deletemapping";
    public static final Advice advice$addMapping;
    public static final Advice advice$removeMapping;

    @RequestMapping
    public String home() {
        return "redirect:/fenixedu-legal-pt/raides/managebranchmappings/search";
    }

    private String jspPage(String page) {
        return JSP_PATH + page;
    }

    @RequestMapping(value={"/search"})
    public String search(Model model) {
        ArrayList dcpList = Lists.newArrayList((Iterable)Bennu.getInstance().getDegreeCurricularPlansSet());
        Collections.sort(dcpList, DegreeCurricularPlan.DEGREE_CURRICULAR_PLAN_COMPARATOR_BY_DEGREE_TYPE_AND_EXECUTION_DEGREE_AND_DEGREE_CODE);
        model.addAttribute("dcpList", (Object)dcpList);
        return this.jspPage(SEARCH_URI);
    }

    @RequestMapping(value={"/view/{degreeCurricularPlanId}"})
    public String view(@PathVariable(value="degreeCurricularPlanId") DegreeCurricularPlan degreeCurricularPlan, Model model) {
        model.addAttribute("degreeCurricularPlan", (Object)degreeCurricularPlan);
        model.addAttribute("mappingEntries", BranchMappingType.getInstance().getMappingEntries(BranchMappingType.readMapping((LegalReport)((Object)RaidesInstance.getInstance())), degreeCurricularPlan));
        return this.jspPage(VIEW_URI);
    }

    @RequestMapping(value={"/addmapping/{degreeCurricularPlanId}"}, method={RequestMethod.GET})
    public String addmapping(@PathVariable(value="degreeCurricularPlanId") DegreeCurricularPlan degreeCurricularPlan, Model model) {
        return this._addmapping(degreeCurricularPlan, model);
    }

    private String _addmapping(DegreeCurricularPlan degreeCurricularPlan, Model model) {
        model.addAttribute("degreeCurricularPlan", (Object)degreeCurricularPlan);
        BranchMappingEntryBean bean = new BranchMappingEntryBean(degreeCurricularPlan);
        model.addAttribute("bean", (Object)bean);
        model.addAttribute("beanJson", (Object)this.getBeanJson(bean));
        return this.jspPage(ADD_MAPPING_URI);
    }

    @RequestMapping(value={"/addmappingpost/{degreeCurricularPlanId}"}, method={RequestMethod.POST})
    public String addmappingpost(@PathVariable(value="degreeCurricularPlanId") DegreeCurricularPlan degreeCurricularPlan, @RequestParam(value="bean") BranchMappingEntryBean bean, Model model) {
        try {
            this.addMapping(bean);
            return String.format("redirect:%s/%s", VIEW_URL, degreeCurricularPlan.getExternalId());
        }
        catch (DomainException e) {
            this.addErrorMessage(e.getLocalizedMessage(), model);
            return this._addmapping(degreeCurricularPlan, model);
        }
    }

    private void addMapping(BranchMappingEntryBean branchMappingEntryBean) {
        Object object = advice$addMapping.perform((Callable)new ManageBranchMappingsController$callable$addMapping(this, branchMappingEntryBean));
    }

    static /* synthetic */ void advised$addMapping(ManageBranchMappingsController this_, BranchMappingEntryBean bean) {
        BranchMappingType.readMapping((LegalReport)((Object)RaidesInstance.getInstance())).addEntry(BranchMappingType.readMapping((LegalReport)((Object)RaidesInstance.getInstance())).keyForObject(bean.getBranchKey()), bean.getValue());
    }

    @RequestMapping(value={"/deletemapping/{degreeCurricularPlanId}"}, method={RequestMethod.POST})
    public String deletemapping(@PathVariable(value="degreeCurricularPlanId") DegreeCurricularPlan degreeCurricularPlan, @RequestParam(value="mappingEntryId") LegalMappingEntry entry, Model model) {
        try {
            this.removeMapping(entry);
            return "redirect:/fenixedu-legal-pt/raides/managebranchmappings/view/" + degreeCurricularPlan.getExternalId();
        }
        catch (DomainException e) {
            this.addErrorMessage(e.getLocalizedMessage(), model);
            return this.view(degreeCurricularPlan, model);
        }
    }

    private void removeMapping(LegalMappingEntry legalMappingEntry) {
        Object object = advice$removeMapping.perform((Callable)new ManageBranchMappingsController$callable$removeMapping(this, legalMappingEntry));
    }

    static /* synthetic */ void advised$removeMapping(ManageBranchMappingsController this_, LegalMappingEntry entry) {
        entry.getLegalMapping().deleteEntry(entry);
    }

    static {
        advice$addMapping = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        advice$removeMapping = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        JSP_PATH = CONTROLLER_URL.substring(1);
    }
}

