/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.legalpt.ui.a3es;

import com.google.common.collect.Sets;
import fr.opensagres.xdocreport.core.io.internal.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Set;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.fenixedu.academic.domain.DegreeCurricularPlan;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.Teacher;
import org.fenixedu.academic.domain.organizationalStructure.Unit;
import org.fenixedu.bennu.core.domain.Bennu;
import org.fenixedu.bennu.core.security.Authenticate;
import org.fenixedu.bennu.spring.portal.SpringFunctionality;
import org.fenixedu.commons.spreadsheet.SpreadsheetBuilder;
import org.fenixedu.commons.spreadsheet.WorkbookExportFormat;
import org.fenixedu.legalpt.domain.a3es.A3esProcess;
import org.fenixedu.legalpt.domain.a3es.A3esProcessType;
import org.fenixedu.legalpt.dto.a3es.A3esProcessBean;
import org.fenixedu.legalpt.services.a3es.process.A3esExportService;
import org.fenixedu.legalpt.ui.FenixeduLegalPTBaseController;
import org.fenixedu.legalpt.ui.FenixeduLegalPTController;
import org.fenixedu.legalpt.util.LegalPTUtil;
import org.joda.time.DateTime;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@Component(value="org.fenixedu.legalpt.ui.a3es.process.teacher")
@SpringFunctionality(app=FenixeduLegalPTController.class, title="label.searchA3esProcess", accessGroup="#managers")
@RequestMapping(value={"/fenixedu-legal-pt/a3es/process/teacher"})
public class A3esProcessTeacherController
extends FenixeduLegalPTBaseController {
    public static final String CONTROLLER_URL = "/fenixedu-legal-pt/a3es/process/teacher";
    private static final String JSP_PATH = "/fenixedu-legal-pt/a3es/process/teacher".substring(1);
    private static final String _SEARCH_URI = "/";
    public static final String SEARCH_URL = "/fenixedu-legal-pt/a3es/process/teacher/";
    private static final String _SEARCHPOSTBACK_URI = "/searchpostback/";
    public static final String SEARCHPOSTBACK_URL = "/fenixedu-legal-pt/a3es/process/teacher/searchpostback/";
    private static final String _SEARCH_TO_VIEW_ACTION_URI = "/search/view/";
    public static final String SEARCH_TO_VIEW_ACTION_URL = "/fenixedu-legal-pt/a3es/process/teacher/search/view/";
    private static final String _READ_URI = "/read/";
    public static final String READ_URL = "/fenixedu-legal-pt/a3es/process/teacher/read/";
    private static final String _VIEWCOURSES_URI = "/viewcourses/";
    private static final String _VIEWINFO_URI = "/viewinfo/";
    public static final String VIEWINFO_URL = "/fenixedu-legal-pt/a3es/process/teacher/viewinfo/";
    private static final String _VIEWINFOPOSTBACK_URI = "/viewinfopostback/";
    public static final String VIEWINFOPOSTBACK_URL = "/fenixedu-legal-pt/a3es/process/teacher/viewinfopostback/";
    public static final String VIEWCOURSES_URL = "/fenixedu-legal-pt/a3es/process/teacher/viewcourses/";
    private static final String _VIEWCOURSESPOSTBACK_URI = "/viewcoursespostback/";
    public static final String VIEWCOURSESPOSTBACK_URL = "/fenixedu-legal-pt/a3es/process/teacher/viewcoursespostback/";
    private static final String _COURSESDOWNLOAD_URI = "/coursesdownload/";
    public static final String COURSESDOWNLOAD_URL = "/fenixedu-legal-pt/a3es/process/teacher/coursesdownload/";
    private static final String _VIEWTEACHERS_URI = "/viewteachers/";
    public static final String VIEWTEACHERS_URL = "/fenixedu-legal-pt/a3es/process/teacher/viewteachers/";
    private static final String _VIEWTEACHERSPOSTBACK_URI = "/viewteacherspostback/";
    public static final String VIEWTEACHERSPOSTBACK_URL = "/fenixedu-legal-pt/a3es/process/teacher/viewteacherspostback/";
    private static final String _TEACHERSDOWNLOAD_URI = "/teachersdownload/";
    public static final String TEACHERSDOWNLOAD_URL = "/fenixedu-legal-pt/a3es/process/teacher/teachersdownload/";

    private String jspPage(String page) {
        return JSP_PATH + _SEARCH_URI + page;
    }

    @RequestMapping
    public String home(Model model) {
        return "forward:/fenixedu-legal-pt/a3es/process/teacher/";
    }

    private void setBean(A3esProcessBean bean, Model model) {
        model.addAttribute("processBeanJson", bean == null ? null : this.getBeanJson(bean));
        model.addAttribute("processBean", (Object)bean);
    }

    private A3esProcess getA3esProcess(Model model) {
        return (A3esProcess)((Object)model.asMap().get("process"));
    }

    private void setA3esProcess(A3esProcess process, Model model) {
        model.addAttribute("process", (Object)process);
    }

    @RequestMapping(value={"/"})
    public String search(Model model) {
        model.addAttribute("searchResults", (Object)Sets.newHashSet());
        A3esProcessBean bean = new A3esProcessBean();
        this.setBean(bean, model);
        return this.jspPage("search");
    }

    @RequestMapping(value={"/"}, method={RequestMethod.POST})
    public String search(@RequestParam(value="bean", required=false) A3esProcessBean bean, Model model) {
        model.addAttribute("searchResults", A3esProcessTeacherController.filterSearch(bean.getType(), bean.getExecutionYear(), bean.getIdentifier(), bean.getDegreeCurricularPlan()));
        this.setBean(bean, model);
        return this.jspPage("search");
    }

    private static Set<A3esProcessBean> filterSearch(A3esProcessType type, ExecutionYear year, String identifier, DegreeCurricularPlan plan) {
        Set<A3esProcess> processes = A3esProcess.find(A3esProcess.getPeriodUnique(year, type), identifier, plan);
        return processes.stream().map(p -> {
            A3esProcessBean bean = new A3esProcessBean((A3esProcess)((Object)p), A3esProcessTeacherController.getTeacher());
            bean.updateCoursesData();
            bean.updateTeachersData();
            return bean.getCoursesData().isEmpty() || bean.getTeachersData().isEmpty() ? null : bean;
        }).filter(i -> i != null).collect(Collectors.toSet());
    }

    private static Teacher getTeacher() {
        return Authenticate.getUser().getPerson().getTeacher();
    }

    @RequestMapping(value={"/searchpostback/"}, method={RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public ResponseEntity<String> searchpostback(@RequestParam(value="bean", required=false) A3esProcessBean bean, Model model) {
        bean.updateDataSources();
        this.setBean(bean, model);
        return new ResponseEntity((Object)this.getBeanJson(bean), HttpStatus.OK);
    }

    @RequestMapping(value={"/search/view/{oid}"})
    public String processSearchToViewAction(@PathVariable(value="oid") A3esProcess process, Model model, RedirectAttributes redirectAttributes) {
        return this.redirect(READ_URL + process.getExternalId(), model, redirectAttributes);
    }

    @RequestMapping(value={"/read/{oid}"})
    public String read(@PathVariable(value="oid") A3esProcess process, Model model) {
        this.setA3esProcess(process, model);
        return this.jspPage("read");
    }

    @RequestMapping(value={"/read/{oid}/viewcourses/"})
    public String processReadToViewCoursesData(@PathVariable(value="oid") A3esProcess process, Model model, RedirectAttributes redirectAttributes) {
        this.setA3esProcess(process, model);
        return this.redirect(VIEWCOURSES_URL + this.getA3esProcess(model).getExternalId(), model, redirectAttributes);
    }

    @RequestMapping(value={"/read/{oid}/viewinfo/"})
    public String processReadToViewInfoData(@PathVariable(value="oid") A3esProcess process, Model model, RedirectAttributes redirectAttributes) {
        this.setA3esProcess(process, model);
        return this.redirect(VIEWINFO_URL + this.getA3esProcess(model).getExternalId(), model, redirectAttributes);
    }

    @RequestMapping(value={"/viewinfo/{oid}"}, method={RequestMethod.GET})
    public String viewinfo(@PathVariable(value="oid") A3esProcess process, Model model) {
        this.setA3esProcess(process, model);
        A3esProcessBean bean = new A3esProcessBean(process);
        bean.updateInfoData();
        this.setBean(bean, model);
        return this.jspPage("viewinfo");
    }

    @RequestMapping(value={"/viewinfopostback/{oid}"}, method={RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public ResponseEntity<String> viewinfopostback(@PathVariable(value="oid") A3esProcess process, @RequestParam(value="bean", required=false) A3esProcessBean bean, Model model) {
        this.setBean(bean, model);
        return new ResponseEntity((Object)this.getBeanJson(bean), HttpStatus.OK);
    }

    @RequestMapping(value={"/viewcourses/{oid}"}, method={RequestMethod.GET})
    public String viewcourses(@PathVariable(value="oid") A3esProcess process, Model model) {
        this.setA3esProcess(process, model);
        A3esProcessBean bean = new A3esProcessBean(process, A3esProcessTeacherController.getTeacher());
        bean.updateCoursesData();
        this.setBean(bean, model);
        return this.jspPage("viewcourses");
    }

    @RequestMapping(value={"/viewcoursespostback/{oid}"}, method={RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public ResponseEntity<String> viewcoursespostback(@PathVariable(value="oid") A3esProcess process, @RequestParam(value="bean", required=false) A3esProcessBean bean, Model model) {
        this.setBean(bean, model);
        return new ResponseEntity((Object)this.getBeanJson(bean), HttpStatus.OK);
    }

    @RequestMapping(value={"/coursesdownload/"}, method={RequestMethod.POST})
    public void coursesdownload(@RequestParam(value="bean", required=false) A3esProcessBean bean, Model model, RedirectAttributes redirectAttributes, HttpServletResponse response) throws IOException {
        if (bean != null) {
            SpreadsheetBuilder builder = new SpreadsheetBuilder();
            ByteArrayOutputStream result = new ByteArrayOutputStream();
            A3esExportService.coursesDownload(builder, bean);
            builder.build(WorkbookExportFormat.EXCEL, (OutputStream)result);
            this.writeFile(response, A3esProcessTeacherController.getFileName(bean, LegalPTUtil.bundle("label.courseFiles", new String[0])), "application/vnd.ms-excel", result.toByteArray());
        }
    }

    @RequestMapping(value={"/read/{oid}/viewteachers/"})
    public String processReadToViewTeachersData(@PathVariable(value="oid") A3esProcess process, Model model, RedirectAttributes redirectAttributes) {
        this.setA3esProcess(process, model);
        return this.redirect(VIEWTEACHERS_URL + this.getA3esProcess(model).getExternalId(), model, redirectAttributes);
    }

    @RequestMapping(value={"/viewteachers/{oid}"}, method={RequestMethod.GET})
    public String viewteachers(@PathVariable(value="oid") A3esProcess process, Model model) {
        this.setA3esProcess(process, model);
        A3esProcessBean bean = new A3esProcessBean(process, A3esProcessTeacherController.getTeacher());
        bean.updateTeachersData();
        this.setBean(bean, model);
        return this.jspPage("viewteachers");
    }

    @RequestMapping(value={"/viewteacherspostback/{oid}"}, method={RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public ResponseEntity<String> viewteacherspostback(@PathVariable(value="oid") A3esProcess process, @RequestParam(value="bean", required=false) A3esProcessBean bean, Model model) {
        this.setBean(bean, model);
        return new ResponseEntity((Object)this.getBeanJson(bean), HttpStatus.OK);
    }

    @RequestMapping(value={"/teachersdownload/"}, method={RequestMethod.POST})
    public void teachersdownload(@RequestParam(value="bean", required=false) A3esProcessBean bean, Model model, RedirectAttributes redirectAttributes, HttpServletResponse response) throws IOException {
        if (bean != null) {
            SpreadsheetBuilder builder = new SpreadsheetBuilder();
            ByteArrayOutputStream result = new ByteArrayOutputStream();
            A3esExportService.teachersDownload(builder, bean);
            builder.build(WorkbookExportFormat.EXCEL, (OutputStream)result);
            this.writeFile(response, A3esProcessTeacherController.getFileName(bean, LegalPTUtil.bundle("label.teacherFiles", new String[0])), "application/vnd.ms-excel", result.toByteArray());
        }
    }

    private static String getFileName(A3esProcessBean input, String suffix) {
        Unit institutionUnit = Bennu.getInstance().getInstitutionUnit();
        String acronym = institutionUnit.getAcronym();
        String title = acronym + "_" + suffix.replace(" ", "-") + "_" + input.getName().replace(" ", "-").replace(_SEARCH_URI, "-") + "_";
        return title + new DateTime().toString("yyyy-MM-dd_HH-mm-ss") + ".xls";
    }
}

