/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.legalpt.services.raides.export;

import com.google.common.base.Strings;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.nio.charset.Charset;
import java.util.Collection;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import org.fenixedu.academic.domain.student.Student;
import org.fenixedu.legalpt.jaxb.raides.DuracaoPrograma;
import org.fenixedu.legalpt.jaxb.raides.InformacaoAlunos;
import org.fenixedu.legalpt.jaxb.raides.NumeroID;
import org.fenixedu.legalpt.jaxb.raides.ObjectFactory;
import org.fenixedu.ulisboa.specifications.domain.legal.raides.Raides;
import org.fenixedu.ulisboa.specifications.domain.legal.raides.TblDiplomado;
import org.fenixedu.ulisboa.specifications.domain.legal.raides.TblIdentificacao;
import org.fenixedu.ulisboa.specifications.domain.legal.raides.TblInscrito;
import org.fenixedu.ulisboa.specifications.domain.legal.raides.TblMobilidadeInternacional;
import org.fenixedu.ulisboa.specifications.domain.legal.raides.report.RaidesRequestParameter;
import org.fenixedu.ulisboa.specifications.domain.legal.report.LegalReportRequest;
import org.fenixedu.ulisboa.specifications.domain.legal.report.LegalReportResultFile;
import org.fenixedu.ulisboa.specifications.domain.legal.report.LegalReportResultFileType;
import org.joda.time.LocalDate;

public class XmlToBaseFileWriter {
    private static final String ENCODING = "utf-8";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static LegalReportResultFile write(LegalReportRequest reportRequest, RaidesRequestParameter raidesRequestParameter, Raides raides) {
        LegalReportResultFile legalReportResultFile;
        ObjectFactory factory = new ObjectFactory();
        InformacaoAlunos informacaoAlunos = factory.createInformacaoAlunos();
        XmlToBaseFileWriter.fillExtracao(raidesRequestParameter, factory, informacaoAlunos);
        InformacaoAlunos.Alunos alunos = factory.createInformacaoAlunosAlunos();
        informacaoAlunos.setAlunos(alunos);
        for (Student student : raides.studentsToReport()) {
            InformacaoAlunos.Alunos.Aluno aluno = XmlToBaseFileWriter.fillAluno(raidesRequestParameter, raides, factory, student);
            if (aluno == null) continue;
            alunos.getAluno().add(aluno);
        }
        JAXBContext context = JAXBContext.newInstance((String)ObjectFactory.class.getPackage().getName());
        Marshaller marshaller = context.createMarshaller();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        OutputStreamWriter osw = new OutputStreamWriter((OutputStream)baos, Charset.forName(ENCODING));
        try {
            marshaller.setProperty("jaxb.encoding", (Object)ENCODING);
            marshaller.setProperty("jaxb.formatted.output", (Object)true);
            marshaller.marshal((Object)informacaoAlunos, (Writer)osw);
            byte[] content = baos.toByteArray();
            String filename = "A0" + raidesRequestParameter.getMoment() + raidesRequestParameter.getInstitutionCode() + ".xml";
            legalReportResultFile = new LegalReportResultFile(reportRequest, LegalReportResultFileType.XML, filename, content);
        }
        catch (Throwable throwable) {
            try {
                try {
                    osw.close();
                    baos.close();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                throw throwable;
            }
            catch (JAXBException e) {
                throw new RuntimeException(e);
            }
        }
        try {
            osw.close();
            baos.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return legalReportResultFile;
    }

    protected static InformacaoAlunos.Alunos.Aluno fillAluno(RaidesRequestParameter raidesRequestParameter, Raides raides, ObjectFactory factory, Student student) {
        try {
            TblIdentificacao tblIdentificacao = raides.identificacaoForStudent(student);
            Collection<TblInscrito> inscricoesForStudent = raides.inscricoesForStudent(student, raidesRequestParameter);
            Collection<TblDiplomado> diplomadosForStudent = raides.diplomadosForStudent(student, raidesRequestParameter);
            TblMobilidadeInternacional tblMobilidadeInternacional = raides.mobilidadeInternacionalForStudent(student, raidesRequestParameter);
            if (raidesRequestParameter.isFilterEntriesWithErrors() && !tblIdentificacao.isValid()) {
                return null;
            }
            if (raidesRequestParameter.isFilterEntriesWithErrors() && inscricoesForStudent.isEmpty() && diplomadosForStudent.isEmpty() && tblMobilidadeInternacional == null) {
                return null;
            }
            InformacaoAlunos.Alunos.Aluno aluno = factory.createInformacaoAlunosAlunosAluno();
            aluno.setIdentificacao(XmlToBaseFileWriter.fillIdentificacaoAluno(raides, factory, student));
            if (!inscricoesForStudent.isEmpty()) {
                InformacaoAlunos.Alunos.Aluno.Inscricoes inscricoes = factory.createInformacaoAlunosAlunosAlunoInscricoes();
                aluno.setInscricoes(inscricoes);
                for (TblInscrito tblInscrito : inscricoesForStudent) {
                    inscricoes.getInscricao().add(XmlToBaseFileWriter.fillInscricao(raides, factory, student, tblInscrito));
                }
            }
            if (!diplomadosForStudent.isEmpty()) {
                InformacaoAlunos.Alunos.Aluno.Diplomas diplomas = factory.createInformacaoAlunosAlunosAlunoDiplomas();
                aluno.setDiplomas(diplomas);
                for (TblDiplomado tblDiplomado : diplomadosForStudent) {
                    diplomas.getDiploma().add(XmlToBaseFileWriter.fillDiploma(raides, factory, student, tblDiplomado));
                }
            }
            if (tblMobilidadeInternacional != null) {
                InformacaoAlunos.Alunos.Aluno.Mobilidade mobilidade = XmlToBaseFileWriter.fillMobilidadeInternacional(raides, factory, student, tblMobilidadeInternacional);
                aluno.setMobilidade(mobilidade);
            }
            return aluno;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private static InformacaoAlunos.Alunos.Aluno.Mobilidade fillMobilidadeInternacional(Raides raides, ObjectFactory factory, Student student, TblMobilidadeInternacional tblMobilidadeInternacional) {
        InformacaoAlunos.Alunos.Aluno.Mobilidade mobilidade = factory.createInformacaoAlunosAlunosAlunoMobilidade();
        mobilidade.setAnoCurricular(XmlToBaseFileWriter.longValueOf(tblMobilidadeInternacional.getAnoCurricular()));
        mobilidade.setAnoLetivo(tblMobilidadeInternacional.getAnoLectivo());
        mobilidade.setAreaCientifica(null);
        mobilidade.setCurso(tblMobilidadeInternacional.getCurso());
        mobilidade.setDuracaoPrograma(XmlToBaseFileWriter.duracaoProgramaValueOf(tblMobilidadeInternacional));
        mobilidade.setECTSInscricao(XmlToBaseFileWriter.bigDecimalValueOf(tblMobilidadeInternacional.getEctsInscrito()));
        mobilidade.setNivelCursoDestino(null);
        mobilidade.setNivelCursoOrigem(XmlToBaseFileWriter.longValueOf(tblMobilidadeInternacional.getNivelCursoOrigem()));
        mobilidade.setPaisOrigemMobilidadeCredito(tblMobilidadeInternacional.getPaisOrigemMobilidadeCredito());
        mobilidade.setOutroNivelCurDestino(null);
        mobilidade.setOutroNivelCurOrigem(tblMobilidadeInternacional.getOutroNivelCurOrigem());
        mobilidade.setOutroPrograma(tblMobilidadeInternacional.getOutroPrograma());
        mobilidade.setProgMobilidade(XmlToBaseFileWriter.longValueOf(tblMobilidadeInternacional.getProgMobilidade()));
        mobilidade.setAreaCientifica(tblMobilidadeInternacional.getAreaCientifica());
        mobilidade.setNivelCursoDestino(XmlToBaseFileWriter.longValueOf(tblMobilidadeInternacional.getNivelCursoDestino()));
        mobilidade.setOutroNivelCurDestino(tblMobilidadeInternacional.getOutroNivelCursoDestino());
        if (!Strings.isNullOrEmpty((String)tblMobilidadeInternacional.getRamo())) {
            mobilidade.setRamo(tblMobilidadeInternacional.getRamo());
        }
        mobilidade.setRegimeFrequencia(XmlToBaseFileWriter.longValueOf(tblMobilidadeInternacional.getRegimeFrequencia()));
        mobilidade.setTipoProgMobilidade(XmlToBaseFileWriter.longValueOf(tblMobilidadeInternacional.getTipoProgMobilidade()));
        return mobilidade;
    }

    private static BigDecimal bigDecimalValueOf(String value) {
        if (Strings.isNullOrEmpty((String)value)) {
            return null;
        }
        return new BigDecimal(value);
    }

    private static InformacaoAlunos.Alunos.Aluno.Diplomas.Diploma fillDiploma(Raides raides, ObjectFactory factory, Student student, TblDiplomado tblDiplomado) {
        InformacaoAlunos.Alunos.Aluno.Diplomas.Diploma diploma = factory.createInformacaoAlunosAlunosAlunoDiplomasDiploma();
        diploma.setAnoEscolaridadeAnt(XmlToBaseFileWriter.longValueOf(tblDiplomado.getAnoEscolaridadeAnt()));
        diploma.setAnoLetivo(tblDiplomado.getAnoLectivo());
        diploma.setClassificacaoFinal(XmlToBaseFileWriter.longValueOf(tblDiplomado.getClassificacaoFinal()));
        diploma.setConcluiuGrau(XmlToBaseFileWriter.booleanValueOf(tblDiplomado.getConcluiGrau()));
        diploma.setConclusaoMD(XmlToBaseFileWriter.booleanValueOf(tblDiplomado.getConclusaoMd()));
        diploma.setClassificacaoFinalMD(XmlToBaseFileWriter.longValueOf(tblDiplomado.getClassificacaoFinalMd()));
        diploma.setCurso(tblDiplomado.getCurso());
        diploma.setDataDiploma(tblDiplomado.getDataDiploma());
        diploma.setEscolaridadeAnterior(XmlToBaseFileWriter.longValueOf(tblDiplomado.getEscolaridadeAnterior()));
        diploma.setOutroEscolaridadeAnterior(tblDiplomado.getOutroEscolaridadeAnterior());
        diploma.setMobilidadeCredito(XmlToBaseFileWriter.booleanValueOf(tblDiplomado.getMobilidadeCredito()));
        diploma.setNumInscConclusao(XmlToBaseFileWriter.longValueOf(tblDiplomado.getNumInscConclusao()));
        diploma.setEstabEscolaridadeAnt(tblDiplomado.getEstabEscolaridadeAnt());
        diploma.setOutroEstabEscolarAnt(tblDiplomado.getOutroEstabEscolarAnt());
        diploma.setCursoEscolarAnt(tblDiplomado.getCursoEscolarAnt());
        diploma.setOutroCursoEscolarAnt(tblDiplomado.getOutroCursoEscolarAnt());
        diploma.setOutroProgMobCredito(tblDiplomado.getOutroProgMobCredito());
        diploma.setPaisEscolaridadeAnt(tblDiplomado.getPaisEscolaridadeAnt());
        diploma.setPaisMobilidadeCredito(tblDiplomado.getPaisMobilidadeCredito());
        diploma.setProgMobilidadeCredito(XmlToBaseFileWriter.longValueOf(tblDiplomado.getProgMobilidadeCredito()));
        diploma.setAreaInvestigacao(XmlToBaseFileWriter.integerValueOf(tblDiplomado.getAreaInvestigacao()));
        if (!Strings.isNullOrEmpty((String)tblDiplomado.getRamo())) {
            diploma.setRamo(tblDiplomado.getRamo());
        } else {
            diploma.setRamo("1000017");
        }
        diploma.setTipoMobilidadeCredito(XmlToBaseFileWriter.longValueOf(tblDiplomado.getTipoMobilidadeCredito()));
        return diploma;
    }

    protected static InformacaoAlunos.Alunos.Aluno.Inscricoes.Inscricao fillInscricao(Raides raides, ObjectFactory factory, Student student, TblInscrito tblInscrito) {
        InformacaoAlunos.Alunos.Aluno.Inscricoes.Inscricao inscricao = factory.createInformacaoAlunosAlunosAlunoInscricoesInscricao();
        inscricao.setCurso(tblInscrito.getCurso());
        if (!Strings.isNullOrEmpty((String)tblInscrito.getRamo())) {
            inscricao.setRamo(tblInscrito.getRamo());
        } else {
            inscricao.setRamo("1000017");
        }
        inscricao.setAnoLetivo(tblInscrito.getAnoLectivo());
        inscricao.setAnoCurricular(XmlToBaseFileWriter.longValueOf(tblInscrito.getAnoCurricular()));
        inscricao.setPrimeiraVez(XmlToBaseFileWriter.booleanValueOf(tblInscrito.getPrimeiraVez()));
        inscricao.setRegimeFrequencia(XmlToBaseFileWriter.longValueOf(tblInscrito.getRegimeFrequencia()));
        inscricao.setNumInscNesteCurso(tblInscrito.getNumInscNesteCurso() != null ? Long.valueOf(tblInscrito.getNumInscNesteCurso().intValue()) : null);
        inscricao.setECTSInscricao(tblInscrito.getEctsInscricao() != null ? tblInscrito.getEctsInscricao().setScale(2, RoundingMode.HALF_EVEN) : null);
        inscricao.setECTSAcumulados(tblInscrito.getEctsAcumulados() != null ? tblInscrito.getEctsAcumulados().setScale(2, RoundingMode.HALF_EVEN) : null);
        inscricao.setTempoParcial(XmlToBaseFileWriter.booleanValueOf(tblInscrito.getTempoParcial()));
        inscricao.setBolseiro(XmlToBaseFileWriter.longValueOf(tblInscrito.getBolseiro()));
        inscricao.setFormaIngresso(XmlToBaseFileWriter.longValueOf(tblInscrito.getFormaIngresso()));
        inscricao.setEstabInscricaoAnt(tblInscrito.getEstabInscricaoAnt());
        inscricao.setOutroEstabInscAnt(tblInscrito.getOutroEstabInscAnt());
        inscricao.setNotaIngresso(!Strings.isNullOrEmpty((String)tblInscrito.getNotaIngresso()) ? new BigDecimal(tblInscrito.getNotaIngresso()) : null);
        inscricao.setOpcaoIngresso(XmlToBaseFileWriter.longValueOf(tblInscrito.getOpcaoIngresso()));
        inscricao.setNumInscCursosAnt(tblInscrito.getNumInscCursosAnt() != null ? Long.valueOf(tblInscrito.getNumInscCursosAnt().intValue()) : null);
        inscricao.setAnoUltimaInscricao(tblInscrito.getAnoUltimaInscricao());
        inscricao.setEstadoCivil(XmlToBaseFileWriter.longValueOf(tblInscrito.getEstadoCivil()));
        inscricao.setTrabalhadorEstudante(XmlToBaseFileWriter.booleanValueOf(tblInscrito.getEstudanteTrabalhador()));
        inscricao.setAlunoDeslocado(XmlToBaseFileWriter.booleanValueOf(tblInscrito.getAlunoDeslocado()));
        inscricao.setConcelho(tblInscrito.getResideConcelho());
        if (!Strings.isNullOrEmpty((String)tblInscrito.getNivelEscolarPai())) {
            inscricao.setNivelEscolarPai(XmlToBaseFileWriter.longValueOf(tblInscrito.getNivelEscolarPai()));
        } else {
            inscricao.setNivelEscolarPai(XmlToBaseFileWriter.longValueOf("22"));
        }
        if (!Strings.isNullOrEmpty((String)tblInscrito.getNivelEscolarMae())) {
            inscricao.setNivelEscolarMae(XmlToBaseFileWriter.longValueOf(tblInscrito.getNivelEscolarMae()));
        } else {
            inscricao.setNivelEscolarMae(XmlToBaseFileWriter.longValueOf("22"));
        }
        if (!Strings.isNullOrEmpty((String)tblInscrito.getSituacaoProfPai())) {
            inscricao.setSituacaoProfPai(XmlToBaseFileWriter.longValueOf(tblInscrito.getSituacaoProfPai()));
        } else {
            inscricao.setSituacaoProfPai(XmlToBaseFileWriter.longValueOf("19"));
        }
        if (!Strings.isNullOrEmpty((String)tblInscrito.getSituacaoProfMae())) {
            inscricao.setSituacaoProfMae(XmlToBaseFileWriter.longValueOf(tblInscrito.getSituacaoProfMae()));
        } else {
            inscricao.setSituacaoProfMae(XmlToBaseFileWriter.longValueOf("19"));
        }
        if (!Strings.isNullOrEmpty((String)tblInscrito.getSituacaoProfAluno()) && !"19".equals(tblInscrito.getSituacaoProfAluno())) {
            inscricao.setSituacaoProfAluno(XmlToBaseFileWriter.longValueOf(tblInscrito.getSituacaoProfAluno()));
        } else {
            inscricao.setSituacaoProfAluno(XmlToBaseFileWriter.longValueOf("17"));
        }
        if (!Strings.isNullOrEmpty((String)tblInscrito.getProfissaoPai())) {
            inscricao.setProfissaoPai(XmlToBaseFileWriter.longValueOf(tblInscrito.getProfissaoPai()));
        } else {
            inscricao.setProfissaoPai(XmlToBaseFileWriter.longValueOf("21"));
        }
        if (!Strings.isNullOrEmpty((String)tblInscrito.getProfissaoMae())) {
            inscricao.setProfissaoMae(XmlToBaseFileWriter.longValueOf(tblInscrito.getProfissaoMae()));
        } else {
            inscricao.setProfissaoMae(XmlToBaseFileWriter.longValueOf("21"));
        }
        if (!Strings.isNullOrEmpty((String)tblInscrito.getProfissaoAluno()) && !"21".equals(tblInscrito.getProfissaoAluno())) {
            inscricao.setProfissaoAluno(XmlToBaseFileWriter.longValueOf(tblInscrito.getProfissaoAluno()));
        } else {
            inscricao.setProfissaoAluno(XmlToBaseFileWriter.longValueOf("20"));
        }
        inscricao.setEscolaridadeAnterior(XmlToBaseFileWriter.longValueOf(tblInscrito.getEscolaridadeAnterior()));
        inscricao.setOutroEscolaridadeAnterior(tblInscrito.getOutroEscolaridadeAnterior());
        inscricao.setPaisEscolaridadeAnt(tblInscrito.getPaisEscolaridadeAnt());
        inscricao.setAnoEscolaridadeAnt(XmlToBaseFileWriter.longValueOf(tblInscrito.getAnoEscolaridadeAnt()));
        inscricao.setEstabEscolaridadeAnt(tblInscrito.getEstabEscolaridadeAnt());
        inscricao.setOutroEstabEscolarAnt(tblInscrito.getOutroEstabEscolarAnt());
        inscricao.setCursoEscolarAnt(tblInscrito.getCursoEscolarAnt());
        inscricao.setOutroCursoEscolarAnt(tblInscrito.getOutroCursoEscolarAnt());
        inscricao.setTipoEstabSec(XmlToBaseFileWriter.longValueOf(tblInscrito.getTipoEstabSec()));
        return inscricao;
    }

    protected static InformacaoAlunos.Alunos.Aluno.Identificacao fillIdentificacaoAluno(Raides raides, ObjectFactory factory, Student student) {
        InformacaoAlunos.Alunos.Aluno.Identificacao identificacao = factory.createInformacaoAlunosAlunosAlunoIdentificacao();
        TblIdentificacao tblIdentificacao = raides.identificacaoForStudent(student);
        identificacao.setDataNascimento(tblIdentificacao.getDataNasc());
        identificacao.setNome(tblIdentificacao.getNome());
        identificacao.setNumeroAluno(tblIdentificacao.getIdAluno().toString());
        NumeroID numeroID = factory.createNumeroID();
        numeroID.setValue(tblIdentificacao.getNumId());
        numeroID.setTipo(Long.valueOf(tblIdentificacao.getTipoId()));
        numeroID.setDigitosControlo(tblIdentificacao.getCheckDigitId());
        identificacao.setNumeroID(numeroID);
        identificacao.setOutroTipoID(tblIdentificacao.getTipoIdDescr());
        identificacao.setPaisDeNacionalidade(tblIdentificacao.getNacionalidade());
        if (!Strings.isNullOrEmpty((String)tblIdentificacao.getOutroPaisDeNacionalidade())) {
            identificacao.setOutroPaisDeNacionalidade(tblIdentificacao.getOutroPaisDeNacionalidade());
        }
        if (!Strings.isNullOrEmpty((String)tblIdentificacao.getPaisEnsinoSecundario())) {
            identificacao.setPaisEnsinoSec(tblIdentificacao.getPaisEnsinoSecundario());
        } else {
            identificacao.setPaisEnsinoSec("PT");
        }
        identificacao.setPaisResidencia(tblIdentificacao.getResidePais());
        identificacao.setSexo(tblIdentificacao.getSexo());
        return identificacao;
    }

    protected static void fillExtracao(RaidesRequestParameter raidesRequestParameter, ObjectFactory factory, InformacaoAlunos informacaoAlunos) {
        InformacaoAlunos.Extracao extracao = factory.createInformacaoAlunosExtracao();
        informacaoAlunos.setExtracao(extracao);
        extracao.setCodigoEstabelecimento(raidesRequestParameter.getInstitutionCode());
        extracao.setDataExtracao(new LocalDate());
        extracao.setMomento(Integer.valueOf(raidesRequestParameter.getMoment()));
    }

    protected static Long longValueOf(String value) {
        if (Strings.isNullOrEmpty((String)value)) {
            return null;
        }
        return Long.valueOf(value);
    }

    protected static Long longValueOf(BigDecimal value) {
        if (value == null) {
            return null;
        }
        return value.longValue();
    }

    protected static DuracaoPrograma duracaoProgramaValueOf(TblMobilidadeInternacional tblMobilidadeInternacional) {
        if (Strings.isNullOrEmpty((String)tblMobilidadeInternacional.getDuracaoPrograma())) {
            return null;
        }
        return DuracaoPrograma.fromValue(tblMobilidadeInternacional.getDuracaoPrograma());
    }

    protected static Boolean booleanValueOf(String value) {
        if (Strings.isNullOrEmpty((String)value)) {
            return null;
        }
        return Boolean.valueOf(value);
    }

    protected static Integer integerValueOf(String value) {
        if (Strings.isNullOrEmpty((String)value)) {
            return null;
        }
        return Integer.valueOf(value);
    }
}

