/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.legalpt.services.a3es.process;

import java.math.BigDecimal;
import java.text.Collator;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang.StringUtils;
import org.fenixedu.academic.domain.CompetenceCourse;
import org.fenixedu.academic.domain.CurricularCourse;
import org.fenixedu.academic.domain.Degree;
import org.fenixedu.academic.domain.DegreeCurricularPlan;
import org.fenixedu.academic.domain.ExecutionInterval;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.Job;
import org.fenixedu.academic.domain.Job_Base;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.Professorship;
import org.fenixedu.academic.domain.Qualification;
import org.fenixedu.academic.domain.Qualification_Base;
import org.fenixedu.academic.domain.ShiftProfessorship;
import org.fenixedu.academic.domain.ShiftType;
import org.fenixedu.academic.domain.Teacher;
import org.fenixedu.academic.domain.TeacherAuthorization;
import org.fenixedu.academic.domain.TeacherCategory;
import org.fenixedu.academic.domain.academicStructure.AcademicArea;
import org.fenixedu.academic.domain.academicStructure.AcademicAreaType;
import org.fenixedu.academic.domain.dml.DynamicField;
import org.fenixedu.academic.domain.organizationalStructure.Unit;
import org.fenixedu.academic.domain.person.JobType;
import org.fenixedu.academic.domain.person.qualifications.QualificationLevel;
import org.fenixedu.academic.domain.researchPublication.ResearchPublication;
import org.fenixedu.academic.domain.researchPublication.ResearchPublicationType;
import org.fenixedu.bennu.core.domain.Bennu;
import org.fenixedu.commons.i18n.LocalizedString;
import org.fenixedu.legalpt.domain.a3es.A3esInstance;
import org.fenixedu.legalpt.domain.a3es.A3esProcessType;
import org.fenixedu.legalpt.domain.a3es.mapping.A3esMappingType;
import org.fenixedu.legalpt.domain.teacher.SpecialistTitle;
import org.fenixedu.legalpt.dto.a3es.A3esProcessBean;
import org.fenixedu.legalpt.dto.a3es.A3esTeacherBean;
import org.fenixedu.legalpt.services.a3es.process.A3esExportService;
import org.fenixedu.ulisboa.specifications.domain.legal.mapping.LegalMapping;
import org.fenixedu.ulisboa.specifications.domain.legal.report.LegalReport;
import org.joda.time.DateTime;
import org.joda.time.LocalDate;
import pt.ist.fenixframework.DomainObject;
import pt.ist.fenixframework.core.AbstractDomainObject;

public class A3esHarvestTeachersDataService {
    private static final int _PRIME_PUBLICATIONS_MIN_YEAR = 5;
    private static final int _QUALIFICATIONS = 3;
    private static final int _PUBLICATIONS = 5;
    private static final int _ACTIVITIES = 5;
    private static final int _TEACHING_SERVICES = 10;
    private static final int _OTHER_TEACHING_SERVICES = 10;
    private final ExecutionYear year;
    private final ExecutionInterval semester;
    private final DegreeCurricularPlan degreeCurricularPlan;
    private final String processStudyCycle;

    public A3esHarvestTeachersDataService(A3esProcessBean bean) {
        this.year = bean.getExecutionYear();
        this.semester = this.year.getFirstExecutionPeriod();
        this.degreeCurricularPlan = bean.getDegreeCurricularPlan();
        this.processStudyCycle = this.degreeCurricularPlan.getDegree().getNameFor(this.year).getContent() + " (" + this.degreeCurricularPlan.getDegree().getDegreeType().getName().getContent().substring(0, 1) + ")" + A3esExportService.SEMICOLON;
        Set coordinators = this.degreeCurricularPlan.getExecutionDegreesSet().stream().filter(ed -> ed.getExecutionYear() == this.year).flatMap(ed -> ed.getCoordinatorsListSet().stream()).map(c -> c.getPerson()).collect(Collectors.toSet());
        A3esExportService.readPersonProfessorships(this.degreeCurricularPlan, this.year).entrySet().stream().map(entry -> {
            Map personProfessorships = (Map)entry.getValue();
            Person person = (Person)entry.getKey();
            Teacher teacher = bean.getTeacher();
            if (teacher != null && person != teacher.getPerson() && !coordinators.contains(teacher.getPerson())) {
                return null;
            }
            A3esTeacherBean data = new A3esTeacherBean();
            TeacherAuthorization auth = this.getTeacherAuthorization(person);
            A3esHarvestTeachersDataService.fillName(data, person);
            A3esHarvestTeachersDataService.fillInstitutionName(data);
            A3esHarvestTeachersDataService.fillSchoolName(data);
            this.fillAssociatedResearchCentre(data, person);
            this.fillCategory(data, auth);
            A3esHarvestTeachersDataService.fillSpecialty(data, person);
            A3esHarvestTeachersDataService.fillTimeAllocation(data, auth);
            A3esHarvestTeachersDataService.fillAttainedDegree(data, person);
            A3esHarvestTeachersDataService.fillOtherAttainedDegrees(data, person);
            A3esHarvestTeachersDataService.fillPrimePublishedWork(data, person);
            A3esHarvestTeachersDataService.fillPrimeProfessionalActivities(data, person);
            A3esHarvestTeachersDataService.fillOtherPublishedWork(data, person);
            A3esHarvestTeachersDataService.fillOtherProfessionalActivities(data, person);
            if (bean.getProcess().getType().equals((Object)A3esProcessType.EVALUATION_OF_NEW_PROGRAM)) {
                this.fillTeachingService(data, personProfessorships);
                this.fillOtherTeachingService(data, personProfessorships);
            } else {
                this.fillTeachingServiceOriginal(data, personProfessorships);
            }
            return data;
        }).filter(i -> i != null).collect(Collectors.toCollection(() -> bean.getTeachersData()));
    }

    private void fillBasics(A3esTeacherBean data, Person person) {
        ExecutionYear firstTeacherService = person.getProfessorshipsSet().stream().filter(p -> p.getExecutionCourse().getAssociatedCurricularCoursesSet().stream().anyMatch(cc -> cc.getDegreeCurricularPlan() == this.degreeCurricularPlan)).map(p -> p.getExecutionCourse().getExecutionYear()).distinct().min(Comparator.naturalOrder()).orElse(null);
        data.addField("firstTeacherService", "firstTeacherService", firstTeacherService.getQualifiedName(), A3esExportService._UNSUPPORTED);
    }

    private static void fillName(A3esTeacherBean data, Person person) {
        data.addField("name", "name", person.getName(), A3esExportService._200);
    }

    private static void fillInstitutionName(A3esTeacherBean data) {
        Unit currentInstitution = Bennu.getInstance().getInstitutionUnit();
        Unit university = currentInstitution.getParentUnits().stream().filter(u -> u.isUniversityUnit()).findFirst().orElse(currentInstitution);
        data.addField("ies", "higherEducationInstitution", university.getName(), A3esExportService._200);
    }

    private static void fillSchoolName(A3esTeacherBean data) {
        data.addField("uo", "organicUnit", Bennu.getInstance().getInstitutionUnit().getName(), A3esExportService._200);
    }

    private void fillAssociatedResearchCentre(A3esTeacherBean data, Person person) {
        String code = "teacherResearchCenterMembership";
        DynamicField field = DynamicField.findField((DomainObject)person, (String)"teacherResearchCenterMembership");
        data.addField("research_center", "researchUnitFiliation", field == null ? null : (String)field.getValue(String.class), A3esExportService._200);
    }

    private void fillCategory(A3esTeacherBean data, TeacherAuthorization auth) {
        TeacherCategory category = auth == null ? null : auth.getTeacherCategory();
        String source = LegalMapping.find((LegalReport)((Object)A3esInstance.getInstance()), A3esMappingType.CONTRACT_CATEGORY).translate((DomainObject)category);
        data.addField("cat", "category", source, A3esExportService._UNLIMITED);
    }

    private TeacherAuthorization getTeacherAuthorization(Person person) {
        Teacher teacher = person == null ? null : person.getTeacher();
        return teacher == null ? null : (TeacherAuthorization)teacher.getLatestTeacherAuthorizationInInterval(this.year.getAcademicInterval().toInterval()).orElse(null);
    }

    private static void fillSpecialty(A3esTeacherBean data, Person person) {
        String code = "teacherSpecialistTitle";
        DynamicField field = DynamicField.findField((DomainObject)person, (String)"teacherSpecialistTitle");
        data.addField("spec", "specialist", field == null || field.getValue(String.class) == null ? null : LegalMapping.find((LegalReport)((Object)A3esInstance.getInstance()), A3esMappingType.SPECIALIST_TITLE).translate(SpecialistTitle.valueOf((String)field.getValue(String.class))), A3esExportService._100);
        DynamicField specialistAreaField = DynamicField.findField((DomainObject)person, (String)"teacherSpecialistArea");
        data.addField("spec_area", "specialistArea", specialistAreaField == null ? null : (String)specialistAreaField.getValue(String.class), A3esExportService._200);
    }

    private static void fillTimeAllocation(A3esTeacherBean data, TeacherAuthorization auth) {
        Double allocation = auth == null ? null : auth.getWorkPercentageInInstitution();
        String source = allocation == null ? null : BigDecimal.valueOf(allocation).stripTrailingZeros().toPlainString();
        data.addField("time", "regime", source, A3esExportService._30);
    }

    private static void fillAttainedDegree(A3esTeacherBean data, Person person) {
        Qualification q = A3esHarvestTeachersDataService.findMostRelevantQualification(person);
        A3esTeacherBean.AttainedDegree attainedDegree = new A3esTeacherBean.AttainedDegree();
        data.setAttainedDegree(attainedDegree);
        String year = q == null ? null : q.getYear();
        String level = A3esHarvestTeachersDataService.getDegreeLevel(q);
        String area = A3esHarvestTeachersDataService.getDegreeArea(q);
        String institution = A3esHarvestTeachersDataService.getDegreeInstitution(q);
        attainedDegree.addField("deg", "degreeType", level, A3esExportService._200);
        attainedDegree.addField("degarea", "degreeScientificArea", area, A3esExportService._200);
        attainedDegree.addField("ano_grau", "degreeYear", year, A3esExportService._UNLIMITED);
        attainedDegree.addField("instituicao_conferente", "degreeInstitution", institution, A3esExportService._200);
    }

    private static String getDegreeLevel(Qualification q) {
        QualificationLevel level = q == null ? null : q.getLevel();
        return level == null ? null : LegalMapping.find((LegalReport)((Object)A3esInstance.getInstance()), A3esMappingType.SCHOOL_LEVEL).translate((DomainObject)level);
    }

    private static String getDegreeArea(Qualification q) {
        if (q != null) {
            if (!StringUtils.isBlank((String)q.getSpecializationArea())) {
                return q.getSpecializationArea().trim();
            }
            if (q.getDegreeUnit() != null) {
                return q.getDegreeUnit().getName();
            }
            if (!StringUtils.isBlank((String)q.getDegree())) {
                return q.getDegree().trim();
            }
        }
        return q == null ? null : q.getSpecializationArea();
    }

    private static String getDegreeInstitution(Qualification q) {
        return q == null ? null : (q.getInstitutionUnit() != null ? q.getInstitutionUnit().getName() : q.getSchool());
    }

    private static void fillOtherAttainedDegrees(A3esTeacherBean data, Person person) {
        LinkedHashSet<A3esTeacherBean.AttainedDegree> otherAttainedDegrees = new LinkedHashSet<A3esTeacherBean.AttainedDegree>();
        Qualification main = A3esHarvestTeachersDataService.findMostRelevantQualification(person);
        person.getAssociatedQualificationsSet().stream().filter(q -> q != main).sorted(Comparator.comparing(Qualification_Base::getYear, Comparator.nullsFirst(Comparator.naturalOrder())).reversed()).forEach(q -> {
            if (otherAttainedDegrees.size() == 3) {
                return;
            }
            A3esTeacherBean.AttainedDegree attainedDegree = new A3esTeacherBean.AttainedDegree();
            otherAttainedDegrees.add(attainedDegree);
            String year = q == null ? null : q.getYear();
            String level = StringUtils.isNotBlank((String)q.getOtherLevel()) ? q.getOtherLevel() : A3esHarvestTeachersDataService.getDegreeLevel(q);
            String area = A3esHarvestTeachersDataService.getDegreeArea(q);
            String institution = A3esHarvestTeachersDataService.getDegreeInstitution(q);
            String classification = q.getMark();
            attainedDegree.addField("year", "year", year, A3esExportService._UNLIMITED);
            attainedDegree.addField("degree", "degreeTypeOrTitle", level, A3esExportService._30);
            attainedDegree.addField("area", "area", area, A3esExportService._100);
            attainedDegree.addField("ies", "institution", institution, A3esExportService._100);
            attainedDegree.addField("rank", "classification", classification, A3esExportService._30);
        });
        data.setOtherAttainedDegrees(otherAttainedDegrees);
    }

    private static void fillPrimePublishedWork(A3esTeacherBean data, Person person) {
        A3esTeacherBean.TeacherActivity result = new A3esTeacherBean.TeacherActivity();
        String id = "investigation";
        for (String source : A3esHarvestTeachersDataService.findPublications(person, ResearchPublicationType.findByCode((String)"AC"), new DateTime().getYear() - 5)) {
            if (result.getField("investigation").size() == 5) break;
            result.addField("investigation", "investigation", source, A3esExportService._500);
        }
        data.setPrimePublishedWork(result);
    }

    private static void fillPrimeProfessionalActivities(A3esTeacherBean data, Person person) {
        A3esTeacherBean.TeacherActivity result = new A3esTeacherBean.TeacherActivity();
        String id = "highlevelactivities";
        for (String source : A3esHarvestTeachersDataService.findJobs(person, JobType.findByCode((String)"ADNP"))) {
            if (result.getField(id).size() == 5) break;
            result.addField(id, id, source, A3esExportService._200);
        }
        data.setPrimeProfessionalActivities(result);
    }

    private static void fillOtherPublishedWork(A3esTeacherBean data, Person person) {
        A3esTeacherBean.TeacherActivity result = new A3esTeacherBean.TeacherActivity();
        String id = "otherpublications";
        for (String source : A3esHarvestTeachersDataService.findPublications(person, ResearchPublicationType.findByCode((String)"PP"), null)) {
            if (result.getField("otherpublications").size() == 5) break;
            result.addField("otherpublications", "otherpublications", source, A3esExportService._500);
        }
        data.setOtherPublishedWork(result);
    }

    private static void fillOtherProfessionalActivities(A3esTeacherBean data, Person person) {
        A3esTeacherBean.TeacherActivity result = new A3esTeacherBean.TeacherActivity();
        String id = "profession";
        for (String source : A3esHarvestTeachersDataService.findJobs(person, JobType.findByCode((String)"EP"))) {
            if (result.getField("profession").size() == 5) break;
            result.addField("profession", "profession", source, A3esExportService._200);
        }
        data.setOtherProfessionalActivities(result);
    }

    private void fillTeachingServiceOriginal(A3esTeacherBean data, Map<CompetenceCourse, Set<Professorship>> personProfessorships) {
        LinkedHashSet<A3esTeacherBean.TeachingService> teachingServices = new LinkedHashSet<A3esTeacherBean.TeachingService>();
        Stream<Map.Entry<CompetenceCourse, Set<Professorship>>> sorted = personProfessorships.entrySet().stream().sorted((x, y) -> Collator.getInstance().compare(((CompetenceCourse)x.getKey()).getName(), ((CompetenceCourse)y.getKey()).getName()));
        if (A3esInstance.getInstance().getGroupPersonProfessorshipByCourse()) {
            this.fillTeachingServiceByCourseOriginal(teachingServices, sorted);
        } else {
            this.fillTeachingServiceByShiftTypeOriginal(teachingServices, sorted);
        }
        data.setTeachingServices(teachingServices);
    }

    private void fillTeachingServiceByShiftTypeOriginal(Set<A3esTeacherBean.TeachingService> teachingServices, Stream<Map.Entry<CompetenceCourse, Set<Professorship>>> personProfessorships) {
        personProfessorships.forEach(entry -> {
            CompetenceCourse competence = (CompetenceCourse)entry.getKey();
            Set competenceProfessorships = (Set)entry.getValue();
            competenceProfessorships.stream().flatMap(p -> p.getAssociatedShiftProfessorshipSet().stream()).forEach(sp -> {
                if (teachingServices.size() == 10) {
                    return;
                }
                ShiftType type = A3esHarvestTeachersDataService.getShiftType(sp);
                if (type == null) {
                    return;
                }
                A3esTeacherBean.TeachingService service = new A3esTeacherBean.TeachingService();
                teachingServices.add(service);
                service.addField("curricularUnit", "curricularUnit", this.getCourseName(competence), A3esExportService._100);
                Stream<CurricularCourse> courses = sp.getProfessorship().getExecutionCourse().getAssociatedCurricularCoursesSet().stream();
                String studyCycle = this.getStudyCycles(courses);
                service.addField("studyCycle", "studyCycle", studyCycle, A3esExportService._200);
                String shiftType = A3esExportService.getShiftTypeAcronym(type);
                service.addField("type", "type", shiftType, A3esExportService._30);
                BigDecimal hours = A3esExportService.calculateTeachingHours(sp);
                service.addField("hoursPerWeek", "totalContactHours", hours.toPlainString(), A3esExportService._UNLIMITED);
            });
        });
    }

    private void fillTeachingServiceByCourseOriginal(Set<A3esTeacherBean.TeachingService> teachingServices, Stream<Map.Entry<CompetenceCourse, Set<Professorship>>> personProfessorships) {
        personProfessorships.forEach(entry -> {
            CompetenceCourse competence = (CompetenceCourse)entry.getKey();
            Set competenceProfessorships = (Set)entry.getValue();
            if (teachingServices.size() == 10) {
                return;
            }
            Set shiftProfessorships = competenceProfessorships.stream().flatMap(p -> p.getAssociatedShiftProfessorshipSet().stream()).filter(sp -> A3esHarvestTeachersDataService.getShiftType(sp) != null).collect(Collectors.toSet());
            if (shiftProfessorships.isEmpty()) {
                return;
            }
            A3esTeacherBean.TeachingService service = new A3esTeacherBean.TeachingService();
            teachingServices.add(service);
            service.addField("curricularUnit", "curricularUnit", this.getCourseName(competence), A3esExportService._100);
            Stream<CurricularCourse> courses = shiftProfessorships.stream().flatMap(sp -> sp.getProfessorship().getExecutionCourse().getAssociatedCurricularCoursesSet().stream());
            String studyCycle = this.getStudyCycles(courses);
            service.addField("studyCycle", "studyCycle", studyCycle, A3esExportService._200);
            String shiftType = shiftProfessorships.stream().map(sp -> A3esExportService.getShiftTypeAcronym(A3esHarvestTeachersDataService.getShiftType(sp))).distinct().sorted().collect(Collectors.joining(","));
            service.addField("type", "type", shiftType, A3esExportService._30);
            BigDecimal hours = shiftProfessorships.stream().map(sp -> A3esExportService.calculateTeachingHours(sp)).reduce(BigDecimal.ZERO, BigDecimal::add);
            service.addField("hoursPerWeek", "totalContactHours", hours.toPlainString(), A3esExportService._UNLIMITED);
        });
    }

    private void fillTeachingService(A3esTeacherBean data, Map<CompetenceCourse, Set<Professorship>> personProfessorships) {
        LinkedHashSet<A3esTeacherBean.TeachingService> teachingServices = new LinkedHashSet<A3esTeacherBean.TeachingService>();
        Stream<Map.Entry<CompetenceCourse, Set<Professorship>>> sorted = personProfessorships.entrySet().stream().sorted((x, y) -> Collator.getInstance().compare(((CompetenceCourse)x.getKey()).getName(), ((CompetenceCourse)y.getKey()).getName()));
        if (A3esInstance.getInstance().getGroupPersonProfessorshipByCourse()) {
            this.fillTeachingServiceByCourse(teachingServices, sorted);
        } else {
            this.fillTeachingServiceByShiftType(teachingServices, sorted);
        }
        data.setTeachingServices(teachingServices);
    }

    private void fillTeachingServiceByShiftType(Set<A3esTeacherBean.TeachingService> teachingServices, Stream<Map.Entry<CompetenceCourse, Set<Professorship>>> personProfessorships) {
        personProfessorships.forEach(entry -> {
            CompetenceCourse competence = (CompetenceCourse)entry.getKey();
            Set competenceProfessorships = (Set)entry.getValue();
            competenceProfessorships.stream().flatMap(p -> p.getAssociatedShiftProfessorshipSet().stream()).forEach(sp -> {
                if (teachingServices.size() == 10) {
                    return;
                }
                ShiftType type = A3esHarvestTeachersDataService.getShiftType(sp);
                if (type == null) {
                    return;
                }
                Stream<CurricularCourse> courses = sp.getProfessorship().getExecutionCourse().getAssociatedCurricularCoursesSet().stream();
                String studyCycle = this.getStudyCycles(courses);
                if (studyCycle.contains(this.processStudyCycle)) {
                    A3esTeacherBean.TeachingService service = new A3esTeacherBean.TeachingService();
                    teachingServices.add(service);
                    service.addField("curricularUnit", "curricularUnit", this.getCourseName(competence), A3esExportService._100);
                    String shiftType = A3esExportService.getShiftTypeAcronym(type);
                    service.addField("type", "type", shiftType, A3esExportService._30);
                    BigDecimal hours = A3esExportService.calculateTeachingHours(sp);
                    service.addField("hoursPerWeek", "totalContactHours", hours.toPlainString(), A3esExportService._UNLIMITED);
                }
            });
        });
    }

    private void fillTeachingServiceByCourse(Set<A3esTeacherBean.TeachingService> teachingServices, Stream<Map.Entry<CompetenceCourse, Set<Professorship>>> personProfessorships) {
        personProfessorships.forEach(entry -> {
            CompetenceCourse competence = (CompetenceCourse)entry.getKey();
            Set competenceProfessorships = (Set)entry.getValue();
            if (teachingServices.size() == 10) {
                return;
            }
            Set shiftProfessorships = competenceProfessorships.stream().flatMap(p -> p.getAssociatedShiftProfessorshipSet().stream()).filter(sp -> A3esHarvestTeachersDataService.getShiftType(sp) != null).collect(Collectors.toSet());
            if (shiftProfessorships.isEmpty()) {
                return;
            }
            Stream<CurricularCourse> courses = shiftProfessorships.stream().flatMap(sp -> sp.getProfessorship().getExecutionCourse().getAssociatedCurricularCoursesSet().stream());
            String studyCycle = this.getStudyCycles(courses);
            if (studyCycle.contains(this.processStudyCycle)) {
                A3esTeacherBean.TeachingService service = new A3esTeacherBean.TeachingService();
                teachingServices.add(service);
                service.addField("curricularUnit", "curricularUnit", this.getCourseName(competence), A3esExportService._100);
                String shiftType = shiftProfessorships.stream().map(sp -> A3esExportService.getShiftTypeAcronym(A3esHarvestTeachersDataService.getShiftType(sp))).distinct().sorted().collect(Collectors.joining(","));
                service.addField("type", "type", shiftType, A3esExportService._30);
                BigDecimal hours = shiftProfessorships.stream().map(sp -> A3esExportService.calculateTeachingHours(sp)).reduce(BigDecimal.ZERO, BigDecimal::add);
                service.addField("hoursPerWeek", "totalContactHours", hours.toPlainString(), A3esExportService._UNLIMITED);
            }
        });
    }

    private void fillOtherTeachingService(A3esTeacherBean data, Map<CompetenceCourse, Set<Professorship>> personProfessorships) {
        LinkedHashSet<A3esTeacherBean.OtherTeachingService> otherTeachingServices = new LinkedHashSet<A3esTeacherBean.OtherTeachingService>();
        Stream<Map.Entry<CompetenceCourse, Set<Professorship>>> sorted = personProfessorships.entrySet().stream().sorted((x, y) -> Collator.getInstance().compare(((CompetenceCourse)x.getKey()).getName(), ((CompetenceCourse)y.getKey()).getName()));
        if (A3esInstance.getInstance().getGroupPersonProfessorshipByCourse()) {
            this.fillOtherTeachingServiceByCourse(otherTeachingServices, sorted);
        } else {
            this.fillOtherTeachingServiceByShiftType(otherTeachingServices, sorted);
        }
        data.setOtherTeachingServices(otherTeachingServices);
    }

    private void fillOtherTeachingServiceByShiftType(Set<A3esTeacherBean.OtherTeachingService> otherTeachingServices, Stream<Map.Entry<CompetenceCourse, Set<Professorship>>> personProfessorships) {
        personProfessorships.forEach(entry -> {
            CompetenceCourse competence = (CompetenceCourse)entry.getKey();
            Set competenceProfessorships = (Set)entry.getValue();
            competenceProfessorships.stream().flatMap(p -> p.getAssociatedShiftProfessorshipSet().stream()).forEach(sp -> {
                if (otherTeachingServices.size() == 10) {
                    return;
                }
                ShiftType type = A3esHarvestTeachersDataService.getShiftType(sp);
                if (type == null) {
                    return;
                }
                Stream<CurricularCourse> courses = sp.getProfessorship().getExecutionCourse().getAssociatedCurricularCoursesSet().stream();
                String studyCycle = this.getStudyCycles(courses);
                if (!studyCycle.contains(this.processStudyCycle)) {
                    A3esTeacherBean.OtherTeachingService service = new A3esTeacherBean.OtherTeachingService();
                    otherTeachingServices.add(service);
                    service.addField("otherCurricularUnit", "otherCurricularUnit", this.getCourseName(competence), A3esExportService._100);
                    service.addField("studyCycle", "studyCycle", studyCycle, A3esExportService._200);
                    BigDecimal hours = A3esExportService.calculateTeachingHours(sp);
                    service.addField("contactHours", "totalContactHours", hours.toPlainString(), A3esExportService._UNLIMITED);
                }
            });
        });
    }

    private void fillOtherTeachingServiceByCourse(Set<A3esTeacherBean.OtherTeachingService> otherTeachingServices, Stream<Map.Entry<CompetenceCourse, Set<Professorship>>> personProfessorships) {
        personProfessorships.forEach(entry -> {
            CompetenceCourse competence = (CompetenceCourse)entry.getKey();
            Set competenceProfessorships = (Set)entry.getValue();
            if (otherTeachingServices.size() == 10) {
                return;
            }
            Set shiftProfessorships = competenceProfessorships.stream().flatMap(p -> p.getAssociatedShiftProfessorshipSet().stream()).filter(sp -> A3esHarvestTeachersDataService.getShiftType(sp) != null).collect(Collectors.toSet());
            if (shiftProfessorships.isEmpty()) {
                return;
            }
            Stream<CurricularCourse> courses = shiftProfessorships.stream().flatMap(sp -> sp.getProfessorship().getExecutionCourse().getAssociatedCurricularCoursesSet().stream());
            String studyCycle = this.getStudyCycles(courses);
            if (!studyCycle.contains(this.processStudyCycle)) {
                A3esTeacherBean.OtherTeachingService service = new A3esTeacherBean.OtherTeachingService();
                otherTeachingServices.add(service);
                service.addField("otherCurricularUnit", "otherCurricularUnit", this.getCourseName(competence), A3esExportService._100);
                service.addField("studyCycle", "studyCycle", studyCycle, A3esExportService._200);
                BigDecimal hours = shiftProfessorships.stream().map(sp -> A3esExportService.calculateTeachingHours(sp)).reduce(BigDecimal.ZERO, BigDecimal::add);
                service.addField("contactHours", "totalContactHours", hours.toPlainString(), A3esExportService._UNLIMITED);
            }
        });
    }

    private String getCourseName(CompetenceCourse course) {
        LocalizedString i18n = course.getNameI18N(this.semester);
        Object result = i18n.getContent(A3esExportService.PT);
        if (i18n.getContent(A3esExportService.EN) != null) {
            result = (String)result + " | " + i18n.getContent(A3esExportService.EN);
        }
        return result;
    }

    private static ShiftType getShiftType(ShiftProfessorship sp) {
        List types = sp.getShift().getTypes();
        if (types.size() != 1) {
            return null;
        }
        return (ShiftType)types.iterator().next();
    }

    private String getStudyCycles(Stream<CurricularCourse> courses) {
        if (A3esInstance.getInstance().getStudyCycleByDegree()) {
            return this.getStudyCycleByDegree(courses);
        }
        return this.getStudyCycleByName(courses);
    }

    private String getStudyCycleByName(Stream<CurricularCourse> courses) {
        String studyCycle = courses.flatMap(c -> c.getDegree().getCycleTypes().stream()).map(ct -> ct.getDescriptionI18N().getContent()).distinct().sorted().collect(Collectors.joining(A3esExportService.SEMICOLON));
        return studyCycle;
    }

    private String getStudyCycleByDegree(Stream<CurricularCourse> coursesStream) {
        Set courses = coursesStream.collect(Collectors.toSet());
        boolean containsDcp = courses.stream().anyMatch(c -> c.getDegreeCurricularPlan() == this.degreeCurricularPlan);
        Set otherDegrees = courses.stream().map(c -> c.getDegree()).filter(d -> d != this.degreeCurricularPlan.getDegree()).collect(Collectors.toSet());
        Function<Degree, String> degreeFormatter = d -> d.getNameFor(this.year).getContent() + " (" + d.getDegreeType().getName().getContent().substring(0, 1) + ")";
        return (String)(containsDcp ? degreeFormatter.apply(this.degreeCurricularPlan.getDegree()) + A3esExportService.SEMICOLON : "") + otherDegrees.stream().map(degreeFormatter).distinct().sorted().collect(Collectors.joining(A3esExportService.SEMICOLON));
    }

    private static String findSpecializationArea(Person person) {
        String result = null;
        Qualification qualification = A3esHarvestTeachersDataService.findMostRelevantQualification(person);
        if (qualification != null && StringUtils.isBlank((String)(result = qualification.getSpecializationArea()))) {
            AcademicArea area = qualification.getAcademicAreasSet().stream().filter(a -> a.getType() == AcademicAreaType.findByCode((String)"DEGREE_SPECIALIZATION")).findFirst().orElse(null);
            result = area == null ? null : area.getName().getContent(A3esExportService.PT);
        }
        return result;
    }

    private static Qualification findMostRelevantQualification(Person person) {
        return person.getAssociatedQualificationsSet().stream().filter(q -> q.getMainQualification()).findAny().orElse(null);
    }

    private static Set<String> findPublications(Person person, Optional<ResearchPublicationType> type, Integer minYear) {
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        ResearchPublication.findPublicationsSortedByRelevance((Person)person, (ResearchPublicationType)type.orElse(null)).stream().filter(r -> minYear == null || r.getYear() != null && r.getYear() >= minYear).forEach(r -> result.add(A3esExportService.getApaFormat(r.getAuthors(), r.getYear() == null ? null : r.getYear().toString(), r.getTitle() == null ? null : r.getTitle().toString(), r.getPublicationData())));
        return result;
    }

    private static Set<String> findJobs(Person person, Optional<JobType> type) {
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        A3esHarvestTeachersDataService.findJobsSortedByBeginDate(person, type.orElse(null)).forEach(r -> result.add(A3esHarvestTeachersDataService.getJobFormat(r)));
        return result;
    }

    public static SortedSet<Job> findJobsSortedByBeginDate(Person person, JobType type) {
        TreeSet<Job> result = new TreeSet<Job>(Comparator.comparing(Job_Base::getBeginDate, Comparator.nullsFirst(Comparator.naturalOrder())).reversed().thenComparing(AbstractDomainObject::getExternalId));
        if (person != null && type != null) {
            result.addAll(person.getJobsSet().stream().filter(j -> j.getBeginDate() != null && type.equals((Object)j.getType())).collect(Collectors.toSet()));
        }
        return result;
    }

    private static String getJobFormat(Job job) {
        LocalDate beginDate;
        Object result = "";
        LocalDate end = job.getEndDate();
        if (end == null) {
            result = (String)result + A3esExportService.label("since") + " ";
        }
        if ((beginDate = job.getBeginDate()) != null) {
            result = (String)result + beginDate.toString("yyyy") + " ";
        }
        if (end != null) {
            if (beginDate != null) {
                result = (String)result + "- ";
            }
            result = (String)result + end.toString("yyyy") + " ";
        }
        if (!StringUtils.isBlank((String)job.getPosition())) {
            result = (String)result + job.getPosition() + " ";
        }
        if (!StringUtils.isBlank((String)job.getEmployerName())) {
            result = (String)result + "- " + job.getEmployerName() + " ";
        }
        return ((String)result).trim();
    }
}

