/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.legalpt.ui.rebides;

import com.google.gson.Gson;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.bennu.TupleDataSourceBean;
import org.fenixedu.bennu.core.domain.exceptions.DomainException;
import org.fenixedu.bennu.scheduler.CronTask;
import org.fenixedu.bennu.scheduler.TaskRunner;
import org.fenixedu.bennu.scheduler.domain.SchedulerSystem;
import org.fenixedu.bennu.spring.portal.SpringFunctionality;
import org.fenixedu.legalpt.domain.rebides.RebidesInstance;
import org.fenixedu.legalpt.domain.rebides.report.RebidesRequestParameter;
import org.fenixedu.legalpt.task.ProcessPendingLegalReportRequest;
import org.fenixedu.legalpt.ui.FenixeduLegalPTBaseController;
import org.fenixedu.legalpt.ui.FenixeduLegalPTController;
import org.fenixedu.ulisboa.specifications.domain.legal.report.LegalReport;
import org.fenixedu.ulisboa.specifications.domain.legal.report.LegalReportRequest;
import org.fenixedu.ulisboa.specifications.domain.legal.report.LegalReportResultFile;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

@SpringFunctionality(app=FenixeduLegalPTController.class, title="label.title.manageRebidesRequests", accessGroup="logged")
@RequestMapping(value={"/fenixedu-legal-pt/rebides/managerebidesrequests"})
public class RebidesRequestsController
extends FenixeduLegalPTBaseController {
    public static final String CONTROLLER_URL = "/fenixedu-legal-pt/rebides/managerebidesrequests";
    public static final String JSP_PATH = "/fenixedu-legal-pt/rebides/managerebidesrequests".substring(1);
    private static final String _SEARCH_URI = "/search";
    public static final String SEARCH_URL = "/fenixedu-legal-pt/rebides/managerebidesrequests/search";
    private static final String _READ_URI = "/read";
    public static final String READ_URL = "/fenixedu-legal-pt/rebides/managerebidesrequests/read";
    private static final String _DOWNLOAD_RESULT_FILE_URI = "/downloadresultfile";
    public static final String DOWNLOAD_RESULT_FILE_URL = "/fenixedu-legal-pt/rebides/managerebidesrequests/downloadresultfile";
    private static final String _CREATE_URI = "/create";
    public static final String CREATE_URL = "/fenixedu-legal-pt/rebides/managerebidesrequests/create";

    @RequestMapping
    public String home() {
        return "forward:/fenixedu-legal-pt/rebides/managerebidesrequests/search";
    }

    @RequestMapping(value={"/search"})
    public String search(Model model) {
        model.addAttribute("reportRequests", (Object)RebidesInstance.getInstance().getLegalRequestsSet());
        return this.jspPage(_SEARCH_URI);
    }

    @RequestMapping(value={"/read/{requestId}"})
    public String read(@PathVariable(value="requestId") LegalReportRequest request, Model model) {
        model.addAttribute("reportRequest", (Object)request);
        return this.jspPage(_READ_URI);
    }

    @RequestMapping(value={"/downloadresultfile/{resultFileId}"})
    public void downloadresultfile(@PathVariable(value="resultFileId") LegalReportResultFile resultFile, Model model, HttpServletResponse response) {
        try {
            response.setContentType(resultFile.getContentType());
            response.setHeader("Content-Disposition", "attachment;filename=" + resultFile.getFilename());
            response.getOutputStream().write(resultFile.getContent());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @RequestMapping(value={"/create"}, method={RequestMethod.GET})
    public String create(Model model) {
        RebidesRequestParameter rebidesParameter = new RebidesRequestParameter();
        RebidesInstance rebidesInstance = RebidesInstance.getInstance();
        rebidesParameter.setInstitutionCode(rebidesInstance.getInstitutionCode());
        rebidesParameter.setInterlocutorName(rebidesInstance.getInterlocutorName());
        rebidesParameter.setInterlocutorEmail(rebidesInstance.getInterlocutorEmail());
        rebidesParameter.setInterlocutorPhone(rebidesInstance.getInterlocutorPhone());
        rebidesParameter.setMoment("1");
        rebidesParameter.setExecutionYear(ExecutionYear.readCurrentExecutionYear());
        rebidesParameter.setFilterEntriesWithErrors(true);
        model.addAttribute("bean", (Object)rebidesParameter);
        model.addAttribute("beanJson", (Object)this.getBeanJson(rebidesParameter));
        model.addAttribute("executionYearDataSource", (Object)this.getNotClosedExecutionYearsJson());
        return this.jspPage(_CREATE_URI);
    }

    private String getNotClosedExecutionYearsJson() {
        List list = ExecutionYear.readNotClosedExecutionYears().stream().sorted(ExecutionYear.REVERSE_COMPARATOR_BY_YEAR).map(x -> {
            TupleDataSourceBean tuple = new TupleDataSourceBean();
            tuple.setId(x.getExternalId());
            tuple.setText(x.getName());
            return tuple;
        }).collect(Collectors.toList());
        return new Gson().toJson(list);
    }

    @RequestMapping(value={"/create"}, method={RequestMethod.POST})
    public String create(@RequestParam(value="bean") RebidesRequestParameter rebidesRequestParameter, Model model) {
        try {
            LegalReportRequest request = LegalReportRequest.createRequest((LegalReport)((Object)RebidesInstance.getInstance()), rebidesRequestParameter);
            if (request.isPending()) {
                SchedulerSystem.queue((TaskRunner)new TaskRunner((CronTask)new ProcessPendingLegalReportRequest(request.getExternalId())));
            }
            return "redirect:/fenixedu-legal-pt/rebides/managerebidesrequests/search";
        }
        catch (DomainException e) {
            this.addErrorMessage(e.getLocalizedMessage(), model);
            model.addAttribute("bean", (Object)rebidesRequestParameter);
            model.addAttribute("beanJson", (Object)this.getBeanJson(rebidesRequestParameter));
            model.addAttribute("executionYearDataSource", (Object)this.getNotClosedExecutionYearsJson());
            return this.jspPage(_CREATE_URI);
        }
    }

    private String jspPage(String page) {
        return JSP_PATH + "/" + page.substring(1, page.length());
    }
}

