/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.legalpt.services.report.log;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import org.fenixedu.academic.domain.ProfessionType;
import org.fenixedu.academic.domain.ProfessionalSituationConditionType;
import org.fenixedu.academic.domain.SchoolLevelType;
import org.fenixedu.academic.domain.SchoolPeriodDuration;
import org.fenixedu.commons.spreadsheet.SheetData;
import org.fenixedu.commons.spreadsheet.SpreadsheetBuilder;
import org.fenixedu.commons.spreadsheet.WorkbookExportFormat;
import org.fenixedu.legalpt.domain.LegalReportContext;
import org.fenixedu.legalpt.util.LegalPTUtil;
import org.fenixedu.ulisboa.specifications.domain.exceptions.ULisboaSpecificationsDomainException;
import org.fenixedu.ulisboa.specifications.domain.legal.report.LegalReportRequest;
import org.fenixedu.ulisboa.specifications.domain.legal.report.LegalReportResultFile;
import org.fenixedu.ulisboa.specifications.domain.legal.report.LegalReportResultFileType;
import org.joda.time.DateTime;

public class XlsExporterLog {
    public static LegalReportResultFile write(LegalReportRequest reportRequest, LegalReportContext.LegalReportEntryData legalReportEntryData) {
        List<LegalReportContext.ReportEntry> compiledData = legalReportEntryData.getErrorEntries();
        compiledData.addAll(legalReportEntryData.getWarnEntries());
        compiledData.addAll(legalReportEntryData.getInfoEntries());
        SheetData<LegalReportContext.ReportEntry> compiledSheet = new SheetData<LegalReportContext.ReportEntry>(compiledData){

            protected void makeLine(LegalReportContext.ReportEntry reportEntry) {
                String type = reportEntry.getType() == LegalReportContext.ReportEntryType.ERROR ? "Erro" : (reportEntry.getType() == LegalReportContext.ReportEntryType.WARN ? "Aviso" : (reportEntry.getType() == LegalReportContext.ReportEntryType.INFO ? "Informa\u00e7\u00e3o" : ""));
                this.addCell("Tipo", type);
                this.addCell("Assunto", reportEntry.getTarget());
                String[] fields = reportEntry.getMessage().split(";");
                for (int i = 0; i < fields.length; ++i) {
                    if (i == 1) {
                        this.addCell("N\u00ba de Aluno", fields[i]);
                        continue;
                    }
                    if (i == 3) {
                        this.addCell("N\u00ba de Matr\u00edcula", fields[i]);
                        continue;
                    }
                    if (i == 5) {
                        this.addCell("C\u00f3digo de Curso", fields[i]);
                        continue;
                    }
                    if (i == 7) {
                        this.addCell("Curso", fields[i]);
                        continue;
                    }
                    if (i == 9) {
                        this.addCell("Ano", fields[i]);
                        continue;
                    }
                    if (i == 10) {
                        this.addCell("Mensagem", fields[i]);
                        continue;
                    }
                    if (i <= 10) continue;
                    this.addCell(String.format("[%d]", i), fields[i]);
                }
            }
        };
        ByteArrayOutputStream outputStream = null;
        try {
            outputStream = new ByteArrayOutputStream();
            SpreadsheetBuilder spreadsheetBuilder = new SpreadsheetBuilder();
            spreadsheetBuilder.addSheet("Erros | Avisos | Informa\u00e7\u00f5es", (SheetData)compiledSheet);
            spreadsheetBuilder.build(WorkbookExportFormat.EXCEL, (OutputStream)outputStream);
            byte[] content = outputStream.toByteArray();
            String fileName = "Logs_" + reportRequest.getLegalReport().getName().getContent() + "_" + new DateTime().toString("dd-MM-yyyy-HH-mm") + "." + LegalReportResultFileType.XLS.toString().toLowerCase();
            LegalReportResultFile legalReportResultFile = new LegalReportResultFile(reportRequest, LegalReportResultFileType.XLS, fileName, content);
            return legalReportResultFile;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ULisboaSpecificationsDomainException((Throwable)e, "error.XlsxExporter.spreadsheet.generation.failed", new String[0]);
        }
        finally {
            try {
                outputStream.close();
            }
            catch (IOException e) {
                e.printStackTrace();
                throw new ULisboaSpecificationsDomainException((Throwable)e, "error.XlsxExporter.spreadsheet.generation.failed", new String[0]);
            }
        }
    }

    protected static String pdiLabel(String key) {
        return LegalPTUtil.bundle("org.fenixedu.academic.domain.student.PrecedentDegreeInformation." + key, new String[0]);
    }

    protected static String pidLabel(String key) {
        return LegalPTUtil.bundle("label.org.fenixedu.academic.domain.student.PersonalIngressionData." + key, new String[0]);
    }

    protected static String schoolLevelLocalizedName(SchoolLevelType schoolLevel) {
        return schoolLevel.getLocalizedName();
    }

    protected static String professionTypeLocalizedName(ProfessionType profession) {
        return profession.getLocalizedName();
    }

    protected static String professionalSituationConditionTypeLocalizedName(ProfessionalSituationConditionType conditionType) {
        return conditionType.getLocalizedName();
    }

    protected static String schoolPeriodDurationLocalizedName(SchoolPeriodDuration duration) {
        return LegalPTUtil.bundle("label.SchoolPeriodDuration." + duration.name(), new String[0]);
    }
}

