/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.legalpt.services.rebides.export;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.nio.charset.Charset;
import java.util.GregorianCalendar;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import org.apache.commons.lang.StringUtils;
import org.fenixedu.legalpt.domain.rebides.report.RebidesRequestParameter;
import org.fenixedu.legalpt.dto.rebides.CareerActivitiesBean;
import org.fenixedu.legalpt.dto.rebides.IdentificationBean;
import org.fenixedu.legalpt.dto.rebides.QualificationBean;
import org.fenixedu.legalpt.dto.rebides.RebidesBean;
import org.fenixedu.legalpt.dto.rebides.TeacherBean;
import org.fenixedu.legalpt.jaxb.rebides.InformacaoDocentes;
import org.fenixedu.legalpt.jaxb.rebides.Myboolean;
import org.fenixedu.legalpt.jaxb.rebides.NumeroID;
import org.fenixedu.legalpt.jaxb.rebides.ObjectFactory;
import org.fenixedu.legalpt.jaxb.rebides.Sexo;
import org.fenixedu.ulisboa.specifications.domain.legal.report.LegalReportRequest;
import org.fenixedu.ulisboa.specifications.domain.legal.report.LegalReportResultFile;
import org.fenixedu.ulisboa.specifications.domain.legal.report.LegalReportResultFileType;
import org.joda.time.LocalDate;

public class RebidesXmlToBaseFileWriter {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static LegalReportResultFile write(LegalReportRequest reportRequest, RebidesBean rebides) {
        LegalReportResultFile legalReportResultFile;
        RebidesRequestParameter requestParameters = reportRequest.getParametersAs(RebidesRequestParameter.class);
        ObjectFactory factory = new ObjectFactory();
        DatatypeFactory dataTypeFactory = RebidesXmlToBaseFileWriter.createDataTypeFactory();
        InformacaoDocentes informacaoDocentes = factory.createInformacaoDocentes();
        RebidesXmlToBaseFileWriter.fillExtracao(requestParameters, factory, dataTypeFactory, informacaoDocentes);
        InformacaoDocentes.Docentes docentes = factory.createInformacaoDocentesDocentes();
        informacaoDocentes.setDocentes(docentes);
        for (TeacherBean teacher : rebides.getTeachers()) {
            InformacaoDocentes.Docentes.Docente docente = RebidesXmlToBaseFileWriter.fillDocente(factory, dataTypeFactory, teacher);
            if (docente == null) continue;
            docentes.getDocente().add(docente);
        }
        JAXBContext context = JAXBContext.newInstance((String)ObjectFactory.class.getPackage().getName());
        Marshaller marshaller = context.createMarshaller();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        OutputStreamWriter osw = new OutputStreamWriter((OutputStream)baos, Charset.forName("ISO-8859-15"));
        try {
            marshaller.setProperty("jaxb.encoding", (Object)"ISO-8859-15");
            marshaller.setProperty("jaxb.formatted.output", (Object)true);
            marshaller.marshal((Object)informacaoDocentes, (Writer)osw);
            byte[] content = baos.toByteArray();
            String filename = "D0" + requestParameters.getMoment() + requestParameters.getInstitutionCode() + ".xml";
            legalReportResultFile = new LegalReportResultFile(reportRequest, LegalReportResultFileType.XML, filename, content);
        }
        catch (Throwable throwable) {
            try {
                try {
                    osw.close();
                    baos.close();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                throw throwable;
            }
            catch (JAXBException e) {
                throw new RuntimeException(e);
            }
        }
        try {
            osw.close();
            baos.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return legalReportResultFile;
    }

    private static DatatypeFactory createDataTypeFactory() {
        try {
            return DatatypeFactory.newInstance();
        }
        catch (DatatypeConfigurationException e1) {
            throw new RuntimeException(e1);
        }
    }

    protected static void fillExtracao(RebidesRequestParameter parameters, ObjectFactory factory, DatatypeFactory dataTypeFactory, InformacaoDocentes informacaoDocentes) {
        InformacaoDocentes.Extracao extracao = factory.createInformacaoDocentesExtracao();
        informacaoDocentes.setExtracao(extracao);
        extracao.setCodigoEstabelecimento(parameters.getInstitutionCode());
        extracao.setDataExtracao(RebidesXmlToBaseFileWriter.toXMLDate(dataTypeFactory, new LocalDate()));
        extracao.setEmailInterlocutor(parameters.getInterlocutorEmail());
        extracao.setMomento(Integer.valueOf(parameters.getMoment()));
        extracao.setNomeInterlocutor(parameters.getInterlocutorName());
        extracao.setTelefoneInterlocutor(new BigInteger(parameters.getInterlocutorPhone()));
    }

    protected static InformacaoDocentes.Docentes.Docente fillDocente(ObjectFactory factory, DatatypeFactory dataTypeFactory, TeacherBean teacher) {
        IdentificationBean identificationBean = teacher.getIdentification();
        CareerActivitiesBean careerActivitiesBean = teacher.getCareerActivities();
        List<QualificationBean> qualificationsForTeacher = teacher.getQualifications();
        InformacaoDocentes.Docentes.Docente docente = factory.createInformacaoDocentesDocentesDocente();
        docente.setIdentificacao(RebidesXmlToBaseFileWriter.fillIdentificacaoDocente(factory, dataTypeFactory, identificationBean));
        docente.setSituacaoCarreiraAtividades(RebidesXmlToBaseFileWriter.fillSituacaoCarreiraAtividades(factory, careerActivitiesBean));
        if (!qualificationsForTeacher.isEmpty()) {
            InformacaoDocentes.Docentes.Docente.Habilitacoes habilitacoes = factory.createInformacaoDocentesDocentesDocenteHabilitacoes();
            docente.setHabilitacoes(habilitacoes);
            for (QualificationBean qualificationBean : qualificationsForTeacher) {
                habilitacoes.getHabilitacao().add(RebidesXmlToBaseFileWriter.fillHabilitacao(factory, qualificationBean));
            }
        }
        return docente;
    }

    private static InformacaoDocentes.Docentes.Docente.Identificacao fillIdentificacaoDocente(ObjectFactory factory, DatatypeFactory datatypeFactory, IdentificationBean bean) {
        InformacaoDocentes.Docentes.Docente.Identificacao identificacao = factory.createInformacaoDocentesDocentesDocenteIdentificacao();
        identificacao.setNome(bean.getName());
        NumeroID numeroID = factory.createNumeroID();
        numeroID.setValue(bean.getDocumentIdNumber());
        numeroID.setTipo(bean.getDocumentIdType() != null ? new BigInteger(bean.getDocumentIdType()) : null);
        identificacao.setNumeroID(numeroID);
        identificacao.setOutroTipoID(bean.getOtherIdDocumentType());
        identificacao.setDataNascimento(RebidesXmlToBaseFileWriter.toXMLDate(datatypeFactory, bean.getDateOfBirth()));
        identificacao.setSexo(bean.getGender() != null ? Sexo.valueOf(bean.getGender()) : null);
        identificacao.setPaisDeNacionalidade(bean.getNationalityCountry());
        identificacao.setOutroPaisDeNacionalidade(bean.getOtherNationalityCountry());
        return identificacao;
    }

    private static InformacaoDocentes.Docentes.Docente.SituacaoCarreiraAtividades fillSituacaoCarreiraAtividades(ObjectFactory factory, CareerActivitiesBean bean) {
        InformacaoDocentes.Docentes.Docente.SituacaoCarreiraAtividades situacaoCarreiraAtividades = factory.createInformacaoDocentesDocentesDocenteSituacaoCarreiraAtividades();
        situacaoCarreiraAtividades.setDepartamento(bean.getDepartment());
        situacaoCarreiraAtividades.setOutroDepartamento(bean.getOtherDepartment());
        situacaoCarreiraAtividades.setCategoria(bean.getCategory() != null ? Integer.valueOf(bean.getCategory()) : -1);
        situacaoCarreiraAtividades.setConvidado(RebidesXmlToBaseFileWriter.toXmlBoolean(bean.getGuest()));
        situacaoCarreiraAtividades.setEquiparado(RebidesXmlToBaseFileWriter.toXmlBoolean(bean.getSchoolStaff()));
        situacaoCarreiraAtividades.setProvasAptidao(bean.getServiceRegime());
        situacaoCarreiraAtividades.setProvasAgregacao(bean.getAggregationTests());
        situacaoCarreiraAtividades.setProvasEspecialista(bean.getExpertTests());
        situacaoCarreiraAtividades.setDocencia(RebidesXmlToBaseFileWriter.toXmlBoolean(bean.getTeaching()));
        situacaoCarreiraAtividades.setHorasLetivas(bean.getTeachingHoursPercentage() != null ? bean.getTeachingHoursPercentage().setScale(1, RoundingMode.HALF_EVEN) : null);
        situacaoCarreiraAtividades.setUnidadeHL(bean.getTeachingHoursUnit());
        situacaoCarreiraAtividades.setActReitor(RebidesXmlToBaseFileWriter.toXmlBoolean(bean.getRootUnitPresident()));
        situacaoCarreiraAtividades.setActViceReitor(RebidesXmlToBaseFileWriter.toXmlBoolean(bean.getRootUnitVicePresident()));
        situacaoCarreiraAtividades.setActDiretor(RebidesXmlToBaseFileWriter.toXmlBoolean(bean.getUnitPresident()));
        situacaoCarreiraAtividades.setActCoordena(RebidesXmlToBaseFileWriter.toXmlBoolean(bean.getUnitCoordinator()));
        situacaoCarreiraAtividades.setActConsGeral(RebidesXmlToBaseFileWriter.toXmlBoolean(bean.getCoordenatorGeneralCouncil()));
        situacaoCarreiraAtividades.setActConsGest(RebidesXmlToBaseFileWriter.toXmlBoolean(bean.getManagementCouncilActivities()));
        situacaoCarreiraAtividades.setActConsCient(RebidesXmlToBaseFileWriter.toXmlBoolean(bean.getScientificCouncilActivities()));
        situacaoCarreiraAtividades.setActConsPedag(RebidesXmlToBaseFileWriter.toXmlBoolean(bean.getPedagogicCouncilActivities()));
        situacaoCarreiraAtividades.setActFormacao(RebidesXmlToBaseFileWriter.toXmlBoolean(bean.getCoachingOrResearchProjectActivities()));
        situacaoCarreiraAtividades.setActOutra(RebidesXmlToBaseFileWriter.toXmlBoolean(bean.getOtherActivity()));
        situacaoCarreiraAtividades.setActOutraDescr(bean.getOtherActivityDescription());
        return situacaoCarreiraAtividades;
    }

    private static InformacaoDocentes.Docentes.Docente.Habilitacoes.Habilitacao fillHabilitacao(ObjectFactory factory, QualificationBean bean) {
        InformacaoDocentes.Docentes.Docente.Habilitacoes.Habilitacao habitalitacao = factory.createInformacaoDocentesDocentesDocenteHabilitacoesHabilitacao();
        return habitalitacao;
    }

    protected static Long longValueOf(String value) {
        if (StringUtils.isEmpty((String)value)) {
            return null;
        }
        return Long.valueOf(value);
    }

    protected static Long longValueOf(BigDecimal value) {
        if (value == null) {
            return null;
        }
        return value.longValue();
    }

    private static XMLGregorianCalendar toXMLDate(DatatypeFactory datatypeFactory, LocalDate date) {
        XMLGregorianCalendar result = RebidesXmlToBaseFileWriter.toXmlDateTime(datatypeFactory, date);
        if (result == null) {
            return null;
        }
        result.setTime(Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE);
        result.setTimezone(Integer.MIN_VALUE);
        return result;
    }

    private static XMLGregorianCalendar toXmlDateTime(DatatypeFactory datatypeFactory, LocalDate date) {
        if (date == null) {
            return null;
        }
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.setTimeInMillis(date.toDate().getTime());
        return datatypeFactory.newXMLGregorianCalendar(gregorianCalendar);
    }

    private static Myboolean toXmlBoolean(Boolean value) {
        if (value == null) {
            return null;
        }
        return value != false ? Myboolean.TRUE : Myboolean.FALSE;
    }
}

