/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.legalpt.dto.raides;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.fenixedu.academic.domain.District;
import org.fenixedu.academic.domain.candidacy.IngressionType;
import org.fenixedu.academic.domain.student.RegistrationProtocol;
import org.fenixedu.academic.domain.student.StatuteType;
import org.fenixedu.bennu.IBean;
import org.fenixedu.bennu.TupleDataSourceBean;
import org.fenixedu.bennu.core.domain.Bennu;
import org.fenixedu.ulisboa.specifications.domain.legal.raides.IntegratedMasterFirstCycleGraduatedReportOption;
import org.fenixedu.ulisboa.specifications.domain.legal.raides.RaidesInstance;
import org.fenixedu.ulisboa.specifications.util.ULisboaConstants;

public class RaidesInstanceBean
implements IBean {
    private String passwordToZip;
    private Set<RegistrationProtocol> mobilityAgreements;
    private Set<RegistrationProtocol> enrolledAgreements;
    private Set<IngressionType> degreeChangeIngressions;
    private Set<IngressionType> degreeTransferIngressions;
    private Set<IngressionType> ingressionsForGeneralAccessRegime;
    private Set<StatuteType> grantOwnerStatuteTypes;
    private List<TupleDataSourceBean> ingressionTypesDataSource;
    private List<TupleDataSourceBean> registrationProtocolsDataSource;
    private List<TupleDataSourceBean> integratedMasterFirstCycleGraduatedReportOptionsDataSource;
    private List<TupleDataSourceBean> defaultDistrictOfResidenceDataSource;
    private List<TupleDataSourceBean> grantOwnerStatuteTypesDataSource;
    private String institutionCode;
    private String interlocutorPhone;
    private IntegratedMasterFirstCycleGraduatedReportOption integratedMasterFirstCycleGraduatedReportOption;
    private District defaultDistrictOfResidence;
    private boolean reportGraduatedWithoutConclusionProcess;

    public RaidesInstanceBean(RaidesInstance raidesInstance) {
        this.setInstitutionCode(raidesInstance.getInstitutionCode());
        this.setInterlocutorPhone(raidesInstance.getInterlocutorPhone());
        this.setPasswordToZip(raidesInstance.getPasswordToZip());
        this.setMobilityAgreements(Sets.newHashSet((Iterable)raidesInstance.getMobilityAgreementsSet()));
        this.setEnrolledAgreements(Sets.newHashSet((Iterable)raidesInstance.getEnrolledAgreementsSet()));
        this.setDegreeChangeIngressions(Sets.newHashSet((Iterable)raidesInstance.getDegreeChangeIngressionsSet()));
        this.setDegreeTransferIngressions(Sets.newHashSet((Iterable)raidesInstance.getDegreeTransferIngressionsSet()));
        this.setIngressionsForGeneralAccessRegime(Sets.newHashSet((Iterable)raidesInstance.getGeneralAccessRegimeIngressionsSet()));
        this.setIntegratedMasterFirstCycleGraduatedReportOption(raidesInstance.getIntegratedMasterFirstCycleGraduatedReportOption());
        this.setDefaultDistrictOfResidence(raidesInstance.getDefaultDistrictOfResidence());
        this.setReportGraduatedWithoutConclusionProcess(raidesInstance.isReportGraduatedWithoutConclusionProcess());
        this.setGrantOwnerStatuteTypes(Sets.newHashSet((Iterable)raidesInstance.getGrantOwnerStatuteTypesSet()));
        this.loadDataSources();
    }

    private void loadDataSources() {
        this.ingressionTypesDataSource = Lists.newArrayList();
        this.ingressionTypesDataSource.add(ULisboaConstants.SELECT_OPTION);
        this.ingressionTypesDataSource.addAll(Bennu.getInstance().getIngressionTypesSet().stream().map(i -> new TupleDataSourceBean(i.getExternalId(), i.getDescription().getContent())).collect(Collectors.toList()));
        this.registrationProtocolsDataSource = Lists.newArrayList();
        this.registrationProtocolsDataSource.add(ULisboaConstants.SELECT_OPTION);
        this.registrationProtocolsDataSource.addAll(Bennu.getInstance().getRegistrationProtocolsSet().stream().map(r -> new TupleDataSourceBean(r.getExternalId(), r.getDescription().getContent())).collect(Collectors.toList()));
        ArrayList l = Lists.newArrayList((Object[])IntegratedMasterFirstCycleGraduatedReportOption.values());
        this.integratedMasterFirstCycleGraduatedReportOptionsDataSource = Lists.newArrayList();
        this.integratedMasterFirstCycleGraduatedReportOptionsDataSource.addAll(l.stream().map(i -> new TupleDataSourceBean(i.name(), i.getLocalizedName().getContent())).collect(Collectors.toSet()));
        this.defaultDistrictOfResidenceDataSource = Lists.newArrayList();
        this.defaultDistrictOfResidenceDataSource.addAll(Bennu.getInstance().getDistrictsSet().stream().map(i -> new TupleDataSourceBean(i.getExternalId(), i.getName())).collect(Collectors.toSet()));
        this.grantOwnerStatuteTypesDataSource = Lists.newArrayList();
        this.grantOwnerStatuteTypesDataSource.addAll(Bennu.getInstance().getStatuteTypesSet().stream().sorted(StatuteType.COMPARATOR_BY_NAME).map(s -> new TupleDataSourceBean(s.getExternalId(), s.getCode() + " - " + s.getName().getContent())).collect(Collectors.toList()));
    }

    public String getPasswordToZip() {
        return this.passwordToZip;
    }

    public void setPasswordToZip(String passwordToZip) {
        this.passwordToZip = passwordToZip;
    }

    public Set<RegistrationProtocol> getMobilityAgreements() {
        return this.mobilityAgreements;
    }

    public void setMobilityAgreements(Set<RegistrationProtocol> mobilityAgreements) {
        this.mobilityAgreements = mobilityAgreements;
    }

    public Set<RegistrationProtocol> getEnrolledAgreements() {
        return this.enrolledAgreements;
    }

    public void setEnrolledAgreements(Set<RegistrationProtocol> enrolledAgreements) {
        this.enrolledAgreements = enrolledAgreements;
    }

    public Set<IngressionType> getDegreeChangeIngressions() {
        return this.degreeChangeIngressions;
    }

    public void setDegreeChangeIngressions(Set<IngressionType> degreeChangeIngressions) {
        this.degreeChangeIngressions = degreeChangeIngressions;
    }

    public Set<IngressionType> getDegreeTransferIngressions() {
        return this.degreeTransferIngressions;
    }

    public void setDegreeTransferIngressions(Set<IngressionType> degreeTransferIngressions) {
        this.degreeTransferIngressions = degreeTransferIngressions;
    }

    public List<TupleDataSourceBean> getIngressionTypesDataSource() {
        return this.ingressionTypesDataSource;
    }

    public Set<IngressionType> getIngressionsForGeneralAccessRegime() {
        return this.ingressionsForGeneralAccessRegime;
    }

    public void setIngressionsForGeneralAccessRegime(Set<IngressionType> ingressionsForGeneralAccessRegime) {
        this.ingressionsForGeneralAccessRegime = ingressionsForGeneralAccessRegime;
    }

    public Set<StatuteType> getGrantOwnerStatuteTypes() {
        return this.grantOwnerStatuteTypes;
    }

    public void setGrantOwnerStatuteTypes(Set<StatuteType> grantOwnerStatuteTypes) {
        this.grantOwnerStatuteTypes = grantOwnerStatuteTypes;
    }

    public List<TupleDataSourceBean> getGrantOwnerStatuteTypesDataSource() {
        return this.grantOwnerStatuteTypesDataSource;
    }

    public String getInstitutionCode() {
        return this.institutionCode;
    }

    public void setInstitutionCode(String institutionCode) {
        this.institutionCode = institutionCode;
    }

    public String getInterlocutorPhone() {
        return this.interlocutorPhone;
    }

    public void setInterlocutorPhone(String interlocutorPhone) {
        this.interlocutorPhone = interlocutorPhone;
    }

    public IntegratedMasterFirstCycleGraduatedReportOption getIntegratedMasterFirstCycleGraduatedReportOption() {
        return this.integratedMasterFirstCycleGraduatedReportOption;
    }

    public void setIntegratedMasterFirstCycleGraduatedReportOption(IntegratedMasterFirstCycleGraduatedReportOption integratedMasterFirstCycleGraduatedReportOption) {
        this.integratedMasterFirstCycleGraduatedReportOption = integratedMasterFirstCycleGraduatedReportOption;
    }

    public District getDefaultDistrictOfResidence() {
        return this.defaultDistrictOfResidence;
    }

    public void setDefaultDistrictOfResidence(District defaultDistrictOfResidence) {
        this.defaultDistrictOfResidence = defaultDistrictOfResidence;
    }

    public boolean isReportGraduatedWithoutConclusionProcess() {
        return this.reportGraduatedWithoutConclusionProcess;
    }

    public void setReportGraduatedWithoutConclusionProcess(boolean reportGraduatedWithoutConclusionProcess) {
        this.reportGraduatedWithoutConclusionProcess = reportGraduatedWithoutConclusionProcess;
    }
}

