/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.legalpt.domain.rebides.mapping;

import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Collections;
import java.util.Locale;
import java.util.Set;
import org.fenixedu.academic.domain.SchoolLevelType;
import org.fenixedu.academic.domain.organizationalStructure.PartyTypeEnum;
import org.fenixedu.academic.domain.organizationalStructure.ScientificAreaUnit;
import org.fenixedu.academic.domain.organizationalStructure.Unit;
import org.fenixedu.academic.domain.person.Gender;
import org.fenixedu.academic.domain.person.IDDocumentType;
import org.fenixedu.bennu.core.domain.Bennu;
import org.fenixedu.bennu.core.i18n.BundleUtil;
import org.fenixedu.commons.i18n.I18N;
import org.fenixedu.commons.i18n.LocalizedString;
import org.fenixedu.legalpt.util.LegalPTUtil;
import org.fenixedu.ulisboa.specifications.domain.legal.mapping.DomainObjectLegalMapping;
import org.fenixedu.ulisboa.specifications.domain.legal.mapping.EnumerationLegalMapping;
import org.fenixedu.ulisboa.specifications.domain.legal.mapping.ILegalMappingType;
import org.fenixedu.ulisboa.specifications.domain.legal.mapping.LegalMapping;
import org.fenixedu.ulisboa.specifications.domain.legal.mapping.StringLegalMapping;
import org.fenixedu.ulisboa.specifications.domain.legal.report.LegalReport;
import pt.ist.fenixframework.FenixFramework;

public enum RebidesMappingType implements ILegalMappingType
{
    ID_DOCUMENT_TYPE,
    CONTRACT_CATEGORY,
    CONTRACT_SERVICE_REGIME,
    CONTRACT_BINDING_REGIME,
    CONTRACT_WAGE_LEVEL,
    BOOLEAN,
    GENDER,
    SCHOOL_LEVEL,
    SCHOOL_LEVEL_ORIGIN,
    SCIENTIFIC_AREA,
    DEPARTMENT;

    private static final String ENUMERATION_RESOURCES = "resources.EnumerationResources";

    public Set<?> getValues() {
        switch (this) {
            case ID_DOCUMENT_TYPE: {
                return Sets.newHashSet((Object[])IDDocumentType.values());
            }
            case CONTRACT_CATEGORY: {
                return Collections.emptySet();
            }
            case CONTRACT_SERVICE_REGIME: {
                return Collections.emptySet();
            }
            case CONTRACT_BINDING_REGIME: {
                return Collections.emptySet();
            }
            case CONTRACT_WAGE_LEVEL: {
                return Collections.emptySet();
            }
            case SCIENTIFIC_AREA: {
                return Collections.emptySet();
            }
            case BOOLEAN: {
                return Sets.newHashSet((Object[])new Boolean[]{Boolean.TRUE, Boolean.FALSE});
            }
            case GENDER: {
                return Sets.newHashSet((Object[])Gender.values());
            }
            case SCHOOL_LEVEL: {
                return Sets.newHashSet((Object[])SchoolLevelType.values());
            }
            case SCHOOL_LEVEL_ORIGIN: {
                return Collections.emptySet();
            }
            case DEPARTMENT: {
                Collection departments = Collections2.filter((Collection)Bennu.getInstance().getInstitutionUnit().getAllSubUnits(), (Predicate)new Predicate<Unit>(){

                    public boolean apply(Unit entry) {
                        return entry.getPartyType().getType() == PartyTypeEnum.DEPARTMENT;
                    }
                });
                return Sets.newHashSet((Iterable)departments);
            }
        }
        return Collections.EMPTY_SET;
    }

    @Override
    public LegalMapping createMapping(LegalReport report) {
        switch (this) {
            case CONTRACT_CATEGORY: 
            case CONTRACT_SERVICE_REGIME: 
            case CONTRACT_BINDING_REGIME: 
            case CONTRACT_WAGE_LEVEL: 
            case SCIENTIFIC_AREA: 
            case SCHOOL_LEVEL_ORIGIN: 
            case DEPARTMENT: {
                return new DomainObjectLegalMapping(report, this);
            }
            case BOOLEAN: {
                return new StringLegalMapping(report, this);
            }
        }
        return new EnumerationLegalMapping(report, this);
    }

    @Override
    public LocalizedString getLocalizedNameKey(String key) {
        LocalizedString mls = new LocalizedString();
        switch (this) {
            case BOOLEAN: {
                return LegalPTUtil.bundleI18N("label." + key, new String[0]);
            }
            case GENDER: {
                Gender gender = Gender.valueOf((String)key);
                mls = mls.with(I18N.getLocale(), gender.toLocalizedString(I18N.getLocale()));
                return mls;
            }
            case ID_DOCUMENT_TYPE: {
                IDDocumentType idDocumentType = IDDocumentType.valueOf((String)key);
                mls = mls.with(I18N.getLocale(), idDocumentType.getLocalizedName(I18N.getLocale()));
                return mls;
            }
            case CONTRACT_CATEGORY: {
                return new LocalizedString(I18N.getLocale(), "TODO_CONTRACT_CATEGORY");
            }
            case CONTRACT_SERVICE_REGIME: {
                return new LocalizedString(I18N.getLocale(), "TODO_CONTRACT_SERVICE_REGIME");
            }
            case CONTRACT_BINDING_REGIME: {
                return new LocalizedString(I18N.getLocale(), "TODO_CONTRACT_BINDING_REGIME");
            }
            case CONTRACT_WAGE_LEVEL: {
                return new LocalizedString(I18N.getLocale(), "TODO_CONTRACT_WAGE_LEVEL");
            }
            case SCIENTIFIC_AREA: {
                return ((ScientificAreaUnit)FenixFramework.getDomainObject((String)key)).getPartyName().toLocalizedString();
            }
            case SCHOOL_LEVEL: {
                SchoolLevelType schoolLevel = SchoolLevelType.valueOf((String)key);
                return this.localizedName(schoolLevel, I18N.getLocale());
            }
            case SCHOOL_LEVEL_ORIGIN: {
                return new LocalizedString(I18N.getLocale(), "TODO_SCHOOL_LEVEL_ORIGIN");
            }
            case DEPARTMENT: {
                return ((Unit)FenixFramework.getDomainObject((String)key)).getPartyName().toLocalizedString();
            }
        }
        return new LocalizedString();
    }

    @Override
    public String getCode() {
        return this.name();
    }

    @Override
    public LocalizedString getName() {
        return LegalPTUtil.bundleI18N(this.getQualifiedNameKey(), new String[0]);
    }

    @Override
    public LocalizedString getDescription() {
        return LegalPTUtil.bundleI18N(this.getQualifiedDescriptionKey(), new String[0]);
    }

    protected String getQualifiedDescriptionKey() {
        return this.getClass().getName() + "." + this.name() + ".description";
    }

    protected String getQualifiedNameKey() {
        return this.getClass().getName() + "." + this.name() + ".name";
    }

    private LocalizedString localizedName(SchoolLevelType schoolLevel, Locale ... locales) {
        return this.localizedName(ENUMERATION_RESOURCES, schoolLevel.getQualifiedName(), locales);
    }

    private LocalizedString localizedName(String bundle, String key, Locale ... locales) {
        return BundleUtil.getLocalizedString((String)ENUMERATION_RESOURCES, (String)key, (String[])new String[0]);
    }
}

