/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.ulisboa.specifications.domain.legal.report;

import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.concurrent.Callable;
import org.fenixedu.bennu.core.domain.Bennu;
import org.fenixedu.bennu.core.security.Authenticate;
import org.fenixedu.ulisboa.specifications.domain.exceptions.ULisboaSpecificationsDomainException;
import org.fenixedu.ulisboa.specifications.domain.legal.report.LegalReport;
import org.fenixedu.ulisboa.specifications.domain.legal.report.LegalReportRequest$callable$cancelRequest;
import org.fenixedu.ulisboa.specifications.domain.legal.report.LegalReportRequest$callable$createRequest;
import org.fenixedu.ulisboa.specifications.domain.legal.report.LegalReportRequestParameters;
import org.fenixedu.ulisboa.specifications.domain.legal.report.LegalReportRequest_Base;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

public class LegalReportRequest
extends LegalReportRequest_Base {
    protected static final Comparator<LegalReportRequest> COMPARE_BY_REQUEST_DATE;
    public static final Advice advice$cancelRequest;
    public static final Advice advice$createRequest;

    protected LegalReportRequest() {
        this.setBennu(Bennu.getInstance());
        this.setBennuPending(Bennu.getInstance());
    }

    protected void init(LegalReport report) {
        this.setWhenRequested(new DateTime());
        this.setRequestor(Authenticate.getUser().getPerson());
        this.setLegalReport(report);
        this.checkRules();
    }

    private void checkRules() {
        if (this.getRequestor() == null) {
            throw new ULisboaSpecificationsDomainException("error.ReportRequest.requestor.required", new String[0]);
        }
        if (this.getWhenRequested() == null) {
            throw new ULisboaSpecificationsDomainException("error.ReportRequest.whenRequested.required", new String[0]);
        }
        if (this.getLegalReport() == null) {
            throw new ULisboaSpecificationsDomainException("error.ReportRequest.report.required", new String[0]);
        }
    }

    public boolean isPending() {
        return this.getBennuPending() != null;
    }

    public Boolean getPending() {
        return this.getBennuPending() != null;
    }

    public boolean isCancelable() {
        return this.isPending();
    }

    public Boolean getCancelable() {
        return this.getBennuPending() != null;
    }

    public void process() {
        this.getLegalReport().process(this);
    }

    public void cancelRequest() {
        Object object = advice$cancelRequest.perform((Callable)new LegalReportRequest$callable$cancelRequest(this));
    }

    static /* synthetic */ void advised$cancelRequest(LegalReportRequest this_) {
        this_.setBennuPending(null);
    }

    public static final LegalReportRequest findFirstAsynchronousPendingRequest() {
        Collection requests = Collections2.filter((Collection)Bennu.getInstance().getPendingLegalReportRequestsSet(), (Predicate)new Predicate<LegalReportRequest>(){

            public boolean apply(LegalReportRequest request) {
                return request.getLegalReport().getSynchronous() == false;
            }
        });
        if (requests.isEmpty()) {
            return null;
        }
        return Collections.min(requests, COMPARE_BY_REQUEST_DATE);
    }

    public String getParameters() {
        throw new ULisboaSpecificationsDomainException("error.ReportRequest.report.use.method.getParametersAs", new String[0]);
    }

    public <T extends LegalReportRequestParameters> T getParametersAs(Class<T> type) {
        return LegalReportRequestParameters.fromJson(type, super.getParameters());
    }

    public void setParameters(LegalReportRequestParameters reportRequestParameter) {
        super.setParameters(reportRequestParameter != null ? reportRequestParameter.toJson() : null);
    }

    public static LegalReportRequest createRequest(LegalReport legalReport, LegalReportRequestParameters legalReportRequestParameters) {
        return (LegalReportRequest)((Object)advice$createRequest.perform((Callable)new LegalReportRequest$callable$createRequest(legalReport, legalReportRequestParameters)));
    }

    static /* synthetic */ LegalReportRequest advised$createRequest(LegalReport report, LegalReportRequestParameters parameters) {
        LegalReportRequest result = new LegalReportRequest();
        result.init(report);
        result.setParameters(parameters);
        if (report.getSynchronous().booleanValue()) {
            result.process();
        }
        return result;
    }

    public void markAsProcessed() {
        this.setWhenProcessed(new DateTime());
        this.setBennuPending(null);
    }

    static {
        advice$cancelRequest = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        advice$createRequest = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        COMPARE_BY_REQUEST_DATE = new Comparator<LegalReportRequest>(){

            @Override
            public int compare(LegalReportRequest o1, LegalReportRequest o2) {
                int c = o1.getWhenRequested().compareTo((ReadableInstant)o2.getWhenRequested());
                return c != 0 ? c : o1.getExternalId().compareTo(o2.getExternalId());
            }
        };
    }
}

