/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.ulisboa.specifications.domain.legal.report;

import com.google.common.collect.Sets;
import java.lang.annotation.Annotation;
import java.text.Collator;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.Callable;
import org.fenixedu.academic.domain.DomainObjectUtil;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.bennu.core.domain.Bennu;
import org.fenixedu.bennu.core.domain.groups.PersistentGroup;
import org.fenixedu.commons.i18n.LocalizedString;
import org.fenixedu.legalpt.domain.LegalReportContext;
import org.fenixedu.ulisboa.specifications.domain.legal.mapping.ILegalMappingType;
import org.fenixedu.ulisboa.specifications.domain.legal.report.LegalReport$callable$createReport;
import org.fenixedu.ulisboa.specifications.domain.legal.report.LegalReportRequest;
import org.fenixedu.ulisboa.specifications.domain.legal.report.LegalReport_Base;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

public abstract class LegalReport
extends LegalReport_Base {
    public static Comparator<LegalReport> COMPARATOR_BY_NAME;
    public static final Advice advice$createReport;

    protected LegalReport() {
        this.setBennu(Bennu.getInstance());
    }

    public String getType() {
        return ((Object)((Object)this)).getClass().getName();
    }

    public final void process(LegalReportRequest reportRequest) {
        try {
            LegalReportContext.init();
            this.executeProcessing(reportRequest);
        }
        finally {
            LegalReportContext.destroy();
        }
    }

    public static Collection<LegalReport> findReportsWithAccessBy(Person person) {
        HashSet result = Sets.newHashSet();
        for (LegalReport LegalReport2 : Bennu.getInstance().getLegalReportsSet()) {
            if (!LegalReport2.hasAccess(person)) continue;
            result.add(LegalReport2);
        }
        return result;
    }

    private boolean hasAccess(Person person) {
        if (person.getUser() != null) {
            return this.getGroup().isMember(person.getUser());
        }
        return false;
    }

    public static <T extends LegalReport> T createReport(Class<T> clazz) {
        return (T)((Object)((LegalReport)((Object)advice$createReport.perform((Callable)new LegalReport$callable$createReport(clazz)))));
    }

    static /* synthetic */ <T extends LegalReport> T advised$createReport(Class<T> type) {
        try {
            return (T)((Object)((LegalReport)((Object)type.newInstance())));
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    public abstract void executeProcessing(LegalReportRequest var1);

    public abstract LocalizedString getNameI18N();

    public abstract Set<ILegalMappingType> getMappingTypes();

    public abstract Set<?> getPossibleKeys(String var1);

    public abstract LocalizedString getMappingTypeNameI18N(String var1);

    public abstract LocalizedString getLocalizedNameMappingKey(String var1, String var2);

    public abstract void edit(LocalizedString var1, PersistentGroup var2, Boolean var3, Boolean var4);

    public abstract void delete();

    static {
        advice$createReport = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        COMPARATOR_BY_NAME = new Comparator<LegalReport>(){

            @Override
            public int compare(LegalReport o1, LegalReport o2) {
                String leftName = o1.getNameI18N().getContent();
                String rightName = o2.getNameI18N().getContent();
                if (leftName == null && rightName == null) {
                    return o1.getExternalId().compareTo(o2.getExternalId());
                }
                if (leftName == null) {
                    return 1;
                }
                if (rightName == null) {
                    return -1;
                }
                int result = Collator.getInstance().compare(leftName, rightName);
                return result == 0 ? DomainObjectUtil.COMPARATOR_BY_ID.compare(o1, o2) : result;
            }
        };
    }
}

