/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.ulisboa.specifications.domain.legal.raides;

import com.google.common.base.Strings;
import java.math.BigDecimal;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.bennu.core.domain.Bennu;
import org.fenixedu.bennu.core.security.Authenticate;
import org.fenixedu.ulisboa.specifications.domain.legal.raides.IRaidesReportRequestDefaultData;
import org.fenixedu.ulisboa.specifications.domain.legal.raides.RaidesInstance;
import org.fenixedu.ulisboa.specifications.domain.legal.raides.report.RaidesPeriodInputType;
import org.fenixedu.ulisboa.specifications.domain.legal.raides.report.RaidesRequestParameter;
import org.fenixedu.ulisboa.specifications.domain.legal.settings.LegalSettings;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

public class RaidesReportRequestDefaultData
implements IRaidesReportRequestDefaultData {
    public static final DateTimeFormatter DATETIME_FORMATTER = DateTimeFormat.forPattern((String)"dd/MM/yyyy");

    public static final Boolean IsRaidesStudentEditionActive() {
        return LegalSettings.getInstance().getRaidesFormActiveForStudent();
    }

    @Override
    public void fill(RaidesRequestParameter raidesRequestParameter) {
        raidesRequestParameter.addPeriod(RaidesPeriodInputType.ENROLLED, ExecutionYear.readExecutionYearByName((String)"2015/2016"), DATETIME_FORMATTER.parseDateTime("01/04/2015").toLocalDate(), DATETIME_FORMATTER.parseDateTime("31/03/2016").toLocalDate(), true, false, BigDecimal.ZERO, BigDecimal.ZERO, false, 0, 0);
        raidesRequestParameter.addPeriod(RaidesPeriodInputType.INTERNATIONAL_MOBILITY, ExecutionYear.readExecutionYearByName((String)"2015/2016"), DATETIME_FORMATTER.parseDateTime("01/09/2015").toLocalDate(), DATETIME_FORMATTER.parseDateTime("31/03/2016").toLocalDate(), true, false, BigDecimal.ZERO, BigDecimal.ZERO, false, 0, 0);
        raidesRequestParameter.getDegrees().addAll(RaidesInstance.getInstance().getDegreesToReportSet());
        raidesRequestParameter.getAgreementsForEnrolled().addAll(RaidesInstance.getInstance().getEnrolledAgreementsSet());
        raidesRequestParameter.getAgreementsForMobility().addAll(RaidesInstance.getInstance().getMobilityAgreementsSet());
        raidesRequestParameter.getIngressionsForDegreeChange().addAll(RaidesInstance.getInstance().getDegreeChangeIngressionsSet());
        raidesRequestParameter.getIngressionsForDegreeTransfer().addAll(RaidesInstance.getInstance().getDegreeTransferIngressionsSet());
        raidesRequestParameter.getIngressionsForGeneralAccessRegime().addAll(RaidesInstance.getInstance().getGeneralAccessRegimeIngressionsSet());
        raidesRequestParameter.setInstitution(Bennu.getInstance().getInstitutionUnit());
        raidesRequestParameter.setInstitutionCode(!Strings.isNullOrEmpty((String)RaidesInstance.getInstance().getInstitutionCode()) ? RaidesInstance.getInstance().getInstitutionCode() : Bennu.getInstance().getInstitutionUnit().getCode());
        raidesRequestParameter.setMoment("2");
        raidesRequestParameter.setInterlocutorName(Authenticate.getUser().getPerson().getName());
        raidesRequestParameter.setInterlocutorEmail(Authenticate.getUser().getPerson().getDefaultEmailAddressValue());
        raidesRequestParameter.setInterlocutorPhone(RaidesInstance.getInstance().getInterlocutorPhone());
        raidesRequestParameter.setFilterEntriesWithErrors(true);
    }
}

